/* package-info.java
 * =========================================================================
 * This file is part of the GrInvIn project - http://www.grinvin.org
 * 
 * Copyright (C) 2005-2008 Universiteit Gent
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or (at
 * your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 * 
 * A copy of the GNU General Public License can be found in the file
 * LICENSE.txt provided with the source distribution of this program (see
 * the META-INF directory in the source jar). This license can also be
 * found on the GNU website at http://www.gnu.org/licenses/gpl.html.
 * 
 * If you did not receive a copy of the GNU General Public License along
 * with this program, contact the lead developer, or write to the Free
 * Software Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA
 * 02110-1301, USA.
 */

/**
 * Provides classes for displaying and editing graphs.
 *
 * <h2>How graphs are represented</h2>
 *
 * There are several classes and interfaces that can be used to represent graph
 * objects.
 * <ul>
 * <li>The interface {@link org.grinvin.graphs.GraphView} presents a read-only view of an abstract 
 * graph as a collection of vertices and edges.</li>
 * <li>The interface {@link org.grinvin.graphs.Graph} extends {@code org.grinvin.graphs.GraphView} to make it mutable.
 * It is possible to add or remove vertices and edges to objects of this type.</li>
 * </ul>
 * To make it possible for a graph to be displayed, we need coordinates for its 
 * vertices, in other words, the graph needs to be <i>embedded into Euclidian space</i>.
 * Embeddings need not be 2-dimensional and a single abstract graph may allow different
 * embeddings, at the same time.
 * <ul>
 * <li>The interface {@link org.grinvin.graphs.EmbeddingView} provides a map 
 * between vertices of a {@code org.grinvin.graphs.GraphView} (called its <i>peer</i>)
 * and coordinate-tuples.
 * </li>
 * <li>The interface {@link org.grinvin.graphs.Embedding} extends {@code org.grinvin.graphs.EmbeddingView} 
 * to make it mutable.</li>
 * </ul>
 * </ul>
 * In principle, an embedding could also provide extra information on how edges 
 * should be embedded. However, currently an edge is always embedded as a 
 * (straight) line segment that joins the vertices.
 *
 * <h2>Vertices and edges</h2>
 * 
 * Vertices and edges are represented as objects of types {@link org.grinvin.graphs.Vertex}
 * and {@link org.grinvin.graphs.Edge}, both belonging to the common supertype {@link org.grinvin.graphs.Element}.<p>
 * Each vertex carries an <i>index</i>, i.e., a sequence number for that vertex within the graph to which
 * it belongs. Vertex indices are in the range 0..n-1 where n is the number of vertices of the
 * corresponding graph. Note that the index of a vertex may change during the life time of that vertex.
 * <p> 
 * The internal state of elements (their annotations, for vertices, their index, and for edges, 
 * their endpoints) can only be manipulated using a {@code org.grinvin.graphs.Graph} object 
 * as an intermediary.
 * Elements should also not be shared between different {@code org.grinvin.graphs.Graph} objects.
 * <p>
 * For instance, to create a new vertex, you cannot call its constructor (as it is package private)
 * but you should call the method {@link org.grinvin.graphs.Graph#addNewVertex} instead. This will add
 * the newly created vertex to the corresponding graph. To join two vertices in 
 * a graph by an edge, you should call the method {@link org.grinvin.graphs.Graph#addNewEdge} which
 * will at the same time add that edge to the graph.
 * 
 * <p><b>Note:</b> Interfaces {@code org.grinvin.graphs.GraphView} and {@code org.grinvin.graphs.Graph} must not be confused with
 * interfaces of the same name in the package {@code be.ugent.caagtlib.im} from the
 * caagtlib project.
 */
package org.grinvin.graphs;


