/* GraphGeneratorCellRenderer.java
 * =========================================================================
 * This file is part of the GrInvIn project - http://www.grinvin.org
 * 
 * Copyright (C) 2005-2008 Universiteit Gent
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or (at
 * your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 * 
 * A copy of the GNU General Public License can be found in the file
 * LICENSE.txt provided with the source distribution of this program (see
 * the META-INF directory in the source jar). This license can also be
 * found on the GNU website at http://www.gnu.org/licenses/gpl.html.
 * 
 * If you did not receive a copy of the GNU General Public License along
 * with this program, contact the lead developer, or write to the Free
 * Software Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA
 * 02110-1301, USA.
 */

package org.grinvin.gui.components.render;

import java.awt.Color;

import org.grinvin.generators.graphs.GraphGenerator;
import org.grinvin.graphs.GraphURIType;
import org.grinvin.gui.icons.SelectUnselectIcon;
import org.grinvin.gui.icons.SvgIconManager;

/**
 * Renderer to render {@link GraphGenerator} objects in a {@link be.ugent.caagt.swirl.lists.CellList}.
 */
public class GraphGeneratorCellRenderer extends AbstractGrinvinCellListCellRenderer {
    
    /**
     * Return the singleton instance of this type.
     */
    public static GraphGeneratorCellRenderer getInstance() {
        return INSTANCE;
    }
    
    //
    private static final GraphGeneratorCellRenderer INSTANCE
            = new GraphGeneratorCellRenderer();

    //
    public SelectUnselectIcon createIcon(Object value, int size) {
        GraphGenerator generator = getGenerator(value);
        return SvgIconManager.getInstance().createSelectUnselectIcon(generator.getIconPath(), generator.getSelectedIconPath(), size);
    }

    /**
     * Returns the standard icon background color for graph generators.
     */ 
    protected Color getIconBackgroundColor(Object value) {
        return GraphURIType.GENERATOR.getIconBackgroundColor();
    }

    //
    protected String getName(Object value) {
        return getGenerator(value).getName();
    }

    //
    protected String getDescription(Object value) {
        return getGenerator(value).getDescription();
    }
    
    //
    private GraphGenerator getGenerator(Object value) {
        if (value instanceof GraphGenerator) {
            return (GraphGenerator)value;
        } else {
            throw new IllegalArgumentException("GraphGeneratorCellRenderer can only be used with lists of GraphGenerator");
        }
    }

}
