/* InvariantValuesSaver.java
 * =========================================================================
 * This file is part of the GrInvIn project - http://www.grinvin.org
 * 
 * Copyright (C) 2005-2008 Universiteit Gent
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or (at
 * your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 * 
 * A copy of the GNU General Public License can be found in the file
 * LICENSE.txt provided with the source distribution of this program (see
 * the META-INF directory in the source jar). This license can also be
 * found on the GNU website at http://www.gnu.org/licenses/gpl.html.
 * 
 * If you did not receive a copy of the GNU General Public License along
 * with this program, contact the lead developer, or write to the Free
 * Software Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA
 * 02110-1301, USA.
 */

package org.grinvin.io;

import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

import org.grinvin.invariants.InvariantValue;
import org.grinvin.invariants.InvariantValueDelegate;

import org.jdom.DocType;
import org.jdom.Element;

/**
 * Saved for the computed values of a saved GraphBundle
 */
public class InvariantValuesSaver {
    
    //
    private static final String PUBLIC_ID = "-//GrInvIn IO//Invariant Values 1.1//EN";
    
    //
    private InvariantValuesSaver() { }
    
    private static Collection<InvariantValue> sortValues(Collection<InvariantValue> values) {
        List<InvariantValue> result = new ArrayList<InvariantValue>(values);
        Collections.sort(result, new MyComparator());
        return result;
    }
    
    //
    public static void save(Collection<InvariantValue> values, OutputStream out) throws IOException {
        Element element = new Element("invariantvalues");
        
        for (InvariantValue value : sortValues(values)) {
            InvariantValueDelegate delegate = value.getType().getDelegate();
            element.addContent(delegate.toElement(value));
        }
        
        LoaderSaverHelper.outputXML(element,
                new DocType("invariantvalues", PUBLIC_ID, "http://downloads.grinvin.org/dtds/io/invariantvalues-1.1.dtd"),
                out);
    }
    
    private static class MyComparator implements Comparator<InvariantValue> {

        public int compare(InvariantValue value1, InvariantValue value2) {
            return value1.getInvariant().getId().compareTo(value2.getInvariant().getId());
        }
        
    }
    
}
