/* AnnotationSaver.java
 * =========================================================================
 * This file is part of the GrInvIn project - http://www.grinvin.org
 * 
 * Copyright (C) 2005-2008 Universiteit Gent
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or (at
 * your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 * 
 * A copy of the GNU General Public License can be found in the file
 * LICENSE.txt provided with the source distribution of this program (see
 * the META-INF directory in the source jar). This license can also be
 * found on the GNU website at http://www.gnu.org/licenses/gpl.html.
 * 
 * If you did not receive a copy of the GNU General Public License along
 * with this program, contact the lead developer, or write to the Free
 * Software Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA
 * 02110-1301, USA.
 */

package org.grinvin.io.graphs;

import java.io.IOException;
import java.io.OutputStream;

import org.grinvin.graphs.AnnotationView;
import org.grinvin.graphs.Edge;
import org.grinvin.graphs.Vertex;
import org.grinvin.io.LoaderSaverHelper;

import org.jdom.DocType;
import org.jdom.Element;

/**
 *
 */
public class AnnotationSaver {
    
    //
    private AnnotationSaver() { }
    
    /**
     * Convert the given annotation to a JDOM-element.
     */
    public static Element toElement(AnnotationView annotation) {
        
        Element element = new Element("annotation");
        
        // vertex annotations
        for (Vertex v: annotation.getPeer().vertices()) {
            if (annotation.getAnnotation(v) != null) {
                Element vertex = new Element("vertex");
                vertex.setAttribute("id", Integer.toString(v.getIndex()));
                vertex.setAttribute("text", annotation.getAnnotation(v).toString());
                element.addContent(vertex);
            }
        }
        
        // edge annotations
        for (Edge e: annotation.getPeer().edges()) {
            if (annotation.getAnnotation(e) != null) {
                Element edge = new Element("edge");
                edge.setAttribute("from", Integer.toString(e.getFirstEndpoint().getIndex()));
                edge.setAttribute("to", Integer.toString(e.getSecondEndpoint().getIndex()));
                edge.setAttribute("text", annotation.getAnnotation(e).toString());
                element.addContent(edge);
            }
        }
        
        return element;
    }
    
    /**
     * Save the annotation graph onto the output stream.
     * @param out Output stream to which the result shall be written.
     */
    public static void save(AnnotationView annotation, OutputStream out) throws IOException {
        LoaderSaverHelper.outputXML(toElement(annotation), new DocType("annotation", "-//GrInvIn IO//Annotation 1.0//EN", "http://downloads.grinvin.org/dtds/io/annotation-1.0.dtd"), out);
    }
    
}
