/* package-info.java
 * =========================================================================
 * This file is part of the GrInvIn project - http://www.grinvin.org
 * 
 * Copyright (C) 2005-2008 Universiteit Gent
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or (at
 * your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 * 
 * A copy of the GNU General Public License can be found in the file
 * LICENSE.txt provided with the source distribution of this program (see
 * the META-INF directory in the source jar). This license can also be
 * found on the GNU website at http://www.gnu.org/licenses/gpl.html.
 * 
 * If you did not receive a copy of the GNU General Public License along
 * with this program, contact the lead developer, or write to the Free
 * Software Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA
 * 02110-1301, USA.
 */

/**
 * Provides classes for loading an saving graphs.<p>
 *
 * The classes {@link org.grinvin.io.GraphBundleLoader} 
 * and {@link org.grinvin.io.GraphBundleSaver} provide methods to load and save
 * {@link org.grinvin.graphs.GraphBundle} objects from streams or files in 
 * <tt>gph</tt>-format, as described below.
 *
 * <h2>The <tt>gph</tt>-format</h2>
 * A single graph bundle is stored as a (compressed) ZIP-archive containing 
 * a directory of XML-files, called <i>sections</i>. 
 * Currently the following sections are supported:
 * <ul>
 * <li>The section <a href="#meta-info><tt>meta-info.xml</tt></a> 
 * which contains information on the structure
 * of the archive itself, e.g., version information.</li>
 * <li>The section <a href="#resources><tt>resources.xml</tt></a> containing 
 * internationalized string resources for this graph bundle, e.g., the name of the
 * graph.</li>
 * <li>The section <a href="#graph"><tt>graph.xml</tt></a> with an abstract representation
 * of the graph, e.g., which vertex is connected to which vertex.</li>
 * <li>Sections with names of the form <a href="#embedding"><tt>embedding-*.xml</tt></a> 
 * which contain different embeddings of the graph, 
 * i.e., the list of coordinates to be assigned to the
 * vertices of the abstract graph.</l>
 * </ul>
 * Entries can be stored in any order, although the above order is prefered and may
 * load faster and use fewer memory resources.
 *
 * <a name="meta-info"><h2>Section <tt>meta-info.xml</tt></h2></a>
 * Contains information on the structure of the archive itself. This section is stored
 * as an XML properties document, as described in {@code java.util.Properties}.
 * Currently the following properties are supported:
 * <ul>
 * <li><tt>version</tt>. Version of the format used in the 
 * form <i>major-nr</i>.<i>minor-nr</i>. The version described in this text
 * is <tt>1.0</tt>.</li>
 * <li><tt>nrOfEmbeddings</tt> (optional). The number of embeddings stored in
 * this bundle. Can be omitted when zero.</li>
 * </ul>
 *
 * <a name="resources"><h2>Section <tt>resources.xml</tt></h2></a>
 * Internationalized string resources for this graph. Stored as an internationalized
 * XML document, as described in {@link org.grinvin.util.InternationalizedProperties}.
 * Refer to the documentation of 
 * {@link org.grinvin.graphs.GraphBundleView#getProperties} for a list of supported
 * properties.
 *
 * <a name="graph"><h2>Section <tt>graph.xml</tt></h2></a>
 * Representation of an abstract graph according to the following DTD:
 * <pre> 
 *    &lt;!ELEMENT graph ( vertex*, edge* ) &gt;
 *    &lt;!ATTLIST graph nrofvertices CDATA #REQUIRED &gt;
 *
 *    &lt;!ELEMENT vertex EMPTY &gt;
 *    &lt;!ATTLIST vertex id ID #REQUIRED &gt;
 *    &lt;!ATTLIST vertex annotation CDATA #IMPLIED &gt;
 *
 *    &lt;!ELEMENT edge EMPTY &gt;
 *    &lt;!ATTLIST edge from IDREF #REQUIRED &gt;
 *    &lt;!ATTLIST edge to   IDREF #REQUIRED &gt;
 *    &lt;!ATTLIST edge annotation CDATA #IMPLIED &gt;
 * </pre>
 * Vertices are implicitly numbered from 0 upto <tt>nrofvertices</tt>-1. 
 * This sequence number is used as an id for the vertex. Vertices without annotations
 * need not be explicitly present as elements. 
 *
 * <a name="embedding"><h2>Sections <tt>embedding_0.xml</tt>, 
 * <tt>embedding_1.xml</tt>, ...</h2></a>
 * Zero or more consecutively numbered embeddings fo the graph. Each embedding is
 * stored according to the following DTD:
 * <pre> 
 *    &lt;!ELEMENT embedding ( coordinates* ) &gt;
 *    &lt;!ATTLIST graph dimension CDATA #REQUIRED &gt;
 *
 *    &lt;!ELEMENT coordinates ( double ) &gt;
 *    &lt;!ATTLIST coordinates id IDREF #REQUIRED &gt;
 *
 *    &lt;!ELEMENT double EMPTY &gt;
 *    &lt;!ATTLIST double value CDATA #REQUIRED &gt;
 * </pre>
 * Each <tt>coordinates</tt> element refers to the corresponding vertex by
 * using the corresponding id from the <tt>graph.xml</tt> section.
 */
package org.grinvin.io;


