#!/bin/bash

################################################################################
# Linux Management Providers (LMP), Physical Asset provider package
# Copyright (C) 2008 Guillaume BOTTEX, ETRI <guillaumebottex@etri.re.kr, guillaumebottex@gmail.com>
# 
# This program is being developed under the "OpenDRIM" project.
# The "OpenDRIM" project web page: http://opendrim.sourceforge.net
# The "OpenDRIM" project mailing list: opendrim@googlegroups.com
# 
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; version 2
# of the License.
# 
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
#################################################################################

#################################################################################
# To contributors, please leave your contact information in this section
# AND comment your changes in the source code.
# 
# Modified by <Author(s)>, <Affiliation>, <Year>
################################################################################

if test "$3" = pegasus
then
	
	cimmof -aE -n $1 $6/mof/OpenDRIM_Card.mof

	OUTFILE=./TEMP_REGISTRATION
	
cat >> $OUTFILE << EOFC
instance of PG_ProviderModule {
Caption = "OpenDRIM_Card provider module";
Name = "PhysicalAsset_OpenDRIM_CardModule";
Location = "cmpiPhysicalAsset_OpenDRIM_CardProvider";
Vendor = "$2";
Version = "$5";
InterfaceType = "CMPI";
InterfaceVersion = "2.0.0";
};

instance of PG_Provider {
Caption = "OpenDRIM_Card provider";
Name = "PhysicalAsset_OpenDRIM_CardProvider";
ProviderModuleName = "PhysicalAsset_OpenDRIM_CardModule";
};

instance of PG_ProviderCapabilities {
Caption = "OpenDRIM_Card provider capabilities";
ProviderModuleName = "PhysicalAsset_OpenDRIM_CardModule";
ProviderName = "PhysicalAsset_OpenDRIM_CardProvider";
ClassName = "OpenDRIM_Card";
ProviderType = {2, 5};
Namespaces = {"$1"};
SupportedProperties = {"Caption", "InstallDate", "Name", "OperationalStatus", "StatusDescriptions", "Status", "HealthState", "PrimaryStatus", "DetailedStatus", "OperatingStatus", "CommunicationStatus", "Tag", "Description", "CreationClassName", "ElementName", "Manufacturer", "Model", "SKU", "SerialNumber", "Version", "PartNumber", "OtherIdentifyingInfo", "PoweredOn", "ManufactureDate", "VendorEquipmentType", "UserTracking", "CanBeFRUed", "RemovalConditions", "Removable", "Replaceable", "HotSwappable", "Height", "Depth", "Width", "Weight", "PackageType", "OtherPackageType", "VendorCompatibilityStrings", "HostingBoard", "SlotLayout", "RequiresDaughterBoard", "SpecialRequirements", "RequirementsDescription", "OperatingVoltages"};
SupportedMethods = {"IsCompatible", "ConnectorPower"};
CapabilityID = "PhysicalAsset_OpenDRIM_Card";
};

EOFC
	
	cimmof -n root/PG_InterOp $OUTFILE
	
	rm -f $OUTFILE
	
fi

if test "$3" = sfcb
then
	
	OUTFILE=./OpenDRIM_Card.reg
	
cat >> $OUTFILE <<EOFC
[OpenDRIM_Card]   
   provider: PhysicalAsset_OpenDRIM_CardProvider
   location: cmpiPhysicalAsset_OpenDRIM_CardProvider
   type: instance method
   namespace: $1
#
EOFC
	
	sfcbstage -r $OUTFILE -n $1 $6/mof/OpenDRIM_Card.mof
	
	rm -f $OUTFILE
	
	sfcbrepos -f
	
fi

if test "$3" = openwbem
then
	
	OUTFILE=./OpenDRIM_Card-reg.mof
	rm -f $OUTFILE
	sed "s/Provider *( *\"cmpi:/Provider(\"cmpi::/g" < $6/mof/OpenDRIM_Card.mof >> $OUTFILE
	owmofc -u http://localhost/$1 $OUTFILE
	
	rm -f $OUTFILE
	
fi
