/*###############################################################################
# Linux Management Providers (LMP), System Memory provider package
# Copyright (C) 2008 Guillaume BOTTEX, ETRI <guillaumebottex@etri.re.kr, guillaumebottex@gmail.com>
#
# This program is being developed under the "OpenDRIM" project.
# The "OpenDRIM" project web page: http://opendrim.sourceforge.net
# The "OpenDRIM" project mailing list: opendrim@googlegroups.com
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; version 2
# of the License.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
#################################################################################

#################################################################################
# To contributors, please leave your contact information in this section
# AND comment your changes in the source code.
#
# Modified by <Author(s)>, <Affiliation>, <Year>
###############################################################################*/

#ifndef OPENDRIM_MEMORY_H_
#define OPENDRIM_MEMORY_H_

#include <Instance.h>

const static char* OpenDRIM_Memory_classnames[] = {"OpenDRIM_Memory"};
static string OpenDRIM_Memory_NAMESPACE = _NAMESPACE;

class OpenDRIM_Memory {

public:
	
	string Caption;
	bool Caption_isNULL;
	
	string Description;
	bool Description_isNULL;
	
	string ElementName;
	bool ElementName_isNULL;
	
	string InstallDate;
	bool InstallDate_isNULL;
	
	vector<unsigned short> OperationalStatus;
	bool OperationalStatus_isNULL;
	
	vector<string> StatusDescriptions;
	bool StatusDescriptions_isNULL;
	
	string Status;
	bool Status_isNULL;
	
	unsigned short HealthState;
	bool HealthState_isNULL;
	
	unsigned short PrimaryStatus;
	bool PrimaryStatus_isNULL;
	
	unsigned short DetailedStatus;
	bool DetailedStatus_isNULL;
	
	unsigned short OperatingStatus;
	bool OperatingStatus_isNULL;
	
	unsigned short CommunicationStatus;
	bool CommunicationStatus_isNULL;
	
	unsigned short EnabledState;
	bool EnabledState_isNULL;
	
	string OtherEnabledState;
	bool OtherEnabledState_isNULL;
	
	unsigned short RequestedState;
	bool RequestedState_isNULL;
	
	unsigned short EnabledDefault;
	bool EnabledDefault_isNULL;
	
	string TimeOfLastStateChange;
	bool TimeOfLastStateChange_isNULL;
	
	vector<unsigned short> AvailableRequestedStates;
	bool AvailableRequestedStates_isNULL;
	
	unsigned short TransitioningToState;
	bool TransitioningToState_isNULL;
	
	string SystemCreationClassName;
	bool SystemCreationClassName_isNULL;
	
	string SystemName;
	bool SystemName_isNULL;
	
	string CreationClassName;
	bool CreationClassName_isNULL;
	
	string DeviceID;
	bool DeviceID_isNULL;
	
	bool PowerManagementSupported;
	bool PowerManagementSupported_isNULL;
	
	vector<unsigned short> PowerManagementCapabilities;
	bool PowerManagementCapabilities_isNULL;
	
	unsigned short Availability;
	bool Availability_isNULL;
	
	unsigned short StatusInfo;
	bool StatusInfo_isNULL;
	
	unsigned int LastErrorCode;
	bool LastErrorCode_isNULL;
	
	string ErrorDescription;
	bool ErrorDescription_isNULL;
	
	bool ErrorCleared;
	bool ErrorCleared_isNULL;
	
	vector<string> OtherIdentifyingInfo;
	bool OtherIdentifyingInfo_isNULL;
	
	unsigned long long PowerOnHours;
	bool PowerOnHours_isNULL;
	
	unsigned long long TotalPowerOnHours;
	bool TotalPowerOnHours_isNULL;
	
	vector<string> IdentifyingDescriptions;
	bool IdentifyingDescriptions_isNULL;
	
	vector<unsigned short> AdditionalAvailability;
	bool AdditionalAvailability_isNULL;
	
	unsigned long long MaxQuiesceTime;
	bool MaxQuiesceTime_isNULL;
	
	unsigned short LocationIndicator;
	bool LocationIndicator_isNULL;
	
	unsigned short DataOrganization;
	bool DataOrganization_isNULL;
	
	string Purpose;
	bool Purpose_isNULL;
	
	unsigned short Access;
	bool Access_isNULL;
	
	unsigned long long BlockSize;
	bool BlockSize_isNULL;
	
	unsigned long long NumberOfBlocks;
	bool NumberOfBlocks_isNULL;
	
	unsigned long long ConsumableBlocks;
	bool ConsumableBlocks_isNULL;
	
	bool IsBasedOnUnderlyingRedundancy;
	bool IsBasedOnUnderlyingRedundancy_isNULL;
	
	bool SequentialAccess;
	bool SequentialAccess_isNULL;
	
	vector<unsigned short> ExtentStatus;
	bool ExtentStatus_isNULL;
	
	bool NoSinglePointOfFailure;
	bool NoSinglePointOfFailure_isNULL;
	
	unsigned short DataRedundancy;
	bool DataRedundancy_isNULL;
	
	unsigned short PackageRedundancy;
	bool PackageRedundancy_isNULL;
	
	unsigned char DeltaReservation;
	bool DeltaReservation_isNULL;
	
	bool Primordial;
	bool Primordial_isNULL;
	
	string Name;
	bool Name_isNULL;
	
	unsigned short NameFormat;
	bool NameFormat_isNULL;
	
	unsigned short NameNamespace;
	bool NameNamespace_isNULL;
	
	string OtherNameNamespace;
	bool OtherNameNamespace_isNULL;
	
	string OtherNameFormat;
	bool OtherNameFormat_isNULL;
	
	unsigned short Usage;
	bool Usage_isNULL;
	
	string OtherUsageDescription;
	bool OtherUsageDescription_isNULL;
	
	vector<unsigned short> ClientSettableUsage;
	bool ClientSettableUsage_isNULL;
	
	bool Volatile;
	bool Volatile_isNULL;
	
	string ErrorMethodology;
	bool ErrorMethodology_isNULL;
	
	unsigned long long StartingAddress;
	bool StartingAddress_isNULL;
	
	unsigned long long EndingAddress;
	bool EndingAddress_isNULL;
	
	unsigned short ErrorInfo;
	bool ErrorInfo_isNULL;
	
	string OtherErrorDescription;
	bool OtherErrorDescription_isNULL;
	
	bool CorrectableError;
	bool CorrectableError_isNULL;
	
	string ErrorTime;
	bool ErrorTime_isNULL;
	
	unsigned short ErrorAccess;
	bool ErrorAccess_isNULL;
	
	unsigned int ErrorTransferSize;
	bool ErrorTransferSize_isNULL;
	
	vector<unsigned char> ErrorData;
	bool ErrorData_isNULL;
	
	unsigned short ErrorDataOrder;
	bool ErrorDataOrder_isNULL;
	
	unsigned long long ErrorAddress;
	bool ErrorAddress_isNULL;
	
	bool SystemLevelAddress;
	bool SystemLevelAddress_isNULL;
	
	unsigned long long ErrorResolution;
	bool ErrorResolution_isNULL;
	
	vector<unsigned char> AdditionalErrorData;
	bool AdditionalErrorData_isNULL;
	
	OpenDRIM_Memory() {
		Caption_isNULL = true;
		Description_isNULL = true;
		ElementName_isNULL = true;
		InstallDate_isNULL = true;
		OperationalStatus_isNULL = true;
		StatusDescriptions_isNULL = true;
		Status_isNULL = true;
		HealthState_isNULL = true;
		PrimaryStatus_isNULL = true;
		DetailedStatus_isNULL = true;
		OperatingStatus_isNULL = true;
		CommunicationStatus_isNULL = true;
		EnabledState_isNULL = true;
		OtherEnabledState_isNULL = true;
		RequestedState_isNULL = true;
		EnabledDefault_isNULL = true;
		TimeOfLastStateChange_isNULL = true;
		AvailableRequestedStates_isNULL = true;
		TransitioningToState_isNULL = true;
		SystemCreationClassName_isNULL = true;
		SystemName_isNULL = true;
		CreationClassName_isNULL = true;
		DeviceID_isNULL = true;
		PowerManagementSupported_isNULL = true;
		PowerManagementCapabilities_isNULL = true;
		Availability_isNULL = true;
		StatusInfo_isNULL = true;
		LastErrorCode_isNULL = true;
		ErrorDescription_isNULL = true;
		ErrorCleared_isNULL = true;
		OtherIdentifyingInfo_isNULL = true;
		PowerOnHours_isNULL = true;
		TotalPowerOnHours_isNULL = true;
		IdentifyingDescriptions_isNULL = true;
		AdditionalAvailability_isNULL = true;
		MaxQuiesceTime_isNULL = true;
		LocationIndicator_isNULL = true;
		DataOrganization_isNULL = true;
		Purpose_isNULL = true;
		Access_isNULL = true;
		BlockSize_isNULL = true;
		NumberOfBlocks_isNULL = true;
		ConsumableBlocks_isNULL = true;
		IsBasedOnUnderlyingRedundancy_isNULL = true;
		SequentialAccess_isNULL = true;
		ExtentStatus_isNULL = true;
		NoSinglePointOfFailure_isNULL = true;
		DataRedundancy_isNULL = true;
		PackageRedundancy_isNULL = true;
		DeltaReservation_isNULL = true;
		Primordial_isNULL = true;
		Name_isNULL = true;
		NameFormat_isNULL = true;
		NameNamespace_isNULL = true;
		OtherNameNamespace_isNULL = true;
		OtherNameFormat_isNULL = true;
		Usage_isNULL = true;
		OtherUsageDescription_isNULL = true;
		ClientSettableUsage_isNULL = true;
		Volatile_isNULL = true;
		ErrorMethodology_isNULL = true;
		StartingAddress_isNULL = true;
		EndingAddress_isNULL = true;
		ErrorInfo_isNULL = true;
		OtherErrorDescription_isNULL = true;
		CorrectableError_isNULL = true;
		ErrorTime_isNULL = true;
		ErrorAccess_isNULL = true;
		ErrorTransferSize_isNULL = true;
		ErrorData_isNULL = true;
		ErrorDataOrder_isNULL = true;
		ErrorAddress_isNULL = true;
		SystemLevelAddress_isNULL = true;
		ErrorResolution_isNULL = true;
		AdditionalErrorData_isNULL = true;
	}
	
	~OpenDRIM_Memory() {}
	
	string getKeys() const {
		return CF_toLowCase(".SystemCreationClassName=\"" + CF_quoteString(SystemCreationClassName) + "\""".SystemName=\"" + CF_quoteString(SystemName) + "\""".CreationClassName=\"" + CF_quoteString(CreationClassName) + "\""".DeviceID=\"" + CF_quoteString(DeviceID) + "\"");
	}

	int getCaption(string& value) const {
		if (Caption_isNULL==true)
			return NOT_FOUND;
		value = Caption;
		return OK;
	}
	
	int setCaption(const string& newValue) {
		Caption = newValue;
		Caption_isNULL = false;
		return OK;
	}

	int getDescription(string& value) const {
		if (Description_isNULL==true)
			return NOT_FOUND;
		value = Description;
		return OK;
	}
	
	int setDescription(const string& newValue) {
		Description = newValue;
		Description_isNULL = false;
		return OK;
	}

	int getElementName(string& value) const {
		if (ElementName_isNULL==true)
			return NOT_FOUND;
		value = ElementName;
		return OK;
	}
	
	int setElementName(const string& newValue) {
		ElementName = newValue;
		ElementName_isNULL = false;
		return OK;
	}

	int getInstallDate(string& value) const {
		if (InstallDate_isNULL==true)
			return NOT_FOUND;
		value = InstallDate;
		return OK;
	}
	
	int setInstallDate(const string& newValue) {
		InstallDate = newValue;
		InstallDate_isNULL = false;
		return OK;
	}

	int getOperationalStatus(vector<unsigned short>& value) const {
		if (OperationalStatus_isNULL==true)
			return NOT_FOUND;
		value = OperationalStatus;
		return OK;
	}
	
	int setOperationalStatus(const vector<unsigned short>& newValue) {
		OperationalStatus = newValue;
		OperationalStatus_isNULL = false;
		return OK;
	}

	int getStatusDescriptions(vector<string>& value) const {
		if (StatusDescriptions_isNULL==true)
			return NOT_FOUND;
		value = StatusDescriptions;
		return OK;
	}
	
	int setStatusDescriptions(const vector<string>& newValue) {
		StatusDescriptions = newValue;
		StatusDescriptions_isNULL = false;
		return OK;
	}

	int getStatus(string& value) const {
		if (Status_isNULL==true)
			return NOT_FOUND;
		value = Status;
		return OK;
	}
	
	int setStatus(const string& newValue) {
		Status = newValue;
		Status_isNULL = false;
		return OK;
	}

	int getHealthState(unsigned short& value) const {
		if (HealthState_isNULL==true)
			return NOT_FOUND;
		value = HealthState;
		return OK;
	}
	
	int setHealthState(const unsigned short& newValue) {
		HealthState = newValue;
		HealthState_isNULL = false;
		return OK;
	}

	int getPrimaryStatus(unsigned short& value) const {
		if (PrimaryStatus_isNULL==true)
			return NOT_FOUND;
		value = PrimaryStatus;
		return OK;
	}
	
	int setPrimaryStatus(const unsigned short& newValue) {
		PrimaryStatus = newValue;
		PrimaryStatus_isNULL = false;
		return OK;
	}

	int getDetailedStatus(unsigned short& value) const {
		if (DetailedStatus_isNULL==true)
			return NOT_FOUND;
		value = DetailedStatus;
		return OK;
	}
	
	int setDetailedStatus(const unsigned short& newValue) {
		DetailedStatus = newValue;
		DetailedStatus_isNULL = false;
		return OK;
	}

	int getOperatingStatus(unsigned short& value) const {
		if (OperatingStatus_isNULL==true)
			return NOT_FOUND;
		value = OperatingStatus;
		return OK;
	}
	
	int setOperatingStatus(const unsigned short& newValue) {
		OperatingStatus = newValue;
		OperatingStatus_isNULL = false;
		return OK;
	}

	int getCommunicationStatus(unsigned short& value) const {
		if (CommunicationStatus_isNULL==true)
			return NOT_FOUND;
		value = CommunicationStatus;
		return OK;
	}
	
	int setCommunicationStatus(const unsigned short& newValue) {
		CommunicationStatus = newValue;
		CommunicationStatus_isNULL = false;
		return OK;
	}

	int getEnabledState(unsigned short& value) const {
		if (EnabledState_isNULL==true)
			return NOT_FOUND;
		value = EnabledState;
		return OK;
	}
	
	int setEnabledState(const unsigned short& newValue) {
		EnabledState = newValue;
		EnabledState_isNULL = false;
		return OK;
	}

	int getOtherEnabledState(string& value) const {
		if (OtherEnabledState_isNULL==true)
			return NOT_FOUND;
		value = OtherEnabledState;
		return OK;
	}
	
	int setOtherEnabledState(const string& newValue) {
		OtherEnabledState = newValue;
		OtherEnabledState_isNULL = false;
		return OK;
	}

	int getRequestedState(unsigned short& value) const {
		if (RequestedState_isNULL==true)
			return NOT_FOUND;
		value = RequestedState;
		return OK;
	}
	
	int setRequestedState(const unsigned short& newValue) {
		RequestedState = newValue;
		RequestedState_isNULL = false;
		return OK;
	}

	int getEnabledDefault(unsigned short& value) const {
		if (EnabledDefault_isNULL==true)
			return NOT_FOUND;
		value = EnabledDefault;
		return OK;
	}
	
	int setEnabledDefault(const unsigned short& newValue) {
		EnabledDefault = newValue;
		EnabledDefault_isNULL = false;
		return OK;
	}

	int getTimeOfLastStateChange(string& value) const {
		if (TimeOfLastStateChange_isNULL==true)
			return NOT_FOUND;
		value = TimeOfLastStateChange;
		return OK;
	}
	
	int setTimeOfLastStateChange(const string& newValue) {
		TimeOfLastStateChange = newValue;
		TimeOfLastStateChange_isNULL = false;
		return OK;
	}

	int getAvailableRequestedStates(vector<unsigned short>& value) const {
		if (AvailableRequestedStates_isNULL==true)
			return NOT_FOUND;
		value = AvailableRequestedStates;
		return OK;
	}
	
	int setAvailableRequestedStates(const vector<unsigned short>& newValue) {
		AvailableRequestedStates = newValue;
		AvailableRequestedStates_isNULL = false;
		return OK;
	}

	int getTransitioningToState(unsigned short& value) const {
		if (TransitioningToState_isNULL==true)
			return NOT_FOUND;
		value = TransitioningToState;
		return OK;
	}
	
	int setTransitioningToState(const unsigned short& newValue) {
		TransitioningToState = newValue;
		TransitioningToState_isNULL = false;
		return OK;
	}

	int getSystemCreationClassName(string& value) const {
		if (SystemCreationClassName_isNULL==true)
			return NOT_FOUND;
		value = SystemCreationClassName;
		return OK;
	}
	
	int setSystemCreationClassName(const string& newValue) {
		SystemCreationClassName = newValue;
		SystemCreationClassName_isNULL = false;
		return OK;
	}

	int getSystemName(string& value) const {
		if (SystemName_isNULL==true)
			return NOT_FOUND;
		value = SystemName;
		return OK;
	}
	
	int setSystemName(const string& newValue) {
		SystemName = newValue;
		SystemName_isNULL = false;
		return OK;
	}

	int getCreationClassName(string& value) const {
		if (CreationClassName_isNULL==true)
			return NOT_FOUND;
		value = CreationClassName;
		return OK;
	}
	
	int setCreationClassName(const string& newValue) {
		CreationClassName = newValue;
		CreationClassName_isNULL = false;
		return OK;
	}

	int getDeviceID(string& value) const {
		if (DeviceID_isNULL==true)
			return NOT_FOUND;
		value = DeviceID;
		return OK;
	}
	
	int setDeviceID(const string& newValue) {
		DeviceID = newValue;
		DeviceID_isNULL = false;
		return OK;
	}

	int getPowerManagementSupported(bool& value) const {
		if (PowerManagementSupported_isNULL==true)
			return NOT_FOUND;
		value = PowerManagementSupported;
		return OK;
	}
	
	int setPowerManagementSupported(const bool& newValue) {
		PowerManagementSupported = newValue;
		PowerManagementSupported_isNULL = false;
		return OK;
	}

	int getPowerManagementCapabilities(vector<unsigned short>& value) const {
		if (PowerManagementCapabilities_isNULL==true)
			return NOT_FOUND;
		value = PowerManagementCapabilities;
		return OK;
	}
	
	int setPowerManagementCapabilities(const vector<unsigned short>& newValue) {
		PowerManagementCapabilities = newValue;
		PowerManagementCapabilities_isNULL = false;
		return OK;
	}

	int getAvailability(unsigned short& value) const {
		if (Availability_isNULL==true)
			return NOT_FOUND;
		value = Availability;
		return OK;
	}
	
	int setAvailability(const unsigned short& newValue) {
		Availability = newValue;
		Availability_isNULL = false;
		return OK;
	}

	int getStatusInfo(unsigned short& value) const {
		if (StatusInfo_isNULL==true)
			return NOT_FOUND;
		value = StatusInfo;
		return OK;
	}
	
	int setStatusInfo(const unsigned short& newValue) {
		StatusInfo = newValue;
		StatusInfo_isNULL = false;
		return OK;
	}

	int getLastErrorCode(unsigned int& value) const {
		if (LastErrorCode_isNULL==true)
			return NOT_FOUND;
		value = LastErrorCode;
		return OK;
	}
	
	int setLastErrorCode(const unsigned int& newValue) {
		LastErrorCode = newValue;
		LastErrorCode_isNULL = false;
		return OK;
	}

	int getErrorDescription(string& value) const {
		if (ErrorDescription_isNULL==true)
			return NOT_FOUND;
		value = ErrorDescription;
		return OK;
	}
	
	int setErrorDescription(const string& newValue) {
		ErrorDescription = newValue;
		ErrorDescription_isNULL = false;
		return OK;
	}

	int getErrorCleared(bool& value) const {
		if (ErrorCleared_isNULL==true)
			return NOT_FOUND;
		value = ErrorCleared;
		return OK;
	}
	
	int setErrorCleared(const bool& newValue) {
		ErrorCleared = newValue;
		ErrorCleared_isNULL = false;
		return OK;
	}

	int getOtherIdentifyingInfo(vector<string>& value) const {
		if (OtherIdentifyingInfo_isNULL==true)
			return NOT_FOUND;
		value = OtherIdentifyingInfo;
		return OK;
	}
	
	int setOtherIdentifyingInfo(const vector<string>& newValue) {
		OtherIdentifyingInfo = newValue;
		OtherIdentifyingInfo_isNULL = false;
		return OK;
	}

	int getPowerOnHours(unsigned long long& value) const {
		if (PowerOnHours_isNULL==true)
			return NOT_FOUND;
		value = PowerOnHours;
		return OK;
	}
	
	int setPowerOnHours(const unsigned long long& newValue) {
		PowerOnHours = newValue;
		PowerOnHours_isNULL = false;
		return OK;
	}

	int getTotalPowerOnHours(unsigned long long& value) const {
		if (TotalPowerOnHours_isNULL==true)
			return NOT_FOUND;
		value = TotalPowerOnHours;
		return OK;
	}
	
	int setTotalPowerOnHours(const unsigned long long& newValue) {
		TotalPowerOnHours = newValue;
		TotalPowerOnHours_isNULL = false;
		return OK;
	}

	int getIdentifyingDescriptions(vector<string>& value) const {
		if (IdentifyingDescriptions_isNULL==true)
			return NOT_FOUND;
		value = IdentifyingDescriptions;
		return OK;
	}
	
	int setIdentifyingDescriptions(const vector<string>& newValue) {
		IdentifyingDescriptions = newValue;
		IdentifyingDescriptions_isNULL = false;
		return OK;
	}

	int getAdditionalAvailability(vector<unsigned short>& value) const {
		if (AdditionalAvailability_isNULL==true)
			return NOT_FOUND;
		value = AdditionalAvailability;
		return OK;
	}
	
	int setAdditionalAvailability(const vector<unsigned short>& newValue) {
		AdditionalAvailability = newValue;
		AdditionalAvailability_isNULL = false;
		return OK;
	}

	int getMaxQuiesceTime(unsigned long long& value) const {
		if (MaxQuiesceTime_isNULL==true)
			return NOT_FOUND;
		value = MaxQuiesceTime;
		return OK;
	}
	
	int setMaxQuiesceTime(const unsigned long long& newValue) {
		MaxQuiesceTime = newValue;
		MaxQuiesceTime_isNULL = false;
		return OK;
	}

	int getLocationIndicator(unsigned short& value) const {
		if (LocationIndicator_isNULL==true)
			return NOT_FOUND;
		value = LocationIndicator;
		return OK;
	}
	
	int setLocationIndicator(const unsigned short& newValue) {
		LocationIndicator = newValue;
		LocationIndicator_isNULL = false;
		return OK;
	}

	int getDataOrganization(unsigned short& value) const {
		if (DataOrganization_isNULL==true)
			return NOT_FOUND;
		value = DataOrganization;
		return OK;
	}
	
	int setDataOrganization(const unsigned short& newValue) {
		DataOrganization = newValue;
		DataOrganization_isNULL = false;
		return OK;
	}

	int getPurpose(string& value) const {
		if (Purpose_isNULL==true)
			return NOT_FOUND;
		value = Purpose;
		return OK;
	}
	
	int setPurpose(const string& newValue) {
		Purpose = newValue;
		Purpose_isNULL = false;
		return OK;
	}

	int getAccess(unsigned short& value) const {
		if (Access_isNULL==true)
			return NOT_FOUND;
		value = Access;
		return OK;
	}
	
	int setAccess(const unsigned short& newValue) {
		Access = newValue;
		Access_isNULL = false;
		return OK;
	}

	int getBlockSize(unsigned long long& value) const {
		if (BlockSize_isNULL==true)
			return NOT_FOUND;
		value = BlockSize;
		return OK;
	}
	
	int setBlockSize(const unsigned long long& newValue) {
		BlockSize = newValue;
		BlockSize_isNULL = false;
		return OK;
	}

	int getNumberOfBlocks(unsigned long long& value) const {
		if (NumberOfBlocks_isNULL==true)
			return NOT_FOUND;
		value = NumberOfBlocks;
		return OK;
	}
	
	int setNumberOfBlocks(const unsigned long long& newValue) {
		NumberOfBlocks = newValue;
		NumberOfBlocks_isNULL = false;
		return OK;
	}

	int getConsumableBlocks(unsigned long long& value) const {
		if (ConsumableBlocks_isNULL==true)
			return NOT_FOUND;
		value = ConsumableBlocks;
		return OK;
	}
	
	int setConsumableBlocks(const unsigned long long& newValue) {
		ConsumableBlocks = newValue;
		ConsumableBlocks_isNULL = false;
		return OK;
	}

	int getIsBasedOnUnderlyingRedundancy(bool& value) const {
		if (IsBasedOnUnderlyingRedundancy_isNULL==true)
			return NOT_FOUND;
		value = IsBasedOnUnderlyingRedundancy;
		return OK;
	}
	
	int setIsBasedOnUnderlyingRedundancy(const bool& newValue) {
		IsBasedOnUnderlyingRedundancy = newValue;
		IsBasedOnUnderlyingRedundancy_isNULL = false;
		return OK;
	}

	int getSequentialAccess(bool& value) const {
		if (SequentialAccess_isNULL==true)
			return NOT_FOUND;
		value = SequentialAccess;
		return OK;
	}
	
	int setSequentialAccess(const bool& newValue) {
		SequentialAccess = newValue;
		SequentialAccess_isNULL = false;
		return OK;
	}

	int getExtentStatus(vector<unsigned short>& value) const {
		if (ExtentStatus_isNULL==true)
			return NOT_FOUND;
		value = ExtentStatus;
		return OK;
	}
	
	int setExtentStatus(const vector<unsigned short>& newValue) {
		ExtentStatus = newValue;
		ExtentStatus_isNULL = false;
		return OK;
	}

	int getNoSinglePointOfFailure(bool& value) const {
		if (NoSinglePointOfFailure_isNULL==true)
			return NOT_FOUND;
		value = NoSinglePointOfFailure;
		return OK;
	}
	
	int setNoSinglePointOfFailure(const bool& newValue) {
		NoSinglePointOfFailure = newValue;
		NoSinglePointOfFailure_isNULL = false;
		return OK;
	}

	int getDataRedundancy(unsigned short& value) const {
		if (DataRedundancy_isNULL==true)
			return NOT_FOUND;
		value = DataRedundancy;
		return OK;
	}
	
	int setDataRedundancy(const unsigned short& newValue) {
		DataRedundancy = newValue;
		DataRedundancy_isNULL = false;
		return OK;
	}

	int getPackageRedundancy(unsigned short& value) const {
		if (PackageRedundancy_isNULL==true)
			return NOT_FOUND;
		value = PackageRedundancy;
		return OK;
	}
	
	int setPackageRedundancy(const unsigned short& newValue) {
		PackageRedundancy = newValue;
		PackageRedundancy_isNULL = false;
		return OK;
	}

	int getDeltaReservation(unsigned char& value) const {
		if (DeltaReservation_isNULL==true)
			return NOT_FOUND;
		value = DeltaReservation;
		return OK;
	}
	
	int setDeltaReservation(const unsigned char& newValue) {
		DeltaReservation = newValue;
		DeltaReservation_isNULL = false;
		return OK;
	}

	int getPrimordial(bool& value) const {
		if (Primordial_isNULL==true)
			return NOT_FOUND;
		value = Primordial;
		return OK;
	}
	
	int setPrimordial(const bool& newValue) {
		Primordial = newValue;
		Primordial_isNULL = false;
		return OK;
	}

	int getName(string& value) const {
		if (Name_isNULL==true)
			return NOT_FOUND;
		value = Name;
		return OK;
	}
	
	int setName(const string& newValue) {
		Name = newValue;
		Name_isNULL = false;
		return OK;
	}

	int getNameFormat(unsigned short& value) const {
		if (NameFormat_isNULL==true)
			return NOT_FOUND;
		value = NameFormat;
		return OK;
	}
	
	int setNameFormat(const unsigned short& newValue) {
		NameFormat = newValue;
		NameFormat_isNULL = false;
		return OK;
	}

	int getNameNamespace(unsigned short& value) const {
		if (NameNamespace_isNULL==true)
			return NOT_FOUND;
		value = NameNamespace;
		return OK;
	}
	
	int setNameNamespace(const unsigned short& newValue) {
		NameNamespace = newValue;
		NameNamespace_isNULL = false;
		return OK;
	}

	int getOtherNameNamespace(string& value) const {
		if (OtherNameNamespace_isNULL==true)
			return NOT_FOUND;
		value = OtherNameNamespace;
		return OK;
	}
	
	int setOtherNameNamespace(const string& newValue) {
		OtherNameNamespace = newValue;
		OtherNameNamespace_isNULL = false;
		return OK;
	}

	int getOtherNameFormat(string& value) const {
		if (OtherNameFormat_isNULL==true)
			return NOT_FOUND;
		value = OtherNameFormat;
		return OK;
	}
	
	int setOtherNameFormat(const string& newValue) {
		OtherNameFormat = newValue;
		OtherNameFormat_isNULL = false;
		return OK;
	}

	int getUsage(unsigned short& value) const {
		if (Usage_isNULL==true)
			return NOT_FOUND;
		value = Usage;
		return OK;
	}
	
	int setUsage(const unsigned short& newValue) {
		Usage = newValue;
		Usage_isNULL = false;
		return OK;
	}

	int getOtherUsageDescription(string& value) const {
		if (OtherUsageDescription_isNULL==true)
			return NOT_FOUND;
		value = OtherUsageDescription;
		return OK;
	}
	
	int setOtherUsageDescription(const string& newValue) {
		OtherUsageDescription = newValue;
		OtherUsageDescription_isNULL = false;
		return OK;
	}

	int getClientSettableUsage(vector<unsigned short>& value) const {
		if (ClientSettableUsage_isNULL==true)
			return NOT_FOUND;
		value = ClientSettableUsage;
		return OK;
	}
	
	int setClientSettableUsage(const vector<unsigned short>& newValue) {
		ClientSettableUsage = newValue;
		ClientSettableUsage_isNULL = false;
		return OK;
	}

	int getVolatile(bool& value) const {
		if (Volatile_isNULL==true)
			return NOT_FOUND;
		value = Volatile;
		return OK;
	}
	
	int setVolatile(const bool& newValue) {
		Volatile = newValue;
		Volatile_isNULL = false;
		return OK;
	}

	int getErrorMethodology(string& value) const {
		if (ErrorMethodology_isNULL==true)
			return NOT_FOUND;
		value = ErrorMethodology;
		return OK;
	}
	
	int setErrorMethodology(const string& newValue) {
		ErrorMethodology = newValue;
		ErrorMethodology_isNULL = false;
		return OK;
	}

	int getStartingAddress(unsigned long long& value) const {
		if (StartingAddress_isNULL==true)
			return NOT_FOUND;
		value = StartingAddress;
		return OK;
	}
	
	int setStartingAddress(const unsigned long long& newValue) {
		StartingAddress = newValue;
		StartingAddress_isNULL = false;
		return OK;
	}

	int getEndingAddress(unsigned long long& value) const {
		if (EndingAddress_isNULL==true)
			return NOT_FOUND;
		value = EndingAddress;
		return OK;
	}
	
	int setEndingAddress(const unsigned long long& newValue) {
		EndingAddress = newValue;
		EndingAddress_isNULL = false;
		return OK;
	}

	int getErrorInfo(unsigned short& value) const {
		if (ErrorInfo_isNULL==true)
			return NOT_FOUND;
		value = ErrorInfo;
		return OK;
	}
	
	int setErrorInfo(const unsigned short& newValue) {
		ErrorInfo = newValue;
		ErrorInfo_isNULL = false;
		return OK;
	}

	int getOtherErrorDescription(string& value) const {
		if (OtherErrorDescription_isNULL==true)
			return NOT_FOUND;
		value = OtherErrorDescription;
		return OK;
	}
	
	int setOtherErrorDescription(const string& newValue) {
		OtherErrorDescription = newValue;
		OtherErrorDescription_isNULL = false;
		return OK;
	}

	int getCorrectableError(bool& value) const {
		if (CorrectableError_isNULL==true)
			return NOT_FOUND;
		value = CorrectableError;
		return OK;
	}
	
	int setCorrectableError(const bool& newValue) {
		CorrectableError = newValue;
		CorrectableError_isNULL = false;
		return OK;
	}

	int getErrorTime(string& value) const {
		if (ErrorTime_isNULL==true)
			return NOT_FOUND;
		value = ErrorTime;
		return OK;
	}
	
	int setErrorTime(const string& newValue) {
		ErrorTime = newValue;
		ErrorTime_isNULL = false;
		return OK;
	}

	int getErrorAccess(unsigned short& value) const {
		if (ErrorAccess_isNULL==true)
			return NOT_FOUND;
		value = ErrorAccess;
		return OK;
	}
	
	int setErrorAccess(const unsigned short& newValue) {
		ErrorAccess = newValue;
		ErrorAccess_isNULL = false;
		return OK;
	}

	int getErrorTransferSize(unsigned int& value) const {
		if (ErrorTransferSize_isNULL==true)
			return NOT_FOUND;
		value = ErrorTransferSize;
		return OK;
	}
	
	int setErrorTransferSize(const unsigned int& newValue) {
		ErrorTransferSize = newValue;
		ErrorTransferSize_isNULL = false;
		return OK;
	}

	int getErrorData(vector<unsigned char>& value) const {
		if (ErrorData_isNULL==true)
			return NOT_FOUND;
		value = ErrorData;
		return OK;
	}
	
	int setErrorData(const vector<unsigned char>& newValue) {
		ErrorData = newValue;
		ErrorData_isNULL = false;
		return OK;
	}

	int getErrorDataOrder(unsigned short& value) const {
		if (ErrorDataOrder_isNULL==true)
			return NOT_FOUND;
		value = ErrorDataOrder;
		return OK;
	}
	
	int setErrorDataOrder(const unsigned short& newValue) {
		ErrorDataOrder = newValue;
		ErrorDataOrder_isNULL = false;
		return OK;
	}

	int getErrorAddress(unsigned long long& value) const {
		if (ErrorAddress_isNULL==true)
			return NOT_FOUND;
		value = ErrorAddress;
		return OK;
	}
	
	int setErrorAddress(const unsigned long long& newValue) {
		ErrorAddress = newValue;
		ErrorAddress_isNULL = false;
		return OK;
	}

	int getSystemLevelAddress(bool& value) const {
		if (SystemLevelAddress_isNULL==true)
			return NOT_FOUND;
		value = SystemLevelAddress;
		return OK;
	}
	
	int setSystemLevelAddress(const bool& newValue) {
		SystemLevelAddress = newValue;
		SystemLevelAddress_isNULL = false;
		return OK;
	}

	int getErrorResolution(unsigned long long& value) const {
		if (ErrorResolution_isNULL==true)
			return NOT_FOUND;
		value = ErrorResolution;
		return OK;
	}
	
	int setErrorResolution(const unsigned long long& newValue) {
		ErrorResolution = newValue;
		ErrorResolution_isNULL = false;
		return OK;
	}

	int getAdditionalErrorData(vector<unsigned char>& value) const {
		if (AdditionalErrorData_isNULL==true)
			return NOT_FOUND;
		value = AdditionalErrorData;
		return OK;
	}
	
	int setAdditionalErrorData(const vector<unsigned char>& newValue) {
		AdditionalErrorData = newValue;
		AdditionalErrorData_isNULL = false;
		return OK;
	}

};

class OpenDRIM_Memory_RequestStateChange_In {

public:

	unsigned short RequestedState;
	bool RequestedState_isNULL;

	Objectpath Job;
	bool Job_isNULL;

	string TimeoutPeriod;
	bool TimeoutPeriod_isNULL;

	OpenDRIM_Memory_RequestStateChange_In() {
		RequestedState_isNULL = true;
		Job_isNULL = true;
		TimeoutPeriod_isNULL = true;
	}

	~OpenDRIM_Memory_RequestStateChange_In() {}

	int getRequestedState(unsigned short& value) const {
		if (RequestedState_isNULL == true)
			return NOT_FOUND;
		value = RequestedState;
		return OK;
	}
	int setRequestedState(const unsigned short&  newValue) {
		RequestedState = newValue;
		RequestedState_isNULL = false;
		return OK;
	}

	int getJob(Objectpath& value) const {
		if (Job_isNULL == true)
			return NOT_FOUND;
		value = Job;
		return OK;
	}
	int setJob(const Objectpath&  newValue) {
		Job = newValue;
		Job_isNULL = false;
		return OK;
	}

	int getTimeoutPeriod(string& value) const {
		if (TimeoutPeriod_isNULL == true)
			return NOT_FOUND;
		value = TimeoutPeriod;
		return OK;
	}
	int setTimeoutPeriod(const string&  newValue) {
		TimeoutPeriod = newValue;
		TimeoutPeriod_isNULL = false;
		return OK;
	}

};

class OpenDRIM_Memory_RequestStateChange_Out {

public:

	Objectpath Job;
	bool Job_isNULL;

	OpenDRIM_Memory_RequestStateChange_Out() {
		Job_isNULL = true;
	}

	~OpenDRIM_Memory_RequestStateChange_Out() {}

	int getJob(Objectpath& value) const {
		if (Job_isNULL == true)
			return NOT_FOUND;
		value = Job;
		return OK;
	}
	int setJob(const Objectpath&  newValue) {
		Job = newValue;
		Job_isNULL = false;
		return OK;
	}

};

class OpenDRIM_Memory_SetPowerState_In {

public:

	unsigned short PowerState;
	bool PowerState_isNULL;

	string Time;
	bool Time_isNULL;

	OpenDRIM_Memory_SetPowerState_In() {
		PowerState_isNULL = true;
		Time_isNULL = true;
	}

	~OpenDRIM_Memory_SetPowerState_In() {}

	int getPowerState(unsigned short& value) const {
		if (PowerState_isNULL == true)
			return NOT_FOUND;
		value = PowerState;
		return OK;
	}
	int setPowerState(const unsigned short&  newValue) {
		PowerState = newValue;
		PowerState_isNULL = false;
		return OK;
	}

	int getTime(string& value) const {
		if (Time_isNULL == true)
			return NOT_FOUND;
		value = Time;
		return OK;
	}
	int setTime(const string&  newValue) {
		Time = newValue;
		Time_isNULL = false;
		return OK;
	}

};

class OpenDRIM_Memory_EnableDevice_In {

public:

	bool Enabled;
	bool Enabled_isNULL;

	OpenDRIM_Memory_EnableDevice_In() {
		Enabled_isNULL = true;
	}

	~OpenDRIM_Memory_EnableDevice_In() {}

	int getEnabled(bool& value) const {
		if (Enabled_isNULL == true)
			return NOT_FOUND;
		value = Enabled;
		return OK;
	}
	int setEnabled(const bool&  newValue) {
		Enabled = newValue;
		Enabled_isNULL = false;
		return OK;
	}

};

class OpenDRIM_Memory_OnlineDevice_In {

public:

	bool Online;
	bool Online_isNULL;

	OpenDRIM_Memory_OnlineDevice_In() {
		Online_isNULL = true;
	}

	~OpenDRIM_Memory_OnlineDevice_In() {}

	int getOnline(bool& value) const {
		if (Online_isNULL == true)
			return NOT_FOUND;
		value = Online;
		return OK;
	}
	int setOnline(const bool&  newValue) {
		Online = newValue;
		Online_isNULL = false;
		return OK;
	}

};

class OpenDRIM_Memory_QuiesceDevice_In {

public:

	bool Quiesce;
	bool Quiesce_isNULL;

	OpenDRIM_Memory_QuiesceDevice_In() {
		Quiesce_isNULL = true;
	}

	~OpenDRIM_Memory_QuiesceDevice_In() {}

	int getQuiesce(bool& value) const {
		if (Quiesce_isNULL == true)
			return NOT_FOUND;
		value = Quiesce;
		return OK;
	}
	int setQuiesce(const bool&  newValue) {
		Quiesce = newValue;
		Quiesce_isNULL = false;
		return OK;
	}

};

#endif /*OPENDRIM_MEMORY_H_*/
