package tijmp;

import java.util.concurrent.atomic.AtomicLong;
/** The method tracer used in tijmp.
 */
public class TIJMPMethodTracer {
    private static AtomicLong entryCount;
    private static AtomicLong exitCount;

    public static void setInited () {
	entryCount = new AtomicLong ();
	exitCount = new AtomicLong ();
    }

    public static void methodEntry (int cnum, int mnum) {
	if (entryCount != null)
	    entryCount.incrementAndGet ();
    }
    
    public static void methodExit (int cnum, int mnum) {
	if (exitCount != null)
	    exitCount.incrementAndGet ();
    }

    public static long getEntryCount () {
	return entryCount.longValue ();
    }

    public static long getExitCount () {
	return exitCount.longValue ();
    }
}
