#ifndef TIJMP_H__
#define TIJMP_H__

/** Log a an error in some nice way. */
void handle_global_error (jvmtiError err);

/** Tell the profiler that we have reached vm_init. */
void tijmp_vm_inited (void);

/** Check if the profiler has reached vm_init */
jint tijmp_after_vm_init (void);

/** Tell the profiler that we have reached vm_death. */
void tijmp_vm_death (void);

/** Check if the profiler has reached vm_death */
jint tijmp_after_vm_death (void);

/** Lock the bci monitor */
void tijmp_bci_lock (void);

/** Unlock the bci monitor */
void tijmp_bci_unlock (void);

#endif /* TIJMP_H__ */
