/* Call the function version of ttm, called textohtml */
/* If a second command line argument exists it is the TeX file to read
 otherwise accept interactive input. Files longer than CHARLEN are truncated.*/
#define CHARLEN 5000
# include <stdio.h>
# include <string.h>
#ifdef DMALLOC
#include <dmalloc.h>
#else
#include <malloc.h>
#endif
int main(int argc, char *argv[])
{
  extern int textomathml(char* , char* , int, char*, int);
  extern int textomathmldyn(char* , char** , char**, int);
  FILE *file;
  int result,call=0;
  char tex[CHARLEN]={0};
  char *html;
  char *err;
  extern int ttm_mathitalic;
  extern int ttm_debug;
  ttm_debug=0;
  ttm_mathitalic=0; /*Turn off math italic switch*/
  if (argc>1) {
      while(argc>1){ /* Read a filename from the second argument.*/
	  if((file=fopen(argv[1],"r"))){
	      fprintf(stderr,"File translated %s\n",argv[1]);
	      while(fgets(tex,CHARLEN,file)){
		  result=textomathmldyn(tex,&html,&err,CHARLEN);
		  if (html) {
		      printf("%s",html);
		      free(html);
		  }
		  if(err) {
		      if(strlen(err))fprintf(stderr,"%s",err);
		      free(err);
		  }		  
	      }
	  }else{
	      fprintf(stderr,"Can't open file %s\n",argv[1]);
	      return 1;
	  }
	  argv++;
	  argc--;
      }
  }else{ /* Interactive line by line testing.*/
    fprintf(stdout,"Type in some TeX\n");
    while(fgets(tex,CHARLEN,stdin)){
      result=textomathmldyn(tex,&html,&err,CHARLEN);
      call++;
      printf("textohtml call number %d, result %d:\n%s\n%s",call,result,html,err);
    };
  }
  return 0;
}





