// -*- C++ -*-
// $Id: CoherentWrite_Test_Sender_exec.cpp 92902 2010-12-17 15:09:42Z mcorino $

/**
 * Code generated by the The ACE ORB (TAO) IDL Compiler v1.8.3
 * TAO and the TAO IDL Compiler have been developed by:
 *       Center for Distributed Object Computing
 *       Washington University
 *       St. Louis, MO
 *       USA
 *       http://www.cs.wustl.edu/~schmidt/doc-center.html
 * and
 *       Distributed Object Computing Laboratory
 *       University of California at Irvine
 *       Irvine, CA
 *       USA
 * and
 *       Institute for Software Integrated Systems
 *       Vanderbilt University
 *       Nashville, TN
 *       USA
 *       http://www.isis.vanderbilt.edu/
 *
 * Information about TAO is available at:
 *     http://www.cs.wustl.edu/~schmidt/TAO.html
 **/

#include "CoherentWrite_Test_Sender_exec.h"
#include "tao/ORB_Core.h"
#include "ace/Reactor.h"

namespace CIAO_CoherentWrite_Test_Sender_Impl
{
  /**
   * WriteHandler
   */

  WriteHandler::WriteHandler (Sender_exec_i &callback)
    : callback_ (callback)
  {
  }

  int
  WriteHandler::handle_exception (ACE_HANDLE)
  {
    this->callback_.start ();
    return 0;
  }

  /**
   * Facet Executor Implementation Class: restart_writer_exec_i
   */

  restart_writer_exec_i::restart_writer_exec_i (
        ::CoherentWrite_Test::CCM_Sender_Context_ptr ctx,
        Sender_exec_i &callback)
    : ciao_context_ (
        ::CoherentWrite_Test::CCM_Sender_Context::_duplicate (ctx))
      , callback_ (callback)
  {
  }

  restart_writer_exec_i::~restart_writer_exec_i (void)
  {
  }

  // Operations from ::CoherentWriteRestarter

  void
  restart_writer_exec_i::restart_write (void)
  {
    this->callback_.restart ();
  }

  /**
   * Component Executor Implementation Class: Sender_exec_i
   */

  Sender_exec_i::Sender_exec_i (void)
    : iterations_ (0)
      , run_ (1)
      , total_iter (0)
      , wh_ (0)
  {
        ACE_NEW_THROW_EX (this->wh_,
                          WriteHandler (*this),
                          ::CORBA::INTERNAL ());
  }

  Sender_exec_i::~Sender_exec_i (void)
  {
    delete this->wh_;
  }

  // Supported operations and attributes.
  ACE_Reactor*
  Sender_exec_i::reactor (void)
  {
    ACE_Reactor* reactor = 0;
    ::CORBA::Object_var ccm_object =
      this->ciao_context_->get_CCM_object();
    if (! ::CORBA::is_nil (ccm_object.in ()))
      {
        ::CORBA::ORB_var orb = ccm_object->_get_orb ();
        if (! ::CORBA::is_nil (orb.in ()))
          {
            reactor = orb->orb_core ()->reactor ();
          }
      }
    if (reactor == 0)
      {
        throw ::CORBA::INTERNAL ();
      }
    return reactor;
  }

  void
  Sender_exec_i::restart (void)
  {
    ++this->run_;
    delete this->wh_;
    ACE_NEW_THROW_EX (this->wh_,
                      WriteHandler (*this),
                      ::CORBA::INTERNAL ());
    this->reactor ()->notify (this->wh_);
  }

  void
  Sender_exec_i::start (void)
  {
    ::CoherentWriteTestConnector::Writer_var writer =
      this->ciao_context_->get_connection_info_write_data ();

    CoherentWriteStarter_var starter =
      this->ciao_context_->get_connection_start_reader ();
    if (::CORBA::is_nil (starter.in ()) ||
        ::CORBA::is_nil (writer.in ()))
      {
        ACE_ERROR ((LM_ERROR, ACE_TEXT ("ERROR: Unable to start the reader\n")));
        return;
      }

    writer->is_coherent_write (true);
    starter->set_reader_properties (this->iterations_);

    ACE_DEBUG ((LM_DEBUG, "Start run <%d> with <%u> iterations\n",
                          this->run_,
                          this->iterations ()));

    CoherentWriteTestSeq write_many_seq (this->iterations_);
    write_many_seq.length (this->iterations_);
    for (int i = 1; i < this->iterations_ + 1; ++i)
      {
        CoherentWriteTest new_key;
        new_key.symbol = CORBA::string_dup("KEY_1");
        new_key.iteration = ++total_iter;
        write_many_seq[i-1] = new_key;
      }
    writer->write_many (write_many_seq);
    ACE_DEBUG ((LM_DEBUG, ACE_TEXT ("Written <%u> keys uptil now\n"),
                total_iter));
    ACE_OS::sleep (2);
    starter->start_read (this->run_);
  }

  // Component attributes and port operations.

  ::CCM_CoherentWriteRestarter_ptr
  Sender_exec_i::get_restart_writer (void)
  {
    if ( ::CORBA::is_nil (this->ciao_restart_writer_.in ()))
      {
        restart_writer_exec_i *tmp = 0;
        ACE_NEW_RETURN (
          tmp,
          restart_writer_exec_i (
            this->ciao_context_.in (),
            *this),
            ::CCM_CoherentWriteRestarter::_nil ());

          this->ciao_restart_writer_ = tmp;
      }

    return
      ::CCM_CoherentWriteRestarter::_duplicate (
        this->ciao_restart_writer_.in ());
  }

  ::CORBA::UShort
  Sender_exec_i::iterations (void)
  {
    return this->iterations_;
  }

  void
  Sender_exec_i::iterations (
    const ::CORBA::UShort iterations)
  {
    this->iterations_ = iterations;
  }

  // Operations from Components::SessionComponent.

  void
  Sender_exec_i::set_session_context (
    ::Components::SessionContext_ptr ctx)
  {
    this->ciao_context_ =
      ::CoherentWrite_Test::CCM_Sender_Context::_narrow (ctx);

    if ( ::CORBA::is_nil (this->ciao_context_.in ()))
      {
        throw ::CORBA::INTERNAL ();
      }
  }

  void
  Sender_exec_i::configuration_complete (void)
  {
    /* Your code here. */
  }

  void
  Sender_exec_i::ccm_activate (void)
  {
    try
      {
        this->reactor ()->notify (this->wh_);
      }
    catch (const ::CORBA::Exception& ex)
      {
        ex._tao_print_exception ("Exception caught:");
        ACE_ERROR ((LM_ERROR,
          ACE_TEXT ("ERROR: GET_CONNECTION_START_READER : Exception caught\n")));
      }
    catch (...)
      {
        ACE_ERROR ((LM_ERROR,
          ACE_TEXT ("ERROR: GET_CONNECTION_START_READER : Unknown exception caught\n")));
      }
  }

  void
  Sender_exec_i::ccm_passivate (void)
  {
    /* Your code here. */
  }

  void
  Sender_exec_i::ccm_remove (void)
  {
    /* Your code here. */
  }

  extern "C" SENDER_EXEC_Export ::Components::EnterpriseComponent_ptr
  create_CoherentWrite_Test_Sender_Impl (void)
  {
    ::Components::EnterpriseComponent_ptr retval =
      ::Components::EnterpriseComponent::_nil ();

    ACE_NEW_NORETURN (
      retval,
      Sender_exec_i);

    return retval;
  }
}
