// ---------------------------------------------------------------------------
// - Predmth.hpp                                                             -
// - afnix:mth module - predicates declaration                               -
// ---------------------------------------------------------------------------
// - This program is free software;  you can redistribute it  and/or  modify -
// - it provided that this copyright notice is kept intact.                  -
// -                                                                         -
// - This program  is  distributed in  the hope  that it will be useful, but -
// - without  any  warranty;  without  even   the   implied    warranty   of -
// - merchantability or fitness for a particular purpose.  In no event shall -
// - the copyright holder be liable for any  direct, indirect, incidental or -
// - special damages arising in any way out of the use of this software.     -
// ---------------------------------------------------------------------------
// - copyright (c) 1999-2011 amaury darsch                                   -
// ---------------------------------------------------------------------------

#ifndef  AFNIX_PREDMTH_HPP
#define  AFNIX_PREDMTH_HPP

#ifndef  AFNIX_OBJECT_HPP
#include "Object.hpp"
#endif
 
namespace afnix {

  /// this file contains the predicates associated with the afnix:mth
  /// standard module.
  /// @author amaury darsch

  /// the integer plane point object predicate
  /// @param robj the current runnable
  /// @param nset the current nameset
  /// @param args the arguments list
  Object* mth_ippp (Runnable* robj, Nameset* nset, Cons* args);

  /// the real samples array object predicate
  /// @param robj the current runnable
  /// @param nset the current nameset
  /// @param args the arguments list
  Object* mth_rsap (Runnable* robj, Nameset* nset, Cons* args);

  /// the rvi object predicate
  /// @param robj the current runnable
  /// @param nset the current nameset
  /// @param args the arguments list
  Object* mth_rvip (Runnable* robj, Nameset* nset, Cons* args);

  /// the rmi object predicate
  /// @param robj the current runnable
  /// @param nset the current nameset
  /// @param args the arguments list
  Object* mth_rmip (Runnable* robj, Nameset* nset, Cons* args);

  /// the rsi object predicate
  /// @param robj the current runnable
  /// @param nset the current nameset
  /// @param args the arguments list
  Object* mth_rsip (Runnable* robj, Nameset* nset, Cons* args);

  /// the linear object predicate
  /// @param robj the current runnable
  /// @param nset the current nameset
  /// @param args the arguments list
  Object* mth_lnrp (Runnable* robj, Nameset* nset, Cons* args);

  /// the newton object predicate
  /// @param robj the current runnable
  /// @param nset the current nameset
  /// @param args the arguments list
  Object* mth_ntwp (Runnable* robj, Nameset* nset, Cons* args);

  /// the rfi object predicate
  /// @param robj the current runnable
  /// @param nset the current nameset
  /// @param args the arguments list
  Object* mth_rfip (Runnable* robj, Nameset* nset, Cons* args);

  /// the rvector object predicate
  /// @param robj the current runnable
  /// @param nset the current nameset
  /// @param args the arguments list
  Object* mth_rvectp (Runnable* robj, Nameset* nset, Cons* args);

  /// the rmatrix object predicate
  /// @param robj the current runnable
  /// @param nset the current nameset
  /// @param args the arguments list
  Object* mth_rmtrxp (Runnable* robj, Nameset* nset, Cons* args);

  /// the rsparse object predicate
  /// @param robj the current runnable
  /// @param nset the current nameset
  /// @param args the arguments list
  Object* mth_rsprsp (Runnable* robj, Nameset* nset, Cons* args);

  /// the rfunction object predicate
  /// @param robj the current runnable
  /// @param nset the current nameset
  /// @param args the arguments list
  Object* mth_rfuncp (Runnable* robj, Nameset* nset, Cons* args);

  /// the rpolynom object predicate
  /// @param robj the current runnable
  /// @param nset the current nameset
  /// @param args the arguments list
  Object* mth_rpolyp (Runnable* robj, Nameset* nset, Cons* args);
}

#endif
