// ---------------------------------------------------------------------------
// - Rsi.hpp                                                                 -
// - afnix:mth module - real sparse interface definitions                    -
// ---------------------------------------------------------------------------
// - This program is free software;  you can redistribute it  and/or  modify -
// - it provided that this copyright notice is kept intact.                  -
// -                                                                         -
// - This program  is  distributed in  the hope  that it will be useful, but -
// - without  any  warranty;  without  even   the   implied    warranty   of -
// - merchantability or fitness for a particular purpose.  In no event shall -
// - the copyright holder be liable for any  direct, indirect, incidental or -
// - special damages arising in any way out of the use of this software.     -
// ---------------------------------------------------------------------------
// - copyright (c) 1999-2011 amaury darsch                                   -
// ---------------------------------------------------------------------------

#ifndef  AFNIX_RSI_HPP
#define  AFNIX_RSI_HPP

#ifndef  AFNIX_OBJECT_HPP
#include "Object.hpp"
#endif
 
namespace afnix {

  /// This Rsi class is an abstract class that models the behavior of a
  /// real sparse vector. The class is not designed to be mutated and
  /// therefore does not provide all of the vector methods. The sparsity
  /// is merely designed here for storing real indexed value.
  /// @author amaury darsch

  class Rsi : public virtual Object {
  protected:
    /// the sparsity size
    t_long d_size;

  public:
    /// create a null sparse object
    Rsi (void);

    /// create a sparse object by size
    /// @param size the vector size
    Rsi (const t_long size);

    /// @return the sparse object size
    virtual t_long getsize (void) const;

    /// @return the sparse object length
    virtual t_long length (void) const =0;
      
    /// get a sparse index by position
    /// @param pos the position index
    virtual t_long getidx (const t_long pos) const =0;

    /// get a sparse value by position
    /// @param pos the position index
    virtual t_real getval (const t_long pos) const =0;

    /// set a sparse entry by index and value
    /// @param sidx the sparse index to set
    /// @param sval the sparse value to set
    /// @return the sparse position
    virtual t_long set (const t_long sidx, const t_real sval) =0;

  public:
    /// @return true if the given quark is defined
    bool isquark (const long quark, const bool hflg) const;

    /// apply this object with a set of arguments and a quark
    /// @param robj  the current runnable
    /// @param nset  the current nameset    
    /// @param quark the quark to apply these arguments
    /// @param argv  the arguments to apply
    Object* apply (Runnable* robj, Nameset* nset, const long quark,
                   Vector* argv);
  };
}

#endif
