/*
 * Copyright © 2010 Keith Packard <keithp@keithp.com>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; version 2 of the License.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.,
 * 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA.
 */

package altosui;

import java.awt.*;
import java.awt.event.*;
import javax.swing.*;
import javax.swing.filechooser.FileNameExtensionFilter;
import javax.swing.table.*;
import java.io.*;
import java.util.*;
import java.text.*;
import java.util.prefs.*;
import java.util.concurrent.LinkedBlockingQueue;

public class AltosFlightStatus extends JComponent implements AltosFlightDisplay {
	GridBagLayout	layout;

	public class FlightValue {
		JLabel		label;
		JTextField	value;

		void show(AltosState state, int crc_errors) {}

		void reset() {
			value.setText("");
		}

		void set_font() {
			label.setFont(Altos.status_font);
			value.setFont(Altos.status_font);
		}

		public FlightValue (GridBagLayout layout, int x, String text) {
			GridBagConstraints	c = new GridBagConstraints();
			c.insets = new Insets(5, 5, 5, 5);
			c.anchor = GridBagConstraints.CENTER;
			c.fill = GridBagConstraints.BOTH;
			c.weightx = 1;
			c.weighty = 1;

			label = new JLabel(text);
			label.setFont(Altos.status_font);
			label.setHorizontalAlignment(SwingConstants.CENTER);
			c.gridx = x; c.gridy = 0;
			layout.setConstraints(label, c);
			add(label);

			value = new JTextField("");
			value.setFont(Altos.status_font);
			value.setHorizontalAlignment(SwingConstants.CENTER);
			c.gridx = x; c.gridy = 1;
			layout.setConstraints(value, c);
			add(value);
		}
	}

	class Call extends FlightValue {
		void show(AltosState state, int crc_errors) {
			value.setText(state.data.callsign);
		}
		public Call (GridBagLayout layout, int x) {
			super (layout, x, "Callsign");
		}
	}

	Call call;

	class Serial extends FlightValue {
		void show(AltosState state, int crc_errors) {
			value.setText(String.format("%d", state.data.serial));
		}
		public Serial (GridBagLayout layout, int x) {
			super (layout, x, "Serial");
		}
	}

	Serial serial;

	class Flight extends FlightValue {
		void show(AltosState state, int crc_errors) {
			value.setText(String.format("%d", state.data.flight));
		}
		public Flight (GridBagLayout layout, int x) {
			super (layout, x, "Flight");
		}
	}

	Flight flight;

	class FlightState extends FlightValue {
		void show(AltosState state, int crc_errors) {
			value.setText(state.data.state());
		}
		public FlightState (GridBagLayout layout, int x) {
			super (layout, x, "State");
		}
	}

	FlightState flight_state;

	class RSSI extends FlightValue {
		void show(AltosState state, int crc_errors) {
			value.setText(String.format("%d", state.data.rssi));
		}
		public RSSI (GridBagLayout layout, int x) {
			super (layout, x, "RSSI (dBm)");
		}
	}

	RSSI rssi;

	public void reset () {
		call.reset();
		serial.reset();
		flight.reset();
		flight_state.reset();
		rssi.reset();
	}

	public void set_font () {
		call.set_font();
		serial.set_font();
		flight.set_font();
		flight_state.set_font();
		rssi.set_font();
	}

	public void show (AltosState state, int crc_errors) {
		call.show(state, crc_errors);
		serial.show(state, crc_errors);
		flight.show(state, crc_errors);
		flight_state.show(state, crc_errors);
		rssi.show(state, crc_errors);
	}

	public int height() {
		Dimension d = layout.preferredLayoutSize(this);
		return d.height;
	}

	public AltosFlightStatus() {
		layout = new GridBagLayout();

		setLayout(layout);

		call = new Call(layout, 0);
		serial = new Serial(layout, 1);
		flight = new Flight(layout, 2);
		flight_state = new FlightState(layout, 3);
		rssi = new RSSI(layout, 4);
	}
}
