# I.6 What about the _"Tragedy of the Commons"_?

The term _"Tragedy of the Commons"_ is a phrase which is used to describe why,
according to some, commonly owned resources will be destructively overused.
The term was first coined by Garret Hardin in December 1968. [_"The Tragedy of
the Commons"_, **Science**, Vol. 162, No. 3859, pp. 1243-1248] It quickly
became popular with those arguing against any form of collective ownership or
socialism and would be the basis for many arguments for privatisation.

Unsurprisingly, given its popularity with defenders of capitalism and neo-
classical economists, Hardin's argument was a pure thought experiment with
absolutely no empirical evidence to support it. He suggested a scenario in
which commonly owned pasture was open to all local herdsmen to feed their
cattle on. Hardin complemented this assumption with the standard ones of neo-
classical economics, arguing that each herdsman would try to keep as many
cattle as possible on the commons to maximise their income. This would result
in overgrazing and environmental destruction as the cost of each feeding
additional animals is shouldered by all who use the commons while the benefits
accrue to the individual herdsman. However, what is individually rational
becomes collectively irrational when each herdsman, acting in isolation, does
the same thing. The net result of the individual's actions is the ending of
the livelihood of **every** herdsman as the land becomes overused.

His article was used to justify both nationalisation and privatisation of
communal resources (the former often a precursor for the latter). As state
ownership fell out of favour, the lesson of this experiment in logic was as
uniform as it was simple: only privatisation of common resources could ensure
their efficient use and stop them being overused and destroyed. Coming as it
did before the rise of neo-liberalism in the 1970s, Hardin's essay was much
referenced by those seeking to privatise nationalised industries and eliminate
communal institutions in tribal societies in the Third World. That these
resulted in wealth being concentrated in a few hands should come as no
surprise.

Needless to say, there are numerous problems with Hardin's analysis. Most
fundamentally, it was a pure thought experiment and, as such, was not informed
by historical or current practice. In other words, it did not reflect the
reality of the commons as a social institution. The so-called _"Tragedy of the
Commons"_ was no such thing. It is actually an imposition of the _"tragedy of
the free-for-all"_ to communally owned resources (in this case, land). In
reality, commons were **never** _"free for all"_ resources and while the
latter may see overuse and destruction the former managed to survive thousands
of years. So, unfortunately for the supporters of private property who so
regularly invoke the _"Tragedy of the Commons"_, they simply show their
ignorance of what true commons are. As socialist Allan Engler points out:

> _"Supporters of capitalism cite what they call the tragedy of the commons to
explain the wanton plundering of forests, fish and waterways, but common
property is not the problem. When property was held in common by tribes, clans
and villages, people took no more than their share and respected the rights of
others. They cared for common property and when necessary acted together to
protect it against those who would damage it. Under capitalism, there is no
common property. (Public property is a form of private property, property
owned by the government as a corporate person.) Capitalism recognises only
private property and free-for-all property. Nobody is responsible for free-
for-all property until someone claims it as his own. He then has a right to do
as he pleases with it, a right that is uniquely capitalist. Unlike common or
personal property, capitalist property is not valued for itself or for its
utility. It is valued for the revenue it produces for its owner. If the
capitalist owner can maximise his revenue by liquidating it, he has the right
to do that."_ [**Apostles of Greed**, pp. 58-59]

Therefore, as Colin Ward argues, _"[l]ocal, popular, control is the surest way
of avoiding the tragedy of the commons."_ [**Reflected in Water**, p. 20]
Given that a social anarchist society is a communal, decentralised one, it
will have little to fear from irrational overuse or abuse of communally owned
and used resources.

So, the **real** problem is that a lot of economists and sociologists conflate
Hardin's scenario, in which **unmanaged** resources are free for all, with the
situation that prevailed in the use of commons which were communally
**managed** resources in village and tribal communities. Historian E.P.
Thompson, for example, noted that Hardin was _"historically uninformed"_ when
he assumed that commons were pastures open to all. The commons, in reality,
**were** managed by common agreements between those who used them. In an
extensive investigation on this subject, Thompson showed that the _"argument
[is] that since resources held in common are not owned and protected by
anyone, there is an inexorable economic logic that dooms them to over-
exploitation . . . Despite its common sense air, what it overlooks is that
commoners themselves were not without common sense. Over time and over space
the users of commons have developed a rich variety of institutions and
community sanctions which have effected restraints and stints upon use . . .
As the old . . . institutions lapsed, so they fed into a vacuum in which
political influence, market forces, and popular assertion contested with each
other without common rules."_ [**Customs in Common**, p. 108fn and p. 107]
Colin Ward points to a more recent example, that of Spain after the victory of
Franco:

> _"The water history of Spain demonstrates that the tragedy of the commons is
not the one identified by Garrett Hardin. Communal control developed an
elaborate and sophisticated system of fair shares for all. The private
property recommended by Hardin resulted in the selfish individualism that he
thought was inevitable with common access, or in the lofty indifference of the
big landowners."_ [**Op. Cit.**, p. 27]

So, for a while, Hardin's essay _"was taken to provide an argument for the
privatisation of the commons. It is now a well-developed point that Hardin's
argument is not a tragedy of common ownership at all . . . Hardin's argument
is a problem not of common ownership, but of open access in a context of
private ownership of particular assets."_ [John O'Neill, **Markets,
Deliberation and Environment**, p. 54] Significantly, Hardin later admitted
his mistake and noted that _"it is clear to me that the title of my original
contribution should have been **The Tragedy of the** Unmanaged **Commons** . .
. I can understand how I might have misled others."_ [quoted by O'Neill, **Op.
Cit.**, p. 199] But, of course, by then the damage had been done.

There is something quite arrogant about Hardin's assertions, as he basically
assumed that peasant farmers are unable to recognise certain disaster and
change their behaviour accordingly. This, apparently, is where enlightened
elites (governmental and economic) step in. However, in the real world, small
farmers (and others) have created their own institutions and rules for
preserving resources and ensuring that their community has the resources it
needed to survive. Hardin, in other words, ignored what actually happens in a
real commons, namely communal control and self-regulation by the communities
involved who develop the appropriate communal institutions to do so.

Surely, the very obvious fact that humans have lived in societies with commons
for centuries and did not overuse them disproves Hardin's most fundamental
assumptions. _"If we misunderstand the true nature of the commons,"_ argues
scientist Susan Jane Buck Cox _"we also misunderstand the implications of the
demise of the traditional, commons system. Perhaps what existed in fact was
not a 'tragedy of the commons' but rather a triumph: that for hundreds of
years -- and perhaps thousands, although written records do not exist to prove
the longer era -- land was managed successfully by communities."_ This
suggests that it is a case of _"the myth of the tragedy of the commons"_,
rooted in an argument which is _"historically false"_ as the _"commons were
carefully and painstakingly regulated."_ She points to a wider issue, namely
whether _"our perceptions of the nature of humankind are awry"_ for _"it seems
quite likely if 'economic man' had been managing the commons that tragedy
really would have occurred,"_ so _"perhaps someone else was running the
common."_ [_"No Tragedy on the Commons"_, pp. 49-61, **Environmental Ethics**,
vol. 7, p. 60, p. 53, p. 56 and p. 61]

One economist has noted that the "tragedy of the commons" only makes sense
once the assumption of neo-classical economics are taken for granted. If we
assume atomised individuals accessing unmanaged lands then Hardin's
conclusions automatically flow. However, _"if the property were **really**
common, this would imply the necessary existence of institutional agreements .
. . between the co-owners to establish the rules for decisions governing the
management of the resource. To put it more clearly, for common property to be
truly common property implies its existence as an institution."_ It is
precisely these kinds of human institutions which neo-classical economics
ignores and so _"the so-called 'tragedy of the commons' is more accurately
considered 'the tragedy of a methodological individualism'"_. As many critics
note, there are numerous _"conceptual errors"_ contained in the article and
these _"have been repeated systematically by economists."_ In summary, _"the
so-called tragedy of the commons has nothing to do with common property, but
with unrestricted and unregulated access."_ [F. Aguilera-Klink, _"Some Notes
on the Misuse of Classic Writings in Economics on the Subject of Common
Property"_, pp. 221-8, **Ecological Economics**, No. 9, p. 223, p. 221, p. 224
and p. 226]

Much the same can be said against those who argue that the experience of
Stalinism in the Eastern Block and elsewhere shows that public property leads
to pollution and destruction of natural resources. Such arguments also show a
lack of awareness of what common property actually is (it is no co-incidence
that the propertarian-right use such an argument). This is because the
resources in question, as we discussed in [section B.3.5](secB3.md#secb35),
were **not** owned or managed in common -- the fact that these countries were
dictatorships excluded popular control of resources. Thus Stalinism does not,
in fact, show the dangers of having commons or public ownership. Rather it
shows the danger of not subjecting those who manage a resource to public
control (and it is no co-incidence that the USA is far more polluted than
Western Europe -- in the USA, like in the USSR, the controllers of resources
are not subject to popular control and so pass pollution on to the public).
Stalinism shows the danger of state owned resource use (nationalisation)
rather than commonly owned resource use (socialisation), particularly when the
state in question is not under even the limited control of its subjects
implied in representative democracy.

This confusion of public and state owned resources has, of course, been used
to justify the stealing of communal property by the rich and the state. The
continued acceptance of this "confusion" in political debate, like the
continued use of Hardin's original and flawed _"Tragedy of the Commons"_, is
due to the utility of the theory for the rich and powerful, who have a vested
interest in undermining pre-capitalist social forms and stealing communal
resources. Most examples used to justify the _"tragedy of the commons"_ are
**false** examples, based on situations in which the underlying social context
is assumed to be radically different from that involved in using true commons.

In reality, the _"tragedy of the commons"_ comes about only after wealth and
private property, backed by the state, starts to eat into and destroy communal
life. This is well indicated by the fact that commons existed for thousands of
years and only disappeared after the rise of capitalism -- and the powerful
central state it requires -- had eroded communal values and traditions.
Without the influence of wealth concentrations and the state, people get
together and come to agreements over how to use communal resources and have
been doing so for millennia. That was how the commons were successfully
managed before the wealthy sought to increase their holdings and deny the poor
access to land in order to make them fully dependent on the power and whims of
the owning class.

Thus, as Kropotkin stressed, the state _"systematically weeded out all
institutions in which the mutual-aid tendency had formerly found its
expression. The village communities were bereft of their folkmotes, their
courts and independent administration; their lands were confiscated."_
[**Mutual Aid**, p. 182] The possibilities of free discussion and agreement
were destroyed in the name of "absolute" property rights and the power and
authority which goes with them. Both political influence and market forces
were, and are, dominated by wealth: _"There were two occasions that dictated
absolute precision: a trial at law and a process of enclosure. And both
occasions favoured those with power and purses against the little users."_
Popular assertion meant little when the state enforces property rights in the
interests of the wealthy. Ultimately, _"Parliament and law imposed capitalist
definitions to exclusive property in land."_ [Thompson, **Op. Cit.**, p. 134
and p. 163] As Cox suggested, many tenants were _"denied [their] remedy at law
for the illegal abuses of the more powerful landowners"_ and _"[s]ponsored by
wealthy landowners, the land reform was frequently no more than a
sophisticated land-grab."_ [**Op. Cit.**, p. 58 and p. 59] Gerrard Winstanley,
the Digger (and proto-anarchist), was only expressing a widespread popular
sentiment when he complained that _"in Parishes where Commons lie the rich
Norman Freeholders, or the new (more covetous) Gentry overstock the Commons
with sheep and cattle, so that the inferior Tenants and poor labourers can
hardly keep a cow but half starve her."_ [quoted by Maurice Dobb, **Studies in
the Development of Capitalism**, p. 173] The working class is only "left
alone" to starve.

As discussed in [section F.8](secF8.md), the enclosures were part of a wider
state-imposition of capitalism onto society. Of course, enclosure was often
justified by supporters of capitalism by the increased productivity which,
they claim, resulted from it (in effect, repeating Locke's earlier, and
flawed, argument -- see [section B.3.4](secB3.md#secb34)). There are three
objections to this. First, it cannot be assumed that increased productivity
could not be achieved by keeping the commons and by the commoners applying the
improved techniques and technologies that contributed to any post-enclosure
increased productivity. Second, it ignores the key issue of liberty and
replaces it with property (increases in wealth being considered more important
than reducing the freedom of the working class). Third, and more importantly,
this paternalistic rationale for coercion and state action does not fit well
with such apologist's opposition to (certain forms of) state intervention
today (such as taxation or popular land reform). If the "ends justify the
means" (which is what their arguments boil down to) when applied to the rural
working class, then they have little basis for opposing taxation of the
wealthy elite or pro-worker land-reform in a democracy or a popular social
revolution.

To conclude. The "tragedy of the commons" argument is conceptually flawed and
empirically wrong (unsurprising, given that no actual empirical evidence was
presented to support the argument). Sadly, this has not stopped Hardin, or
those inspired by his arguments, from suggesting policies based on a somewhat
dubious understanding of history and humanity. Perhaps this is not that
surprising, given that Hardin's assumptions (which drive his conclusions) are
based not on actual people nor historical evidence but rather by fundamental
components of capitalist economic theory. While under capitalism, and the
short-termism imposed by market forces, you could easily imagine that a desire
for profit would outweigh a person's interest in the long-term survival of
their community, such a perspective is relatively recent in human history.

In fact, communal ownership produces a strong incentive to protect such
resources for people are aware that their offspring will need them and so be
inclined to look after them. By having more resources available, they would be
able to resist the pressures of short-termism and so resist maximising current
production without regard for the future. Capitalist owners have the opposite
incentive for, as argued in [section E.3](secE3.md), unless they maximise
short-term profits then they will not be around in the long-term (so if wood
means more profits than centuries-old forests then the trees will be chopped
down). By combining common ownership with decentralised and federated communal
self-management, anarchism will be more than able to manage resources
effectively, avoiding the pitfalls of both privatisation and nationalisation.

## I.6.1 How can property _"owned by everyone in the world"_ be used?

First, we need to point out the fallacy normally lying behind this objection.
It is assumed that because everyone owns something, then everyone has to be
consulted in what it is used for. This, however, applies the logic of private
property to non-capitalist social forms. While it is true that everyone owns
collective "property" in an anarchist society, it does not mean that everyone
**uses** it. Carlo Cafiero, one of the founders of communist-anarchism, stated
the obvious:

> _"The common wealth being scattered right across the planet, while belonging
by right to the whole of humanity, those who happen to be within reach of that
wealth and in a position to make use of it will utilise it in common. The folk
from a given country will use the land, the machines, the workshops, the
houses, etc., of that country and they will all make common use of them. As
part of humanity, they will exercise here, in fact and directly, their rights
over a portion of mankind's wealth. But should an inhabitant of Peking visit
this country, he [or she] would enjoy the same rights as the rest: in common
with the others, he would enjoy all the wealth of the country, just as he [or
she] would have in Peking."_ [**No Gods, No Masters**, vol. 1, p. 250]

Anarchists, therefore, think that those who **use** a part of society's wealth
have the most say in what happens to it (e.g., workers control the means of
production they use and the work they do when using it). This does not mean
that those using it can do what they like to it. Users would be subject to
recall by local communities if they are abusing their position (for example,
if a workplace were polluting the environment, then the local community could
act to stop or, if need be, close down the workplace). Thus use rights (or
usufruct) replace property rights in a free society, combined with a strong
dose of _"think globally, act locally."_

It is no coincidence that societies that are stateless are also without
private property. As Murray Bookchin pointed out _"an individual appropriation
of goods, a personal claim to tools, land, and other resources . . . is fairly
common in organic [i.e. aboriginal] societies . . . By the same token, co-
operative work and the sharing of resources on a scale that could be called
communistic is also fairly common . . . But primary to both of these seemingly
contrasting relationships is the practice of **usufruct.**"_ Such stateless
societies are based upon _"the principle of **usufruct**, the freedom of
individuals in a community to appropriate resources merely by the virtue of
the fact they are using them . . . Such resources belong to the user as long
as they are being used. Function, in effect, replaces our hallowed concept of
possession."_ [**The Ecology of Freedom**, p. 116] The future stateless
society anarchists hope for would also be based upon such a principle.

In effect, critics of social anarchism confuse property with possession and
think that abolishing property automatically abolishes possession and use
rights. However, as argued in [section B.3](secB3.md), property and
possession are distinctly different. In the words of Charlotte Wilson:

> _"**Property** is the **domination** of an individual, or a coalition of
individuals, over things; it is not the claim of any person or persons to the
use of things -- this is, usufruct, a very different matter. Property means
the monopoly of wealth, the right to prevent others using it, whether the
owner needs it or not. Usufruct implies the claim to the use of such wealth as
supplies the users needs. If any individual shuts of a portion of it (which he
is not using, and does not need for his own use) from his fellows, he is
defrauding the whole community."_ [**Anarchist Essays**, p. 40]

Thus an anarchist society has a simple and effective means of deciding how
communally owned resources are used, one based on possession and usufruct. The
key thing to remember, as discussed in [section I.3.3](secI3.md#seci33), is
that socialisation means that **access** is free: users of a resource are not
subjected to hierarchical social relationships in order to use it.
Socialisation does not mean that people can, say, wander into someone's
workplace and simply take away a machine or computer. Rather, it means that
when someone joins a workplace they are sharing in the use of a common
resource and do so as a free and equal associate rather than as an obedient
wage-slave. If a resource is not being used, then they have free access to use
it. If it is being used then it will be managed by those who use it, with
access granted in agreed ways which ensure egalitarian, and so free,
relationships and outcomes.

As for deciding what a given area of commons is used for, that falls to the
local communities who live next to them. If, for example, a local self-managed
factory wants to expand and eat into the commons, then the local community who
uses (and so controls) the local commons would discuss it and come to an
agreement concerning it. If a minority **really** objects, they can use direct
action to put their point across. But anarchists argue that rational debate
among equals will not result in too much of that. Or suppose an individual
wanted to set up an allotment in a given area, which had not been allocated as
a park. Then he or she would notify the community assembly by appropriate
means (e.g. on a notice board or newspaper), and if no one objected at the
next assembly or in a set time-span, the allotment would go ahead, as no one
else desired to use the resource in question.

Other communities would be confederated with this one, and joint activity
would also be discussed by debate, with a community (like an individual) being
free **not** to associate if they so desire. Other communities could and would
object to ecologically and individually destructive practices. The
interrelationship of ecosystems and freedom is well known, and it is doubtful
that free individuals would sit back and let some amongst them destroy
**their** planet.

Therefore, those who use something control it. This means that "users groups"
would be created to manage resources used by more than one person. For
workplaces this would (essentially) be those who worked there (with, possibly,
the input of consumer groups and co-operatives). Housing associations made up
of tenants would manage housing and repairs. Resources that are used by
associations within society, such as communally owned schools, workshops,
computer networks, and so forth, would be managed on a day-to-day basis by
those who use them. User groups would decide access rules (for example, time-
tables and booking rules) and how they are used, making repairs and
improvements. Such groups would be accountable to their local community.
Hence, if that community thought that any activities by a group within it was
destroying communal resources or restricting access to them, the matter would
be discussed at the relevant assembly. In this way, interested parties manage
their own activities and the resources they use (and so would be very likely
to have an interest in ensuring their proper and effective use), but without
private property and its resulting hierarchies and restrictions on freedom.

Lastly, let us examine clashes of use rights, i.e. cases where two or more
people, communes or syndicates desire to use the same resource. In general,
such problems can be resolved by discussion and decision making by those
involved. This process would be roughly as follows: if the contesting parties
are reasonable, they would probably mutually agree to allow their dispute to
be settled by some mutual friend whose judgement they could trust, or they
would place it in the hands of a jury, randomly selected from the community or
communities in question. This would take place only if they could not come to
an agreement between themselves to share the resource in question.

On thing is certain, however, such disputes are much better settled without
the interference of authority or the re-creation of private property. If those
involved do not take the sane course described above and instead decide to set
up an authority, disaster will be the inevitable result. In the first place,
this authority will have to be given power to enforce its judgement in such
matters. If this happens, the new authority will undoubtedly keep for itself
the best of what is disputed (as payment for services rendered, of course!).
If private property were re-introduced, such authoritarian bodies would
develop sooner, rather than later, with two new classes of oppressors being
created -- the property owners and the enforcers of "justice." Ultimately, it
is strange to think that two parties who meet on terms of equality and
disagree could not be reasonable or just, and that a third party with power
backed up by violence will be the incarnation of justice itself. Common sense
should warn us against such an illusion and, if common sense is lacking, then
history shows that using authority or property to solve disputes is not wise!

And, we should note, it is equally as fallacious, as Leninists suggest, that
only centralisation can ensure common access and common use. Centralisation,
by removing control from the users into a body claiming to represent
"society", replaces the dangers of abuse by a small group of workers with the
dangers of abuse by a bureaucracy invested with power and authority over
**all**. If members of a commune or syndicate can abuse their position and
restrict access for their own benefit, so can the individuals who make up the
bureaucracy gathered round a centralised body (whether that body is, in
theory, accountable by election or not). Indeed, it is far more likely to
occur as the experience of Leninism shows beyond doubt. Thus
**decentralisation** is the key to common ownership and access, **not**
centralisation.

Communal ownership needs communal structures in order to function. Use rights,
and discussion among equals, replace property rights in a free society.
Freedom cannot survive if it is caged behind laws enforced by public or
private states.

## I.6.2 Doesn't communal ownership involve restricting individual liberty?

This point is expressed in many different forms. John Henry MacKay (an
individualist anarchist) put the point as follows:

> _"'Would you [the social anarchist], in the system of society which you call
'free Communism' prevent individuals from exchanging their labour among
themselves by means of their own medium of exchange? And further: Would you
prevent them from occupying land for the purpose of personal use?' . . . [The]
question was not to be escaped. If he answered 'Yes!' he admitted that society
had the right of control over the individual and threw overboard the autonomy
of the individual which he had always zealously defended; if on the other hand
he answered 'No!' he admitted the right of private property which he had just
denied so emphatically."_ [**Patterns of Anarchy**, p. 31]

However, anarchist theory has a simple and clear answer to this question. To
see what this answer is, it simply a case of remembering that use rights
replace property rights in an anarchist society. In other words, individuals
can exchange their labour as they see fit and occupy land for their own use.
This in no way contradicts the abolition of private property, because
occupancy and use is directly opposed to private property (see [section
B.3](secB3.md)). Socialisation is rooted in this concept of _"occupancy and
use"_ and this means that in a free communist society individuals can occupy
and use whatever land and such tools and equipment as they need -- they do not
have to join the free communist society (see [section
I.5.7](secI5.md#seci57)). If they do not, however, they cannot place claims
on the benefits others receive from co-operation and communal life.

This can be seen from Charlotte Wilson's discussions on anarchism written a
few years before MacKay published his _"inescapable"_ question. She asks the
question: _"Does Anarchism . . . then . . . acknowledge . . . no personal
property?"_ She answers by noting that _"every man [or woman] is free to take
what he [or she] requires"_ and so _"it is hardly conceivable that personal
necessaries and conveniences will not be appropriated"_ by individual's for
their personal consumption and use. For _"[w]hen property is protected by no
legal enactments, backed by armed force, and is unable to buy personal
service, its resuscitation on such a scale as to be dangerous to society is
little to be dreaded. The amount appropriated by each individual . . . must be
left to his [or her] own conscience, and the pressure exercised upon him [or
her] by the moral sense and distinct interests of his [or her] neighbours."_
This system of _"usufruct"_ would also apply to the _"instruments of
production -- land included"_, being _"free to all workers, or groups of
workers"_ for _"as long as land and capital are unappropriated, the workers
are free, and that, when these have a master, the workers also are slaves."_
[**Anarchist Essays**, p. 24 and p. 21] This is because, as with all forms of
anarchism, communist-anarchism bases itself on the distinction between
property and possession.

In other words, **possession** replaces private property in a free society.
This applies to those who decide to join a free communist society and those
who desire to remain outside. This is clear from the works of many leading
theorists of free communism (as indicated in [section
G.2.1](secG2.md#secg21)), none of whom thought the occupying of land for
personal use (or a house or the means of production) entailed the _"right of
private property."_ For example, looking at land we find both Kropotkin and
Proudhon arguing along the same lines. For the former: _"Who, then, can
appropriate for himself the tiniest plot of ground . . . without committing a
flagrant injustice?"_ [**Conquest of Bread**, p. 90] For the latter: _"The
land cannot be appropriated"_. Neither denied that individuals could **use**
the land or other resources, simply that it could not be turned into private
property. Thus Proudhon: _"Every occupant is, then, necessarily a possessor or
usufructuary, -- a function that excludes proprietorship."_ [**Property is
Theft!**, p. 103 and p. 100] Obviously John Henry MacKay, unlike Kropotkin,
had not read his Proudhon! As Wilson argued:

> _"Proudhon's famous dictum, 'Property is theft', is the key to the equally
famous enigma . . . 'From each according to his capacities, to each according
to his needs'. When the workers clearly understand that in taking possession
of railways and ships, mines and fields, farm buildings and factories, raw
material and machinery, and all else they need for their labour, they are
claiming the right to use freely for the benefit of society, what social
labour has created, or utilised in the past, and that, in return for their
work, they have a just right to take from the finished product whatever they
personally require."_ [**Op. Cit.**, pp. 20-1]

This can be seen from libertarian communist William Morris and his account of
Proudhon. Morris classed the French anarchist as _"the most noteworthy
figure"_ of a group of _"Socialist thinkers who serve as a kind of link
between the Utopians and the school of . . . scientific Socialists."_ As far
as his critique of property went, Morris argued that in **What is Property?**
Proudhon's _"position is that of a Communist pure and simple."_ [**Political
Writings**, p. 569 and p. 570]

Unsurprisingly, then, we find Kropotkin arguing that _"[a]ll things belong to
all, and provided that men and women contribute their share of labour for the
production of necessary objects, they are entitled to their share of all that
is produced by the community at large."_ He went on to state that _"free
Communism . . . places the products reaped or manufactured in common at the
disposal of all, leaving to each the liberty to consume them as he [or she]
pleases in his [or her] own home."_ [**The Place of Anarchism in Socialistic
Evolution,**, p. 6 and p. 7] This obviously implies a situation of _"occupancy
and use"_ (with those who are actually using a resource controlling it).

This support for possession does not, of course, imply any contradiction with
communism as MacKay suggested. The aim of communism is to place the fruits of
society at the disposal of society, to be used and consumed as the members of
that society desire. As such, individuals are **not** stopped from taking and
using the goods produced and, obviously, this automatically means "excluding"
others from using and consuming them. This in no way implies the recreation of
private property in any meaningful sense. Significantly, this perspective has
been pretty commonplace in human society and numerous authors have pointed out
_"how many languages lack any verb for unilateral ownership."_ [David Graeber,
**Possibilities**, p. 23]

For example, a group of friends go on a picnic and share the food stuffs they
bring. If someone takes an apple from the common bounty and eats it, then
obviously it is no longer available for others to eat. However, this does not
change the common ownership of foodstuffs the picnic is based on. Similarly,
in a communist society people would still have their own homes and, of course,
would have the right to restrict entry to just those whom they have invited.
People would not come in from the street and take up residence in the main
bedroom on the dubious rationale that it is not being used as the inhabitant
is watching TV in the lounge, is on holiday or visiting friends.

Thus communism is based on the obvious fact that individuals will
"appropriate" (use) the products of society to satisfy their own needs
(assuming they can find someone who needs to produce it). What it does,
though, is to deprive individuals of the ability to turn possession into
private property and, as a result, subjugate others to their will by means of
wage labour or landlordism.

In other words, possession (personal "property") is not transformed into
social property. Hence the communist support for individuals **not** joining
the commune, working their land or tools and living by their own hands. Being
based on **possession**, this is utterly compatible with communist principles
and the abolition of private property. This is because people are **using**
the resources in question and for that simple reason are exercising the same
rights as the rest of communist society. Thus the case of the non-member of
free communism is clear -- they would also have access to what they possessed
and used such as the land, housing and means of production. The difference is
that the non-communists would have to barter with the rest of society for
goods rather than take what they need from the communal stores.

To re-iterate, the resources non-communists use do **not** become private
property because they are being used and they revert back into common
ownership once they are no longer occupied and used. In other words,
**possession** replaces **property.** Thus communist-anarchists agree with
Individualist Anarchist John Beverley Robinson when he wrote:

> _"There are two kinds of land ownership, proprietorship or property, by
which the owner is absolute lord of the land to use it or hold it out of use,
as it may please him; and possession, by which he is secure in the tenure of
land which he uses and occupies, but has no claim on it at all if he ceases to
use it. For the secure possession of his crops or buildings or other products,
he needs nothing but the possession of the land he uses."_ [**Patterns of
Anarchy**, p. 273]

This system, we must note, was used in the rural collectives during the
Spanish Revolution, with people free to remain outside the collective working
only as much land and equipment as they could _"occupy and use"_ by their own
labour. Similarly, the individuals within the collective worked in common and
took what they needed from the communal stores (see [section
I.8](secI8.md)).

MacKay's comments raise another interesting point. Given that Individualist
Anarchists oppose the current system of private property in land, **their**
system entails that _"society ha[s] the right of control over the
individual."_ If we look at the _"occupancy and use"_ land system favoured by
the likes of Tucker, we discover that it is based on restricting property in
land (and so the owners of land). As discussed in [section
G.1.2](secG1.md#secg12), the likes of Tucker looked forward to a time when
public opinion (i.e., society) would limit the amount of land which
individuals could acquire and so, from MacKay's perspective, controlling their
actions and violating their autonomy. Which, we must say, is not surprising as
individualism requires the supremacy of the rest of society over the
individual in terms of rules relating to the ownership and use of possessions
(or "property") -- as the Individualist Anarchists themselves implicitly
acknowledge.

MacKay goes on to state that _"every serious man must declare himself: for
Socialism, and thereby for force and against liberty, or for Anarchism, and
thereby for liberty and against force."_ [**Op. Cit.**, p. 32] Which, we must
note, is a strange statement for, as indicated in [section G.1](secG1.md),
individualist anarchists like Benjamin Tucker considered themselves socialists
and opposed capitalist private property (while, confusingly, many of them
calling their system of possession "property").

However, MacKay's statement begs the question: does private property support
liberty? He does not address or even acknowledge the fact that private
property will inevitably lead to the owners of such property gaining control
over the individuals who use, but do not own, it and so denying them liberty
(see [section B.4](secB4.md)). As Proudhon argued:

> _"The purchaser draws boundaries, fences himself in, and says, 'This is
mine; each one by himself, each one for himself.' Here, then, is a piece of
land upon which, henceforth, no one has right to step, save the proprietor and
his friends; which can benefit nobody, save the proprietor and his servants.
Let these multiply, and soon the people . . . will have nowhere to rest, no
place of shelter, no ground to till. They will die of hunger at the
proprietor's door, on the edge of that property which was their birth-right;
and the proprietor, watching them die, will exclaim, 'So perish idlers and
vagrants.'"_ [**Op. Cit.**, p. 111]

Of course, as Proudhon suggested, the non-owner can gain access to the
property by becoming a servant, by selling their liberty to the owner and
agreeing to submit to the owner's authority. Little wonder that he argued that
the _"second effect of property is despotism."_ [**Op. Cit.**, p. 259] As
discussed in [section G.4.1](secG4.md#secg41), this points to a massive
contradiction in any form of individualist anarchism which defends private
property which goes beyond possession and generates wage-labour. This is
because both the state and the property owner **both** assume sole authority
over a given area and all within it. Little wonder Emile Pouget, echoing
Proudhon, argued that:

> _"Property and authority are merely differing manifestations and expressions
of one and the same 'principle' which boils down to the enforcement and
enshrinement of the servitude of man. Consequently, the only difference
between them is one of vantage point: viewed from one angle, slavery appears
as a **property crime**, whereas, viewed from a different angle, it
constitutes an **authority crime.**"_ [**No Gods, No Masters**, vol. 2, p. 66]

So the issue changes if someone claims more resources than they can use as
individuals or as a co-operative group. If they are attempting to restrict
access to others of resources they are not using then the others are entitled
to simply ignore the pretensions of the would-be monopoliser. Without a state
to enforce capitalist property rights, attempts to recreate private property
will flounder in the laughter of their neighbours as these free people defend
their liberty by ignoring the would-be capitalist's attempts to subjugate the
labour of others for their own benefit by monopolising the means of life.
Unsurprisingly, MacKay does not address the fact that private property
requires extensive force (i.e. a state) to protect it against those who use it
or could use it but do not own it.

So MacKay ignores two important aspects of private property. Firstly, that
private property is based upon force, which must be used to ensure the owner's
right to exclude others (the main reason for the existence of the state). And
secondly, he ignores the anti-libertarian nature of "property" when it creates
wage labour -- the other side of "private property" -- in which the liberty of
employees is obviously restricted by the owners whose property they are hired
to use. Unlike in a free communist society, in which members of a commune have
equal rights, power and say within a self-managed association, under "private
property" the owner of the property governs those who use it. When the owner
and the user is identical, this is not a problem (i.e. when possession
replaces property) but once possession becomes property then despotism, as
Proudhon noted, is created. As Charlotte Wilson put it:

> _"Property -- not the claim to use, but to a right to prevent others from
using -- enables individuals who have appropriated the means of production, to
hold in subjection all those who possess nothing . . . and who must work that
they may live. No work is possible without land, materials, and tools or
machinery; thus the masters of those things are the masters also of the
destitute workers, and can live in idleness upon their labour. . . We look for
th[e] socialisation of wealth, not to restraints imposed by authority upon
property, but to the removal, by direct personal action of the people
themselves, of the restraints which secure property against the claims of
popular justice. For authority and property are both manifestations of the
egoistical spirit of domination"._ [**Op. Cit.**, pp. 57-8]

Therefore, it seems that in the name of "liberty" John Henry MacKay and a host
of other "individualists" end up supporting authority and (effectively) some
kind of state. This is hardly surprising as private property is the opposite
of personal possession, not its base. In summary, then, far from communal
property restricting individual liberty (or even personal use of resources) it
is in fact its only defence. That is why all anarchists would agree with Emma
Goldman that _"it is our endeavour to abolish private property, State . . . we
aim to free men from tyrants and government."_ [**A Documentary History of the
American Years**, vol. 1, p. 181]

[‹ I.5 What could the social structure of anarchy look like?](secI5.md "Go
to previous page" ) [up](secIcon.md "Go to parent page" ) [I.7 Won't
Libertarian Socialism destroy individuality? ›](secI7.md "Go to next page" )

