/*
 * Copyright (c) 2019, Intel Corporation. All rights reserved.
 *
 * SPDX-License-Identifier: BSD-3-Clause
 */

#include <lib/mmio.h>
#include <lib/utils_def.h>
#include "s10_system_manager.h"

void enable_nonsecure_access(void)
{
	mmio_write_32(S10_NOC_FW_L4_PER_SCR_NAND_REGISTER, DISABLE_L4_FIREWALL);
	mmio_write_32(S10_NOC_FW_L4_PER_SCR_NAND_DATA, DISABLE_L4_FIREWALL);

	mmio_write_32(S10_NOC_FW_L4_SYS_SCR_NAND_ECC, DISABLE_L4_FIREWALL);
	mmio_write_32(S10_NOC_FW_L4_SYS_SCR_NAND_READ_ECC, DISABLE_L4_FIREWALL);
	mmio_write_32(S10_NOC_FW_L4_SYS_SCR_NAND_WRITE_ECC,
		DISABLE_L4_FIREWALL);

	mmio_write_32(S10_NOC_FW_L4_PER_SCR_USB0_REGISTER, DISABLE_L4_FIREWALL);
	mmio_write_32(S10_NOC_FW_L4_PER_SCR_USB1_REGISTER, DISABLE_L4_FIREWALL);
	mmio_write_32(S10_NOC_FW_L4_SYS_SCR_USB0_ECC, DISABLE_L4_FIREWALL);
	mmio_write_32(S10_NOC_FW_L4_SYS_SCR_USB1_ECC, DISABLE_L4_FIREWALL);

	mmio_write_32(S10_NOC_FW_L4_PER_SCR_SPI_MASTER0, DISABLE_L4_FIREWALL);
	mmio_write_32(S10_NOC_FW_L4_PER_SCR_SPI_MASTER1, DISABLE_L4_FIREWALL);
	mmio_write_32(S10_NOC_FW_L4_PER_SCR_SPI_SLAVE0, DISABLE_L4_FIREWALL);
	mmio_write_32(S10_NOC_FW_L4_PER_SCR_SPI_SLAVE1, DISABLE_L4_FIREWALL);

	mmio_write_32(S10_NOC_FW_L4_PER_SCR_EMAC0, DISABLE_L4_FIREWALL);
	mmio_write_32(S10_NOC_FW_L4_PER_SCR_EMAC1, DISABLE_L4_FIREWALL);
	mmio_write_32(S10_NOC_FW_L4_PER_SCR_EMAC2, DISABLE_L4_FIREWALL);

	mmio_write_32(S10_NOC_FW_L4_SYS_SCR_EMAC0RX_ECC, DISABLE_L4_FIREWALL);
	mmio_write_32(S10_NOC_FW_L4_SYS_SCR_EMAC0TX_ECC, DISABLE_L4_FIREWALL);
	mmio_write_32(S10_NOC_FW_L4_SYS_SCR_EMAC1RX_ECC, DISABLE_L4_FIREWALL);
	mmio_write_32(S10_NOC_FW_L4_SYS_SCR_EMAC1TX_ECC, DISABLE_L4_FIREWALL);
	mmio_write_32(S10_NOC_FW_L4_SYS_SCR_EMAC2RX_ECC, DISABLE_L4_FIREWALL);
	mmio_write_32(S10_NOC_FW_L4_SYS_SCR_EMAC2TX_ECC, DISABLE_L4_FIREWALL);

	mmio_write_32(S10_NOC_FW_L4_PER_SCR_SDMMC, DISABLE_L4_FIREWALL);
	mmio_write_32(S10_NOC_FW_L4_SYS_SCR_SDMMC_ECC, DISABLE_L4_FIREWALL);

	mmio_write_32(S10_NOC_FW_L4_PER_SCR_GPIO0, DISABLE_L4_FIREWALL);
	mmio_write_32(S10_NOC_FW_L4_PER_SCR_GPIO1, DISABLE_L4_FIREWALL);

	mmio_write_32(S10_NOC_FW_L4_PER_SCR_I2C0, DISABLE_L4_FIREWALL);
	mmio_write_32(S10_NOC_FW_L4_PER_SCR_I2C1, DISABLE_L4_FIREWALL);
	mmio_write_32(S10_NOC_FW_L4_PER_SCR_I2C2, DISABLE_L4_FIREWALL);
	mmio_write_32(S10_NOC_FW_L4_PER_SCR_I2C3, DISABLE_L4_FIREWALL);
	mmio_write_32(S10_NOC_FW_L4_PER_SCR_I2C4, DISABLE_L4_FIREWALL);

	mmio_write_32(S10_NOC_FW_L4_PER_SCR_SP_TIMER1, DISABLE_L4_FIREWALL);

	mmio_write_32(S10_NOC_FW_L4_PER_SCR_UART0, DISABLE_L4_FIREWALL);
	mmio_write_32(S10_NOC_FW_L4_PER_SCR_UART1, DISABLE_L4_FIREWALL);

	mmio_write_32(S10_NOC_FW_L4_SYS_SCR_DMA_ECC, DISABLE_L4_FIREWALL);


	mmio_write_32(S10_NOC_FW_L4_SYS_SCR_OCRAM_ECC, DISABLE_L4_FIREWALL);

	mmio_write_32(S10_NOC_FW_L4_SYS_SCR_CLK_MGR, DISABLE_L4_FIREWALL);

	mmio_write_32(S10_NOC_FW_L4_SYS_SCR_IO_MGR, DISABLE_L4_FIREWALL);


	mmio_write_32(S10_NOC_FW_L4_SYS_SCR_RST_MGR, DISABLE_L4_FIREWALL);

	mmio_write_32(S10_NOC_FW_L4_SYS_SCR_SYS_MGR, DISABLE_L4_FIREWALL);

	mmio_write_32(S10_NOC_FW_L4_SYS_SCR_OSC0_TIMER, DISABLE_L4_FIREWALL);
	mmio_write_32(S10_NOC_FW_L4_SYS_SCR_OSC1_TIMER, DISABLE_L4_FIREWALL);

	mmio_write_32(S10_NOC_FW_L4_SYS_SCR_WATCHDOG0, DISABLE_L4_FIREWALL);
	mmio_write_32(S10_NOC_FW_L4_SYS_SCR_WATCHDOG1, DISABLE_L4_FIREWALL);
	mmio_write_32(S10_NOC_FW_L4_SYS_SCR_WATCHDOG2, DISABLE_L4_FIREWALL);
	mmio_write_32(S10_NOC_FW_L4_SYS_SCR_WATCHDOG3, DISABLE_L4_FIREWALL);

	mmio_write_32(S10_NOC_FW_L4_SYS_SCR_DAP, DISABLE_L4_FIREWALL);

	mmio_write_32(S10_NOC_FW_L4_SYS_SCR_L4_NOC_PROBES, DISABLE_L4_FIREWALL);

	mmio_write_32(S10_NOC_FW_L4_SYS_SCR_L4_NOC_QOS, DISABLE_L4_FIREWALL);

	mmio_clrbits_32(S10_CCU_NOC_CPU0_RAMSPACE0_0, 0x03);
	mmio_clrbits_32(S10_CCU_NOC_IOM_RAMSPACE0_0, 0x03);
}

