#include <iostream>
using namespace std;

// =====================================================================
// some preliminary functions for generic printing ... to be extended
template <typename T, bool AVAILABLE=(bool)AC::TypeInfo<T>::AVAILABLE>
struct PrinterSelector;
void print (bool c) { cout << (c ? "true" : "false"); }
void print (unsigned char c) { cout << (int)c; }
void print (int c) { cout << c; }
void print (float f) { cout << f; }
void print (const char *c) { if (c) cout << "\"" << c << "\""; else cout << "<null>"; }
template<typename T> void print (T &c) {
  cout << "{";
  PrinterSelector<T>::print (c);
  cout << " }";
}
template<typename T> void print (T *c) {
  cout << "-> ";
  print (*c);
}

template <typename T>
struct AP {
    static void print (T c) { ::print (c); }
};
template<typename T, unsigned int N> struct AP<T[N]> {
    template <typename T2>
    static void print (T2 *c) {
	cout << "{ ";
	for (unsigned int i = 0; i < N; ++i) {
	    cout << "[" << i << "]=";
	    ::print (c[i]);
	    cout << " ";
	}
	cout << "}";
    }
};

template<typename T, int I = AC::TypeInfo<T>::ELEMENTS> struct _Printer {
  static void print (T &c) {
      _Printer<T,I-1>::print (c);
      cout << " " << AC::TypeInfo<T>::member_name (c, I-1) << "=";
      AP<typename AC::TypeInfo<T>::template Member<I-1>::ReferredType>::print(*AC::TypeInfo<T>::template member<I-1>(&c));
    }
};
template<typename T> struct _Printer<T,0> {
  static void print (T &c) {}
};

template <typename T, bool AVAILABLE>
struct PrinterSelector {
  static void print (T &obj) {
    _Printer<T>::print (obj);
  }
};
template <typename T> struct PrinterSelector<T, false> {
  static void print (T &) {
    cout << " no type info";
  }
};
// =====================================================================

// The test code itself ...
// Led.h
typedef unsigned char uint8_t;

class LED0 {
public:
        volatile uint8_t _pad[0x2];

        // PINA
        volatile uint8_t
                LEDPIN  : 1,
                                : 7;

        // DDRA
        volatile uint8_t
                LEDDDR  : 1,
                                : 7;

        // PORTA
        volatile uint8_t
                LEDPORT : 1,
                                : 7;
};

aspect Led {
        pointcut ledfunc() = "LED%";

        advice ledfunc() : slice class S {
        public:
                S() {
                        LEDPORT = 0;
                        LEDDDR  = 1;
                }

                void on() {
                        LEDPORT = 1;
                }

                void off() {
                        LEDPORT = 0;
                }
        };
};

struct C {
    int i;
    float j;
    const char *k;
};

C inner_c = { 43, 2.1, 0 };
C *cptr = &inner_c;

struct D {
    bool foo;
    int id;
    float size;
    const char *name;
    C **c;
    struct Inner {
      int inner;
    } i;
    int array[5];
} d = {true, 42, 1.8, "Olaf Spinczyk", &cptr, { 42 }, { 1,2,3 }};

struct F; // an incomplete type
LED0 l0; // constructed type with bit field and pad bytes

int main () {
    C c;
    c.i = 42;
    c.j = 3.14;
    c.k = "Hallo";
    print (c); cout << endl;
    print (&d); cout << endl;
    print ((F*)0); cout << endl;
    print (cout); cout << endl;
    print (42); cout << endl;
    print (l0); cout << endl;
}
