#!/usr/bin/env python
# -*- coding: utf-8 -*-

import os
import re
import shutil
import unittest

from common import dict_conf, execcmd, tmpdir
from data   import catalo_export

orig_cata = os.path.join(dict_conf['ASTER_ROOT'], dict_conf['ASTER_VERSION'],
                         "catalo", "compelem", "grandeur_simple__.cata")


class TestDevelopLong(unittest.TestCase):

    def test03_catalo(self):
        export = os.path.join(tmpdir, "catalo.export")
        open(export, "w").write(catalo_export % dict_conf)
        shutil.copy(orig_cata, os.path.join(tmpdir, "catalo.cata"))
        
        cmd = dict_conf["as_run"] + [export]
        iret, out = execcmd(cmd, "dvp.3", return_output=True)
        assert iret == 0
        assert re.search("DIAGNOSTIC JOB : OK", out) \
          or re.search("DIAGNOSTIC JOB :.*ALARM", out)



if __name__ == "__main__":
    unittest.main()

