
// Compile with: mcs /out:TestDrawingWin.exe TestDrawingWin.cs -r:System.Drawing

using System;
using System.Drawing;
using System.Drawing.Drawing2D;


public class TestDrawingWin
{
	public static void Main (string[] args)
	{
		Bitmap bm = new Bitmap ("test.jpg");
		Bitmap bmScaled = new Bitmap ((int) (bm.Width * 0.7F + 0.5F),
			(int) (bm.Height * 0.7F + 0.5F));

		Graphics gr = Graphics.FromImage (bmScaled);
		gr.InterpolationMode = InterpolationMode.HighQualityBicubic;

		gr.DrawImage (bm, new RectangleF (0.0F, 0.0F,
			bm.Width * 0.7F, bm.Height * 0.7F));
		bmScaled.Save ("test.scaled.png", System.Drawing.Imaging.ImageFormat.Png);

		int p = 0;
		for (int y = 0 ; y < bmScaled.Height ; ++y) {
			for (int x = 0 ; x < bmScaled.Width ; ++x) {
				Color col = bmScaled.GetPixel (x, y);

				p += 1;
				/*
				Console.WriteLine ("({0}, {1}): [{2}, {3}, {4}]",
					x, y, col.R, col.G, col.B);
					*/
				// Find a better/faster way, instead of Color class
			}
		}
		Console.WriteLine ("{0} pixels", p);
	}
}


