#!/usr/bin/perl -w
use strict;

=head HOWTO USE

When you release a new version ex: 3.0.3
 - Modify the $version string

When you add a new category
 - Add a print_cat() at the end of the script

To update the downloads.php file

- Change the version on the top of the file
- ./sf2bacula_downloads.pl > downloads.php

By default, it downloads the sourceforge page in the current directory


You can also use a previous output

 ./sf2bacula_downloads.pl <version> <sf_list_2022.html> > downloads.php

=cut

#             bacula|depkgs | depkgs-qt
my $version = '3.0.3';
if ($ARGV[0] =~ /^[\d\.]+$/) {
    $version = shift(@ARGV);
}
my $depkgs_version  = '18Dec09|28Jul09|3.0.3a';

my $base = "http://bacula.svn.sourceforge.net/viewvc/bacula/tags/Release-$version/bacula";
my $notes = "$base/ReleaseNotes";
my $chglog = "$base/ChangeLog";
my %cats;
my $cur;
my %seen;

my $file = "sf_list_$$.html";
my $cmd = "wget -O $file https://sourceforge.net/projects/bacula/files";

if ($ARGV[0] && -f $ARGV[0]) {
    $file = $ARGV[0];
} else {
    system($cmd);
}

open(FP, $file);
while (my $l = <FP>)
{
    #                                         cat   vers  file
    if ($l =~ m!href="(/projects/bacula/files/([^/]+)/([^/]+)/([^/]+)/download)"!) {
        $cur = {
            dl  => $1,
            cat => $2,
            vers => $3,
            file => $4
        };
    }

    # the size, date, and downloads are just after
    if ($cur && $l =~ m!<td>([\d\.]+ [KMG]B)</td>!) {
        $cur->{size} = $1;
        do {
            $l = <FP>;
            if ($l =~ m!<td>(.*?)</td>!) {
                $cur->{date} = $1;
            }
        } while (!$cur->{date});
        do {
            $l = <FP>;
            if ($l =~ m!<td>(.*?)</td>!) {
                $cur->{downloads} = $1;
            }
        } while (!$cur->{downloads});


        # once we have a full $cur element, we can store it
        if (!exists $seen{$cur->{file}}) {
            push @{$cats{$cur->{cat}}}, $cur;
            $seen{$cur->{file}} = 1;
            $cur = undef;
        }
    }
}
close(FP);

print '
<? require_once("inc/header.php"); ?>
<table>
  <tr>
   <td class="contentTopic">
   Bacula downloads for version ', $version, '
   </td>
   </tr>
   <tr>
     <td class="content">
     <center>
      <a href="', $notes, '">Release Notes</a>&nbsp;|&nbsp;
      <a href="', $chglog, '">ChangeLog</a>&nbsp;|&nbsp;
      <a href="#bacula">Sources</a>&nbsp;|&nbsp;
      <a href="#Win32_64">Win32/64</a>&nbsp;|&nbsp;
      <a href="#rpms">RPM</a>&nbsp;|&nbsp;
      <a href="https://sourceforge.net/projects/bacula/files/Bacula%20Public%20Key/Current%20Public%20Key/bacula.pub/download">Public Key</a>&nbsp;|&nbsp;
      <a href="https://sourceforge.net/projects/bacula/files/Bacula%20Public%20Key/Current%20Public%20Key/rpmkey-bacula-0.1-3.noarch.rpm/download">RPM Public Key</a>
     </center>
     </td>
   </tr>
';

my $cat = 'bacula';
#use Data::Dumper;
#print Data::Dumper::Dumper(\%cats);

sub print_cat
{
    my ($cat) = @_;
    my $row = 'odd';

    print '
   <tr>
     <td> <br><a name="', $cat, '"></a><font size="+1"><b>', $cat, ':</b></font>
<table cellspacing="2">
<tr class="title"><th>Name</th><th align="center">', ($cat !~ /rpm/)?'Signature':'', '</th><th>Size</th><th>Date</th><th>Downloads</th></tr>
';
    foreach my $elt ( sort { $a->{file} cmp $b->{file} }  @{$cats{$cat}})
    {
        next if ($elt->{file} =~ /\.sig/); # we skip signature file
        if ($elt->{vers} eq $version || $elt->{vers} =~ /$depkgs_version/)
        {
            print "
<tr class=\"$row\">
 <td><a href='https://sourceforge.net$elt->{dl}'>$elt->{file}</td>
 <td align=\"center\">", 
 ($cat !~ /rpm/)?"<a href='https://sourceforge.net/projects/bacula/files/$cat/$elt->{vers}/$elt->{file}.sig/download'>sig":"", 
 "</td>
 <td align=\"right\">$elt->{size}</td>
 <td align=\"center\">$elt->{date}</td>
 <td align=\"center\">$elt->{downloads}</td>
</tr>
";
        }
        if ($row eq 'odd') { $row = 'even'; } else { $row = 'odd'; }
    }
    print '</table>
     </td>
     </tr>';
}

print_cat('bacula');
print_cat('Win32_64');
print_cat('rpms');
print_cat('rpms-contrib-fschwarz');
print_cat('rpms-contrib-psheaffer');
print_cat('depkgs');
print_cat('depkgs-qt');


print '
</table>
<? require_once("inc/footer.php"); ?>
';
