# Balazar
# Copyright (C) 2003-2005 Jean-Baptiste LAMY
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

import cerealizer, tofu, soya, soya.cerealizer4soya
import balazar.globdef, balazar.base, balazar.building, balazar.character, balazar.controller, balazar.echassian, balazar.hero, balazar.item, balazar.level, balazar.morkul, balazar.npc, balazar.trap, balazar.vegetation, balazar.weather, balazar.wiseman, balazar.game_interface, balazar.player

cerealizer.register(balazar.base.DecorativeEntity)
cerealizer.register(balazar.base.Discutable)
cerealizer.register(balazar.base.EjectedBody)
cerealizer.register(balazar.base.Entity)
cerealizer.register(balazar.base.HurtedBody)
cerealizer.register(balazar.base.Photographiable)
cerealizer.register(balazar.base.SensitiveFloor)
cerealizer.register(balazar.base.SmallHurtedBody)
cerealizer.register(balazar.base.Strikeable)
cerealizer.register(balazar.base.Terraformer)
cerealizer.register(balazar.building.Altar)
cerealizer.register(balazar.building.Building)
cerealizer.register(balazar.building.Farm)
cerealizer.register(balazar.building.Market)
cerealizer.register(balazar.building.MovingVigie)
cerealizer.register(balazar.building.RotatingVigie)
cerealizer.register(balazar.building.Tower)
cerealizer.register(balazar.building.Temple)
cerealizer.register(balazar.building.Vigie)
cerealizer.register(balazar.character.Action)
cerealizer.register(balazar.character.AddState)
cerealizer.register(balazar.character.Blood)
cerealizer.register(balazar.character.Character)
cerealizer.register(balazar.character.Eclat)
cerealizer.register(balazar.character.FallingItem)
cerealizer.register(balazar.character.FightAction)
cerealizer.register(balazar.character.HealEffect)
cerealizer.register(balazar.character.ItemAction)
cerealizer.register(balazar.character.ItemState)
cerealizer.register(balazar.character.NewItemState)
cerealizer.register(balazar.character.SoundState)
cerealizer.register(balazar.character.State)
cerealizer.register(balazar.character.Step)
cerealizer.register(balazar.character.ValueState)
cerealizer.register(balazar.character.DiscussionAction)
cerealizer.register(balazar.controller.StackController)
cerealizer.register(balazar.echassian.AIController)
cerealizer.register(balazar.echassian.Echassian)
cerealizer.register(balazar.echassian.EchassianCartograph)
cerealizer.register(balazar.echassian.FixedAIController)
cerealizer.register(balazar.hero.Balazar)
cerealizer.register(balazar.hero.Hero)
cerealizer.register(balazar.item.Axe)
cerealizer.register(balazar.item.Camera)
cerealizer.register(balazar.item.CursedSword)
cerealizer.register(balazar.item.EquipableItem)
cerealizer.register(balazar.item.Food)
cerealizer.register(balazar.item.HalfVisibleAxe)
cerealizer.register(balazar.item.Item)
cerealizer.register(balazar.item.Key)
cerealizer.register(balazar.item.KillRay)
cerealizer.register(balazar.item.KillerEffect)
cerealizer.register(balazar.item.Knife)
cerealizer.register(balazar.item.Sword)
cerealizer.register(balazar.item.LargeSword)
cerealizer.register(balazar.item.LeftHandHorizontalItem)
cerealizer.register(balazar.item.LeftHandItem)
cerealizer.register(balazar.item.Map)
cerealizer.register(balazar.item.MorkulKillerKnife)
cerealizer.register(balazar.item.MushroomFood)
cerealizer.register(balazar.item.OldMushroomFood)
cerealizer.register(balazar.item.Photo)
cerealizer.register(balazar.item.PomponScepter)
cerealizer.register(balazar.item.RightHandItem)
cerealizer.register(balazar.item.Scepter)
cerealizer.register(balazar.item.TelekinesyCursedItem)
cerealizer.register(balazar.item.TuryleSword)
cerealizer.register(balazar.item.UseableItem)
cerealizer.register(balazar.item.Weapon)
cerealizer.register(balazar.level.Bridge)
cerealizer.register(balazar.level.Country)
cerealizer.register(balazar.level.Level)
cerealizer.register(balazar.morkul.Morkul)
cerealizer.register(balazar.morkul.MorkulAIController)
cerealizer.register(balazar.morkul.MorkulChief)
cerealizer.register(balazar.morkul.MorkulChiefWithScepter)
cerealizer.register(balazar.npc.AIController)
cerealizer.register(balazar.npc.Monster)
cerealizer.register(balazar.npc.NPC)
cerealizer.register(balazar.trap.Chest)
cerealizer.register(balazar.trap.FallingVigie)
cerealizer.register(balazar.trap.Gloom)
cerealizer.register(balazar.trap.Grid)
cerealizer.register(balazar.trap.GridOpener)
cerealizer.register(balazar.trap.LifeAltar)
cerealizer.register(balazar.trap.ManualGridOpener)
cerealizer.register(balazar.trap.MiamGrid)
cerealizer.register(balazar.trap.NoMonsterGrid)
cerealizer.register(balazar.trap.OpenableTrap)
cerealizer.register(balazar.trap.TrapState)
cerealizer.register(balazar.trap.TrappedTile)
cerealizer.register(balazar.trap.RotatingBridgeTile)
cerealizer.register(balazar.trap.Mill)
cerealizer.register(balazar.trap.IndicatorPlatForm)
cerealizer.register(balazar.vegetation.Fasme)
cerealizer.register(balazar.vegetation.GiantMushroom)
cerealizer.register(balazar.vegetation.HurtState)
cerealizer.register(balazar.vegetation.Mushroom)
cerealizer.register(balazar.vegetation.PlantElement)
cerealizer.register(balazar.vegetation.SpcState)
cerealizer.register(balazar.vegetation.Spore)
cerealizer.register(balazar.vegetation.TreasureTreePompon)
cerealizer.register(balazar.vegetation.TreePompon)
cerealizer.register(balazar.vegetation.Vegetal)
cerealizer.register(balazar.vegetation.VegetalAction)
cerealizer.register(balazar.vegetation.VegetalState)
cerealizer.register(balazar.weather.Rain)
cerealizer.register(balazar.weather.Snow)
cerealizer.register(balazar.weather.StarSprite)
cerealizer.register(balazar.weather.SunSprite)
cerealizer.register(balazar.weather.WeatherAgent)
cerealizer.register(balazar.weather.WeatherAtmosphere)
cerealizer.register(balazar.weather.WeatherState)
cerealizer.register(balazar.wiseman.Wiseman)
cerealizer.register(balazar.wiseman.AIController)


# Increase the maximum size of a transfered file
import tofu.client
tofu.client.MAX_LENGTH = 1000000


tofu.enable_pickle    (1, 0)
tofu.enable_cerealizer(0, 1)

cerealizer.freeze_configuration()

soya.tofu4soya.init(
  balazar.game_interface.GameInterface,
  balazar.player.Player,
  balazar.level.Level,
  balazar.character.Action,
  balazar.character.State,
  balazar.character.Character,
  )
