# Copyright (C) 2005 Jay Beale
# Licensed under the GNU General Public License

#######################################################################
##                          test_ConfigureMiscPAM
#######################################################################

$GLOBAL_TEST{'ConfigureMiscPAM'}{'limitsconf'} =
    sub {

	my $limitsconf=&getGlobal('FILE', "limits.conf");
   
	unless ( -e $limitsconf) {
	    return $ASKQ;
	}

	# Look for core dumps deactivated
	unless (&B_match_line($limitsconf,'^\s*\*hard\s+core\s+0\s*$')) {
	    return $ASKQ;
	}

	# Look for a max processes per user of 500 to avoid fork bombs.
	unless (&B_match_line($limitsconf,'^\s*\*hard\s+nproc\s+(\d+)\s*$') and $2 < 500 ) {
	    return $ASKQ;
	}

	return $SKIPQ;
    };

$GLOBAL_TEST{'ConfigureMiscPAM'}{'consolelogin'} =
    sub {

        my $accessconf=&getGlobal('FILE', "pam_access.conf");

	if (&B_match_line($accessconf,'^\s*[^#].*:\s*ALL\s+EXCEPT')) {
	    return $SKIPQ;
	}

	return $ASKQ;
    };


1;
