
package org.forester.util;

import java.util.HashMap;
import java.util.Map;

public final class TaxonomyUtil {

    public static String getTaxGroupByTaxCode( final String code ) {
        return _default_taxcode_taxgroup_map.get( code );
    }

    public static int getTaxIdFromFakeTaxCode( final String code ) {
        return FAKE_CODE_TO_ID_MAP.get( code );
    }

    public static boolean isHasTaxIdFromFakeTaxCode( final String code ) {
        return FAKE_CODE_TO_ID_MAP.containsKey( code );
    }

    private static void put( final String code, final String group ) {
        if ( _default_taxcode_taxgroup_map.containsKey( code ) ) {
            throw new RuntimeException( "duplicate code: " + code );
        }
        _default_taxcode_taxgroup_map.put( code, group );
    }
    private final static Map<String, String>  _default_taxcode_taxgroup_map = new HashMap<String, String>();
    static {
        put( "BUFBU", "deuterostomia" );
        put( "NOTVI", "deuterostomia" );
        put( "SIRIN", "deuterostomia" );
        put( "ASTMX", "deuterostomia" );
        put( "CALMI", "deuterostomia" );
        put( "FICAL", "deuterostomia" );
        put( "LEPOC", "deuterostomia" );
        put( "LYTVA", "deuterostomia" );
        put( "OPHHA", "deuterostomia" );
        put( "PYTBI", "deuterostomia" );
        put( "PATMI", "deuterostomia" );
        put( "HUMAN", "deuterostomia" );
        put( "HOMSA", "deuterostomia" );
        put( "PANTR", "deuterostomia" );
        put( "GORGO", "deuterostomia" );
        put( "PONAB", "deuterostomia" );
        put( "NOMLE", "deuterostomia" );
        put( "MACMU", "deuterostomia" );
        put( "PAPHA", "deuterostomia" );
        put( "CALJA", "deuterostomia" );
        put( "TARSY", "deuterostomia" );
        put( "MICMU", "deuterostomia" );
        put( "OTOGA", "deuterostomia" );
        put( "TUPBE", "deuterostomia" );
        put( "MOUSE", "deuterostomia" );
        put( "RAT", "deuterostomia" );
        put( "MESAU", "deuterostomia" );
        put( "DIPOR", "deuterostomia" );
        put( "CAVPO", "deuterostomia" );
        put( "HETGA", "deuterostomia" );
        put( "SPETR", "deuterostomia" );
        put( "OCHPR", "deuterostomia" );
        put( "RABIT", "deuterostomia" );
        put( "BOVIN", "deuterostomia" );
        put( "SHEEP", "deuterostomia" );
        put( "BALMU", "deuterostomia" );
        put( "TURTR", "deuterostomia" );
        put( "PIG", "deuterostomia" );
        put( "LAMPA", "deuterostomia" );
        put( "HORSE", "deuterostomia" );
        put( "MYOLU", "deuterostomia" );
        put( "PTEVA", "deuterostomia" );
        put( "AILME", "deuterostomia" );
        put( "CANFA", "deuterostomia" );
        put( "FELCA", "deuterostomia" );
        put( "ERIEU", "deuterostomia" );
        put( "SORAR", "deuterostomia" );
        put( "LOXAF", "deuterostomia" );
        put( "PROCA", "deuterostomia" );
        put( "ECHTE", "deuterostomia" );
        put( "CHOHO", "deuterostomia" );
        put( "DASNO", "deuterostomia" );
        put( "MACEU", "deuterostomia" );
        put( "SARHA", "deuterostomia" );
        put( "MONDO", "deuterostomia" );
        put( "ORNAN", "deuterostomia" );
        put( "CHICK", "deuterostomia" );
        put( "MELGA", "deuterostomia" );
        put( "ANAPL", "deuterostomia" );
        put( "TAEGU", "deuterostomia" );
        put( "ALLMI", "deuterostomia" );
        put( "PELSI", "deuterostomia" );
        put( "ANOCA", "deuterostomia" );
        put( "XENLA", "deuterostomia" );
        put( "XENTR", "deuterostomia" );
        put( "MESAL", "deuterostomia" );
        put( "OSCOC", "deuterostomia" );
        put( "POLSP", "deuterostomia" );
        put( "ERPCA", "deuterostomia" );
        put( "LATCH", "deuterostomia" );
        put( "ORYLA", "deuterostomia" );
        put( "XIPMA", "deuterostomia" );
        put( "GASAC", "deuterostomia" );
        put( "TAKRU", "deuterostomia" );
        put( "TETNG", "deuterostomia" );
        put( "ORENI", "deuterostomia" );
        put( "GADMO", "deuterostomia" );
        put( "DANRE", "deuterostomia" );
        put( "PETMA", "deuterostomia" );
        put( "CIOIN", "deuterostomia" );
        put( "CIOSA", "deuterostomia" );
        put( "OIKDI", "deuterostomia" );
        put( "BRAFL", "deuterostomia" );
        put( "SACKO", "deuterostomia" );
        put( "STRPU", "deuterostomia" );
        put( "HYMMI", "protostomia" );
        put( "ECHMU", "protostomia" );
        put( "DROSE", "protostomia" );
        put( "DROSI", "protostomia" );
        put( "DROME", "protostomia" );
        put( "DROYA", "protostomia" );
        put( "DROER", "protostomia" );
        put( "DROAN", "protostomia" );
        put( "DROPE", "protostomia" );
        put( "DROPS", "protostomia" );
        put( "DROWI", "protostomia" );
        put( "DROMO", "protostomia" );
        put( "DROVI", "protostomia" );
        put( "DROGR", "protostomia" );
        put( "AEDAE", "protostomia" );
        put( "ANOGA", "protostomia" );
        put( "CULPI", "protostomia" );
        put( "BOMMO", "protostomia" );
        put( "DANPL", "protostomia" );
        put( "ATTCE", "protostomia" );
        put( "ACREC", "protostomia" );
        put( "CAMFO", "protostomia" );
        put( "APIME", "protostomia" );
        put( "NASVI", "protostomia" );
        put( "TRICA", "protostomia" );
        put( "ACYPI", "protostomia" );
        put( "RHOPR", "protostomia" );
        put( "PEDHC", "protostomia" );
        put( "ARTSF", "protostomia" );
        put( "DAPPU", "protostomia" );
        put( "HOMAM", "protostomia" );
        put( "ANTGC", "protostomia" );
        put( "NARAN", "protostomia" );
        put( "SCUCO", "protostomia" );
        put( "STRMM", "protostomia" );
        put( "IXOSC", "protostomia" );
        put( "TETUR", "protostomia" );
        put( "MESMA", "protostomia" );
        put( "LIMPO", "protostomia" );
        put( "HYPDU", "protostomia" );
        put( "CAEBR", "protostomia" );
        put( "CAERE", "protostomia" );
        put( "CAEBE", "protostomia" );
        put( "CAEEL", "protostomia" );
        put( "CAEJA", "protostomia" );
        put( "PRIPA", "protostomia" );
        put( "BRUMA", "protostomia" );
        put( "WUCBA", "protostomia" );
        put( "TRISP", "protostomia" );
        put( "APLCA", "protostomia" );
        put( "LOTGI", "protostomia" );
        put( "CRAGI", "protostomia" );
        put( "PINFU", "protostomia" );
        put( "CAPTE", "protostomia" );
        put( "HELRO", "protostomia" );
        put( "SCHMA", "protostomia" );
        put( "CLOSI", "protostomia" );
        put( "SCHMD", "protostomia" );
        put( "ANOGL", "protostomia" );
        put( "BLAGE", "protostomia" );
        put( "ZOONE", "protostomia" );
        put( "SCHAM", "protostomia" );
        put( "GRYPE", "protostomia" );
        put( "ONCFA", "protostomia" );
        put( "ACRDI", "cnidaria" );
        put( "NEMVE", "cnidaria" );
        put( "HYDVU", "cnidaria" );
        put( "TRIAD", "placozoa" );
        put( "MNELE", "ctenophora" );
        put( "AMPQE", "porifera" );
        put( "MONBE", "choanoflagellida" );
        put( "SALS5", "choanoflagellida" ); //TODO remove me
        put( "SALR5", "choanoflagellida" );
        put( "AMOPA", "ichthyophonida & filasterea" );
        put( "SARXX", "ichthyophonida & filasterea" );
        put( "CAPO3", "ichthyophonida & filasterea" );
        put( "AALXX", "dikarya" );
        put( "GIBZE", "dikarya" );
        put( "HYPVG", "dikarya" );
        put( "MAGGR", "dikarya" );
        put( "THIHA", "dikarya" );
        put( "THITE", "dikarya" );
        put( "CHAGB", "dikarya" );
        put( "NEUCR", "dikarya" );
        put( "BOTF4", "dikarya" );
        put( "SCLS1", "dikarya" );
        put( "PFIXX", "dikarya" );
        put( "MYCGM", "dikarya" );
        put( "MYCPJ", "dikarya" );
        put( "SPHMS", "dikarya" );
        put( "BCOXX", "dikarya" );
        put( "APPXX", "dikarya" );
        put( "APMXX", "dikarya" );
        put( "APSXX", "dikarya" );
        put( "COCSA", "dikarya" );
        put( "SETTU", "dikarya" );
        put( "PYRTR", "dikarya" );
        put( "PHANO", "dikarya" );
        put( "ASPFN", "dikarya" );
        put( "ASPNC", "dikarya" );
        put( "ASPCL", "dikarya" );
        put( "EMENI", "dikarya" );
        put( "NEOFI", "dikarya" );
        put( "COCIM", "dikarya" );
        put( "UNCRE", "dikarya" );
        put( "AJECG", "dikarya" );
        put( "TUBMM", "dikarya" );
        put( "NAUCC", "dikarya" );
        put( "YEAST", "dikarya" );
        put( "KLULA", "dikarya" );
        put( "ASHGO", "dikarya" );
        put( "CANAL", "dikarya" );
        put( "CANTT", "dikarya" );
        put( "DEBHA", "dikarya" );
        put( "YARLI", "dikarya" );
        put( "SCHJY", "dikarya" );
        put( "SCHOT", "dikarya" );
        put( "SCHPO", "dikarya" );
        put( "PNECA", "dikarya" );
        put( "AGABU", "dikarya" );
        put( "COPC7", "dikarya" );
        put( "LACBS", "dikarya" );
        put( "LACBI", "dikarya" );
        put( "PLEOS", "dikarya" );
        put( "CPUXX", "dikarya" );
        put( "SERL9", "dikarya" );
        put( "JARXX", "dikarya" );
        put( "GLOTR", "dikarya" );
        put( "FPIXX", "dikarya" );
        put( "PPLXX", "dikarya" );
        put( "TRAVE", "dikarya" );
        put( "WOLCO", "dikarya" );
        put( "CERSU", "dikarya" );
        put( "DICSQ", "dikarya" );
        put( "HETAN", "dikarya" );
        put( "CRYNE", "dikarya" );
        put( "TREME", "dikarya" );
        put( "MALGO", "dikarya" );
        put( "USTMA", "dikarya" );
        put( "MELLP", "dikarya" );
        put( "PUCGR", "dikarya" );
        put( "RHOGR", "dikarya" );
        put( "SPORO", "dikarya" );
        put( "WALSC", "dikarya" );
        put( "RHIID", "other fungi" );
        put( "RHIO9", "other fungi" );
        put( "MUCCI", "other fungi" );
        put( "PHYBL", "other fungi" );
        put( "RHIOR", "other fungi" );
        put( "MVNXX", "other fungi" );
        put( "CREXX", "other fungi" );
        put( "ALLMA", "other fungi" );
        put( "BATDJ", "other fungi" );
        put( "SPIPN", "other fungi" );
        put( "GONPR", "other fungi" );
        put( "PIRSE", "other fungi" );
        put( "ENCCU", "other fungi" );
        put( "ENCHA", "other fungi" );
        put( "VITCO", "other fungi" );
        put( "ENTBH", "other fungi" );
        put( "TRAHO", "other fungi" );
        put( "VAVCU", "other fungi" );
        put( "EDHAE", "other fungi" );
        put( "FALXX", "nucleariidae and fonticula group" );
        put( "DICDI", "amoebozoa" );
        put( "DICPU", "amoebozoa" );
        put( "DICFS", "amoebozoa" );
        put( "POLPA", "amoebozoa" );
        put( "ENTHI", "amoebozoa" );
        put( "ENTDS", "amoebozoa" );
        put( "AMBTC", "embryophyta" );
        put( "FRAVE", "embryophyta" );
        put( "PRUPE", "embryophyta" );
        put( "CUCSA", "embryophyta" );
        put( "SOYBN", "embryophyta" );
        put( "MEDTR", "embryophyta" );
        put( "MANES", "embryophyta" );
        put( "RICCO", "embryophyta" );
        put( "POPTR", "embryophyta" );
        put( "ARALY", "embryophyta" );
        put( "ARATH", "embryophyta" );
        put( "THEHA", "embryophyta" );
        put( "CARPA", "embryophyta" );
        put( "CCLXX", "embryophyta" );
        put( "CITSI", "embryophyta" );
        put( "EUCGR", "embryophyta" );
        put( "VITVI", "embryophyta" );
        put( "SOLLC", "embryophyta" );
        put( "SOLPI", "embryophyta" );
        put( "SOLTU", "embryophyta" );
        put( "TOBAC", "embryophyta" );
        put( "MIMGU", "embryophyta" );
        put( "AQUCA", "embryophyta" );
        put( "SORBI", "embryophyta" );
        put( "MAIZE", "embryophyta" );
        put( "PANVG", "embryophyta" );
        put( "SETIT", "embryophyta" );
        put( "ORYSA", "embryophyta" );
        put( "ORYSJ", "embryophyta" );
        put( "BRADI", "embryophyta" );
        put( "HORVD", "embryophyta" );
        put( "MUSAM", "embryophyta" );
        put( "PICAB", "embryophyta" );
        put( "SELML", "embryophyta" );
        put( "PHYPA", "embryophyta" );
        put( "OSTLU", "chlorophyta" );
        put( "ORCXX", "chlorophyta" );
        put( "OSTTA", "chlorophyta" );
        put( "MICPC", "chlorophyta" );
        put( "MICSR", "chlorophyta" );
        put( "ASCXX", "chlorophyta" );
        put( "CHLVA", "chlorophyta" );
        put( "CSUXX", "chlorophyta" );
        put( "CHLRE", "chlorophyta" );
        put( "VOLCA", "chlorophyta" );
        put( "CYAME", "rhodophyta" );
        put( "GALSU", "rhodophyta" );
        put( "CHOCR", "rhodophyta" );
        put( "CYAPA", "glaucocystophyceae" );
        put( "EMIHU", "hacrobia" );
        put( "GUITH", "hacrobia" );
        put( "PLACH", "alveolata" );
        put( "PLAF7", "alveolata" );
        put( "PLAYO", "alveolata" );
        put( "PLAVS", "alveolata" );
        put( "THEAN", "alveolata" );
        put( "THEPA", "alveolata" );
        put( "BABBO", "alveolata" );
        put( "EIMAC", "alveolata" );
        put( "EIMTE", "alveolata" );
        put( "TOXGO", "alveolata" );
        put( "CRYHO", "alveolata" );
        put( "CRYPV", "alveolata" );
        put( "CRYPI", "alveolata" );
        put( "CRYCO", "alveolata" );
        put( "THOHE", "alveolata" );
        put( "PARTE", "alveolata" );
        put( "TETTS", "alveolata" );
        put( "OTRXX", "alveolata" );
        put( "BLEJA", "alveolata" );
        put( "PERM5", "alveolata" );
        put( "ICHMG", "alveolata" );
        put( "FCYXX", "stramenopiles" );
        put( "PHATR", "stramenopiles" );
        put( "THAPS", "stramenopiles" );
        put( "THAOC", "stramenopiles" );
        put( "AURAN", "stramenopiles" );
        put( "ECTSI", "stramenopiles" );
        put( "PHYIN", "stramenopiles" );
        put( "PHYRM", "stramenopiles" );
        put( "PHYSO", "stramenopiles" );
        put( "PHYCI", "stramenopiles" );
        put( "PHYCP", "stramenopiles" );
        put( "HYAAE", "stramenopiles" );
        put( "PYTUL", "stramenopiles" );
        put( "AKEXX", "stramenopiles" );
        put( "SAGXX", "stramenopiles" );
        put( "ALIXX", "stramenopiles" );
        put( "BLAHO", "stramenopiles" );
        put( "BIGNA", "rhizaria" );
        put( "RETFI", "rhizaria" );
        put( "TRYB2", "excavata" );
        put( "TRYCR", "excavata" );
        put( "LEIMA", "excavata" );
        put( "LEIIN", "excavata" );
        put( "LEIBR", "excavata" );
        put( "BODSA", "excavata" );
        put( "NAEGR", "excavata" );
        put( "GIAIC", "excavata" );
        put( "TRIVA", "excavata" );
        put( "TTRXX", "apusozoa" );
        put( "THEKO", "archaea" );
        put( "METAC", "archaea" );
        put( "METBF", "archaea" );
        put( "METMA", "archaea" );
        put( "METBU", "archaea" );
        put( "METB6", "archaea" );
        put( "METHU", "archaea" );
        put( "METMJ", "archaea" );
        put( "METLZ", "archaea" );
        put( "METTP", "archaea" );
        put( "HALMA", "archaea" );
        put( "NATPH", "archaea" );
        put( "HALS3", "archaea" );
        put( "HALSP", "archaea" );
        put( "HALWD", "archaea" );
        put( "ARCFU", "archaea" );
        put( "METJA", "archaea" );
        put( "META3", "archaea" );
        put( "METMP", "archaea" );
        put( "METVS", "archaea" );
        put( "METS3", "archaea" );
        put( "METST", "archaea" );
        put( "METTH", "archaea" );
        put( "METKA", "archaea" );
        put( "PYRFU", "archaea" );
        put( "PYRKO", "archaea" );
        put( "PYRAB", "archaea" );
        put( "PYRHO", "archaea" );
        put( "THEON", "archaea" );
        put( "NANEQ", "archaea" );
        put( "NITMS", "archaea" );
        put( "THEAC", "archaea" );
        put( "THEVO", "archaea" );
        put( "PICTO", "archaea" );
        put( "PYRAR", "archaea" );
        put( "PYRCJ", "archaea" );
        put( "PYRAE", "archaea" );
        put( "PYRIL", "archaea" );
        put( "THENV", "archaea" );
        put( "CALMQ", "archaea" );
        put( "SULAC", "archaea" );
        put( "SULTO", "archaea" );
        put( "SULSO", "archaea" );
        put( "METS5", "archaea" );
        put( "AERPE", "archaea" );
        put( "STAMF", "archaea" );
        put( "THEPD", "archaea" );
        put( "HYPBU", "archaea" );
        put( "IGNH4", "archaea" );
        put( "KORCO", "archaea" );
        put( "KORVE", "bacteria" );
        put( "ECOLI", "bacteria" );
        put( "ECO57", "bacteria" );
        put( "SHIFL", "bacteria" );
        put( "SALTY", "bacteria" );
        put( "YERPE", "bacteria" );
        put( "PHOLU", "bacteria" );
        put( "PHOPR", "bacteria" );
        put( "VIBCH", "bacteria" );
        put( "SHEDO", "bacteria" );
        put( "PSEF5", "bacteria" );
        put( "PSEPF", "bacteria" );
        put( "PSEAE", "bacteria" );
        put( "CHRSD", "bacteria" );
        put( "DECAR", "bacteria" );
        put( "RALME", "bacteria" );
        put( "NITEU", "bacteria" );
        put( "NITMU", "bacteria" );
        put( "THIDE", "bacteria" );
        put( "ALHEH", "bacteria" );
        put( "HALHL", "bacteria" );
        put( "NITOC", "bacteria" );
        put( "THICR", "bacteria" );
        put( "IDILO", "bacteria" );
        put( "LEGPN", "bacteria" );
        put( "XANAC", "bacteria" );
        put( "XYLFT", "bacteria" );
        put( "AGRT5", "bacteria" );
        put( "RHIEC", "bacteria" );
        put( "BRAJA", "bacteria" );
        put( "RHOPT", "bacteria" );
        put( "RHOS1", "bacteria" );
        put( "ROSDO", "bacteria" );
        put( "CAUCR", "bacteria" );
        put( "ACICY", "bacteria" );
        put( "RHORU", "bacteria" );
        put( "HAEIN", "bacteria" );
        put( "PASMU", "bacteria" );
        put( "NEIME", "bacteria" );
        put( "ACIFE", "bacteria" );
        put( "DESPS", "bacteria" );
        put( "DESDE", "bacteria" );
        put( "SYNAS", "bacteria" );
        put( "GEOME", "bacteria" );
        put( "GEOSL", "bacteria" );
        put( "ANADE", "bacteria" );
        put( "MYXXA", "bacteria" );
        put( "ACIBL", "bacteria" );
        put( "SOLUS", "bacteria" );
        put( "RHOBA", "bacteria" );
        put( "KINRD", "bacteria" );
        put( "KOCRD", "bacteria" );
        put( "MICPN", "bacteria" );
        put( "STRCO", "bacteria" );
        put( "THEFY", "bacteria" );
        put( "MYCLE", "bacteria" );
        put( "MYCTU", "bacteria" );
        put( "CORJK", "bacteria" );
        put( "RHOOB", "bacteria" );
        put( "RUBXD", "bacteria" );
        put( "CHLAU", "bacteria" );
        put( "ROSCS", "bacteria" );
        put( "HERAU", "bacteria" );
        put( "SPHTD", "bacteria" );
        put( "DEIGD", "bacteria" );
        put( "DEIRA", "bacteria" );
        put( "THET8", "bacteria" );
        put( "ANAVT", "bacteria" );
        put( "NOSS7", "bacteria" );
        put( "NOSP7", "bacteria" );
        put( "ACAM1", "bacteria" );
        put( "MICAN", "bacteria" );
        put( "TRIER", "bacteria" );
        put( "SYNEL", "bacteria" );
        put( "SYNY3", "bacteria" );
        put( "GLOVI", "bacteria" );
        put( "PROMA", "bacteria" );
        put( "PROMP", "bacteria" );
        put( "PROMM", "bacteria" );
        put( "SYNS3", "bacteria" );
        put( "CHLPB", "bacteria" );
        put( "PROAE", "bacteria" );
        put( "PELLU", "bacteria" );
        put( "PROVI", "bacteria" );
        put( "CHLP8", "bacteria" );
        put( "CHLTE", "bacteria" );
        put( "CHLCH", "bacteria" );
        put( "CHLTA", "bacteria" );
        put( "FLAJO", "bacteria" );
        put( "GRAFK", "bacteria" );
        put( "CYTH3", "bacteria" );
        put( "BACFR", "bacteria" );
        put( "BACTN", "bacteria" );
        put( "PORGI", "bacteria" );
        put( "SALRD", "bacteria" );
        put( "AKKM8", "bacteria" );
        put( "METI4", "bacteria" );
        put( "LEPIC", "bacteria" );
        put( "BACAN", "bacteria" );
        put( "BACC3", "bacteria" );
        put( "BACSU", "bacteria" );
        put( "BACHD", "bacteria" );
        put( "GEOKA", "bacteria" );
        put( "LISMO", "bacteria" );
        put( "STAAU", "bacteria" );
        put( "CLOP1", "bacteria" );
        put( "CARHZ", "bacteria" );
        put( "THETN", "bacteria" );
        put( "DESHA", "bacteria" );
        put( "EUBR3", "bacteria" );
        put( "FERNB", "bacteria" );
        put( "THELT", "bacteria" );
        put( "THEMA", "bacteria" );
        put( "MYCGE", "bacteria" );
        put( "MYCPN", "bacteria" );
        put( "MESFL", "bacteria" );
        put( "UREPA", "bacteria" );
        put( "BORBU", "bacteria" );
        put( "TREPA", "bacteria" );
        put( "CHLPN", "bacteria" );
        put( "CHLFF", "bacteria" );
        put( "CHLMU", "bacteria" );
        put( "RICTY", "bacteria" );
        put( "BARHE", "bacteria" );
        put( "PELUB", "bacteria" );
        put( "RICB8", "bacteria" );
        put( "RICRO", "bacteria" );
        put( "FRATU", "bacteria" );
        put( "STRPN", "bacteria" );
        put( "STRPY", "bacteria" );
        put( "LACLA", "bacteria" );
        put( "LACAC", "bacteria" );
        put( "BIFLO", "bacteria" );
        put( "FUSNU", "bacteria" );
        put( "DEHE1", "bacteria" );
        put( "DEHSB", "bacteria" );
        put( "NITSB", "bacteria" );
        put( "SULNB", "bacteria" );
        put( "CAMJE", "bacteria" );
        put( "HELPH", "bacteria" );
        put( "AQUAE", "bacteria" );
    }
    private final static Map<String, Integer> FAKE_CODE_TO_ID_MAP           = new HashMap<String, Integer>();
    static {
        FAKE_CODE_TO_ID_MAP.put( "CTEXX", 283909 );
        FAKE_CODE_TO_ID_MAP.put( "HMAXX", 6085 );
        FAKE_CODE_TO_ID_MAP.put( "SARXX", 72019 );
        FAKE_CODE_TO_ID_MAP.put( "SPHAR", 72019 ); //TODO is same as Sphingomonas aromaticivorans
        FAKE_CODE_TO_ID_MAP.put( "AALXX", 398408 );
        FAKE_CODE_TO_ID_MAP.put( "PFIXX", 83344 );
        FAKE_CODE_TO_ID_MAP.put( "MPSXX", 692275 );
        FAKE_CODE_TO_ID_MAP.put( "BCOXX", 430998 );
        FAKE_CODE_TO_ID_MAP.put( "APPXX", 178873 );
        FAKE_CODE_TO_ID_MAP.put( "APMXX", 46634 );
        FAKE_CODE_TO_ID_MAP.put( "APSXX", 1042127 );
        FAKE_CODE_TO_ID_MAP.put( "CPUXX", 80637 );
        FAKE_CODE_TO_ID_MAP.put( "JARXX", 202697 );
        FAKE_CODE_TO_ID_MAP.put( "FPIXX", 40483 );
        FAKE_CODE_TO_ID_MAP.put( "PPLXX", 104341 );
        FAKE_CODE_TO_ID_MAP.put( "MVNXX", 1069443 );
        FAKE_CODE_TO_ID_MAP.put( "CREXX", 61392 );
        FAKE_CODE_TO_ID_MAP.put( "FALXX", 691883 );
        FAKE_CODE_TO_ID_MAP.put( "CCLXX", 85681 );
        FAKE_CODE_TO_ID_MAP.put( "ORCXX", 385169 );
        FAKE_CODE_TO_ID_MAP.put( "ASCXX", 763042 );
        FAKE_CODE_TO_ID_MAP.put( "CSUXX", 574566 );
        FAKE_CODE_TO_ID_MAP.put( "OTRXX", 1172189 );
        FAKE_CODE_TO_ID_MAP.put( "FCYXX", 186039 );
        FAKE_CODE_TO_ID_MAP.put( "AKEXX", 702273 );
        FAKE_CODE_TO_ID_MAP.put( "SAGXX", 876976 );
        FAKE_CODE_TO_ID_MAP.put( "ALIXX", 87102 );
        FAKE_CODE_TO_ID_MAP.put( "TTRXX", 529818 );
    }
}
