#include "Bdef.h"


#if (INTFACE == C_CALL)
void Cdtrsd2d(ConTxt, uplo, diag, m, n, A, lda, rdest, cdest)
int  ConTxt;
char  *uplo;
char  *diag;
int  m;
int  n;
double  *A;
int  lda;
int  rdest;
int  cdest;
#else
void dtrsd2d_(ConTxt, uplo, diag, m, n, A, lda, rdest, cdest)
int  *ConTxt;
char  *uplo;
char  *diag;
int  *m;
int  *n;
double  *A;
int  *lda;
int  *rdest;
int  *cdest;
#endif
/*
 *  -- V1.1 BLACS routine --
 *  University of Tennessee, May 1, 1996
 *  Written by Clint Whaley.
 *
 *  Purpose
 *  =======
 *  Locally-blocking point-to-point trapezoidal double precision send.
 *
 *  Arguments
 *  =========
 *
 *  ConTxt  (input) Ptr to int
 *          Index into MyConTxts00 (my contexts array).
 *
 *  UPLO    (input) Ptr to char
 *          Specifies the part of the matrix to be sent.
 *          = 'U':      Upper trapezoidal part
 *          ELSE :      Lower trapezoidal part
 *
 *  DIAG    (input) Ptr to char
 *          Specifies whether the matrix is unit diagonal or not.
 *          = 'U':      Matrix is unit diagonal, diagonal not communicated.
 *          ELSE :      Matrix is not unit diagonal, diagonal is communicated.
 *
 *  M       (input) Ptr to int
 *          The number of rows of the matrix A.  M >= 0.
 *
 *  N       (input) Ptr to int
 *          The number of columns of the matrix A.  N >= 0.
 *
 *  A       (input) Ptr to double precision two dimensional array
 *          The m by n matrix A.  Fortran77 (column-major) storage
 *          assumed.
 *          If UPLO = 'U', only the upper trapezoid is accessed;
 *          if UPLO = 'L', only the lower trapezoid is accessed.
 *
 *  LDA     (input) Ptr to int
 *          The leading dimension of the array A.  LDA >= M.
 *
 *  RDEST   (input) Ptr to int
 *          The process row of the destination process.
 *
 *  CDEST   (input) Ptr to int
 *          The process column of the destination process.
 *
 * ------------------------------------------------------------------------
 */
{
#if (BlacsDebugLvl > 0)
   void ArgCheck00();
#endif
   void dtrpack00();
   void Ssend2dID();

   int tlda;
   BLACSCONTEXT *ctxt;
   char tuplo, tdiag;

   MGetConTxt(Mpval(ConTxt), ctxt);
   tuplo = Mlowcase(*uplo);
   tdiag = Mlowcase(*diag);

#if (BlacsDebugLvl > 0)
   ArgCheck00(Mpval(ConTxt), RT_SD, __FILE__, 'a', tuplo, tdiag, Mpval(m),
              Mpval(n), Mpval(lda), 1, Mpaddress(rdest), Mpaddress(cdest));
#endif
   if (Mpval(lda) < Mpval(m)) tlda = Mpval(m);
   else tlda = Mpval(lda);

/*
 * Get buff, pack, and send message
 */
   dtrpack00(tuplo, tdiag, Mpval(m), Mpval(n), (double *) A, tlda);
   Ssend2dID(ctxt, Mpval(rdest), Mpval(cdest));
}  /* end of dtrsd2d_ */
