/*
 * buffy - Mailbox watcher
 *
 * Copyright (C) 2003--2008  Enrico Zini <enrico@enricozini.org>
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#ifdef HAVE_CONFIG_H
#include <config.h>
#define APPNAME PACKAGE_NAME
#else
#warning No config.h found: using fallback values
#define APPNAME __FILE__
#define PACKAGE_VERSION "unknown"
#endif

//#include "Environment.h"
#include <buffy/mailfolder.h>
#include <wibble/exception.h>
#include <wibble/commandline/parser.h>

#include <vector>
#include <iostream>

using namespace std;
using namespace buffy;
using namespace wibble;
using namespace wibble::commandline;

static void printStats(const MailFolder& f)
{
	cout << f.name() << ": path " << f.path()
		 << ", new " << f.getMsgNew()
		 << " unread " << f.getMsgUnread()
		 << ", total " << f.getMsgTotal()
		 << ", flagged " << f.getMsgFlagged()
		 << endl;
}

struct Options : public StandardParserWithManpage
{
	BoolOption* verbose;
	BoolOption* debug;
	BoolOption* loop;

	Options() : StandardParserWithManpage("bshow", PACKAGE_VERSION, 1, PACKAGE_BUGREPORT)
	{
		usage = "";
		description =
			"Mail folder monitor.\n"
			"Monitor new and unread messages in a collection of mail folders.";
		verbose = add<BoolOption>("verbose", 0, "verbose", "", "enable verbose output");
		debug = add<BoolOption>("debug", 0, "debug", "", "enable debugging output (includes verbose output)");
		loop = add<BoolOption>("loop", 'l', "loop", "", "continuously loop checking for new changes");
	}
};

int main(int argc, char* argv[])
{
	Options opts;
	try {
		// Process the commandline
		if (opts.parse(argc, (const char**)argv))
			return 0;

//		Environment::init();
		
//		if (opts.get("verbose").defined())
//			Environment::get().verbose(true);
//		if (opts.get("debug").defined())
//			Environment::get().debug(true);

		bool loop = opts.loop->boolValue();

		do {
			while (opts.hasNext())
			{
				string path = opts.next();
				MailFolder f = MailFolder::accessFolder(path);
				if (!f.valid())
					cerr << path << " is not a mail folder." << endl;
				else
				{
					if (f.changed())
						f.updateStatistics();
					printStats(f);
				}
			}
			if (loop) sleep(1);
		} while (loop);
		
		return 0;
	} catch (wibble::exception::BadOption& e) {
		cerr << e.desc() << endl;
		opts.outputHelp(cerr);
		return 1;
	} catch (std::exception& e) {
		cerr << e.what() << endl;
		return 1;
	}
}

// vim:set ts=4 sw=4:
