(* :Name: Label *)

(* :Title: Label *)

(* :Author: Tom Wickham-Jones*)

(* :Package Version: 1.0 *)

(* :Mathematica Version: 2.2 *)

(*:Summary:
	This package provides functions for placing labels
	on a plot.
*)


(* :History:
	Created spring 1994 by Tom Wickham-Jones.
	
	This package is described in the book
	Mathematica Graphics: Techniques and Applications.
	Tom Wickham-Jones, TELOS/Springer-Verlag 1994.

*)


(*:Warnings:
	The package adds rules to Graphics and changes the
	way that PlotLabel works.
*)


BeginPackage[ "ExtendGraphics`Label`"]


Begin["`Private`"]


Unprotect[ Graphics];
                    
LabelTest[ head_, opts_] :=
		!FreeQ[ PlotLabel /. opts /. Options[ head], Text];

Graphics /:                                               
Display[   
    stm_,
    obj:Graphics[ g_, opts___] /; LabelTest[ Graphics, Flatten[{opts}]]] :=
    (
    Display[ stm, InsertLabel[ obj]];
         obj
    );
    
   
InsertLabel[ Graphics[ g_, opts___]] :=
    Block[{newp, x1, x2, y1, y2, asp, labs},
        newp = Show[ Graphics[ g, opts], 
        			PlotLabel -> None,
                	DisplayFunction -> Identity] ;
        {{x1, x2}, {y1, y2}} = 
              FullOptions[ newp, PlotRange] ;
        asp = FullOptions[ newp, AspectRatio] ;
    	labs = PlotLabel /. Flatten[{opts}] /. Options[ Graphics] ;
        labs = labs /. 
        	 Scaled[ {x_, y_}] :> {x (x2-x1) + x1, y (y2-y1) + y1} ;
        Graphics[ { Rectangle[ {x1,y1}, {x2, y2}, newp],
				    labs}, 
                  PlotRange -> All,
                  AspectRatio -> asp]
        ]                                


End[]

EndPackage[]

                                  
(*

<<ExtendGraphics/Label.m

p = Plot[ Sin[x], {x,0,2Pi}]
 

Show[ p, 
	Frame -> True,
	PlotLabel -> 
		{Text["Main Label\n Top Label", Scaled[{0.5, 1.0}], {0, -1}],
		 Text["Bottom Label", Scaled[{0.5, 0.0}], {0, 1}],
		 Text["Left Label", Scaled[{0.0, 0.5}], {1, 0}, {0,1}],
		 Text["Corner Label", {6.5,1}, {-1, -1}]}]



Show[ p, 
	PlotLabel -> 
		{Text["Bottom Label", Scaled[{0.5, 0.0}], {0, 1}],
		 Text["Left Label", Scaled[{0.0, 0.5}], {1, 0}, {0,1}],
		 Text["X-axis Label", {6.5,0.0 }, {-1, 0}],
		 Text["Corner Label", {6.5,1}, {-1, -1}]}]
		 
Show[ p, PlotLabel ->
                Text[ "X-axis Left", {-0.2, 0}, {1,0}]]


*)






