#!/usr/bin/perl -w

eval 'exec perl -S $0 ${1+"$@"}'
    if 0;

# This script will create the Makefile to build and install a full-screen
# text user interface for CLC-INTERCAL

# This file is part of CLC-INTERCAL 1.-94.-2

# Copyright (c) 2008 Claudio Calvelli, all rights reserved.

# CLC-INTERCAL is copyrighted software. However, permission to use, modify,
# and distribute it is granted provided that the conditions set out in the
# licence agreement are met. See files README and COPYING in the distribution.

require 5.005;
use Config qw(%Config);
use ExtUtils::MakeMaker;
use strict;

use vars qw($VERSION $PERVERSION);
($VERSION) = ($PERVERSION = "CLC-INTERCAL/UI-Curses Makefile.PL 1.-94.-2") =~ /\s(\S+)$/;

my @want_type = grep { /^type=/ } @ARGV;
@ARGV = grep { ! /^type=/ } @ARGV;

my $base = $ENV{CLC_INTERCAL_PATH}
	 ? "'$ENV{CLC_INTERCAL_PATH}/INTERCAL/"
	 : 'Language::INTERCAL::';
my $end = $ENV{CLC_INTERCAL_PATH}
	? ".pm'"
	: '';

for my $module (qw(Exporter InstallModule)) {
    eval "require $base$module$end";
    if ($@) {
	$@ =~ /can't locate/i and die "You don't appear to have CLC-INTERCAL installed:\n$@";
	die "Error loading the CLC-INTERCAL installer:\n$@";
    }
}

import Language::INTERCAL::InstallModule '1.-94.-2';

install Language::INTERCAL::InstallModule 'UI-Curses', 0, {
	'Curses' => 0,
};

1;
