/*
 *   This file is part of Clinica.
 *
 *   Clinica is free software: you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation, either version 3 of the License, or
 *   (at your option) any later version.
 *
 *   Clinica is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with Clinica.  If not, see <http://www.gnu.org/licenses/>.
 *
 *   Authors: Leonardo Robol <leo@robol.it>
 *            Gianmarco Brocchi <brocchi@poisson.phc.unipi.it>
 */

using Gtk;

namespace Clinica {

    /**
     * @brief Page is an interface inherited by all the pages
     * that will be put in the main widget. 
     *
     * Some common methods are provided here and inheritance
     * from Gtk.Alignment is enforced to make sure that the widget
     * is add-able in the main-align. 
     */
    public interface Page : Alignment {
    	public signal void start_page_requested ();
    	public signal void patient_list_requested ();
    	public signal void doctor_list_requested ();
    	public signal void medicines_search_page_requested ();
    	public signal void calendar_window_requested ();
        public signal void error (string message);
        public signal void new_title (string title);
        public abstract ResourceManager resource_manager { get; set; }
        
        public void connect_signal () {
        	error.connect (resource_manager.user_interface.error_callback);
        	start_page_requested.connect((t) => resource_manager.user_interface.show_start_page ());
        	patient_list_requested.connect((t) => resource_manager.user_interface.show_patient_list_page());
        	doctor_list_requested.connect((t) => resource_manager.user_interface.show_doctor_list_page());
        	medicines_search_page_requested.connect ((t) => resource_manager.user_interface.show_medicines_search_page ());
        	calendar_window_requested.connect ((t) => resource_manager.user_interface.show_calendar_window ());
        	new_title.connect((t, title) => resource_manager.user_interface.window.set_title(title));
        }
        
        public abstract void setup ();
    }

}
