/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.event;

import net.sf.saxon.event.ComplexContentOutputter;
import net.sf.saxon.event.NamespaceReducer;
import net.sf.saxon.event.Receiver;
import net.sf.saxon.event.SequenceReceiver;
import net.sf.saxon.om.DocumentInfo;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NamePool;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.Orphan;
import net.sf.saxon.tinytree.TinyBuilder;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.value.AtomicValue;

public abstract class SequenceWriter
extends SequenceReceiver {
    private Receiver outputter = null;
    private TinyBuilder builder = null;
    private int level = 0;
    private boolean inStartTag = false;

    public abstract void write(Item var1) throws XPathException;

    public boolean hasOpenNodes() {
        return this.level != 0;
    }

    public void startDocument(int n) throws XPathException {
        if (this.outputter == null) {
            this.createTree();
        }
        if (this.level++ == 0) {
            this.outputter.startDocument(n);
        }
    }

    private void createTree() throws XPathException {
        this.builder = new TinyBuilder();
        this.builder.setPipelineConfiguration(this.getPipelineConfiguration());
        this.builder.setSystemId(this.getSystemId());
        NamespaceReducer namespaceReducer = new NamespaceReducer();
        namespaceReducer.setUnderlyingReceiver(this.builder);
        namespaceReducer.setPipelineConfiguration(this.getPipelineConfiguration());
        ComplexContentOutputter complexContentOutputter = new ComplexContentOutputter();
        complexContentOutputter.setHostLanguage(this.getPipelineConfiguration().getHostLanguage());
        complexContentOutputter.setPipelineConfiguration(this.getPipelineConfiguration());
        complexContentOutputter.setReceiver(namespaceReducer);
        this.outputter = complexContentOutputter;
        this.outputter.setSystemId(this.systemId);
        this.outputter.setPipelineConfiguration(this.getPipelineConfiguration());
        this.outputter.open();
    }

    public void endDocument() throws XPathException {
        if (--this.level == 0) {
            this.outputter.endDocument();
            DocumentInfo documentInfo = (DocumentInfo)this.builder.getCurrentRoot();
            this.append(documentInfo, 0, 2);
        }
        this.previousAtomic = false;
    }

    public void startElement(int n, int n2, int n3, int n4) throws XPathException {
        if (this.inStartTag) {
            this.startContent();
        }
        if (this.outputter == null) {
            this.createTree();
        }
        this.outputter.startElement(n, n2, n3, n4);
        ++this.level;
        this.inStartTag = true;
        this.previousAtomic = false;
    }

    public void endElement() throws XPathException {
        if (this.inStartTag) {
            this.startContent();
        }
        this.outputter.endElement();
        if (--this.level == 0) {
            NodeInfo nodeInfo = this.builder.getCurrentRoot();
            this.append(nodeInfo, 0, 2);
        }
        this.previousAtomic = false;
    }

    public void namespace(int n, int n2) throws XPathException {
        if (this.level == 0) {
            NamePool namePool = this.getNamePool();
            Orphan orphan = new Orphan(this.getConfiguration());
            orphan.setNodeKind((short)13);
            orphan.setNameCode(namePool.allocate("", "", namePool.getPrefixFromNamespaceCode(n)));
            orphan.setStringValue(namePool.getURIFromNamespaceCode(n));
            this.append(orphan, 0, 2);
        } else {
            this.outputter.namespace(n, n2);
        }
        this.previousAtomic = false;
    }

    public void attribute(int n, int n2, CharSequence charSequence, int n3, int n4) throws XPathException {
        if (this.level == 0) {
            Orphan orphan = new Orphan(this.getConfiguration());
            orphan.setNodeKind((short)2);
            orphan.setNameCode(n);
            orphan.setStringValue(charSequence);
            orphan.setTypeAnnotation(n2);
            this.append(orphan, n3, 2);
        } else {
            this.outputter.attribute(n, n2, charSequence, n3, n4);
        }
        this.previousAtomic = false;
    }

    public void startContent() throws XPathException {
        this.inStartTag = false;
        this.outputter.startContent();
        this.previousAtomic = false;
    }

    public void characters(CharSequence charSequence, int n, int n2) throws XPathException {
        if (this.level == 0) {
            Orphan orphan = new Orphan(this.getConfiguration());
            orphan.setNodeKind((short)3);
            orphan.setStringValue(charSequence);
            this.append(orphan, n, 2);
        } else if (charSequence.length() > 0) {
            if (this.inStartTag) {
                this.startContent();
            }
            this.outputter.characters(charSequence, n, n2);
        }
        this.previousAtomic = false;
    }

    public void comment(CharSequence charSequence, int n, int n2) throws XPathException {
        if (this.inStartTag) {
            this.startContent();
        }
        if (this.level == 0) {
            Orphan orphan = new Orphan(this.getConfiguration());
            orphan.setNodeKind((short)8);
            orphan.setStringValue(charSequence);
            this.append(orphan, n, 2);
        } else {
            this.outputter.comment(charSequence, n, n2);
        }
        this.previousAtomic = false;
    }

    public void processingInstruction(String string, CharSequence charSequence, int n, int n2) throws XPathException {
        if (this.inStartTag) {
            this.startContent();
        }
        if (this.level == 0) {
            Orphan orphan = new Orphan(this.getConfiguration());
            orphan.setNameCode(this.getNamePool().allocate("", "", string));
            orphan.setNodeKind((short)7);
            orphan.setStringValue(charSequence);
            this.append(orphan, n, 2);
        } else {
            this.outputter.processingInstruction(string, charSequence, n, n2);
        }
        this.previousAtomic = false;
    }

    public void close() throws XPathException {
        this.previousAtomic = false;
        if (this.outputter != null) {
            this.outputter.close();
        }
    }

    public void append(Item item, int n, int n2) throws XPathException {
        if (item == null) {
            return;
        }
        if (this.level == 0) {
            this.write(item);
            this.previousAtomic = false;
        } else if (item instanceof AtomicValue) {
            if (this.previousAtomic) {
                this.outputter.characters(" ", 0, 0);
            }
            this.outputter.characters(item.getStringValueCS(), 0, 0);
            this.previousAtomic = true;
        } else {
            ((NodeInfo)item).copy(this.outputter, 2, true, n);
            this.previousAtomic = false;
        }
    }
}

