/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.sort;

import java.io.Serializable;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Comparator;
import java.util.Properties;
import net.sf.saxon.Configuration;
import net.sf.saxon.expr.Container;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.StaticContext;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.instruct.Executable;
import net.sf.saxon.sort.AtomicComparer;
import net.sf.saxon.sort.AtomicSortComparer;
import net.sf.saxon.sort.DescendingComparer;
import net.sf.saxon.sort.EmptyGreatestComparer;
import net.sf.saxon.sort.NumericComparer;
import net.sf.saxon.sort.TextComparer;
import net.sf.saxon.trans.DynamicError;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.TypeHierarchy;
import net.sf.saxon.value.EmptySequence;
import net.sf.saxon.value.StringValue;

public class SortKeyDefinition
implements Serializable {
    private static StringValue defaultOrder = new StringValue("ascending");
    private static StringValue defaultCaseOrder = new StringValue("#default");
    private static StringValue defaultLanguage = StringValue.EMPTY_STRING;
    protected Expression sortKey;
    protected Expression order = defaultOrder;
    protected Expression dataTypeExpression = null;
    protected Expression caseOrder = defaultCaseOrder;
    protected Expression language = defaultLanguage;
    protected Expression collationName = null;
    protected Expression stable = null;
    protected transient Comparator collation;
    protected String baseURI;
    protected boolean emptyLeast = true;
    protected boolean backwardsCompatible = false;
    protected Container parentExpression;
    protected transient Comparator comparer = null;

    public void setParentExpression(Container container) {
        this.parentExpression = container;
    }

    public Container getParentExpression() {
        return this.parentExpression;
    }

    public void setSortKey(Expression expression) {
        this.sortKey = expression;
    }

    public Expression getSortKey() {
        return this.sortKey;
    }

    public void setOrder(Expression expression) {
        this.order = expression;
    }

    public Expression getOrder() {
        return this.order;
    }

    public void setDataTypeExpression(Expression expression) {
        this.dataTypeExpression = expression;
    }

    public Expression getDataTypeExpression() {
        return this.dataTypeExpression;
    }

    public void setCaseOrder(Expression expression) {
        this.caseOrder = expression;
    }

    public Expression getCaseOrder() {
        return this.caseOrder;
    }

    public void setLanguage(Expression expression) {
        this.language = expression;
    }

    public Expression getLanguage() {
        return this.language;
    }

    public void setCollationName(Expression expression) {
        this.collationName = expression;
    }

    public Expression getCollationName() {
        return this.collationName;
    }

    public void setCollation(Comparator comparator) {
        this.collation = comparator;
    }

    public Comparator getCollation() {
        return this.collation;
    }

    public void setBaseURI(String string) {
        this.baseURI = string;
    }

    public String getBaseURI() {
        return this.baseURI;
    }

    public void setStable(Expression expression) {
        this.stable = expression;
    }

    public Expression getStable() {
        return this.stable;
    }

    public void setBackwardsCompatible(boolean bl) {
        this.backwardsCompatible = bl;
    }

    public boolean isBackwardsCompatible() {
        return this.backwardsCompatible;
    }

    public void setEmptyLeast(boolean bl) {
        this.emptyLeast = bl;
    }

    public boolean getEmptyLeast() {
        return this.emptyLeast;
    }

    public boolean isFixed() {
        return !(!(this.order instanceof StringValue) || this.dataTypeExpression != null && !(this.dataTypeExpression instanceof EmptySequence) && !(this.dataTypeExpression instanceof StringValue) || !(this.caseOrder instanceof StringValue) || !(this.language instanceof StringValue) || this.stable != null && !(this.stable instanceof StringValue) || this.collationName != null && !(this.collationName instanceof StringValue));
    }

    public SortKeyDefinition simplify(StaticContext staticContext, Executable executable) throws XPathException {
        this.sortKey = this.sortKey.simplify(staticContext);
        this.order = this.order.simplify(staticContext);
        if (this.dataTypeExpression != null) {
            this.dataTypeExpression = this.dataTypeExpression.simplify(staticContext);
        }
        this.caseOrder = this.caseOrder.simplify(staticContext);
        this.language = this.language.simplify(staticContext);
        if (this.stable != null) {
            this.stable = this.stable.simplify(staticContext);
        }
        return this;
    }

    public Comparator makeComparator(XPathContext xPathContext) throws XPathException {
        StringValue stringValue;
        Serializable serializable;
        Object object;
        String string;
        Comparator comparator;
        String string2 = this.order.evaluateAsString(xPathContext);
        Configuration configuration = xPathContext.getConfiguration();
        TypeHierarchy typeHierarchy = configuration.getTypeHierarchy();
        if (this.collation != null) {
            comparator = this.collation;
        } else {
            if (this.collationName != null) {
                string = this.collationName.evaluateAsString(xPathContext);
                try {
                    object = new URI(string);
                    if (!((URI)object).isAbsolute()) {
                        if (this.baseURI == null) {
                            throw new DynamicError("Collation URI is relative, and base URI is unknown");
                        }
                        serializable = new URI(this.baseURI);
                        object = ((URI)serializable).resolve((URI)object);
                    }
                }
                catch (URISyntaxException uRISyntaxException) {
                    throw new DynamicError("Collation name " + string + " is not a valid URI: " + uRISyntaxException);
                }
                try {
                    comparator = xPathContext.getCollation(((URI)object).toString());
                }
                catch (XPathException xPathException) {
                    if ("FOCH0002".equals(xPathException.getErrorCodeLocalPart())) {
                        xPathException.setErrorCode("XTDE1035");
                    }
                    throw xPathException;
                }
            }
            string = this.caseOrder.evaluateAsString(xPathContext);
            object = this.language.evaluateAsString(xPathContext);
            serializable = new Properties();
            if (!((String)object).equals("")) {
                ((Properties)serializable).setProperty("lang", (String)object);
            }
            if (!string.equals("#default")) {
                ((Properties)serializable).setProperty("case-order", string);
            }
            comparator = configuration.getPlatform().makeCollation(configuration, (Properties)serializable);
        }
        if (this.dataTypeExpression == null) {
            int n = this.sortKey.getItemType(typeHierarchy).getAtomizedItemType().getPrimitiveType();
            comparator = AtomicSortComparer.makeSortComparer(comparator, n, xPathContext);
            if (!this.emptyLeast) {
                comparator = new EmptyGreatestComparer((AtomicComparer)comparator);
            }
        } else {
            string = this.dataTypeExpression.evaluateAsString(xPathContext);
            if (string.equals("text")) {
                comparator = new TextComparer(comparator);
            } else if (string.equals("number")) {
                comparator = NumericComparer.getInstance();
            } else {
                object = new DynamicError("data-type on xsl:sort must be 'text' or 'number'");
                ((XPathException)object).setErrorCode("XTDE0030");
                throw object;
            }
        }
        if (this.stable != null && !((String)(object = (stringValue = (StringValue)this.stable.evaluateItem(xPathContext)).getStringValue().trim())).equals("yes") && !((String)object).equals("no")) {
            serializable = new DynamicError("Value of 'stable' on xsl:sort must be 'yes' or 'no'");
            ((XPathException)serializable).setErrorCode("XTDE0030");
            throw serializable;
        }
        if (string2.equals("ascending")) {
            return comparator;
        }
        if (string2.equals("descending")) {
            return new DescendingComparer(comparator);
        }
        DynamicError dynamicError = new DynamicError("order must be 'ascending' or 'descending'");
        dynamicError.setErrorCode("XTDE0030");
        throw dynamicError;
    }

    public void setComparer(Comparator comparator) {
        this.comparer = comparator;
    }

    public Comparator getComparer() {
        return this.comparer;
    }
}

