/* $Id: cxdeque-test.c,v 1.3 2007/07/20 07:42:04 scastro Exp $
 *
 * This file is part of the ESO C Extension Library
 * Copyright (C) 2001-2006 European Southern Observatory
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */

/*
 * $Author: scastro $
 * $Date: 2007/07/20 07:42:04 $
 * $Revision: 1.3 $
 * $Name: cpl-5_3_0-BRANCH $
 */

#undef CX_DISABLE_ASSERT
#undef CX_LOG_DOMAIN

#include <stdio.h>
#include <string.h>

#include "cxmemory.h"
#include "cxmessages.h"
#include "cxdeque.h"


int
main(void)
{

    cx_deque *d;
    cx_deque_iterator pos;

    /*    cxchar letters[] = "ABCDEFGHIJKLMNOPQRSTUVWXYZ";*/
    cxint i;
    cxint num1[10] = {0, 1, 2, 3, 4, 5, 6, 7, 8, 9};
    /*    cxint num2[10] = {8, 9, 7, 0, 3, 2, 5, 1, 4, 6};*/



    /*
     * Test 1: Create a deque, check that it is a valid empty deque and
     *         destroy it again.
     */

    d = cx_deque_new();
    cx_assert(d != NULL);

    cx_assert(cx_deque_empty(d));
    cx_assert(cx_deque_size(d) == 0);
    cx_assert(cx_deque_begin(d) == cx_deque_end(d));

    cx_deque_destroy(d,NULL);

        /*
     * Test 2: Create a deque and append the numbers num1, check that
     *         the data were properly appended, thereby verifying that
     *         we can properly step through the array.
     */

    d = cx_deque_new();

    for (i = 0; i < 10; i++)
        cx_deque_push_back(d, &num1[i]);

    
    cx_assert(cx_deque_size(d) == 10);
    i = 0;
    pos = cx_deque_begin(d);

    while (pos != cx_deque_end(d)) {
        cxptr data = cx_deque_get(d, pos);
        cx_assert(*((cxint *)data) == i);

        pos = cx_deque_next(d, pos);
        i++;
    }
    
    cx_deque_destroy(d, NULL);

        /*
     * Test 3: Same as test 2, but insert the numbers as head of the array.
     */

    d = cx_deque_new();

    for (i = 0; i < 10; i++)
        cx_deque_push_front(d, &num1[i]);

    i = 0;
    pos = cx_deque_begin(d);
    
    cx_deque_destroy(d, NULL);

    /*
     * All tests succeeded
     */

    return 0;

}
