# Copyright 1999-2007 Gentoo Foundation
# Distributed under the terms of the GNU General Public License v2
# $Header: $

inherit eutils distutils linux-info

DESCRIPTION="CPUShare Sell Client for Linux"
HOMEPAGE="http://www.cpushare.com/"
SRC_URI="https://www.cpushare.com/downloads/cpushare/core/${P}.tar.bz2"

LICENSE="LGPL-2"
SLOT="0"
KEYWORDS="~amd64 ~x86 ~ppc64 ~ppc"
IUSE=""

DEPEND=""
RDEPEND="${DEPEND}
	>=dev-python/twisted-2.5.0
	>=dev-python/pyopenssl-0.6"

S=${WORKDIR}/${PN}

CONFIG_CHECK="SECCOMP"
ERROR_SECCOMP="${PN} requires support for Secure Computing (SECCOMP) - this can be enabled in 'Processor type and features -> Enable seccomp to safely compute untrusted bytecode'."

src_compile() {
	emake || die "emake failed"
}

src_install() {
	distutils_src_install

	# get rid of this to prevent collision-protect from killing us. it
	# is regenerated in pkg_postinst. Same as in twisted ebuild.
	rm "${D}/usr/$(get_libdir)"/python*/site-packages/twisted/plugins/dropin.cache

	dobin seccomp-loader
	insinto /usr/share/${PN}
	doins -r keys
	newinitd gentoo/cpushare.init.d cpushare || die "init.d failed"
	dodoc README COPYING
	dodir /var/log/cpushare /etc/cpushare
	fperms 700 /etc/cpushare /var/log/cpushare
}

# Same as in twisted ebuild.
update_plugin_cache() {
	python_version
	local tpath="${ROOT}usr/$(get_libdir)/python${PYVER}/site-packages/twisted"
	# we have to remove the cache or removed plugins won't be removed
	# from the cache (http://twistedmatrix.com/bugs/issue926)
	[[ -e "${tpath}/plugins/dropin.cache" ]] && rm -f "${tpath}/plugins/dropin.cache"
	if [[ -e "${tpath}/plugin.py" ]]; then
		# twisted is still installed, update.
	    # we have to use getPlugIns here for <=twisted-2.0.1 compatibility
		einfo "Regenerating plugin cache"
		python -c "from twisted.plugin import IPlugin, getPlugIns;list(getPlugIns(IPlugin))"
	fi
}

pkg_postinst() {
	enewgroup cpushare
	enewuser cpushare -1 -1 /dev/null cpushare

	fowners cpushare:cpushare /var/log/cpushare /etc/cpushare

	distutils_pkg_postinst
	update_plugin_cache

	elog "Download the order.cpu from https://www.cpushare.com/orders/ and copy it"
	elog "in the directory /etc/cpushare/, then you can start CPUShare."
	elog "If in trouble you can use 'sudo cp order.cpu /etc/cpushare/'."
	elog
	elog "To start CPUShare, use the init script, e.g.:"
	elog " # /etc/init.d/cpushare start"
	elog
	elog "You should add CPUShare to your default runlevel so that it will be"
	elog "started on on every bootup, e.g.:"
	elog " # rc-update add cpushare default"
	ewarn
	ewarn "You must agree with the CPUShare User Agreement before running CPUShare."
	ewarn "Running CPUShare is at your own risk."
	ewarn
}

pkg_postrm() {
	distutils_pkg_postrm
	update_plugin_cache
}
