/* preferences.h			-*- C++ -*-
   $Id: preferences.h,v 1.7 2001/11/27 23:57:36 elf Exp $
   
   written by Marc Singer
   27 Oct 1996

   This file is part of the project CurVeS.  See the file README for
   more information.

   Copyright (C) 1996 Marc Singer

   This program is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public License as
   published by the Free Software Foundation; either version 2 of the
   License, or (at your option) any later version.

   This program is distributed in the hope that it will be useful, but
   WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   General Public License for more details.

   You should have received a copy of the GNU General Public License
   with your Debian GNU/Linux system, in
   /usr/share/common-licenses/GPL, or with the Debian GNU/Linux hello
   source package as the file COPYING. If not, write to the Free
   Software Foundation, Inc., 59 Temple Place -Suite 330, MA
   02111-1307, USA.

   -----------
   DESCRIPTION
   -----------

   Preference options management class.

*/

#if !defined (__PREFERENCES_H__)
#    define   __PREFERENCES_H__

/* ----- Includes */

#include <memory.h>

/* ----- Globals */

typedef struct _LPreferenceElement {
  struct _LPreferenceElement* pNext;
  char* szKeyword;
  char* szValue;
  char* szValueDefault;		// Default values for re-reads
} LPreferenceElement;

	// === This is a very important constant.  It is the maximum
	//     length allowed for any preference string.  It is
	//     important because the command strings that we compose
	//     will use it when allocating space to include commands
	//     specified by the user.  Internally, we will discard any
	//     preferences longer than this maximum.
#define CB_PREFERENCE_MAX	100
#define CB_COMMAND		(CB_PREFERENCE_MAX + 40)

class LPreferences {
protected:
  LPreferenceElement* m_pElements; 	// List of preference key/value pairs

  LPreferenceElement* _find (const char* szKeyword);
  void _associate (char* szKeyword, char* szValue);

public:  
  LPreferences () {
    zero (); }
  LPreferences (const char* szPath) {
    zero (); init (szPath); }
  ~LPreferences () {
    release_this (); }
  void zero (void) {
    memset (this, 0, sizeof (*this)); }
  void init (const char* szPath) {
    read (szPath); }
  void release_this (void);
  void release_entries (void);
  void release_settings (void);

  void associate (const char* szKeyword, const char* szValue);
  void associate (const char* szKeyword, int value);
  const char* fetch (const char* szKeyword);
  char* grab (char* pb, int cch);
  void read (const char* szPath);
  void transfer_defaults (void);

  bool as_bool (const char* szKeyword);
  int as_int (const char* szKeyword);

};

extern LPreferences g_preferences;		 // Everybody's favorite

#endif  /* __PREFERENCES_H__ */
