#!/usr/bin/env python2

# THIS FILE IS PART OF THE CYLC SUITE ENGINE.
# Copyright (C) 2008-2019 NIWA & British Crown (Met Office) & Contributors.
#
# This program is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.
"""Parsec - library for parsing nested Cylc's INI-style configuration."""

import logging


class ParsecError(Exception):
    def __init__(self, msg=''):
        Exception.__init__(self, msg)
        self.msg = self.args[0]

    def __str__(self):
        return str(self.msg)


LOG = logging.getLogger('cylc')  # Acceptable?
if hasattr(logging, 'NullHandler'):  # Back compat Python <2.7
    LOG.addHandler(logging.NullHandler())  # Start with a null handler
