.TH dds2index 1L 2.4 \" -*- nroff -*-
.\"----------
.SH NAME
.\"----------
dds2index \- tool to create an indexfile for the use of
.\"----------
.SH SYNOPSIS
.\"----------
.B dds2index
[options]
.\"----------
.SH DESCRIPTION
.\"----------
.B dds2index
creates an index file that is required by the file extraction utility
.BR dds2tar(1) .
It works on 
.B tar 
archives stored on dds tape devices (DAT).
Since the file structure of the tape archives is
used to extract the files, the archive must be an 
.B uncompressed tar 
archive. But compression by the transparent
signal processor of the tape device is allowed.
.PP
The index created by
.BR dds2index
is written to 
.I stdout 
by default and should normally be stored on hard disk as 
.I indexfile 
for later use by 
.BR dds2tar(1) .
.PP
The default tape device to read from is
.IR /dev/tape ,
which may be overridden with the environment variable
.BR TAPE ,
which in turn may be overridden with the
.BI -f\  device
option. The device must be a SCSI tape device.
.PP
.\"----------
.SH OPTIONS
.\"----------
.TP
.BI -f\  devicefile
device of the tape archive. Must be a character special file.
.TP
.BI -t\  indexfile
write the index to 
.IR indexfile ,
not to
.IR stdout.
.TP
.BR -z , --compress
write the index in (gzip) compressed mode.
.TP
.B --help
print some screens of online help with examples through a pager
and exit immediatley.
.\"----------
.SH OPTIONS you didn't really need
.\"----------
.TP
.B -b, --block-size
Set the maximal blocksize, dds2index can handle.
.TP
.TP
.B --z, --no-compress
Don't filter the archive file through gzip.
.TP
.BR -v , --verbose
verbose mode. Print to 
.IR stderr 
what is going on. 
.TP
.BR -h , --hash-mode
Print a hash sign '#' to 
.I stderr 
for each MB read from tape.
.TP
.BR -V , --version
Print the version number of
.B dds2index
to 
.I stderr 
and exit immediately.
.\"----------
.SH EXAMPLES
.\"----------
.RP
Example of getting the index from the default tape /dev/tape
and storing it in file archive.idx:
.IP
dds2index -v -t archive.idx
.\"----------
.SH WARNING
.\"----------
This program can only read records (tar is calling them tape blocks)
up to 32 kbytes. A bigger buffer will cause problems with the Linux
device driver.
.\"----------
.SH ENVIRONMENT
.\"----------
The environment variable
.B TAPE
overrides the default tape device /dev/tape.
.\"----------
.SH FILES
.\"----------
.TP 14
/dev/tape
default tape device file. Must be a character special file.
.\"----------
.SH "SEE ALSO"
.\"----------
dds2tar(1), mt(1), mt-dds(1), tar(1), gzip(1)

.\"----------
.SH HISTORY
.\"----------
This program was created as a tool for 
.BR dds2tar(1) .

.\"----------
.SH AUTHOR
.\"----------
J"org Weule (weule@cs.uni-duesseldorf.de), Phone +49 211 751409.
This software is available at
ftp.uni-duesseldorf.de:/pub/unix/apollo

