%define config_opts --prefix=%{_prefix} --sysconfdir=%{_sysconfdir} --mandir=%{_mandir} --libdir=%{_libdir} --bindir=%{_bindir} --includedir=%{_includedir} --datadir=%{_datadir} --enable-threads --disable-system-install --disable-more-warnings

Summary:   DJPlay Music Player
Name:      djplay
Version:   0.5.0
Release:   1
License:   GPL
Group:     Applications/Multimedia
Source0:   %{name}-%{version}.tar.gz
URL:       http://djplay.sourceforge.net/
BuildRoot: %{_tmppath}/%{name}-%{version}-root
Packager: Melanie Thielker <melanie@t-data.com>
Requires: qt >= 3.2.1
Requires: libmad >= 0.15.1
Requires: libvorbis >= 1.1.0
Requires: libogg >= 1.1.0
Requires: libsamplerate >= 0.1.2
Requires: jack-audio-connection-kit >= 0.101.1
Requires: audiofile >= 0.2.6
Requires: libusb >= 0.1.11
Requires: libdjconsole >= 0.1.0
Requires: cdparanoia >= alpha9.8-27.1
Requires: id3lib >= 3.8.3
Requires: swh-plugins >= 0.4.15
Requires: ladspa >= 1.12
Provides: djplay

BuildRequires:  qt-devel >= 3.2.1
BuildRequires:  libmad-devel >= 0.7.1
BuildRequires:  libvorbis-devel >= 0.7.1
BuildRequires:  libogg-devel >= 0.7.1
BuildRequires:  libsamplerate-devel >= 0.1.2
BuildRequires:  jack-audio-connection-kit-devel >= 0.101.1
BuildRequires:  audiofile-devel >= 0.2.6
BuildRequires:  libusb-devel >= 0.1.11
BuildRequires:  libdjconsole >= 0.1.0
BuildRequires:  cdparanoia-devel >= alpha9.8-27.1
BuildRequires:  id3lib-devel >= 3.8.3
BuildRequires:  ladspa-devel >= 1.12
BuildRequires:  glib-devel >= 1.2.10

%description
DJPlay is a live DJing application
 
%prep
%setup

%build
if [ ! -f configure ]; then
  CFLAGS="$RPM_OPT_FLAGS" ./autogen.sh
fi

CFLAGS="$RPM_OPT_FLAGS" ./configure $ARCHFLAG %{config_opts}


if [ "$SMP" != "" ]; then
  (make "MAKE=make -k -j $SMP"; exit 0)
  make
else
  make CFLAGS="$RPM_OPT_FLAGS"
fi

%install
rm -rf "$RPM_BUILD_ROOT"


make prefix=$RPM_BUILD_ROOT%{_prefix} \
    sysconfdir=$RPM_BUILD_ROOT%{_sysconfdir} \
    bindir=$RPM_BUILD_ROOT%{_bindir} \
    libdir=$RPM_BUILD_ROOT%{_libdir} \
    includedir=$RPM_BUILD_ROOT%{_includedir} \
    datadir=$RPM_BUILD_ROOT%{_datadir} \
    mandir=$RPM_BUILD_ROOT%{_mandir} \
    infodir=$RPM_BUILD_ROOT%{_infodir} install

%find_lang %{name}


%clean
rm -rf $RPM_BUILD_ROOT

%files -f %{name}.lang
%defattr(-, root, root)
%doc README COPYING ChangeLog
%{_bindir}/djplay
%{_datadir}/locale/*
%{_datadir}/djplay/*

