#ifndef _SOUNDTOUCHEFFECT_H_INCLUDED
#define _SOUNDTOUCHEFFECT_H_INCLUDED

#include "config.h"
#include "effect.h"

#ifdef HAVE_LIBSOUNDTOUCH

class SoundTouchEffect;

class SoundTouchEffectChannel : public EffectChannel
{
public:
	SoundTouchEffectChannel(SoundTouchEffect *e, unsigned long in_port, unsigned long out_port);
	SoundTouchEffectChannel(SoundTouchEffectChannel *c, SoundTouchEffect *e, unsigned long in_port, unsigned long out_port);
	virtual ~SoundTouchEffectChannel();

	virtual void setBuffer(float *buffer);
protected:
	virtual void process(unsigned long nsamples);

	friend class SoundTouchEffect;
};

class SoundTouchEffect : public Effect
{
public:
	SoundTouchEffect();
	virtual ~SoundTouchEffect();
	
	virtual unsigned long ports();
	virtual void setControl(unsigned long port, float data);
	virtual float control(unsigned long port);
	virtual void process(unsigned long nsamples);

	virtual SoundTouchEffectChannel *left();
	virtual SoundTouchEffectChannel *right();
protected:

	friend class SoundTouchEffectChannel;
};

#endif
#endif
