"""Expose names from the compiled cpp modules to the dolfin name space"""

#--- Imports the SWIG-generated Python code (C++ interface) ---
import dolfin.cpp as cpp
__swigversion__ = cpp.__swigversion__
__version__ = cpp.__dolfinversion__

# Optional packages checkers
# --------------------------
from cpp import (has_linear_algebra_backend, has_mpi, has_slepc, has_trilinos,
                 has_scotch, has_cgal, has_openmp, has_umfpack, has_cholmod,
                 has_parmetis, has_gmp, has_zlib)

# Classes and functions from dolfin/la
# ------------------------------------
from cpp import down_cast
from cpp import residual, normalize
from cpp import Matrix, Vector, Scalar, GenericMatrix, GenericVector
from cpp import LinearSolver, KrylovSolver, LUSolver, SingularSolver
from cpp import BlockMatrix, BlockVector
from cpp import DefaultFactory
from cpp import list_linear_solver_methods, list_lu_solver_methods
from cpp import list_krylov_solver_methods, list_krylov_solver_preconditioners
from cpp import linear_solver_methods, lu_solver_methods
from cpp import krylov_solver_methods, krylov_solver_preconditioners

# Optional package uBLAS
if has_linear_algebra_backend("uBLAS"):
    from cpp import uBLASVector, uBLASSparseMatrix, uBLASDenseMatrix
    from cpp import uBLASSparseFactory, uBLASDenseFactory
    from cpp import (uBLASSparseFactory_instance,
                     uBLASDenseFactory_instance)
    from cpp import uBLASKrylovMatrix, uBLASKrylovSolver

# Optional package petsc
if has_linear_algebra_backend("PETSc"):
    from cpp import (PETScMatrix, PETScVector, PETScFactory,
                     PETScFactory_instance)
    from cpp import PETScKrylovMatrix, PETScKrylovSolver, PETScPreconditioner
    from cpp import PETScLUSolver, PETScUserPreconditioner

# Optional package Epetra
if has_linear_algebra_backend("Epetra"):
    from cpp import (EpetraMatrix, EpetraVector, EpetraFactory,
                     EpetraFactory_instance)
    from cpp import EpetraKrylovSolver, TrilinosPreconditioner
    from cpp import EpetraLUSolver

# Optional package MTL4
if has_linear_algebra_backend("MTL4"):
    from cpp import (MTL4Matrix, MTL4Vector, MTL4Factory,
                     MTL4Factory_instance)

# Optional package slepc
if has_slepc():
    from cpp import SLEPcEigenSolver

# Classes from dolfin/io
# ----------------------
from cpp import File

# Classes from dolfin/quadrature
# ------------------------------
from cpp import GaussQuadrature, RadauQuadrature, LobattoQuadrature

# Classes from dolfin/mesh
# ------------------------
from cpp import Mesh, MeshEditor, BoundaryMesh, SubMesh
from cpp import MeshValueCollection
from cpp import MeshFunction, VertexFunction, EdgeFunction
from cpp import FaceFunction, FacetFunction, CellFunction
from cpp import MeshEntity, Vertex, Edge, Face, Facet, Cell, Point
from cpp import vertices, edges, faces, facets, cells, entities, SubsetIterator
from cpp import SubDomain, DomainBoundary
from cpp import (UnitInterval, Interval,
                 UnitTriangle, UnitSquare, Rectangle, UnitCircle,
                 UnitTetrahedron, UnitCube, Box, UnitSphere)

from cpp import IntersectionOperator
from cpp import PrimitiveIntersector_do_intersect as do_intersect
from cpp import PrimitiveIntersector_do_intersect_exact as do_intersect_exact

# Classes from dolfin/fem
# -----------------------
from cpp import Assembler
from cpp import SystemAssembler
from cpp import SubSpace
from cpp import PointSource

# Classes from dolfin/nls
# -----------------------
from cpp import NewtonSolver, NonlinearProblem

# Classes and free functions from dolfin/log
# ------------------------------------------
from cpp import Progress, Timer, Table, Event
from cpp import info, warning, error, log, begin, end, timing
from cpp import set_log_level, get_log_level, set_log_active
from cpp import not_working_in_parallel
from cpp import tic, toc, summary, list_timings

# Functions from dolfin/math
# --------------------------
from cpp import near, between

# Classes from dolfin/common
# --------------------------
from cpp import MPI

# Classes from dolfin/parameter
# -----------------------------
from cpp import Parameters

# Classes from dolfin/adaptivity
# ------------------------------
from cpp import TimeSeries
from cpp import adapt
