from re import compile, MULTILINE, IGNORECASE, sub

from dosage.helpers import BasicScraper, bounceStarter, indirectStarter


class SamAndFuzzy(BasicScraper):
    latestUrl = 'http://www.samandfuzzy.com/'
    imageUrl = 'http://www.samandfuzzy.com/archive.php?comicID=%s'
    imageSearch = compile(r'(/comics/.+?)" alt')
    prevSearch = compile(r'(/archive.php\?comicID=.+?)".+?nav_prev')
    help = 'Index format: n'


class SarahZero(BasicScraper):
    latestUrl = 'http://www.sarahzero.com/'
    imageUrl = 'http://www.sarahzero.com/sz_%s.html'
    imageSearch = compile(r'<img src="(z_(?:(?:spreads)|(?:temp)).+?)" alt=""')
    prevSearch = compile(r'href="(.+?)".+?sz_05_nav')
    help = 'Index format: nnnn'


class ScaryGoRound(BasicScraper):
    latestUrl = 'http://www.scarygoround.com/'
    imageUrl = 'http://www.scarygoround.com/?date=%s'
    imageSearch = compile(r'<img src="(strips/\d{8}\..{3})"')
    prevSearch = compile(r'<a href="(\?date=\d{8})" class=\'newmenus\'>Previous')
    help = 'Index format: n (unpadded)'


class SlightlyDamned(BasicScraper):
    latestUrl = 'http://raizap.com/sdamned/index.php'
    imageUrl = 'http://raizap.com/sdamned/pages.php\?comicID=%s'
    imageSearch = compile(r'"(.+?comics2/.+?)"')
    prevSearch = compile(r'</a>.+?(pages.php\?comicID=.+?)".+?back1')
    help = 'Index format: n (unpadded)'


class SluggyFreelance(BasicScraper):
    latestUrl = 'http://www.sluggy.com/'
    imageUrl = 'http://www.sluggy.com/daily.php?date=%s'
    imageSearch = compile(r'<img[^>]+src="((?:http://www\.sluggy\.com|\.\.)/images/comics/\d{6}.*?\..+?)"')
    prevSearch = compile(r'<a href="(http://www\.sluggy\.com/daily\.php\?date=\d{6})"><img border="." src="[^"]+" alt="Previous Comic">')
    help = 'Index format: yymmdd'


class Sokora(BasicScraper):
    latestUrl = 'http://www.sokora.com/'
    imageUrl = 'http://www.sokora.com/index.php?strip_id=%s'
    imageSearch = compile(r'<img.+?src="(istrip_files/strips/.+?)"')
    prevSearch = compile(r'<a href="(/?index\.php\?strip_id=\d+?)"[^>]+><img[^>]+src="images/back_off.jpg"')
    help = 'Index format: nnnn'


class SpareParts(BasicScraper):
    latestUrl = 'http://www.sparepartscomics.com/'
    imageUrl = 'http://www.sparepartscomics.com/comics/\\?date=s%'
    imageSearch = compile(r'(/comics/2.+?)[" ]')
    prevSearch = compile(r'(/comics/.+?|index.php\?.+?)".+?Prev')
    help = 'Index format: yyyymmdd'


class Spoonies(BasicScraper):
    latestUrl = 'http://www.spoonies.net/main.htm'
    imageUrl = 'http://www.spoonies.net/d/%s.htm'
    imageSearch = compile(r'<img border="0" src="(.*?comics/\d{4}/\d{4}%20\d{3}\..+?)"')
    prevSearch = compile(r'<a href="(.*?\d{6}\.htm)">')
    help = 'Index format: yyyy/mmddyy'


class Sternstaub(BasicScraper):
    latestUrl = 'http://www.sternstaub.com/'
    imageUrl = 'http://www.sternstaub.com/?page=archive&comicid=%s'
    imageSearch = compile(r'<img src="(comics/.+?)" /><br />')
    prevSearch = compile(r'<a href="(\?page=archive&comicid=\d{10})">Previous')
    help = 'Index format: yyyymmddnn'


class Stubble(BasicScraper):
    latestUrl = 'http://www.stubblecomics.com/'
    imageUrl = 'http://www.stubblecomics.com/d/%s.html'
    imageSearch = compile(r'"(/comics/.*?)"')
    prevSearch = compile(r'"(.*?)".*?backarrow')
    help = 'Index format: yyyymmdd'


class SuburbanTribe(BasicScraper):
    latestUrl = 'http://www.suburbantribe.net/'
    imageUrl = 'http://www.suburbantribe.net/showArchive.asp?archive=%s'
    imageSearch = compile(r'<img src="(strips/\d+?.+?)"')
    prevSearch = compile(r'<a href="(showArchive\.asp\?archive=\d+?)"><img src="images/PreviousStrip.gif"')
    help = 'Index format: yyyymmdd'


class SuccubusJustice(BasicScraper):
    latestUrl = 'http://www.succubus-justice.com/Com%20main%20frame.htm'
    imageUrl = 'http://www.succubus-justice.com/%s%%20frame.htm'
    imageSearch = compile(r'<p align="center"><img src="((?:reworked%20gifs/)?[\w%]+\.\w+)"')
    prevSearch = compile(r'<a href="([\w%]+\.htm)"[^>]*><img src="124.gif"')
    help = 'Index format: nnn'


class Supafine(BasicScraper):
    latestUrl = 'http://www.supafine.com/comics/view.shtml'
    imageUrl = 'http://www.supafine.com/comics/news-archive-%s.shtml'
    imageSearch = compile(r'<img src="(http://www\.supafine\.com/comics/\w+?\..+?)"></td>')
    prevSearch = compile(r'<a href="(http://www\.supafine\.com/comics/news-archive-\d+-\d+-\d+\.shtml)">Previous Strip</a>')
    help = 'Index format: dd-mm-yyyy'


class SomethingPositive(BasicScraper):
    starter = bounceStarter('http://www.somethingpositive.net/', compile(r'<a\s*\n?\s*href="(sp\d{8}\.shtml)">Next<br>Comic', MULTILINE | IGNORECASE))
    imageUrl = 'http://www.somethingpositive.net/sp%s.shtml'
    imageSearch = compile(r'<img src="(/?arch/.+\..+?)"')
    prevSearch = compile(r'<a \n?href="(sp\d{8}\.shtml)">(?:<font size=1\nface=".+?"\nSTYLE=".+?">)?(?:Previous|<img src="images2/previous)', MULTILINE | IGNORECASE)
    help = 'Index format: mmddyyyy'

    def namer(cls, imageUrl, pageUrl):
        return pageUrl.split('/')[-1].split('.')[0]


class SexyLosers(BasicScraper):
    imageUrl = 'http://www.sexylosers.com/%s.html'
    imageSearch = compile(r'<img src\s*=\s*"\s*(comics/[\w\.]+?)"', IGNORECASE)
    prevSearch = compile(r'<a href="(/\d{3}\.\w+?)"><font color = FFAAAA><<', IGNORECASE)
    help = 'Index format: nnn'
    starter = indirectStarter('http://www.sexylosers.com/',
                              compile(r'latest comic</b>: <a href = "(/[\w\.]+?)">', IGNORECASE))

    def namer(cls, imageUrl, pageUrl):
        index = pageUrl.split('/')[-1].split('.')[0]
        title = imageUrl.split('/')[-1].split('.')[0]
        return index + '-' + title



def smackJeeves(names):
    class SJScraper(BasicScraper):
        imageUrl = property(lambda self: self.baseUrl + self.shortName)
        imageSearch = compile(r'<img src="(http://www\.smackjeeves\.com/images/uploaded/comics/[^"]*)"', IGNORECASE)
        prevSearch = compile(r'<a href="(/comics/\d+/[^"]*)"><img[^>]*alt="< Previous"', IGNORECASE)
        help = 'Index format: nnnn (some increasing number)'

        def namer(cls, imageUrl, pageUrl):
            return pageUrl.split('/')[-2]


    def makeScraper(shortName):
        baseUrl = 'http://%s.smackjeeves.com/comics/' % shortName
        return SJScraper.make('SmackJeeves/' + shortName,
                              baseUrl=baseUrl,
                              starter=bounceStarter(baseUrl, compile(r'<a href="(/comics/\d+/[^"]*)"><img[^>]*alt="Next >"', IGNORECASE)))

    return dict((name, makeScraper(name)) for name in names)


globals().update(smackJeeves([
    '20galaxies',
    'axe13',
    'beartholomew',
    'bliss',
    'durian',
    'mpmcomic',
    'nlmo-project',
    'paranoidloyd',
    'thatdreamagain',
    'wowcomics',
    ]))


class StarCrossdDestiny(BasicScraper):
    latestUrl = 'http://starcrossd.net/'
    imageUrl = 'http://www.starcrossd.net/archives/%s.html'
    imageSearch = compile(r'<img src="((?:http://(?:www\.)?starcrossd\.net/(?:ch1/)?strips/\d+\.[^"]+)|(?:http://(?:www\.)?juno\.gewdguys\.com/\w+/\d+\.[^"]+))"[^>]*>')
    prevSearch = compile(r'<a href="(http://www\.starcrossd\.net/(?:ch1/)?archives/\d+\.html)"[^>]*"[^"]*"[^>]*><img src="http://starcrossd.net/parts/comic_prev.gif" border="0">', IGNORECASE)
    help = 'Index format: nnnnnnnn'

    def namer(cls, imageUrl, pageUrl):
        if imageUrl.find('ch1') == -1:
            # At first all images were stored in a strips/ directory but that was changed with the introduction of book2
            imageUrl = sub('(?:strips)|(?:images)','book1',imageUrl)
        elif not imageUrl.find('strips') == -1:
            imageUrl = imageUrl.replace('strips/','')
        directory, filename = imageUrl.split('/')[-2:]
        filename, extension = os.path.splitext(filename)
        return directory + '-' + filename


class SGVY(BasicScraper):
    imageUrl = 'http://www.sgvy.com/Edda%s/Issue%s/Page%s.html'
    imageSearch = compile(r'"comic" src="((?:\.\./)+images/sgvy/sgvy-[-\w\d]+\.\w+)"')
    prevSearch = compile(r'<a href="((?:\.\./)+(?:Edda\d+|Holiday)/(?:Issue\d+/Page\d+|Cover)\.html)">Prev</a>')
    help = 'Index format: edda-issue-page'

    starter = indirectStarter('http://www.sgvy.com/', compile(r'<a href="(archives/(?:Edda\d+|Holiday)/(?:Issue\d+/Page\d+|Cover)\.html)">'))

    def setStrip(self, index):
        self.currentUrl = self.imageUrl % tuple(map(int, index.split('-')))


class Spamusement(BasicScraper):
    imageUrl = 'http://spamusement.com/index.php/comics/view/%s'
    imageSearch = compile(r'<img src="(http://spamusement.com/gfx/\d+\..+?)"', IGNORECASE)
    prevSearch = compile(r'<a href="(http://spamusement.com/index.php/comics/view/.+?)">', IGNORECASE)
    help = 'Index format: n (unpadded)'

    starter = indirectStarter('http://spamusement.com/', prevSearch)


def snafuComics():
    class SnafuComics(BasicScraper):
        imageSearch = compile(r'"(comics/.*?)"')
        prevSearch = compile(r'<a href="(\?strip_id=.*?)".+?[^>].+PREVIOUS')
        help = 'Index format: n (unpadded)'

        @property
        def imageUrl(self):
            return self.latestUrl + 'index.php?strip_id=%s'

    comics = {
        'Grim': 'http://grim.snafu-comics.com/',
        'KOF': 'http://kof.snafu-comics.com/',
        'PowerPuffGirls': 'http://ppg.snafu-comics.com/',
        'Snafu': 'http://www.snafu-comics.com/',
        'Tin': 'http://tin.snafu-comics.com/',
        'TW': 'http://tw.snafu-comics.com/',
        }

    return dict((name, SnafuComics.make('SnafuComics/' + name, latestUrl=latestUrl)) for name, latestUrl in comics.iteritems())

globals().update(snafuComics())


class SosiaalisestiRajoittuneet(BasicScraper):
    latestUrl = 'http://sosiaalisestirajoittuneet.fi/index_nocomment.php'
    imageUrl = 'http://sosiaalisestirajoittuneet.fi/index_nocomment.php?date=%s'
    imageSearch = compile(r'<img src="(strips/web/\d+.jpg)" alt=".*?"   />')
    prevSearch = compile(r'<a href="(index_nocomment\.php\?date=\d+)"><img\s+src="images/active_edellinen\.gif"', MULTILINE)
