#@ MODIF N_MACRO Noyau  DATE 07/09/2009   AUTEUR COURTOIS M.COURTOIS 
# -*- coding: iso-8859-1 -*-
# RESPONSABLE COURTOIS M.COURTOIS
#            CONFIGURATION MANAGEMENT OF EDF VERSION
# ======================================================================
# COPYRIGHT (C) 1991 - 2002  EDF R&D                  WWW.CODE-ASTER.ORG
# THIS PROGRAM IS FREE SOFTWARE; YOU CAN REDISTRIBUTE IT AND/OR MODIFY
# IT UNDER THE TERMS OF THE GNU GENERAL PUBLIC LICENSE AS PUBLISHED BY
# THE FREE SOFTWARE FOUNDATION; EITHER VERSION 2 OF THE LICENSE, OR   
# (AT YOUR OPTION) ANY LATER VERSION.                                 
#
# THIS PROGRAM IS DISTRIBUTED IN THE HOPE THAT IT WILL BE USEFUL, BUT 
# WITHOUT ANY WARRANTY; WITHOUT EVEN THE IMPLIED WARRANTY OF          
# MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE. SEE THE GNU    
# GENERAL PUBLIC LICENSE FOR MORE DETAILS.                            
#
# YOU SHOULD HAVE RECEIVED A COPY OF THE GNU GENERAL PUBLIC LICENSE   
# ALONG WITH THIS PROGRAM; IF NOT, WRITE TO EDF R&D CODE_ASTER,       
#    1 AVENUE DU GENERAL DE GAULLE, 92141 CLAMART CEDEX, FRANCE.      
#                                                                       
#                                                                       
# ======================================================================


""" 
    Ce module contient la classe de definition MACRO
    qui permet de spcifier les caractristiques d'une macro-commande
"""

import types,string,traceback

import N_ENTITE
import N_MACRO_ETAPE
import nommage

class MACRO(N_ENTITE.ENTITE):
   """
    Classe pour definir une macro-commande

    Cette classe a trois attributs de classe 

    - class_instance qui indique la classe qui devra etre utilise 
            pour crer l'objet qui servira  controler la conformit d'un 
            macro-commande avec sa dfinition

    - label qui indique la nature de l'objet de dfinition (ici, MACRO)

    - nommage qui est un module Python qui fournit la fonctionnalit de nommage

    et les attributs d'instance suivants :

    - nom   : son nom

    - op   : le numro d'oprateur

    - sd_prod : le type de concept produit. C'est une classe ou une fonction qui retourne
                      une classe

    - reentrant : vaut 'n' ou 'o'. Indique si l'oprateur est rentrant ou pas. Un oprateur
                        rentrant peut modifier un concept d'entre et le produire comme concept de sortie

    - repetable : vaut 'n' ou 'o'. Indique si l'oprateur est rpetable ou pas. Un oprateur
                        non rptable ne doit apparaitre qu'une fois dans une excution. C'est du ressort
                        de l'objet grant le contexte d'excution de vrifier cette contrainte.

    - fr   : commentaire associ en francais

    - ang : commentaire associ en anglais

    - docu : cl de documentation associe

    - regles : liste des rgles associes

    - op_init : cet attribut vaut None ou une fonction. Si cet attribut ne vaut pas None, cette
                      fonction est excute lors des phases d'initialisation de l'tape associe.

    - niveau : indique le niveau dans lequel est rang l'oprateur. Les oprateurs peuvent etre
                     rangs par niveau. Ils apparaissent alors exclusivement dans leur niveau de rangement.
                     Si niveau vaut None, l'oprateur est rang au niveau global.

    - entites : dictionnaire dans lequel sont stocks les sous entits de l'oprateur. Il s'agit
                      des entits de dfinition pour les mots-cls : FACT, BLOC, SIMP. Cet attribut
                      est initialis avec args, c'est  dire les arguments d'appel restants.


   """
   class_instance = N_MACRO_ETAPE.MACRO_ETAPE
   label = 'MACRO'
   nommage = nommage

   def __init__(self,nom,op,sd_prod=None,reentrant='n',repetable='o',fr="",ang="",
                docu="",regles=(),op_init=None,niveau = None,fichier_ini=0,UIinfo=None,**args):
      """
         Mthode d'initialisation de l'objet MACRO. Les arguments sont utiliss pour initialiser
         les attributs de meme nom
      """
      # XXX fichier_ini n'est pas utilis pour l'instant
      self.nom=nom
      # op est obligatoire et permet de spcifier la procdure de construction de la macro
      # - Si op est un entier la construction de la macro est ralise par une subroutine fortran opsxxx ou
      # xxx est donn par la valeur absolue de op. L'execution est egalement effectue via cette subroutine.
      # - Si op est une fonction Python, la construction de la macro est effectue par l'appel  cette fonction
      # Suivant le cas on garde l info dans self.op ou dans self.proc
      if type(op) == types.IntType:
        self.proc=None
        self.op=op
      else:
        self.op=None
        self.proc=op

      self.sd_prod=sd_prod
      self.reentrant=reentrant
      self.fr=fr
      self.ang=ang
      self.repetable = repetable
      self.docu=docu
      if type(regles)== types.TupleType:
          self.regles=regles
      else:
          self.regles=(regles,)
      self.fichier_ini = fichier_ini
      # Attribut op_init : Fonction a appeler a la construction de l operateur sauf si == None
      self.op_init=op_init
      self.entites=args
      current_cata=CONTEXT.get_current_cata()
      if niveau == None:
         self.niveau=None
         current_cata.enregistre(self)
      else:
         self.niveau=current_cata.get_niveau(niveau)
         self.niveau.enregistre(self)
      self.UIinfo=UIinfo
      self.affecter_parente()

   def __call__(self,reuse=None,**args):
      """
          Construit l'objet MACRO_ETAPE a partir de sa definition (self),
          puis demande la construction de ses sous-objets et du concept produit.
      """
      # Glut MC (2007-05) / Sensibilit
      # Prcaution ncessaire pour la sensibilit (on fait 'exec' du texte d'une commande)
      # car on n'a pas de "ligne"  dcoder pour trouver le nom du rsultat ( gauche
      # du signe gal). C tombe bien, dans ce cas, sd_prod=None : pas de rsultat !
      if self.sd_prod != None:
         nomsd=self.nommage.GetNomConceptResultat(self.nom)
      else:
         nomsd = None
      etape= self.class_instance(oper=self,reuse=reuse,args=args)
      etape.McBuild()
      return etape.Build_sd(nomsd)

   def make_objet(self,mc_list='oui'):
      """
           Cette mthode cre l'objet MACRO_ETAPE dont la dfinition est self sans
           crer sa sdprod.
           Normalement l'tape est enregistre auprs de son parent.
           Si l'argument mc_list vaut 'oui', elle dclenche en plus la construction
           des objets MCxxx.
      """
      etape= self.class_instance(oper=self,reuse=None,args={})
      if mc_list == 'oui':etape.McBuild()
      return etape

   def verif_cata(self):
      """
          Mthode de vrification des attributs de dfinition
      """
      if self.op is not None and (type(self.op) != types.IntType or self.op > 0) :
        self.cr.fatal("L'attribut 'op' doit etre un entier sign : %s" %`self.op`)
      if self.proc is not None and type(self.proc) != types.FunctionType:
        self.cr.fatal("L'attribut op doit etre une fonction Python : %s" % `self.proc`)
      if type(self.regles) != types.TupleType :
        self.cr.fatal("L'attribut 'regles' doit etre un tuple : %s" %`self.regles`)
      if type(self.fr) != types.StringType :
        self.cr.fatal("L'attribut 'fr' doit etre une chaine de caractres : %s" %`self.fr`)
      if type(self.docu) != types.StringType :
        self.cr.fatal("L'attribut 'docu' doit etre une chaine de caractres : %s" %`self.docu` )
      if type(self.nom) != types.StringType :
        self.cr.fatal("L'attribut 'nom' doit etre une chaine de caractres : %s" %`self.nom`)
      if self.reentrant not in ('o','n','f'):
        self.cr.fatal("L'attribut 'reentrant' doit valoir 'o','n' ou 'f' : %s" %`self.reentrant`)
      self.verif_cata_regles()

   def supprime(self):
      """
          Mthode pour supprimer les rfrences arrires susceptibles de provoquer
          des cycles de rfrences
      """
      self.niveau=None


