/* gdu.vapi generated by vapigen, do not modify. */

[CCode (cprefix = "Gdu", lower_case_cprefix = "gdu_")]
namespace Gdu {
	[CCode (cheader_filename = "gdu/gdu.h")]
	public class Device : GLib.Object {
		public void* drive_ata_smart_get_blob (size_t out_size);
		public bool drive_ata_smart_get_is_available ();
		public unowned string drive_ata_smart_get_status ();
		public uint64 drive_ata_smart_get_time_collected ();
		public void drive_ata_smart_refresh_data (Gdu.DeviceDriveAtaSmartRefreshDataCompletedFunc callback);
		public bool drive_get_can_detach ();
		public bool drive_get_can_spindown ();
		public unowned string drive_get_connection_interface ();
		public uint64 drive_get_connection_speed ();
		public bool drive_get_is_media_ejectable ();
		public bool drive_get_is_rotational ();
		public unowned string drive_get_media ();
		public unowned string drive_get_media_compatibility ();
		public unowned string drive_get_model ();
		public bool drive_get_requires_eject ();
		public unowned string drive_get_revision ();
		public unowned string drive_get_serial ();
		public unowned string drive_get_vendor ();
		public void filesystem_list_open_files (Gdu.DeviceFilesystemListOpenFilesCompletedFunc callback);
		public unowned GLib.List filesystem_list_open_files_sync () throws GLib.Error;
		public unowned Gdu.Device find_parent ();
		public uint64 get_block_size ();
		public uint64 get_detection_time ();
		public Posix.dev_t get_dev ();
		public unowned string get_device_file ();
		public uint64 get_media_detection_time ();
		public unowned string get_mount_path ();
		public unowned string get_mount_paths ();
		public Posix.uid_t get_mounted_by_uid ();
		public unowned string get_object_path ();
		public unowned Gdu.Pool get_pool ();
		public bool get_presentation_hide ();
		public unowned string get_presentation_icon_name ();
		public unowned string get_presentation_name ();
		public bool get_presentation_nopolicy ();
		public uint64 get_size ();
		public unowned string id_get_label ();
		public unowned string id_get_type ();
		public unowned string id_get_usage ();
		public unowned string id_get_uuid ();
		public unowned string id_get_version ();
		public bool is_drive ();
		public bool is_linux_md ();
		public bool is_linux_md_component ();
		public bool is_luks ();
		public bool is_luks_cleartext ();
		public bool is_media_available ();
		public bool is_media_change_detected ();
		public bool is_media_change_detection_inhibitable ();
		public bool is_media_change_detection_inhibited ();
		public bool is_media_change_detection_polling ();
		public bool is_mounted ();
		public bool is_optical_disc ();
		public bool is_partition ();
		public bool is_partition_table ();
		public bool is_read_only ();
		public bool is_removable ();
		public bool is_system_internal ();
		public unowned string job_get_id ();
		public Posix.uid_t job_get_initiated_by_uid ();
		public double job_get_percentage ();
		public bool job_in_progress ();
		public bool job_is_cancellable ();
		public unowned string linux_md_component_get_holder ();
		public unowned string linux_md_component_get_home_host ();
		public unowned string linux_md_component_get_level ();
		public unowned string linux_md_component_get_name ();
		public int linux_md_component_get_num_raid_devices ();
		public unowned string linux_md_component_get_state ();
		public unowned string linux_md_component_get_uuid ();
		public unowned string linux_md_component_get_version ();
		public unowned string linux_md_get_home_host ();
		public unowned string linux_md_get_level ();
		public unowned string linux_md_get_name ();
		public int linux_md_get_num_raid_devices ();
		public unowned string linux_md_get_slaves ();
		public unowned string linux_md_get_state ();
		public unowned string linux_md_get_sync_action ();
		public double linux_md_get_sync_percentage ();
		public uint64 linux_md_get_sync_speed ();
		public unowned string linux_md_get_uuid ();
		public unowned string linux_md_get_version ();
		public bool linux_md_is_degraded ();
		public unowned string luks_cleartext_get_slave ();
		public Posix.uid_t luks_cleartext_unlocked_by_uid ();
		public unowned string luks_get_holder ();
		public void op_cancel_job (Gdu.DeviceCancelJobCompletedFunc callback);
		public void op_drive_ata_smart_initiate_selftest (string test, Gdu.DeviceDriveAtaSmartInitiateSelftestCompletedFunc callback);
		public void op_drive_detach (Gdu.DeviceDriveDetachCompletedFunc callback);
		public void op_drive_eject (Gdu.DeviceDriveEjectCompletedFunc callback);
		public void op_drive_poll_media (Gdu.DeviceDrivePollMediaCompletedFunc callback);
		public void op_filesystem_check (Gdu.DeviceFilesystemCheckCompletedFunc callback);
		public void op_filesystem_create (string fstype, string fslabel, string encrypt_passphrase, bool fs_take_ownership, Gdu.DeviceFilesystemCreateCompletedFunc callback);
		public void op_filesystem_mount (string options, Gdu.DeviceFilesystemMountCompletedFunc callback);
		public void op_filesystem_set_label (string new_label, Gdu.DeviceFilesystemSetLabelCompletedFunc callback);
		public void op_filesystem_unmount (Gdu.DeviceFilesystemUnmountCompletedFunc callback);
		public void op_linux_md_add_component (string component_objpath, Gdu.DeviceLinuxMdAddComponentCompletedFunc callback);
		public void op_linux_md_check (string options, Gdu.DeviceLinuxMdCheckCompletedFunc callback);
		public void op_linux_md_remove_component (string component_objpath, Gdu.DeviceLinuxMdRemoveComponentCompletedFunc callback);
		public void op_linux_md_stop (Gdu.DeviceLinuxMdStopCompletedFunc callback);
		public void op_luks_change_passphrase (string old_secret, string new_secret, Gdu.DeviceLuksChangePassphraseCompletedFunc callback);
		public void op_luks_lock (Gdu.DeviceLuksLockCompletedFunc callback);
		public void op_luks_unlock (string secret, Gdu.DeviceLuksUnlockCompletedFunc callback);
		public void op_partition_create (uint64 offset, uint64 size, string type, string label, out unowned string flags, string fstype, string fslabel, string encrypt_passphrase, bool fs_take_ownership, Gdu.DevicePartitionCreateCompletedFunc callback);
		public void op_partition_delete (Gdu.DevicePartitionDeleteCompletedFunc callback);
		public void op_partition_modify (string type, string label, out unowned string flags, Gdu.DevicePartitionModifyCompletedFunc callback);
		public void op_partition_table_create (string scheme, Gdu.DevicePartitionTableCreateCompletedFunc callback);
		public bool optical_disc_get_is_appendable ();
		public bool optical_disc_get_is_blank ();
		public bool optical_disc_get_is_closed ();
		public uint optical_disc_get_num_audio_tracks ();
		public uint optical_disc_get_num_sessions ();
		public uint optical_disc_get_num_tracks ();
		public unowned string partition_get_flags ();
		public unowned string partition_get_label ();
		public int partition_get_number ();
		public uint64 partition_get_offset ();
		public unowned string partition_get_scheme ();
		public uint64 partition_get_size ();
		public unowned string partition_get_slave ();
		public unowned string partition_get_type ();
		public unowned string partition_get_uuid ();
		public int partition_table_get_count ();
		public unowned string partition_table_get_scheme ();
		public virtual signal void changed ();
		public virtual signal void job_changed ();
		public virtual signal void removed ();
	}
	[CCode (cheader_filename = "gdu/gdu.h")]
	public class Drive : GLib.Object, Gdu.Presentable {
		public virtual void activate (Gdu.DriveActivateFunc callback);
		public virtual bool can_activate (bool out_degraded);
		public virtual bool can_deactivate ();
		public virtual void deactivate (Gdu.DriveDeactivateFunc callback);
		public virtual bool has_unallocated_space (bool out_whole_disk_is_unitialized, uint64 out_largest_segment, out unowned Gdu.Presentable out_presentable);
		public virtual bool is_activatable ();
		public virtual bool is_active ();
	}
	[CCode (cheader_filename = "gdu/gdu.h")]
	public class KnownFilesystem : GLib.Object {
		public bool get_can_create ();
		public bool get_can_mount ();
		public unowned string get_id ();
		public uint get_max_label_len ();
		public unowned string get_name ();
		public bool get_supports_fsck ();
		public bool get_supports_label_rename ();
		public bool get_supports_online_fsck ();
		public bool get_supports_online_label_rename ();
		public bool get_supports_online_resize_enlarge ();
		public bool get_supports_online_resize_shrink ();
		public bool get_supports_resize_enlarge ();
		public bool get_supports_resize_shrink ();
		public bool get_supports_unix_owners ();
	}
	[CCode (cheader_filename = "gdu/gdu.h")]
	public class LinuxMdDrive : Gdu.Drive, Gdu.Presentable {
		public Gdu.LinuxMdDriveSlaveFlags get_slave_flags (Gdu.Device slave);
		public unowned GLib.List get_slaves ();
		public unowned string get_uuid ();
		public bool has_slave (Gdu.Device device);
	}
	[CCode (cheader_filename = "gdu/gdu.h")]
	public class Pool : GLib.Object {
		[CCode (has_construct_function = false)]
		public Pool ();
		public unowned Gdu.Device get_by_device_file (string device_file);
		public unowned Gdu.Device get_by_object_path (string object_path);
		public unowned string get_daemon_version ();
		public unowned GLib.List get_devices ();
		public unowned Gdu.Presentable get_drive_by_device (Gdu.Device device);
		public unowned GLib.List get_enclosed_presentables (Gdu.Presentable presentable);
		public unowned Gdu.KnownFilesystem get_known_filesystem_by_id (string id);
		public unowned GLib.List get_known_filesystems ();
		public unowned Gdu.Presentable get_presentable_by_id (string id);
		public unowned GLib.List get_presentables ();
		public unowned Gdu.Presentable get_volume_by_device (Gdu.Device device);
		public bool is_daemon_inhibited ();
		public void op_linux_md_create (GLib.PtrArray component_objpaths, string level, uint64 stripe_size, string name, Gdu.PoolLinuxMdCreateCompletedFunc callback);
		public void op_linux_md_start (GLib.PtrArray component_objpaths, Gdu.PoolLinuxMdStartCompletedFunc callback);
		public bool supports_luks_devices ();
		public virtual signal void device_added (Gdu.Device device);
		public virtual signal void device_changed (Gdu.Device device);
		public virtual signal void device_job_changed (Gdu.Device device);
		public virtual signal void device_removed (Gdu.Device device);
		public virtual signal void presentable_added (Gdu.Presentable presentable);
		public virtual signal void presentable_changed (Gdu.Presentable presentable);
		public virtual signal void presentable_job_changed (Gdu.Presentable presentable);
		public virtual signal void presentable_removed (Gdu.Presentable presentable);
	}
	[CCode (cheader_filename = "gdu/gdu.h")]
	public class Process : GLib.Object {
		public unowned GLib.AppInfo get_app_info ();
		public unowned string get_command_line ();
		public int get_id ();
		public Posix.uid_t get_owner ();
	}
	[CCode (cheader_filename = "gdu/gdu.h")]
	public class Volume : GLib.Object, Gdu.Presentable {
	}
	[CCode (cheader_filename = "gdu/gdu.h")]
	public class VolumeHole : GLib.Object, Gdu.Presentable {
	}
	[CCode (cheader_filename = "gdu/gdu.h")]
	public interface Presentable : GLib.Object {
		public int compare (Gdu.Presentable b);
		public bool equals (Gdu.Presentable b);
		public abstract unowned string get_description ();
		public abstract unowned Gdu.Device get_device ();
		public abstract unowned Gdu.Presentable get_enclosing_presentable ();
		public abstract unowned GLib.Icon get_icon ();
		public abstract unowned string get_id ();
		public abstract unowned string get_name ();
		public abstract uint64 get_offset ();
		public abstract unowned Gdu.Pool get_pool ();
		public abstract uint64 get_size ();
		public unowned Gdu.Presentable get_toplevel ();
		public abstract unowned string get_vpd_name ();
		public uint hash ();
		public abstract bool is_allocated ();
		public abstract bool is_recognized ();
		public signal void changed ();
		public signal void job_changed ();
		public signal void removed ();
	}
	[CCode (cprefix = "GDU_ERROR_", has_type_id = "0", cheader_filename = "gdu/gdu.h")]
	public enum Error {
		FAILED,
		BUSY,
		CANCELLED,
		INHIBITED,
		INVALID_OPTION,
		NOT_SUPPORTED,
		ATA_SMART_WOULD_WAKEUP,
		PERMISSION_DENIED
	}
	[CCode (cprefix = "GDU_LINUX_MD_DRIVE_SLAVE_FLAGS_", has_type_id = "0", cheader_filename = "gdu/gdu.h")]
	public enum LinuxMdDriveSlaveFlags {
		NONE,
		NOT_ATTACHED,
		FAULTY,
		IN_SYNC,
		WRITEMOSTLY,
		BLOCKED,
		SPARE
	}
	[CCode (cheader_filename = "gdu/gdu.h")]
	public delegate void DeviceCancelJobCompletedFunc (Gdu.Device device, GLib.Error error);
	[CCode (cheader_filename = "gdu/gdu.h")]
	public delegate void DeviceDriveAtaSmartInitiateSelftestCompletedFunc (Gdu.Device device, GLib.Error error);
	[CCode (cheader_filename = "gdu/gdu.h")]
	public delegate void DeviceDriveAtaSmartRefreshDataCompletedFunc (Gdu.Device device, GLib.Error error);
	[CCode (cheader_filename = "gdu/gdu.h")]
	public delegate void DeviceDriveDetachCompletedFunc (Gdu.Device device, GLib.Error error);
	[CCode (cheader_filename = "gdu/gdu.h")]
	public delegate void DeviceDriveEjectCompletedFunc (Gdu.Device device, GLib.Error error);
	[CCode (cheader_filename = "gdu/gdu.h")]
	public delegate void DeviceDrivePollMediaCompletedFunc (Gdu.Device device, GLib.Error error);
	[CCode (cheader_filename = "gdu/gdu.h")]
	public delegate void DeviceFilesystemCheckCompletedFunc (Gdu.Device device, bool is_clean, GLib.Error error);
	[CCode (cheader_filename = "gdu/gdu.h")]
	public delegate void DeviceFilesystemCreateCompletedFunc (Gdu.Device device, GLib.Error error);
	[CCode (cheader_filename = "gdu/gdu.h")]
	public delegate void DeviceFilesystemListOpenFilesCompletedFunc (Gdu.Device device, GLib.List processes, GLib.Error error);
	[CCode (cheader_filename = "gdu/gdu.h")]
	public delegate void DeviceFilesystemMountCompletedFunc (Gdu.Device device, string mount_point, GLib.Error error);
	[CCode (cheader_filename = "gdu/gdu.h")]
	public delegate void DeviceFilesystemSetLabelCompletedFunc (Gdu.Device device, GLib.Error error);
	[CCode (cheader_filename = "gdu/gdu.h")]
	public delegate void DeviceFilesystemUnmountCompletedFunc (Gdu.Device device, GLib.Error error);
	[CCode (cheader_filename = "gdu/gdu.h")]
	public delegate void DeviceLinuxMdAddComponentCompletedFunc (Gdu.Device device, GLib.Error error);
	[CCode (cheader_filename = "gdu/gdu.h")]
	public delegate void DeviceLinuxMdCheckCompletedFunc (Gdu.Device device, uint num_errors, GLib.Error error);
	[CCode (cheader_filename = "gdu/gdu.h")]
	public delegate void DeviceLinuxMdRemoveComponentCompletedFunc (Gdu.Device device, GLib.Error error);
	[CCode (cheader_filename = "gdu/gdu.h")]
	public delegate void DeviceLinuxMdStopCompletedFunc (Gdu.Device device, GLib.Error error);
	[CCode (cheader_filename = "gdu/gdu.h")]
	public delegate void DeviceLuksChangePassphraseCompletedFunc (Gdu.Device device, GLib.Error error);
	[CCode (cheader_filename = "gdu/gdu.h")]
	public delegate void DeviceLuksLockCompletedFunc (Gdu.Device device, GLib.Error error);
	[CCode (cheader_filename = "gdu/gdu.h")]
	public delegate void DeviceLuksUnlockCompletedFunc (Gdu.Device device, string object_path_of_cleartext_device, GLib.Error error);
	[CCode (cheader_filename = "gdu/gdu.h")]
	public delegate void DevicePartitionCreateCompletedFunc (Gdu.Device device, string created_device_object_path, GLib.Error error);
	[CCode (cheader_filename = "gdu/gdu.h")]
	public delegate void DevicePartitionDeleteCompletedFunc (Gdu.Device device, GLib.Error error);
	[CCode (cheader_filename = "gdu/gdu.h")]
	public delegate void DevicePartitionModifyCompletedFunc (Gdu.Device device, GLib.Error error);
	[CCode (cheader_filename = "gdu/gdu.h")]
	public delegate void DevicePartitionTableCreateCompletedFunc (Gdu.Device device, GLib.Error error);
	[CCode (cheader_filename = "gdu/gdu.h")]
	public delegate void DriveActivateFunc (Gdu.Drive drive, string assembled_drive_object_path, GLib.Error error);
	[CCode (cheader_filename = "gdu/gdu.h")]
	public delegate void DriveDeactivateFunc (Gdu.Drive drive, GLib.Error error);
	[CCode (cheader_filename = "gdu/gdu.h")]
	public delegate void PoolLinuxMdCreateCompletedFunc (Gdu.Pool pool, string array_object_path, GLib.Error error);
	[CCode (cheader_filename = "gdu/gdu.h")]
	public delegate void PoolLinuxMdStartCompletedFunc (Gdu.Pool pool, string assembled_array_object_path, GLib.Error error);
	[CCode (cheader_filename = "gdu/gdu.h")]
	public delegate void UtilPartTypeForeachFunc (string scheme, string type, string name);
	[CCode (cheader_filename = "gdu/gdu.h")]
	public static GLib.Quark error_quark ();
	[CCode (cheader_filename = "gdu/gdu.h")]
	public static unowned string get_job_description (string job_id);
	[CCode (cheader_filename = "gdu/gdu.h")]
	public static unowned string linux_md_get_raid_level_description (string linux_md_raid_level);
	[CCode (cheader_filename = "gdu/gdu.h")]
	public static unowned string linux_md_get_raid_level_for_display (string linux_md_raid_level, bool long_string);
	[CCode (cheader_filename = "gdu/gdu.h")]
	public static unowned string util_ata_smart_status_to_desc (string status, bool out_highlight, string out_action_text, out unowned GLib.Icon out_icon);
	[CCode (cheader_filename = "gdu/gdu.h")]
	public static bool util_delete_secret (Gdu.Device device);
	[CCode (cheader_filename = "gdu/gdu.h")]
	public static unowned string util_fstype_get_description (string fstype);
	[CCode (cheader_filename = "gdu/gdu.h")]
	public static unowned string util_get_connection_for_display (string connection_interface, uint64 connection_speed);
	[CCode (cheader_filename = "gdu/gdu.h")]
	public static unowned string util_get_default_part_type_for_scheme_and_fstype (string scheme, string fstype, uint64 size);
	[CCode (cheader_filename = "gdu/gdu.h")]
	public static unowned string util_get_desc_for_part_type (string part_scheme, string part_type);
	[CCode (cheader_filename = "gdu/gdu.h")]
	public static unowned string util_get_fstype_for_display (string fstype, string fsversion, bool long_string);
	[CCode (cheader_filename = "gdu/gdu.h")]
	public static unowned string util_get_secret (Gdu.Device device);
	[CCode (cheader_filename = "gdu/gdu.h")]
	public static unowned string util_get_size_for_display (uint64 size, bool long_string);
	[CCode (cheader_filename = "gdu/gdu.h")]
	public static unowned string util_get_speed_for_display (uint64 size);
	[CCode (cheader_filename = "gdu/gdu.h")]
	public static bool util_have_secret (Gdu.Device device);
	[CCode (cheader_filename = "gdu/gdu.h")]
	public static unowned string util_part_table_type_get_description (string part_type);
	[CCode (cheader_filename = "gdu/gdu.h")]
	public static void util_part_type_foreach (Gdu.UtilPartTypeForeachFunc callback);
	[CCode (cheader_filename = "gdu/gdu.h")]
	public static bool util_save_secret (Gdu.Device device, string secret, bool save_in_keyring_session);
}
