/////////////////////////////////////////////////////////////
//                                                         //
// Copyright (c) 2003-2011 by The University of Queensland //
// Earth Systems Science Computational Centre (ESSCC)      //
// http://www.uq.edu.au/esscc                              //
//                                                         //
// Primary Business: Brisbane, Queensland, Australia       //
// Licensed under the Open Software License version 3.0    //
// http://www.opensource.org/licenses/osl-3.0.php          //
//                                                         //
/////////////////////////////////////////////////////////////


#include "tml/type/gettype.h"

// get MPI type for buildin types
// should eventually cover all MPI data types 
template <> 
MPI_Datatype SGetType::operator()<signed char>(const signed char&)
{
  return MPI_CHAR;
}

template <> 
MPI_Datatype SGetType::operator()<char>(const char&)
{
  return MPI_CHAR;
}

template <> 
MPI_Datatype SGetType::operator()<int>(const int&)
{
  return MPI_INT;
}

template <> 
MPI_Datatype SGetType::operator()<float>(const float&)
{
  return MPI_FLOAT;
}

template <> 
MPI_Datatype SGetType::operator()<double>(const double&)
{
  return MPI_DOUBLE;
}
