#############################################################
##                                                         ##
## Copyright (c) 2003-2013 by The University of Queensland ##
## Earth Systems Science Computational Centre (ESSCC)      ##
## http://www.uq.edu.au/esscc                              ##
##                                                         ##
## Primary Business: Brisbane, Queensland, Australia       ##
## Licensed under the Open Software License version 3.0    ##
## http://www.opensource.org/licenses/osl-3.0.php          ##
##                                                         ##
#############################################################

"""
Defines the L{TriangulatedSurface} class.
"""
class TriangulatedSurface(object):
    def __init__(self, nodeSequence, faceSequence):
        """
        Initialise the mesh data.
        @type nodeSequence: iterable
        @param nodeSequence: The list of triangle vertices.
        @type faceSequence: iterable
        @param faceSequence: A list three-tuples, with each three-tuple
        representing a triangular facet. Each three-tuple element is
        an index into the nodeSequence array indicating a vertex of
        the triangular facet.
        """
        self.nodeSequence = list(nodeSequence)
        self.faceSequence = list(faceSequence)


