/*
 * $Id: chip_intel_8259A.c,v 1.23 2009-06-03 11:34:04 vrsieh Exp $
 *
 * Copyright (C) 2003-2009 FAUmachine Team <info@faumachine.org>.
 * This program is free software. You can redistribute it and/or modify it
 * under the terms of the GNU General Public License, either version 2 of
 * the License, or (at your option) any later version. See COPYING.
 */

#include <assert.h>
#include <stdio.h>
#include <stdlib.h>

#include "fixme.h"
#include "glue-log.h"

#include "chip_intel_8259A.h"

struct cpssp {
	/*
	 * Config
	 */

	/*
	 * Signals
	 */
	struct sig_integer *port_cas;
	struct sig_boolean_or *port_ir0;
	struct sig_boolean_or *port_ir1;
	struct sig_boolean_or *port_ir2;
	struct sig_boolean_or *port_ir3;
	struct sig_boolean_or *port_ir4;
	struct sig_boolean_or *port_ir5;
	struct sig_boolean_or *port_ir6;
	struct sig_boolean_or *port_ir7;
	struct sig_boolean_or *port_int;

	/*
	 * State
	 */
	unsigned int state_power;

#define STATE

#define NAME		pic
#define NAME_(x)	pic_ ## x
#define SNAME		"pic"
#include "arch_pic.c"
#undef SNAME
#undef NAME_
#undef NAME

#undef STATE
};

static void
pic_cas_out_set(struct cpssp *cpssp, int irq)
{
	sig_integer_set(cpssp->port_cas, cpssp, irq);
}

static void
pic_irq_out_set(struct cpssp *cpssp, int val)
{
	sig_boolean_or_set(cpssp->port_int, cpssp, val);
}

#define BEHAVIOR

#define NAME		pic
#define NAME_(x)	pic_ ## x
#define SNAME		"pic"
#include "arch_pic.c"
#undef SNAME
#undef NAME_
#undef NAME

#undef BEHAVIOR

static void
chip_intel_8259A_power_set(void *_css, unsigned int val)
{
	struct cpssp *cpssp = (struct cpssp *) _css;

	cpssp->state_power = val;
}

static void
chip_intel_8259A_n_reset_set(void *_css, unsigned int val)
{
	struct cpssp *cpssp = (struct cpssp *) _css;

	pic_reset(cpssp);
}

static int
chip_intel_8259A_inb(void *_css, uint8_t *valp, unsigned long port)
{
	struct cpssp *cpssp = (struct cpssp *) _css;

	pic_inb(cpssp, valp, port);

	return 0;
}

static int
chip_intel_8259A_outb(void *_css, uint8_t value, unsigned long port)
{
	struct cpssp *cpssp = (struct cpssp *) _css;

	pic_outb(cpssp, value, port);

	return 0;
}

static void
chip_intel_8259A_cas_in_set(void *_css, int val)
{
	struct cpssp *cpssp = (struct cpssp *) _css;

	pic_cas_in_set(cpssp, val);
}

static void
chip_intel_8259A_isa_bus_int0_set(void *_css, unsigned int val)
{
	struct cpssp *cpssp = (struct cpssp *) _css;

	pic_isa_bus_int0_set(cpssp, val);
}

static void
chip_intel_8259A_isa_bus_int1_set(void *_css, unsigned int val)
{
	struct cpssp *cpssp = (struct cpssp *) _css;

	pic_isa_bus_int1_set(cpssp, val);
}

static void
chip_intel_8259A_isa_bus_int2_set(void *_css, unsigned int val)
{
	struct cpssp *cpssp = (struct cpssp *) _css;

	pic_isa_bus_int2_set(cpssp, val);
}

static void
chip_intel_8259A_isa_bus_int3_set(void *_css, unsigned int val)
{
	struct cpssp *cpssp = (struct cpssp *) _css;

	pic_isa_bus_int3_set(cpssp, val);
}

static void
chip_intel_8259A_isa_bus_int4_set(void *_css, unsigned int val)
{
	struct cpssp *cpssp = (struct cpssp *) _css;

	pic_isa_bus_int4_set(cpssp, val);
}

static void
chip_intel_8259A_isa_bus_int5_set(void *_css, unsigned int val)
{
	struct cpssp *cpssp = (struct cpssp *) _css;

	pic_isa_bus_int5_set(cpssp, val);
}

static void
chip_intel_8259A_isa_bus_int6_set(void *_css, unsigned int val)
{
	struct cpssp *cpssp = (struct cpssp *) _css;

	pic_isa_bus_int6_set(cpssp, val);
}

static void
chip_intel_8259A_isa_bus_int7_set(void *_css, unsigned int val)
{
	struct cpssp *cpssp = (struct cpssp *) _css;

	pic_isa_bus_int7_set(cpssp, val);
}

static void
chip_intel_8259A_sp_set(void *_css, unsigned int val)
{
	struct cpssp *cpssp = (struct cpssp *) _css;

	pic_sp_set(cpssp, val);

}

void *
chip_intel_8259A_create(
	const char *name,
	struct sig_manage *port_manage,
	struct sig_boolean *port_power,
	struct sig_boolean *port_reset_hash_,
	struct sig_cs *port_cs,
	struct sig_isa_bus_main *port_bus,
	struct sig_integer *port_cas,
	struct sig_boolean_or *port_ir0,
	struct sig_boolean_or *port_ir1,
	struct sig_boolean_or *port_ir2,
	struct sig_boolean_or *port_ir3,
	struct sig_boolean_or *port_ir4,
	struct sig_boolean_or *port_ir5,
	struct sig_boolean_or *port_ir6,
	struct sig_boolean_or *port_ir7,
	struct sig_boolean_or *port_int,
	struct sig_boolean *port_sp
)
{
	static const struct sig_boolean_funcs power_funcs = {
		.set = chip_intel_8259A_power_set,
	};
	static const struct sig_boolean_funcs reset_hash__funcs = {
		.set = chip_intel_8259A_n_reset_set,
	};
	static const struct sig_cs_funcs cs_funcs = {
		.readb = chip_intel_8259A_inb,
		.writeb = chip_intel_8259A_outb,
	};
	static const struct sig_integer_funcs cas_funcs = {
		.set =	chip_intel_8259A_cas_in_set,
	};
	static const struct sig_boolean_or_funcs ir0_funcs = {
		.set =	chip_intel_8259A_isa_bus_int0_set,
	};
	static const struct sig_boolean_or_funcs ir1_funcs = {
		.set =	chip_intel_8259A_isa_bus_int1_set,
	};
	static const struct sig_boolean_or_funcs ir2_funcs = {
		.set =	chip_intel_8259A_isa_bus_int2_set,
	};
	static const struct sig_boolean_or_funcs ir3_funcs = {
		.set =	chip_intel_8259A_isa_bus_int3_set,
	};
	static const struct sig_boolean_or_funcs ir4_funcs = {
		.set =	chip_intel_8259A_isa_bus_int4_set,
	};
	static const struct sig_boolean_or_funcs ir5_funcs = {
		.set =	chip_intel_8259A_isa_bus_int5_set,
	};
	static const struct sig_boolean_or_funcs ir6_funcs = {
		.set =	chip_intel_8259A_isa_bus_int6_set,
	};
	static const struct sig_boolean_or_funcs ir7_funcs = {
		.set =	chip_intel_8259A_isa_bus_int7_set,
	};
	static const struct sig_boolean_funcs sp_funcs = {
		.set =	chip_intel_8259A_sp_set,
	};
	struct cpssp *cpssp;

	cpssp = malloc(sizeof(*cpssp));
	assert(cpssp);

	pic_init(cpssp);

	cpssp->port_cas = port_cas;
	cpssp->port_int = port_int;

	/* Out */
	sig_integer_connect_out(port_cas, cpssp, 0);
	sig_boolean_or_connect_out(port_int, cpssp, 0);

	/* Call */
	sig_cs_connect(port_cs, cpssp, &cs_funcs);

	/* In */
	sig_boolean_connect_in(port_power, cpssp, &power_funcs);

	sig_boolean_connect_in(port_reset_hash_, cpssp, &reset_hash__funcs);

	sig_integer_connect_in(port_cas, cpssp, &cas_funcs);

	sig_boolean_or_connect_in(port_ir0, cpssp, &ir0_funcs);
	sig_boolean_or_connect_in(port_ir1, cpssp, &ir1_funcs);
	sig_boolean_or_connect_in(port_ir2, cpssp, &ir2_funcs);
	sig_boolean_or_connect_in(port_ir3, cpssp, &ir3_funcs);
	sig_boolean_or_connect_in(port_ir4, cpssp, &ir4_funcs);
	sig_boolean_or_connect_in(port_ir5, cpssp, &ir5_funcs);
	sig_boolean_or_connect_in(port_ir6, cpssp, &ir6_funcs);
	sig_boolean_or_connect_in(port_ir7, cpssp, &ir7_funcs);

	sig_boolean_connect_in(port_sp, cpssp, &sp_funcs);

	return cpssp;
}

void
chip_intel_8259A_destroy(void *_cpssp)
{
	struct cpssp *cpssp = _cpssp;

	free(cpssp);
}
