/*
 * $Id: pci_intel_eepro100_gui.c,v 1.9 2009-05-25 09:28:06 vrsieh Exp $
 *
 * Copyright (C) 2003-2009 FAUmachine Team <info@faumachine.org>.
 * This program is free software. You can redistribute it and/or modify it
 * under the terms of the GNU General Public License, either version 2 of
 * the License, or (at your option) any later version. See COPYING.
 */

#include <assert.h>

#include "config.h"

#include "glue-gui.h"

#include "pci_intel_eepro100_gui.h"

#ifdef HAVE_GTK
#include "pci_intel_eepro100_gui_gtk.h"
#endif

void *
pci_intel_eepro100_gui_create(
	unsigned int page,
	const char *name,
	const char *mac,
	struct sig_manage *manage,
	struct sig_pci_bus *port_pci,
	struct sig_eth *port_eth,
	struct sig_boolean *port_opt_busy_led
)
{
	switch (selected_gui) {
#ifdef HAVE_GTK
	case GUI_GTK:
		return pci_intel_eepro100_gui_gtk_create(page, name,
				mac,
				manage,
				port_pci,
				port_eth,
				port_opt_busy_led);
		break;
#endif
	case GUI_NULL:
		return (void *) 1;
	default:
		assert(0);
	}
}

void
pci_intel_eepro100_gui_destroy(void *_cpssp)
{
	switch (selected_gui) {
#ifdef HAVE_GTK
	case GUI_GTK:
		pci_intel_eepro100_gui_gtk_destroy(_cpssp);
		break;
#endif
	case GUI_NULL:
		break;
	default:
		assert(0);
	}
}
