/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.in;

import java.io.EOFException;
import java.io.IOException;
import java.util.Vector;
import loci.formats.CoreMetadata;
import loci.formats.FormatException;
import loci.formats.FormatReader;
import loci.formats.FormatTools;
import loci.formats.MetadataStore;
import loci.formats.RandomAccessStream;

public class SlidebookReader
extends FormatReader {
    private Vector metadataOffsets;
    private Vector pixelOffsets;
    private Vector pixelLengths;

    public SlidebookReader() {
        super("Olympus Slidebook", "sld");
    }

    public boolean isThisType(byte[] block) {
        if (block.length < 8) {
            return false;
        }
        return block[0] == 108 && block[1] == 0 && block[2] == 0 && block[3] == 1 && block[4] == 73 && block[5] == 73 && block[6] == 0;
    }

    public byte[] openBytes(int no, byte[] buf) throws FormatException, IOException {
        FormatTools.assertId(this.currentId, true, 1);
        FormatTools.checkPlaneNumber(this, no);
        FormatTools.checkBufferSize(this, buf.length);
        int plane = this.core.sizeX[this.series] * this.core.sizeY[this.series] * 2;
        long offset = (Long)this.pixelOffsets.get(this.series) + (long)(plane * no);
        this.in.seek(offset);
        this.in.read(buf);
        return buf;
    }

    protected void initFile(String id) throws FormatException, IOException {
        int n;
        if (debug) {
            this.debug("SlidebookReader.initFile(" + id + ")");
        }
        super.initFile(id);
        this.in = new RandomAccessStream(id);
        this.in.order(true);
        this.status("Finding offsets to pixel data");
        this.in.skipBytes(4);
        this.core.littleEndian[0] = this.in.read() == 73;
        this.metadataOffsets = new Vector();
        this.pixelOffsets = new Vector();
        this.pixelLengths = new Vector();
        this.in.seek(0L);
        while (this.in.getFilePointer() < this.in.length() - 8L) {
            this.in.skipBytes(4);
            int checkOne = this.in.read();
            int checkTwo = this.in.read();
            if (checkOne == 73 && checkTwo == 73) {
                this.metadataOffsets.add(new Long(this.in.getFilePointer() - 6L));
                if (this.in.read() == 0) {
                    this.in.skipBytes(249);
                    continue;
                }
                this.in.skipBytes(121);
                continue;
            }
            String s = null;
            long fp = this.in.getFilePointer() - 6L;
            this.in.seek(fp);
            int len = this.in.read();
            if (len > 0 && len <= 32) {
                byte[] b = new byte[len];
                this.in.read(b);
                s = new String(b);
            }
            if (s != null && s.indexOf("Annotation") != -1) {
                if (s.equals("CTimelapseAnnotation")) {
                    this.in.skipBytes(41);
                    if (this.in.read() == 0) {
                        this.in.skipBytes(10);
                        continue;
                    }
                    this.in.seek(this.in.getFilePointer() - 1L);
                    continue;
                }
                if (s.equals("CIntensityBarAnnotation")) {
                    this.in.skipBytes(56);
                    int n2 = this.in.read();
                    while (n2 == 0 || n2 < 6 || n2 > 128) {
                        n2 = this.in.read();
                    }
                    this.in.seek(this.in.getFilePointer() - 1L);
                    continue;
                }
                if (s.equals("CCubeAnnotation")) {
                    this.in.skipBytes(66);
                    int n3 = this.in.read();
                    if (n3 == 0) continue;
                    this.in.seek(this.in.getFilePointer() - 1L);
                    continue;
                }
                if (!s.equals("CScaleBarAnnotation")) continue;
                this.in.skipBytes(52);
                continue;
            }
            if (s != null && s.indexOf("Decon") != -1) {
                this.in.seek(fp);
                while (this.in.read() != 93) {
                }
                continue;
            }
            this.in.seek(fp);
            this.pixelOffsets.add(new Long(fp));
            try {
                byte[] buf = new byte[8192];
                boolean found = false;
                n = this.in.read(buf);
                while (!found && this.in.getFilePointer() < this.in.length()) {
                    for (int i = 0; i < buf.length - 6; ++i) {
                        if (buf[i] != 104 || buf[i + 4] != 73 || buf[i + 5] != 73) continue;
                        found = true;
                        this.in.seek(this.in.getFilePointer() - (long)n + (long)i - 20L);
                        break;
                    }
                    if (found) continue;
                    byte[] tmp = buf;
                    buf = new byte[8192];
                    System.arraycopy(tmp, tmp.length - 20, buf, 0, 20);
                    n = this.in.read(buf, 20, buf.length - 20);
                }
                if (this.in.getFilePointer() <= this.in.length()) {
                    this.pixelLengths.add(new Long(this.in.getFilePointer() - fp));
                    continue;
                }
                this.pixelOffsets.remove(this.pixelOffsets.size() - 1);
            }
            catch (EOFException e) {
                this.pixelOffsets.remove(this.pixelOffsets.size() - 1);
            }
        }
        this.core = new CoreMetadata(this.pixelOffsets.size() - 1);
        this.status("Determining dimensions");
        long pixelBytes = 0L;
        for (int i = 0; i < this.pixelLengths.size(); ++i) {
            pixelBytes += ((Long)this.pixelLengths.get(i)).longValue();
        }
        int iCount = 0;
        int hCount = 0;
        int uCount = 0;
        for (int i = 0; i < this.metadataOffsets.size(); ++i) {
            long off = (Long)this.metadataOffsets.get(i);
            this.in.seek(off);
            n = this.in.read();
            if (n == 105) {
                this.in.skipBytes(79);
                this.core.sizeX[0] = this.in.readShort();
                this.core.sizeY[0] = this.in.readShort();
                ++iCount;
                continue;
            }
            if (n == 104) {
                ++hCount;
                continue;
            }
            if (n != 117) continue;
            ++uCount;
        }
        this.core.rgb[0] = false;
        int n4 = this.core.sizeC[0] = iCount < 5 ? iCount : 1;
        if (this.core.sizeC[0] == 0) {
            this.core.sizeC[0] = 1;
        }
        if (this.core.sizeZ[0] == 0) {
            this.core.sizeZ[0] = 1;
        }
        if (this.core.sizeT[0] == 0) {
            this.core.sizeT[0] = 1;
        }
        if ((long)(this.core.sizeX[0] * this.core.sizeY[0] * 2 * this.core.sizeC[0] * this.core.sizeZ[0] * this.core.sizeT[0]) != pixelBytes && hCount > 0) {
            this.core.sizeZ[0] = hCount / this.core.sizeC[0];
        }
        int n5 = this.core.sizeZ[0] * this.core.sizeC[0] * this.core.sizeT[0];
        if (uCount == this.core.sizeZ[0] * this.core.sizeT[0]) {
            uCount = n5;
        }
        if (uCount < this.core.sizeZ[0] * this.core.sizeT[0] * this.core.sizeC[0]) {
            int planesPerMontage = n5 * 2 / uCount;
            while (planesPerMontage > 1) {
                this.core.sizeY[0] = this.core.sizeY[0] / 2;
                if ((planesPerMontage /= 2) <= 1) continue;
                this.core.sizeX[0] = this.core.sizeX[0] / 2;
                planesPerMontage /= 2;
            }
            if (this.core.sizeC[0] == 1) {
                this.core.sizeC[0] = 2;
            } else {
                this.core.sizeT[0] = this.core.sizeT[0] * 2;
            }
        } else if (uCount > this.core.sizeZ[0] * this.core.sizeT[0] * this.core.sizeC[0]) {
            int planesPerMontage = (int)((long)(this.core.sizeX[0] * this.core.sizeY[0] * 2) / (pixelBytes / (long)uCount));
            if (planesPerMontage % 2 != 0) {
                ++planesPerMontage;
            }
            if (planesPerMontage == 2) {
                planesPerMontage += 2;
            }
            if (planesPerMontage == 0) {
                ++planesPerMontage;
            }
            int plane = this.core.sizeX[0] * this.core.sizeY[0];
            while ((long)(uCount * this.core.sizeC[0] * (plane * 2 / planesPerMontage)) < pixelBytes - (long)plane) {
                ++uCount;
            }
            while (planesPerMontage > 1 && (long)(this.core.sizeX[0] * this.core.sizeY[0] * 2 * uCount) > pixelBytes) {
                this.core.sizeY[0] = this.core.sizeY[0] / 2;
                if ((planesPerMontage /= 2) > 1 && (long)(this.core.sizeX[0] * this.core.sizeY[0] * 2 * uCount) > pixelBytes) {
                    this.core.sizeX[0] = this.core.sizeX[0] / 2;
                    planesPerMontage /= 2;
                    continue;
                }
                planesPerMontage = 1;
            }
            this.core.sizeZ[0] = uCount;
        }
        if (this.core.sizeX[0] == 0) {
            this.core.sizeX[0] = 512;
        }
        if (this.core.sizeY[0] == 0) {
            this.core.sizeY[0] = 512;
        }
        for (int i = 0; i < this.core.sizeX.length; ++i) {
            this.core.sizeX[i] = this.core.sizeX[0];
            this.core.sizeY[i] = this.core.sizeY[0];
            this.core.currentOrder[i] = "XYZCT";
            this.core.pixelType[i] = 3;
            this.core.littleEndian[i] = true;
            this.core.sizeC[i] = this.core.sizeC[0];
            this.core.sizeT[i] = this.core.sizeT[0];
            long len = (Long)this.pixelLengths.get(i);
            this.core.sizeZ[i] = (int)(len / (long)(this.core.sizeX[i] * this.core.sizeY[i] * 2 * this.core.sizeC[i]));
            this.core.imageCount[i] = this.core.sizeC[i] * this.core.sizeZ[i] * this.core.sizeT[i];
            this.core.indexed[i] = false;
            this.core.falseColor[i] = false;
            this.core.metadataComplete[i] = true;
        }
        MetadataStore store = this.getMetadataStore();
        FormatTools.populatePixels(store, this);
        for (int i = 0; i < this.core.sizeX.length; ++i) {
            Integer ii = new Integer(i);
            store.setImage(this.currentId, null, null, ii);
            for (int j = 0; j < this.core.sizeC[i]; ++j) {
                store.setLogicalChannel(j, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, ii);
            }
        }
    }
}

