'''OpenGL extension SUNX.constant_data

This module customises the behaviour of the 
OpenGL.raw.GL.SUNX.constant_data to provide a more 
Python-friendly API

Overview (from the spec)
	
	This extension allows the pixel data specified by the
	application to be used internally without making a second copy.
	This extension affects how the pixel data in client memory is
	interpreted and therefore affects DrawPixels, Bitmap,
	PolygonStipple, TexImage1D, TexImage2D, TexImage3DEXT,
	ColorTableSGI.

The official definition of this extension is available here:
http://www.opengl.org/registry/specs/SUNX/constant_data.txt
'''
from OpenGL import platform, constant, arrays
from OpenGL import extensions, wrapper
from OpenGL.GL import glget
import ctypes
from OpenGL.raw.GL import _types
from OpenGL.raw.GL.SUNX.constant_data import *
from OpenGL.raw.GL.SUNX.constant_data import _EXTENSION_NAME

def glInitConstantDataSUNX():
    '''Return boolean indicating whether this extension is available'''
    from OpenGL import extensions
    return extensions.hasGLExtension( _EXTENSION_NAME )

### END AUTOGENERATED SECTION