/* icondata.c generated by valac 0.12.0, the Vala compiler
 * generated from icondata.vala, do not modify */


#include <glib.h>
#include <glib-object.h>
#include <float.h>
#include <math.h>
#include <gdk/gdk.h>
#include <stdlib.h>
#include <string.h>
#include <cairo.h>


#define TYPE_ICON_DATA (icon_data_get_type ())
#define ICON_DATA(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_ICON_DATA, IconData))
#define ICON_DATA_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_ICON_DATA, IconDataClass))
#define IS_ICON_DATA(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_ICON_DATA))
#define IS_ICON_DATA_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_ICON_DATA))
#define ICON_DATA_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_ICON_DATA, IconDataClass))

typedef struct _IconData IconData;
typedef struct _IconDataClass IconDataClass;
typedef struct _IconDataPrivate IconDataPrivate;

#define TYPE_ICON_TRACE_DATA (icon_trace_data_get_type ())
#define ICON_TRACE_DATA(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_ICON_TRACE_DATA, IconTraceData))
#define ICON_TRACE_DATA_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_ICON_TRACE_DATA, IconTraceDataClass))
#define IS_ICON_TRACE_DATA(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_ICON_TRACE_DATA))
#define IS_ICON_TRACE_DATA_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_ICON_TRACE_DATA))
#define ICON_TRACE_DATA_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_ICON_TRACE_DATA, IconTraceDataClass))

typedef struct _IconTraceData IconTraceData;
typedef struct _IconTraceDataClass IconTraceDataClass;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

struct _IconData {
	GObject parent_instance;
	IconDataPrivate * priv;
};

struct _IconDataClass {
	GObjectClass parent_class;
	void (*update) (IconData* self);
	void (*update_scale) (IconData* self);
};

struct _IconDataPrivate {
	guint _trace_length;
	gdouble* scalerhistory;
	gint scalerhistory_length1;
	gint _scalerhistory_size_;
	gdouble scalerminimum;
	GdkColor _color;
	guint _alpha;
	gboolean _enabled;
	gchar* _id;
	gdouble _scale;
	gchar** _menuitems;
	gint _menuitems_length1;
	gint __menuitems_size_;
	IconTraceData** _traces;
	gint _traces_length1;
	gint __traces_size_;
};


static gpointer icon_data_parent_class = NULL;

GType icon_data_get_type (void) G_GNUC_CONST;
GType icon_trace_data_get_type (void) G_GNUC_CONST;
#define ICON_DATA_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_ICON_DATA, IconDataPrivate))
enum  {
	ICON_DATA_DUMMY_PROPERTY,
	ICON_DATA_COLOR,
	ICON_DATA_ALPHA,
	ICON_DATA_ENABLED,
	ICON_DATA_ID,
	ICON_DATA_SCALE,
	ICON_DATA_MENUITEMS,
	ICON_DATA_TRACE_LENGTH
};
IconData* icon_data_construct (GType object_type, const gchar* id, guint traces, guint scalerdelay, gdouble scalerminimum);
static void icon_data_set_traces (IconData* self, IconTraceData** value, int value_length1);
IconTraceData** icon_data_get_traces (IconData* self, int* result_length1);
IconTraceData* icon_trace_data_new (void);
IconTraceData* icon_trace_data_construct (GType object_type);
static void icon_data_set_id (IconData* self, const gchar* value);
void icon_data_set_trace_length (IconData* self, guint value);
void icon_data_update (IconData* self);
static void icon_data_real_update (IconData* self);
void icon_data_update_scale (IconData* self);
static void icon_data_real_update_scale (IconData* self);
guint icon_data_get_trace_length (IconData* self);
gdouble* icon_trace_data_get_values (IconTraceData* self, int* result_length1);
gdouble utils_max (gdouble* data, int data_length1);
gdouble utils_mean (gdouble* data, int data_length1);
static void icon_data_set_scale (IconData* self, gdouble value);
void icon_data_set_source_color (IconData* self, cairo_t* ctx);
void icon_data_get_color (IconData* self, GdkColor* result);
guint icon_data_get_alpha (IconData* self);
void icon_data_set_color (IconData* self, GdkColor* value);
void icon_data_set_alpha (IconData* self, guint value);
gboolean icon_data_get_enabled (IconData* self);
void icon_data_set_enabled (IconData* self, gboolean value);
const gchar* icon_data_get_id (IconData* self);
gdouble icon_data_get_scale (IconData* self);
gchar** icon_data_get_menuitems (IconData* self, int* result_length1);
void icon_data_set_menuitems (IconData* self, gchar** value, int value_length1);
static gchar** _vala_array_dup3 (gchar** self, int length);
static IconTraceData** _vala_array_dup4 (IconTraceData** self, int length);
void icon_trace_data_set_values_length (IconTraceData* self, guint length);
static void icon_data_finalize (GObject* obj);
static void _vala_icon_data_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_icon_data_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);


IconData* icon_data_construct (GType object_type, const gchar* id, guint traces, guint scalerdelay, gdouble scalerminimum) {
	IconData * self = NULL;
	IconTraceData** _tmp0_ = NULL;
	IconTraceData** _tmp1_;
	gint _tmp1__length1;
	IconTraceData** _tmp2_;
	gdouble* _tmp8_ = NULL;
	g_return_val_if_fail (id != NULL, NULL);
	self = (IconData*) g_object_new (object_type, NULL);
	_tmp0_ = g_new0 (IconTraceData*, traces + 1);
	_tmp1_ = _tmp0_;
	_tmp1__length1 = traces;
	_tmp2_ = _tmp1_;
	icon_data_set_traces (self, _tmp2_, traces);
	_tmp1_ = (_vala_array_free (_tmp1_, _tmp1__length1, (GDestroyNotify) g_object_unref), NULL);
	{
		guint i;
		i = (guint) 0;
		{
			gboolean _tmp3_;
			_tmp3_ = TRUE;
			while (TRUE) {
				IconTraceData** _tmp4_ = NULL;
				gint _tmp5_;
				IconTraceData* _tmp6_ = NULL;
				IconTraceData* _tmp7_;
				if (!_tmp3_) {
					i = i + 1;
				}
				_tmp3_ = FALSE;
				if (!(i < traces)) {
					break;
				}
				_tmp4_ = icon_data_get_traces (self, &_tmp5_);
				_tmp6_ = icon_trace_data_new ();
				_tmp7_ = _tmp6_;
				_g_object_unref0 (_tmp4_[i]);
				_tmp4_[i] = _tmp7_;
			}
		}
	}
	icon_data_set_id (self, id);
	icon_data_set_trace_length (self, (guint) 16);
	_tmp8_ = g_new0 (gdouble, scalerdelay);
	self->priv->scalerhistory = (g_free (self->priv->scalerhistory), NULL);
	self->priv->scalerhistory = _tmp8_;
	self->priv->scalerhistory_length1 = scalerdelay;
	self->priv->_scalerhistory_size_ = scalerdelay;
	{
		guint i;
		i = (guint) 0;
		{
			gboolean _tmp9_;
			_tmp9_ = TRUE;
			while (TRUE) {
				if (!_tmp9_) {
					i = i + 1;
				}
				_tmp9_ = FALSE;
				if (!(i < scalerdelay)) {
					break;
				}
				self->priv->scalerhistory[i] = scalerminimum;
			}
		}
	}
	self->priv->scalerminimum = scalerminimum;
	return self;
}


static void icon_data_real_update (IconData* self) {
	g_return_if_fail (IS_ICON_DATA (self));
	g_critical ("Type `%s' does not implement abstract method `icon_data_update'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
	return;
}


void icon_data_update (IconData* self) {
	ICON_DATA_GET_CLASS (self)->update (self);
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static void icon_data_real_update_scale (IconData* self) {
	gdouble currentpeak;
	gdouble _tmp8_;
	gdouble historymaximum;
	gdouble _tmp11_;
	g_return_if_fail (IS_ICON_DATA (self));
	currentpeak = self->priv->scalerminimum;
	{
		guint i;
		guint _tmp0_;
		guint isize;
		i = (guint) 0;
		_tmp0_ = icon_data_get_trace_length (self);
		isize = _tmp0_;
		{
			gboolean _tmp1_;
			_tmp1_ = TRUE;
			while (TRUE) {
				gdouble currentvalue;
				IconTraceData** _tmp2_ = NULL;
				gint _tmp3_;
				gdouble _tmp7_;
				if (!_tmp1_) {
					i = i + 1;
				}
				_tmp1_ = FALSE;
				if (!(i < isize)) {
					break;
				}
				currentvalue = (gdouble) 0;
				_tmp2_ = icon_data_get_traces (self, &_tmp3_);
				{
					IconTraceData** trace_collection;
					int trace_collection_length1;
					int trace_it;
					trace_collection = _tmp2_;
					trace_collection_length1 = _tmp3_;
					for (trace_it = 0; trace_it < _tmp3_; trace_it = trace_it + 1) {
						IconTraceData* _tmp4_;
						IconTraceData* trace;
						_tmp4_ = _g_object_ref0 (trace_collection[trace_it]);
						trace = _tmp4_;
						{
							gdouble* _tmp5_ = NULL;
							gint _tmp6_;
							_tmp5_ = icon_trace_data_get_values (trace, &_tmp6_);
							currentvalue = currentvalue + _tmp5_[i];
							_g_object_unref0 (trace);
						}
					}
				}
				_tmp7_ = MAX (currentpeak, currentvalue);
				currentpeak = _tmp7_;
			}
		}
	}
	_tmp8_ = utils_max (self->priv->scalerhistory, self->priv->scalerhistory_length1);
	historymaximum = _tmp8_;
	if (currentpeak < historymaximum) {
		{
			guint i;
			guint isize;
			i = (guint) 0;
			isize = (guint) self->priv->scalerhistory_length1;
			{
				gboolean _tmp9_;
				_tmp9_ = TRUE;
				while (TRUE) {
					if (!_tmp9_) {
						i = i + 1;
					}
					_tmp9_ = FALSE;
					if (!((i + 1) < isize)) {
						break;
					}
					self->priv->scalerhistory[i] = self->priv->scalerhistory[i + 1];
				}
			}
		}
	} else {
		{
			guint i;
			guint isize;
			i = (guint) 0;
			isize = (guint) self->priv->scalerhistory_length1;
			{
				gboolean _tmp10_;
				_tmp10_ = TRUE;
				while (TRUE) {
					if (!_tmp10_) {
						i = i + 1;
					}
					_tmp10_ = FALSE;
					if (!((i + 1) < isize)) {
						break;
					}
					self->priv->scalerhistory[i] = currentpeak;
				}
			}
		}
	}
	self->priv->scalerhistory[self->priv->scalerhistory_length1 - 1] = currentpeak;
	_tmp11_ = utils_mean (self->priv->scalerhistory, self->priv->scalerhistory_length1);
	icon_data_set_scale (self, _tmp11_);
}


void icon_data_update_scale (IconData* self) {
	ICON_DATA_GET_CLASS (self)->update_scale (self);
}


void icon_data_set_source_color (IconData* self, cairo_t* ctx) {
	g_return_if_fail (IS_ICON_DATA (self));
	g_return_if_fail (ctx != NULL);
	cairo_set_source_rgba (ctx, self->priv->_color.red / 65535.0, self->priv->_color.green / 65565.0, self->priv->_color.blue / 65565.0, self->priv->_alpha / 65565.0);
}


void icon_data_get_color (IconData* self, GdkColor* result) {
	g_return_if_fail (IS_ICON_DATA (self));
	*result = self->priv->_color;
	return;
}


void icon_data_set_color (IconData* self, GdkColor* value) {
	g_return_if_fail (IS_ICON_DATA (self));
	self->priv->_color = *value;
	g_object_notify ((GObject *) self, "color");
}


guint icon_data_get_alpha (IconData* self) {
	guint result;
	g_return_val_if_fail (IS_ICON_DATA (self), 0U);
	result = self->priv->_alpha;
	return result;
}


void icon_data_set_alpha (IconData* self, guint value) {
	g_return_if_fail (IS_ICON_DATA (self));
	self->priv->_alpha = value;
	g_object_notify ((GObject *) self, "alpha");
}


gboolean icon_data_get_enabled (IconData* self) {
	gboolean result;
	g_return_val_if_fail (IS_ICON_DATA (self), FALSE);
	result = self->priv->_enabled;
	return result;
}


void icon_data_set_enabled (IconData* self, gboolean value) {
	g_return_if_fail (IS_ICON_DATA (self));
	self->priv->_enabled = value;
	g_object_notify ((GObject *) self, "enabled");
}


const gchar* icon_data_get_id (IconData* self) {
	const gchar* result;
	g_return_val_if_fail (IS_ICON_DATA (self), NULL);
	result = self->priv->_id;
	return result;
}


static void icon_data_set_id (IconData* self, const gchar* value) {
	gchar* _tmp0_;
	g_return_if_fail (IS_ICON_DATA (self));
	_tmp0_ = g_strdup (value);
	_g_free0 (self->priv->_id);
	self->priv->_id = _tmp0_;
	g_object_notify ((GObject *) self, "id");
}


gdouble icon_data_get_scale (IconData* self) {
	gdouble result;
	g_return_val_if_fail (IS_ICON_DATA (self), 0.0);
	result = self->priv->_scale;
	return result;
}


static void icon_data_set_scale (IconData* self, gdouble value) {
	g_return_if_fail (IS_ICON_DATA (self));
	self->priv->_scale = value;
	g_object_notify ((GObject *) self, "scale");
}


gchar** icon_data_get_menuitems (IconData* self, int* result_length1) {
	gchar** result;
	gchar** _tmp0_;
	g_return_val_if_fail (IS_ICON_DATA (self), NULL);
	_tmp0_ = self->priv->_menuitems;
	*result_length1 = self->priv->_menuitems_length1;
	result = _tmp0_;
	return result;
}


static gchar** _vala_array_dup3 (gchar** self, int length) {
	gchar** result;
	int i;
	result = g_new0 (gchar*, length + 1);
	for (i = 0; i < length; i++) {
		result[i] = g_strdup (self[i]);
	}
	return result;
}


void icon_data_set_menuitems (IconData* self, gchar** value, int value_length1) {
	gchar** _tmp0_;
	gchar** _tmp1_;
	g_return_if_fail (IS_ICON_DATA (self));
	_tmp0_ = (_tmp1_ = value, (_tmp1_ == NULL) ? ((gpointer) _tmp1_) : _vala_array_dup3 (_tmp1_, value_length1));
	self->priv->_menuitems = (_vala_array_free (self->priv->_menuitems, self->priv->_menuitems_length1, (GDestroyNotify) g_free), NULL);
	self->priv->_menuitems = _tmp0_;
	self->priv->_menuitems_length1 = value_length1;
	self->priv->__menuitems_size_ = value_length1;
	g_object_notify ((GObject *) self, "menuitems");
}


IconTraceData** icon_data_get_traces (IconData* self, int* result_length1) {
	IconTraceData** result;
	IconTraceData** _tmp0_;
	g_return_val_if_fail (IS_ICON_DATA (self), NULL);
	_tmp0_ = self->priv->_traces;
	*result_length1 = self->priv->_traces_length1;
	result = _tmp0_;
	return result;
}


static IconTraceData** _vala_array_dup4 (IconTraceData** self, int length) {
	IconTraceData** result;
	int i;
	result = g_new0 (IconTraceData*, length + 1);
	for (i = 0; i < length; i++) {
		result[i] = _g_object_ref0 (self[i]);
	}
	return result;
}


static void icon_data_set_traces (IconData* self, IconTraceData** value, int value_length1) {
	IconTraceData** _tmp0_;
	IconTraceData** _tmp1_;
	g_return_if_fail (IS_ICON_DATA (self));
	_tmp0_ = (_tmp1_ = value, (_tmp1_ == NULL) ? ((gpointer) _tmp1_) : _vala_array_dup4 (_tmp1_, value_length1));
	self->priv->_traces = (_vala_array_free (self->priv->_traces, self->priv->_traces_length1, (GDestroyNotify) g_object_unref), NULL);
	self->priv->_traces = _tmp0_;
	self->priv->_traces_length1 = value_length1;
	self->priv->__traces_size_ = value_length1;
}


guint icon_data_get_trace_length (IconData* self) {
	guint result;
	g_return_val_if_fail (IS_ICON_DATA (self), 0U);
	result = self->priv->_trace_length;
	return result;
}


void icon_data_set_trace_length (IconData* self, guint value) {
	IconTraceData** _tmp0_ = NULL;
	gint _tmp1_;
	g_return_if_fail (IS_ICON_DATA (self));
	self->priv->_trace_length = value;
	_tmp0_ = icon_data_get_traces (self, &_tmp1_);
	{
		IconTraceData** trace_collection;
		int trace_collection_length1;
		int trace_it;
		trace_collection = _tmp0_;
		trace_collection_length1 = _tmp1_;
		for (trace_it = 0; trace_it < _tmp1_; trace_it = trace_it + 1) {
			IconTraceData* _tmp2_;
			IconTraceData* trace;
			_tmp2_ = _g_object_ref0 (trace_collection[trace_it]);
			trace = _tmp2_;
			{
				icon_trace_data_set_values_length (trace, value);
				_g_object_unref0 (trace);
			}
		}
	}
	g_object_notify ((GObject *) self, "trace-length");
}


static void icon_data_class_init (IconDataClass * klass) {
	icon_data_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (IconDataPrivate));
	ICON_DATA_CLASS (klass)->update = icon_data_real_update;
	ICON_DATA_CLASS (klass)->update_scale = icon_data_real_update_scale;
	G_OBJECT_CLASS (klass)->get_property = _vala_icon_data_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_icon_data_set_property;
	G_OBJECT_CLASS (klass)->finalize = icon_data_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), ICON_DATA_COLOR, g_param_spec_boxed ("color", "color", "color", GDK_TYPE_COLOR, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), ICON_DATA_ALPHA, g_param_spec_uint ("alpha", "alpha", "alpha", 0, G_MAXUINT, (guint) 0xffff, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), ICON_DATA_ENABLED, g_param_spec_boolean ("enabled", "enabled", "enabled", TRUE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), ICON_DATA_ID, g_param_spec_string ("id", "id", "id", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), ICON_DATA_SCALE, g_param_spec_double ("scale", "scale", "scale", -G_MAXDOUBLE, G_MAXDOUBLE, (gdouble) 1, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), ICON_DATA_MENUITEMS, g_param_spec_boxed ("menuitems", "menuitems", "menuitems", G_TYPE_STRV, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), ICON_DATA_TRACE_LENGTH, g_param_spec_uint ("trace-length", "trace-length", "trace-length", 0, G_MAXUINT, 0U, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
}


static void icon_data_instance_init (IconData * self) {
	gchar** _tmp0_ = NULL;
	self->priv = ICON_DATA_GET_PRIVATE (self);
	self->priv->_alpha = (guint) 0xffff;
	self->priv->_enabled = TRUE;
	self->priv->_scale = (gdouble) 1;
	_tmp0_ = g_new0 (gchar*, 0 + 1);
	self->priv->_menuitems = _tmp0_;
	self->priv->_menuitems_length1 = 0;
	self->priv->__menuitems_size_ = self->priv->_menuitems_length1;
}


static void icon_data_finalize (GObject* obj) {
	IconData * self;
	self = ICON_DATA (obj);
	self->priv->scalerhistory = (g_free (self->priv->scalerhistory), NULL);
	_g_free0 (self->priv->_id);
	self->priv->_menuitems = (_vala_array_free (self->priv->_menuitems, self->priv->_menuitems_length1, (GDestroyNotify) g_free), NULL);
	self->priv->_traces = (_vala_array_free (self->priv->_traces, self->priv->_traces_length1, (GDestroyNotify) g_object_unref), NULL);
	G_OBJECT_CLASS (icon_data_parent_class)->finalize (obj);
}


/******************************************************************************
 * Copyright (C) 2011  Michael Hofmann <mh21@piware.de>                       *
 *                                                                            *
 * This program is free software; you can redistribute it and/or modify       *
 * it under the terms of the GNU General Public License as published by       *
 * the Free Software Foundation; either version 3 of the License, or          *
 * (at your option) any later version.                                        *
 *                                                                            *
 * This program is distributed in the hope that it will be useful,            *
 * but WITHOUT ANY WARRANTY; without even the implied warranty of             *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the              *
 * GNU General Public License for more details.                               *
 *                                                                            *
 * You should have received a copy of the GNU General Public License along    *
 * with this program; if not, write to the Free Software Foundation, Inc.,    *
 * 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.                *
 ******************************************************************************/
GType icon_data_get_type (void) {
	static volatile gsize icon_data_type_id__volatile = 0;
	if (g_once_init_enter (&icon_data_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (IconDataClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) icon_data_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (IconData), 0, (GInstanceInitFunc) icon_data_instance_init, NULL };
		GType icon_data_type_id;
		icon_data_type_id = g_type_register_static (G_TYPE_OBJECT, "IconData", &g_define_type_info, G_TYPE_FLAG_ABSTRACT);
		g_once_init_leave (&icon_data_type_id__volatile, icon_data_type_id);
	}
	return icon_data_type_id__volatile;
}


static void _vala_icon_data_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	IconData * self;
	GdkColor boxed0;
	int length;
	self = ICON_DATA (object);
	switch (property_id) {
		case ICON_DATA_COLOR:
		icon_data_get_color (self, &boxed0);
		g_value_set_boxed (value, &boxed0);
		break;
		case ICON_DATA_ALPHA:
		g_value_set_uint (value, icon_data_get_alpha (self));
		break;
		case ICON_DATA_ENABLED:
		g_value_set_boolean (value, icon_data_get_enabled (self));
		break;
		case ICON_DATA_ID:
		g_value_set_string (value, icon_data_get_id (self));
		break;
		case ICON_DATA_SCALE:
		g_value_set_double (value, icon_data_get_scale (self));
		break;
		case ICON_DATA_MENUITEMS:
		g_value_set_boxed (value, icon_data_get_menuitems (self, &length));
		break;
		case ICON_DATA_TRACE_LENGTH:
		g_value_set_uint (value, icon_data_get_trace_length (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_icon_data_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	IconData * self;
	gpointer boxed;
	self = ICON_DATA (object);
	switch (property_id) {
		case ICON_DATA_COLOR:
		icon_data_set_color (self, g_value_get_boxed (value));
		break;
		case ICON_DATA_ALPHA:
		icon_data_set_alpha (self, g_value_get_uint (value));
		break;
		case ICON_DATA_ENABLED:
		icon_data_set_enabled (self, g_value_get_boolean (value));
		break;
		case ICON_DATA_ID:
		icon_data_set_id (self, g_value_get_string (value));
		break;
		case ICON_DATA_SCALE:
		icon_data_set_scale (self, g_value_get_double (value));
		break;
		case ICON_DATA_MENUITEMS:
		boxed = g_value_get_boxed (value);
		icon_data_set_menuitems (self, boxed, g_strv_length (boxed));
		break;
		case ICON_DATA_TRACE_LENGTH:
		icon_data_set_trace_length (self, g_value_get_uint (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}



