/*
 * test-service.c: unit test for the service module
 *
 * Copyright 2010 Canonical Ltd.
 *
 * Authors:
 * David Barth <david.barth@canonical.com>
 * Kalle Valo <kalle.valo@canonical.com>
 *
 * This program is free software: you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 3, as published
 * by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranties of
 * MERCHANTABILITY, SATISFACTORY QUALITY, or FITNESS FOR A PARTICULAR
 * PURPOSE.  See the GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib.h>

#include "service.h"
#include "connman.h"

#define DOMAIN "/Backend/Service"

static Service *service;

#define SERVICE_PATH_FOO "/foo"
#define SERVICE_NAME_FOOBAR "foobar"

static void test_new()
{
  ConnmanService *cs = connman_service_new("/foo");
  Manager *m = manager_new();

  service = service_new(cs, m);

  g_assert(service != NULL);
  g_assert(IS_SERVICE(service));

  g_assert_cmpstr(service_get_path(service), ==, SERVICE_PATH_FOO);
}

gint main (gint argc, gchar *argv[])
{
  g_type_init();

  g_test_init(&argc, &argv, NULL);

  g_test_add_func(DOMAIN "/New", test_new);

  return g_test_run();
}
