/*===================== begin_copyright_notice ==================================

Copyright (c) 2017 Intel Corporation

Permission is hereby granted, free of charge, to any person obtaining a
copy of this software and associated documentation files (the
"Software"), to deal in the Software without restriction, including
without limitation the rights to use, copy, modify, merge, publish,
distribute, sublicense, and/or sell copies of the Software, and to
permit persons to whom the Software is furnished to do so, subject to
the following conditions:

The above copyright notice and this permission notice shall be included
in all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY
CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT,
TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE
SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.


======================= end_copyright_notice ==================================*/
#ifndef __SKU_WA_H__
#define __SKU_WA_H__

#if (_DEBUG || _RELEASE_INTERNAL)
#define GLOBAL_WAFTR_ENABLED 1
#endif

#ifdef _USC_

#include "usc.h"
#define SKU_FEATURE_TABLE  SUscSkuFeatureTable
#define PSKU_FEATURE_TABLE SUscSkuFeatureTable*

#else
#include "Driver_Model.h"

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wpedantic"
#elif defined(__GNUC__)
#pragma GCC diagnostic push
#if __GNUC__ >= 6
#pragma GCC diagnostic ignored "-Wpedantic"
#else
#pragma GCC diagnostic ignored "-pedantic"
#endif
#endif

typedef struct _SKU_FEATURE_TABLE
{

    struct
    {
        unsigned int   FtrDesktop : 1;
        unsigned int   FtrMultiFunc : 1;
        unsigned int   FtrGttBar : 1;
        unsigned int   FtrGmadrBar : 1;
        unsigned int   FtrMmioBar : 1;
        unsigned int   FtrDioBar : 1;
        unsigned int   FtrPrimaryVga : 1;
        unsigned int   FtrBandwidthLimit : 1;
        unsigned int   FtrCoreClkLimit : 1;
        unsigned int   Ftr36BitPhysAddress : 1;
        unsigned int   FtrVTdEnabled : 1;
        unsigned int   FtrPgtblEnableSupported : 1;
        unsigned int   FtrVERing : 1;
        unsigned int   FtrBlitterRing : 1;
        unsigned int   FtrMFXRing : 1;
        unsigned int   FtrVcs2 : 1;
        unsigned int   Ftr3dRing : 1;
        unsigned int   FtrPics : 1;
        unsigned int   FtrGtBigDie : 1;
        unsigned int   FtrGtMediumDie : 1;
        unsigned int   FtrGtSmallDie : 1;
        unsigned int   FtrGT1 : 1;
        unsigned int   FtrNativeGT1 : 1;
        unsigned int   FtrGT1_5 : 1;
        unsigned int   FtrGT1_75 : 1;
        unsigned int   FtrGT1_6 : 1;
        unsigned int   FtrGT2 : 1;
        unsigned int   FtrNativeGT2 : 1;
        unsigned int   FtrGT2_5 : 1;
        unsigned int   FtrGT3 : 1;
        unsigned int   FtrNativeGT3 : 1;
        unsigned int   FtrGT4 : 1;
        unsigned int   FtrPureGT1 : 1;
        unsigned int   FtrGTEuRowSelectLower : 1;
        unsigned int   FtrGTEuRowSelectUpper : 1;
        unsigned int   FtrGT4plus2 : 1;
        unsigned int   FtrGT4plus1 : 1;
        unsigned int   FtrGT2plus2 : 1;
        unsigned int   FtrGT2plus1 : 1;
        unsigned int   FtrEmbeddedPlatformEnabled : 1;
        unsigned int   FtrULT : 1;
        unsigned int   FtrIVBK0Platform : 1;
        unsigned int   FtrIVBM0M1Platform : 1;
        unsigned int   FtrIVBL0Platform : 1;
        unsigned int   FtrIVBL1Platform : 1;
        unsigned int   FtrIVBN0Platform : 1;
        unsigned int   FtrIVBE0E1Platform : 1;
        unsigned int   FtrIVBE2Platform : 1;
        unsigned int   FtrInternalSSC : 1;
        unsigned int   FtrUseMuxedSSCAsRef : 1;
        unsigned int   FtrChannelSwizzlingXOREnabled : 1;
        unsigned int   FtrULX : 1;
        unsigned int   FtrPipeCDisabled : 1;
        unsigned int   FtrPipeDDisabled : 1;
        unsigned int   FtrNumOfPipes : 3;
        unsigned int   FtrGTA : 1;
        unsigned int   FtrGTC : 1;
        unsigned int   FtrGTX : 1;
        unsigned int   Ftr5Slice : 1;
        unsigned int   FtrLLCMLCNotSupported : 1;
        unsigned int   FtrGfxClientSubmission : 1;
        unsigned int   FtrLCIA : 1;
        unsigned int   FtrPinning : 1;
        unsigned int   FtrHalo : 1;
        unsigned int   FtrDt : 1;
        unsigned int   FtrResourceStreamer : 1;
        unsigned int   FtrShaderDoubleSupportDisabled : 1;
        unsigned int   FtrHwSemaphore : 1;
        unsigned int   FtrCCSRing : 1;
        unsigned int   FtrSuperSku : 1;
    };
        struct
    {
        unsigned int   FtrPooledEuEnabled : 1;
    };

    struct
    {
        unsigned int   FtrMultiPipe : 1;
        unsigned int   Ftr3Pipes : 1;
        unsigned int   FtrInternalLvds : 1;
        unsigned int   FtrCrtOnPipeB : 1;
        unsigned int   FtrSerialDvo : 1;
        unsigned int   FtrSDVOHDMI : 1;
        unsigned int   FtrDualView : 1;
        unsigned int   FtrWirelessDisplayNndi : 1;
        unsigned int   FtreDPonPortD : 1;
        unsigned int   FtreDPonPortC : 1;
        unsigned int   FtreDPonPortB : 1;
        unsigned int   FtrWirelessDisplay_2_1 : 1;
        unsigned int   FtrDisplayDisabled : 1;
        unsigned int   FtrSGTPVSKUStrapPresent : 1;
        unsigned int   FtrS0ixSKU : 1;
        unsigned int   FtrS0ixSRByGunit : 1;
        unsigned int   FtrGfxS0ixCapable : 1;
        unsigned int   FtrConnectedStandby : 1;
        unsigned int   FtrSKU4KDisplay : 1;
        unsigned int   FtrSupportModesGreaterThan3840Horizontal : 1;
        unsigned int   FtrCollageSupport : 1;
        unsigned int   FtrLPEAudio : 1;
        unsigned int   FtrHDMIPixelMax225Mhz : 1;
        unsigned int   FtrDPMaxRes25x16_60 : 1;
        unsigned int   FtrCRTNotSupported : 1;
        unsigned int   FtrMipi : 1;
        unsigned int   FtrCommandModeMIPI  :   1;
        unsigned int   FtrAllowDC9WithMIPIDSR : 1;
        unsigned int   FtrDualMipi : 1;
        unsigned int   FtrSF1_0 : 1;
        unsigned int   FtrMPOSupport : 1;
        unsigned int   FtrDisableMPOMultiDisplayConfig : 1;
        unsigned int   FtrFractional48Hz : 1;
        unsigned int   FtrCHVBxSku : 1;
        unsigned int   FtrSplitScreenMPO : 1;
        unsigned int   FtrInvertRotation : 1;
        unsigned int   FtrPortraitLFP : 1;
        unsigned int   FtrGunitOffset : 1;
        unsigned int   FtrHWScalingNotSupported : 1;
        unsigned int   FtrDynamicCDClkOnlyForSDInternal : 1;
        unsigned int   FtrDDI4 : 1;
        unsigned int   FtrEnableUnderRun : 1;
        unsigned int   FtrEnable10bitRGBMPO : 1;
        unsigned int   FtrSAGVNotifyPCode : 1;
        unsigned int   FtrCoG : 1;
        unsigned int   FtreDPVDSC : 1;
        unsigned int   FtrPeriodicFrameNotification : 1;
        unsigned int   FtrDPVDSC : 1;
    };

    struct
    {
        unsigned int   FtrCapGttMapAddr : 1;

        unsigned int   FtrOverlay : 1;
        unsigned int   FtrOverlayMmioFlip : 1;
        unsigned int   FtrFullOverlayDownscale : 1;
        unsigned int   FtrFixedGfxMem64MbMax : 1;
        unsigned int   FtrTotalGfxMem256MbMax : 1;
        unsigned int   FtrAsyncMMIOFlipSupport : 1;


        unsigned int   FtrMediaReset : 1;
        unsigned int   FtrParallelEngine : 1;

        unsigned int   FtrEnableCloneOverlay : 1;
        unsigned int   FtrEnableCollageOverlay : 1;

        unsigned int   FtrGpGpuMidBatchPreempt                     :   1;
        unsigned int   FtrGpGpuThreadGroupLevelPreempt             :   1;
        unsigned int   FtrGpGpuMidThreadLevelPreempt               :   1;
        unsigned int   Ftr3dMidBatchPreempt                        :   1;
        unsigned int   Ftr3dObjectLevelPreempt                     :   1;
        unsigned int   FtrMediaMidBatchPreempt                     :   1;
        unsigned int   FtrMediaThreadGroupLevelPreempt             :   1;
        unsigned int   FtrMediaMidThreadLevelPreempt               :   1;
        unsigned int   FtrPerCtxtPreemptionGranularityControl      :   1;
        unsigned int   FtrDisableWDDMPreempt                       :   1;

        unsigned int   FtrBigPage                       : 1;
        unsigned int   FtrPPGTT                         : 1;
        unsigned int   FtrIA32eGfxPTEs                  : 1;
        unsigned int   FtrPml4Support                   : 1;
        unsigned int   FtrPml3OnHwPml4Support           : 1;
        unsigned int   FtrSVM                           : 1;
        unsigned int   FtrTileMappedResource            : 1;
        unsigned int   FtrTranslationTable              : 1;
        unsigned int   FtrUserModeTranslationTable      : 1;
        unsigned int   FtrNullPages                     : 1;
        unsigned int   FtrL3IACoherency                 : 1;
        unsigned int   FtrMIUpdateGTTCanUpdatePPGTT     : 1;
        unsigned int   FtrReportCombinedDVMSSVM         : 1;
        unsigned int   FtrRemoteFx                      : 1;
        unsigned int   FtrDriverManagedL3ParityErrors   : 1;
        unsigned int   FtrL3HangOnParityError           : 1;
        unsigned int   FtrEDram                         : 1;
        unsigned int   FtrLLCBypass                     : 1;
        unsigned int   FtrCrystalwell                   : 1;
        unsigned int   FtrCentralCachePolicy            : 1;
        unsigned int   FtrIoMmu                         : 1;
        unsigned int   FtrDriverControlledIoMmu         : 1;
        unsigned int   FtrIoMmuPageFaulting             : 1;
        unsigned int   FtrDmaBufferMemSpaceSplitting    : 1;
        unsigned int   FtrSecurePPGTTUpdate             : 1;
        unsigned int   FtrPigms                         : 1;
        unsigned int   FtrWddm2GpuMmu                   : 1;
        unsigned int   FtrWddm2Svm                      : 1;
        unsigned int   FtrStandardMipTailFormat         : 1;
        unsigned int   FtrDisplayColorEnhancement       : 1;
        unsigned int   FtrWddm2_1_64kbPages             : 1;
        unsigned int   FtrGttCacheInvalidation          : 1;
        unsigned int   FtrMemorySeg                     : 1;
        unsigned int   FtrCacheCoherentMemSeg           : 1;
        unsigned int   FtrDynamicDisplayAliasing        : 1;
        unsigned int   FtrLinearCCS                     : 1;

        unsigned int   FtrKMDTestSupportFromRegKey : 1;
        unsigned int   FtrKmdDaf : 1;
        unsigned int   FtrDisableOverlayRotation : 1;
        unsigned int   FtrUnmapPagingReservedGTTSeg : 1;
        unsigned int   FtrKmdNotifyUmd : 1;
        unsigned int   FtrDeferredWaitForEventOnAsyncFlip : 1;
        unsigned int   FtrPerfModeSdiWrite : 1;
        unsigned int   FtrUse3DEngineforLateralBlts : 1;
        unsigned int   FtrPreemptTestMode : 1;
        unsigned int   FtrGuCWriteCombineEnable : 1;
        unsigned int   FtrGuCInternalMsgChannelEnable : 1;

        unsigned int   FtrSubSliceIzHashing : 1;
        unsigned int   FtrFrameBufferLLC : 1;
        unsigned int   FtrGpuMmuPageFault : 1;
        unsigned int   FtrOSManagedAllocations  : 1;
        unsigned int   FtrCsResponseEventOptimization : 1;
        unsigned int   FtrRuntimeLogBuffer            : 1;
    };

    struct
    {
        unsigned int   FtrHwBin : 1;
        unsigned int   Ftr8BitPalette : 1;
        unsigned int   FtrPixelShader : 1;
        unsigned int   FtrPixelShader30 : 1;
        unsigned int   FtrBWGConsumerTextures : 1;
        unsigned int   FtrMultiRenderTarget : 1;
        unsigned int   FtrHWTnL : 1;
        unsigned int   FtrOcclusionQuery : 1;
        unsigned int   FtrOcclusionQueryOGL : 1;
        unsigned int   FtrAutoGenMipMap : 1;
        unsigned int   FtrWorkstation : 1;
        unsigned int   FtrEtcFormats : 1;
        unsigned int   FtrAstcLdr2D : 1;
        unsigned int   FtrAstcHdr2D : 1;
        unsigned int   FtrAstc3D : 1;
        unsigned int   FtrUmdThreadingShim : 1;
        unsigned int   FtrBoundingBoxOptOGL : 1;
        unsigned int   FtrResourceStreamerEnabled : 1;
        unsigned int   FtrHiZSamplerDisabled : 1;
    };



    struct
    {
        unsigned int FtrWin7 : 1;
        unsigned int FtrWin8 : 1;
        unsigned int FtrWddm1_3 : 1;
        unsigned int FtrWddm2_0 : 1;
        unsigned int FtrWddm2_1 : 1;
        unsigned int FtrWddm2_2 : 1;
        unsigned int FtrWddm2_3 : 1;
        unsigned int FtrWddm2_4 : 1;
        unsigned int FtrWddm2_5 : 1;
    };

    struct
    {
        unsigned int    FtrKmSecurityParser : 1;
    };

    struct
    {
        unsigned int    FtrOsManagedHwContext : 1;
    };

    struct
    {
        unsigned int    FtrVgt : 1;
    };

    struct
    {
        unsigned int    FtrOGLTexelOffsetPrecisionFix : 1;
    };

    struct
    {
        unsigned int    FtrEnableMissingAlpaFormatFilter             : 1;
        unsigned int    FtrEnablePlanarYUVFilteringFix               : 1;
    };


    struct
    {
        unsigned int FtrGtPsmi : 1;

    };

} SKU_FEATURE_TABLE, *PSKU_FEATURE_TABLE;

#if defined(__clang__)
#pragma clang diagnostic pop
#elif defined(__GNUC__)
#pragma GCC diagnostic pop
#endif

#endif



#define WA_DECLARE( wa, wa_comment, wa_bugType, wa_impact, wa_component) unsigned int wa : 1;

enum WA_BUG_TYPE
{
    WA_BUG_TYPE_UNKNOWN = 0,
    WA_BUG_TYPE_CORRUPTION = 1,
    WA_BUG_TYPE_HANG = 2,
    WA_BUG_TYPE_PERF = 4,
    WA_BUG_TYPE_FUNCTIONAL = 8,
    WA_BUG_TYPE_SPEC = 16,
    WA_BUG_TYPE_FAIL = 32
};

#define WA_BUG_PERF_IMPACT(f) f
#define WA_BUG_PERF_IMPACT_UNKNOWN -1

enum WA_COMPONENT
{
    WA_COMPONENT_UNKNOWN = 0,
    WA_COMPONENT_KMD = 0x1,
    WA_COMPONENT_MINIPORT = 0x2,
    WA_COMPONENT_GMM = 0x4,
    WA_COMPONENT_D3D = 0x8,
    WA_COMPONENT_OGL = 0x10,
    WA_COMPONENT_SOFTBIOS = 0x20,
    WA_COMPONENT_PWRCONS = 0x40,
    WA_COMPONENT_MEDIA = 0x80,
    WA_COMPONENT_OCL = 0x100,
};


typedef struct _WA_TABLE
{


        WA_DECLARE(
        WaIncreaseDefaultTLBEntries,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaDisSvClkGating,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaDisable_MASF_ClkGating,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaDisable_ISC_ClkGating,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaDisable_VFE_ClkGating,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaDisable_Clipper_ClkGating,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaDisable_VF_ClkGating,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaDisable_GS_ClkGating,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaTempDisableDOPClkGating,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaDisable_RCPH_RCC_RCZ_ClkGating,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaDisable_ECOSKPD_Chicken_Bits,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)


        unsigned int : 0;

        WA_DECLARE(
        Wa1280Cursor,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaSyncFlush,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        Wa1stBlt,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaSetupBlt,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaTextImmBlt,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaFlipStatus,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaIIRReadEnable,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaIsrFlipStatusRevert,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaUserToggleIir,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaDisableAsynchMMIOFlip,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaNonPipelinedStateCommandFlush,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaIlkEnableBothDispAndSPR,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaExtendedWaitForFlush,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaBitBashingForILKEDID,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaReadAksvFromDebugRegs,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaDPHDMIBlankOutIssueOnSamePort,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaPruneModeWithIncorrectHsyncOffset,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaEnablePartialDPSFeatures,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaEnableIPLLinkLaneReversal,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaSDVORxTerminationWA,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaStrapStateInvalidforeDPifDisabled,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaIPLPLLandDPLLRecoveryWA,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaDisablePF3BeforePipeDisable,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaeDPPLL162MhzWA,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaEnableVGAAccessThroughIOPort,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaIlkFlipMMIO,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaEnableDPIdlePatternforOnlyx4Lane,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaDisableRgbToYuvCSCInCenteredMode,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaYuvToRgbCSCConversionDisable,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaEnableClockGatingForMiWaitForEvent,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaEnableVDIPerformanceChickenBits,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaSimDisableVblankInterrupt,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaConvertAlphaToXORCursorForxvYCC,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaGTContextSaveIssue,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaForceVDD,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaSNBA0VSwingPreEmphasisSelect,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaSNBA0FDITxPLLOn,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaSNBIPLLaneCountSwitch,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaGTRbRvSyncIssue,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaGTRbsyncReadIssue,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaSaveLastRingObj,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaUseStaticWMLatencyValues,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaDisableeDPAfterEnableFDIPLL,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaEnableNullVSDPkt,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaSyncFlushVTDFix,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaFDITrainLink,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaFDIAutoLinkSetTimingOverrride,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        DisableSpritePassThroughMode,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaFP16GammaEnabling,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WADP0ClockGatingDisable,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)


        unsigned int : 0;

        WA_DECLARE(
        Wa2DNegativeStart,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaNoAsyncFlip,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaBatchBufferForWaitOnEvent,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaOvlFastHDownScale,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaOverlayPitch,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaEnableVblank,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        Wa2ndSpritePanning,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaOvHunitCounter,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaOvlPipeSwitching,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaPackedtoPlanar,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaDisableDdbmunitClkGating,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaDisableSpriteClkGating,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaSpriteAsOverlay,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaNoAsyncFlip180degree,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaToggleRenderClockThrottle,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaDisableOverlayFlipsInAwayMode,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaProgramDisplayPlaneWMforSprite,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaHas2CSLStubDisplay,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaDisableYTileForS3D,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaSKLDPAfeOverride,
        "Workaround",
        WA_BUG_TYPE_SPEC,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_SOFTBIOS)

        WA_DECLARE(
        WaKBLDPAfeOverride,
        "Workaround",
        WA_BUG_TYPE_SPEC,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_SOFTBIOS)

        WA_DECLARE(
        WaHDMIVswingChickenBitOverride,
        "Workaround",
        WA_BUG_TYPE_SPEC,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_SOFTBIOS)


        unsigned int : 0;

        WA_DECLARE(
        WaOCLDisableMaxThreads,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaOCLDisableBarriers,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaOCLDisableImageWrites,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaOCLDisableA64Messages,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaOCLLimitCurbeSize,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaOCLAddMSFlushForPreemption,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaOCLEnableFMaxFMinPlusZero,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaOCLUseLegacyTiming,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaCohPWmergeDisable,
        "Workaround",
        WA_BUG_TYPE_HANG,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN )

        WA_DECLARE(
        WaMaskUnmaskRegisterWriteForMBOinFlip,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaEnsureLP7WMInPSR2,
        "Workaround",
        WA_BUG_TYPE_FUNCTIONAL,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaDisableL3ErrorDetectionHangOnError,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaOCLGAMRepeaterBug,
        "Workaround",
        WA_BUG_TYPE_CORRUPTION,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaEnablePooledEuFor2x6,
        "Workaround",
        WA_BUG_TYPE_FUNCTIONAL,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)


        unsigned int : 0;

        WA_DECLARE(
        WaStallBeforePostSyncOpOnGPGPU,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaForceCsStallOnTimestampQuery,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaForceCsStallOnTimestampQueryOrDepthCount,
        "Workaround",
        WA_BUG_TYPE_CORRUPTION,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaForceRCPFEHangWorkaround,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN )

        WA_DECLARE(
        WaMSFWithNoWatermarkTSGHang,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaAtomicFlushOnInterfaceDescriptor,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaHwzFlushStrDword,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaDisableSecondLevelVertexCache,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaDisableHwbClockGating,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaDisableDagRounding,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaHwbRingSize,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaBorderColorChromaKey,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaMixedModeForceRead,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        Wa4DTextureCoordinates,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaMixedModeLinear,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaZBiasUseVtxTransform,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaFlushGWB,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaEndSceneNoPrimitives,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaConfirmHWBOOM,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaAsyncEndSceneBPLCorrupt,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaFastClearContextSwitch,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaHWBExpandOBR,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaIndexVertexNOP,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaIndirectVerticesPRB,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaHWBStaleSlowState,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaDisableA2R10G10B10Target,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaDisbaleIndirectLoadWideMode,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaZoneInitCorruption,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaFlushGWBOnBPLReset,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaOneOverW,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaIdleRingForSyncFlush,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaWIZSingleSubspanDispatch,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaDisable_RenderCache_OperationalFlush,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaEnable_BugFix_RCCAllocation,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaDisable_Suppress_CacheableIndicator,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaDisable_WIZUnit_ScratchSpace,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaStateless_Accesses_Allowed,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaMiSetContext_Hang,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        Wa_StateBaseAddress_Hang,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaDisable_TexturesOnlyForA0,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaDisable_Trickle_Feed,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaDisableHWBAutoReportHead,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaRestoreInhibit,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaEnableMTConstantReadFix,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        Wa_MI_SET_CONTEXT_Hang,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaDisableStencilBufferTestOnStencilBufferDisable,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaDontTurnOffCRClkInCStates,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaNoopHWContextLoadRegImm,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaPPGTTSteeringRegisterPresent,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaVSHWBug_Option1_DisableVertexCache,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        Wa_CS_URB_STATE_Hang,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaUseMediaEngineForPaging,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaInitAuxBuffersToTiled,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaDisableRenderCachePipelinedFlush,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaTimedSingleVertexDispatch,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaDisableFastClear,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaDisableHiZ,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaGTDisableHiZ,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaDisableHiZMSAAPerPixelLineAAEnabled,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaDisableFastClearYOffsetNonX4Aligned,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaDepthStallAfterFastClear,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaVertexShader96And128CacheEntries,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaClampSamplerArrayIndex,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaSampleSeparateStencil,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaForce8PSThreads,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaLimitWmMaxNumThreads,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaDisablePerPixelMSAA,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaDisableAlphaToCoverage1x,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaDisableAlphaToCoverage4x,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaLd2dmsSurfaceArrayOfSize1,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaDisableAlphaToCoverageDither,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaForcePushConstantEvenReadLength,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaDisableSQRORDClockGating,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaCorrectionForCosine0,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaDisableHeaderBypassForPSDepthOutput,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaForceHeaderForKillPixInstructions,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaDecomposePowToLogMulExp,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaCSStallOnAllPipeControls,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaMultisampledArrays,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaDisable128bppRTClears,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaGsPsdHang,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaForceThreadSwitchWhenUpdateMRFBeforeSend,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaFlushAfterPerspectiveDivideStateChange,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaDisableSampleFromStencil,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaReadAfterWriteHazard,
        "Workaround",
        WA_BUG_TYPE_CORRUPTION,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaDisableMadSrc0Replicate,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaSamplerChannelDisables,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaSFCorruption,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaCsStallBeforeStateCacheInvalidate,
        "Workaround",
        WA_BUG_TYPE_HANG,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaCsStallAtEveryFourthPipecontrol,
        "Workaround",
        WA_BUG_TYPE_HANG,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaUAVTypedWriteOverlapping,
        "Workaround",
        WA_BUG_TYPE_CORRUPTION,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaUAVTypedReadOverwritesAllDestChannels,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaPSInvocation,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaUseOnlySIMD8UntypedRead,
        "Workaround",
        WA_BUG_TYPE_HANG,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaDisableMscWithGS,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaSurface3DForceHorizontalAlignment4,
        "Workaround",
        WA_BUG_TYPE_HANG,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaUVoffsetToZeroForLd2dms,
        "Workaround",
        WA_BUG_TYPE_CORRUPTION,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaMsaaDisableMinArrayOffset,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaEnableAllCubeFacesForNonCubeSurfaces,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaFlushStateCacheOnDepthRangeChange,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaPerThreadScratchSpaceInGPGPUIncrease,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaUseFDP3InsteadOfFDP2,
        "Workaround",
        WA_BUG_TYPE_CORRUPTION,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaApplyAbsToFrcInstruction,
        "Workaround",
        WA_BUG_TYPE_CORRUPTION,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaForPlusInfRoundingModeFrcInstruction,
        "Workaround",
        WA_BUG_TYPE_CORRUPTION,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaDsNeedMoreThan138UrbHandlesAllocated,
        "Workaround",
        WA_BUG_TYPE_HANG,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaEmulateIBFEInstrucion,
        "Workaround",
        WA_BUG_TYPE_CORRUPTION,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaCsStallBeforeWriteCacheFlush,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaShaderCalculateResourceOffsets,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaUseThreadPayloadCompression,
        "Workaround",
        WA_BUG_TYPE_PERF,
        WA_BUG_PERF_IMPACT(20), WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaEnableTransformedVerticesHWClipping,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaDisableHiZPlanesWhenMSAAEnabled,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaUnlitCentroidInterpolation,
        "Workaround",
        WA_BUG_TYPE_CORRUPTION,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaDisableMcsForSINTFormat,
        "Workaround",
        WA_BUG_TYPE_CORRUPTION,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaAddCallToEOTEnabled,
        "Workaround",
        WA_BUG_TYPE_HANG,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaAlignDrawScissorRectTo2x2MSAA,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaTimestampMaskDefectiveBits,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaDX9MSAARasterization,
        "Workaround",
        WA_BUG_TYPE_CORRUPTION,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaZeroUnusedSampleDGradientsParameters,
        "Workaround",
        WA_BUG_TYPE_CORRUPTION,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaAlphaToOneOGL,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaDisableMsaaFastClear,
        "Workaround",
        WA_BUG_TYPE_CORRUPTION,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaDisableMcsFastClear,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaDummyRenderForAdderIssue,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaROBUnitVertexCorruption,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaOGLGSVertexReordering,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaOGLGSVertexReorderingTriStripAdjOnly,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaGsvEnableSWTurbo,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaGsvDisableTurbo,
        "Workaround",
        WA_BUG_TYPE_HANG,
        WA_BUG_PERF_IMPACT, WA_COMPONENT_PWRCONS)

        WA_DECLARE(
        WaGatherEUTimestampDispersion,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaXScaledFormatConversion,
        "Workaround",
        WA_BUG_TYPE_CORRUPTION,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaCMPInstFlagDepClearedEarly,
        "Workaround",
        WA_BUG_TYPE_CORRUPTION,
        WA_BUG_PERF_IMPACT(50), WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaForceUAVOnlyToFalse,
        "Workaround",
        WA_BUG_TYPE_CORRUPTION,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaAlphaCompareAlwaysWhenAlphaTestDisabled,
        "Workaround",
        WA_BUG_TYPE_CORRUPTION,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaScalarAtomic,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaVSThreadDispatchOverride,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaL3UseSamplerForLoadDualConstant,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaL3UseSamplerForVectorLoadScatter,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        Wa1DSurfaceSIMD4x2ArrayIndexInRAddress,
        "Workaround",
        WA_BUG_TYPE_CORRUPTION,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaIndexBufferOffsetOverflow,
        "Workaround",
        WA_BUG_TYPE_CORRUPTION,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaBreakSimd16TernaryInstructionsIntoSimd8,
        "Workaround",
        WA_BUG_TYPE_HANG | WA_BUG_TYPE_CORRUPTION,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaGSPullModelForPatchlistInputTopology,
        "Workaround",
        WA_BUG_TYPE_FUNCTIONAL,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaGSSingleDispatchModeForTriangleInput,
        "Workaround",
        WA_BUG_TYPE_FUNCTIONAL,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaForceSIMD8ForBFIInstruction,
        "Workaround",
        WA_BUG_TYPE_FUNCTIONAL,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaDisable4x2SubspanOptimization,
        "Workaround",
        WA_BUG_TYPE_HANG,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaBreakSimd16InstWhenAccIsUsedIntoSimd8,
        "Workaround",
        WA_BUG_TYPE_CORRUPTION,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaSendMiFlushAfterMediaStateFlush,
        "Workaround",
        WA_BUG_TYPE_HANG,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaAvcCabacDistortionBasedMinQp,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaEnableDummyMovInGpgpuContextSave,
        "Workaround",
        WA_BUG_TYPE_CORRUPTION,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaClearNotificationRegInGpgpuContextSave,
        "Workaround",
        WA_BUG_TYPE_HANG,
        WA_BUG_PERF_IMPACT(0), WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaGrfDepClearOnOutstandingSamplerInGpgpuContextSave,
        "Workaround",
        WA_BUG_TYPE_HANG,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaStoreAcc2to9InAlign16InGpgpuContextSave,
        "Workaround",
        WA_BUG_TYPE_CORRUPTION,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaGrfDependecyClearInGpgpuContextRestore,
        "Workaround",
        WA_BUG_TYPE_HANG,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaRestoreFCandMSGRegistersFromUpperOword,
        "Workaround",
        WA_BUG_TYPE_HANG,
        WA_BUG_PERF_IMPACT(0), WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaRestoreFC4RegisterDW0fromDW1,
        "Workaround",
        WA_BUG_TYPE_HANG,
        WA_BUG_PERF_IMPACT(0), WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaRestoreFc0RegistersWithOffset,
        "Workaround",
        WA_BUG_TYPE_HANG,
        WA_BUG_PERF_IMPACT(0), WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaGrfScoreboardClearInGpgpuContextSave,
        "Workaround",
        WA_BUG_TYPE_HANG,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaClearFlowControlGpgpuContextSave,
        "Workaround",
        WA_BUG_TYPE_HANG,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaClearCr0SpfInGpgpuContextRestore,
        "Workaround",
        WA_BUG_TYPE_HANG,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaDisableDbg0Register,
        "Workaround",
        WA_BUG_TYPE_CORRUPTION,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaDisableRSBeforeBTPoolDisable,
        "Workaround",
        WA_BUG_TYPE_HANG,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaUseRSChickenFor3DMidBatchPreempt,
        "Workaround",
        WA_BUG_TYPE_HANG,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaNotifRegSwapInGpGpuContextRestore,
        "Workaround",
        WA_BUG_TYPE_HANG,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaStoreSlmOffsetInSRDuringGpGpuPreemption,
        "Workaround",
        WA_BUG_TYPE_HANG,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaSampleGCToSampleLC,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaResetMSAAStates,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaCMPInstNullDstForcesThreadSwitch,
        "Workaround",
        WA_BUG_TYPE_HANG,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaCMPInstNullDstBreaksR0Scoreboarding,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaVSPreventFullTrackingFifo,
        "Workaround",
        WA_BUG_TYPE_HANG,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaVFInvalidate,
        "Workaround",
        WA_BUG_TYPE_HANG,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaForceHeaderForDualSourceBlendHi,
        "Workaround",
        WA_BUG_TYPE_CORRUPTION,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaFixedFormatConversion,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaForceHSPullModel,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaPreventHSTessLevelsInterference,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaAvoidDomainShaderCacheStall,
        "Workaround",
        WA_BUG_TYPE_PERF,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaIndirectDispatchPredicate,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaSetTriLinearFilterForLODPreclamp,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaCSScratchSpaceSize,
        "Workaround",
        WA_BUG_TYPE_HANG,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaCSNoWayToLimitScratchSpace,
        "Workaround",
        WA_BUG_TYPE_HANG,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaInsertNopToHaltDestination,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaForceL3Serialization,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaHizAmbiguate8x4Aligned,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaHizAmbiguateRequiredNonAlignedBeforeRender,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaFlushWriteCachesOnMultisampleChange,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaForceTypeConvertF32To16ToAlign1,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaAdditionalMovWhenSrc1ModOnMulMach,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaForceMulSrc1WordToAlign1,
        "Workaround",
        WA_BUG_TYPE_CORRUPTION,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaDoNotPushConstantsForAllPulledGSTopologies,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaCallForcesThreadSwitch,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaThreadSwitchAfterCall,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaDisableSIMD32PixelShaderDispatchFor2xMSAA,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WANOPBeetweenIndirectAdressingAndBranch,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaDX9MSAAonDX10HW,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaInvalidateAndHDCDeadlock,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaL3WriteIncomplete,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaMiUrbClearAfterMiSetContext,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaForceNonZeroSBEOutputAttributeCount,
        "Workaround",
        WA_BUG_TYPE_PERF,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaScoreboardStallBeforeStateCacheInvalidate,
        "Workaround",
        WA_BUG_TYPE_FUNCTIONAL,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaDoNotUseMIReportPerfCount,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaForceClearBindingTableEntries,
        "Workaround",
        WA_BUG_TYPE_FUNCTIONAL,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaLimitMaxPSThreadsToPhysical,
        "Workaround",
        WA_BUG_TYPE_HANG,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaLimitMaxHSUrbHandles,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaA32StatelessMessagesRequireHeader,
        "Workaround",
        WA_BUG_TYPE_HANG,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaNoA32ByteScatteredStatelessMessages,
        "Workaround",
        WA_BUG_TYPE_CORRUPTION,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaNearestFilterLODClamp,
        "Workaround",
        WA_BUG_TYPE_CORRUPTION,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaSingleSubspanDispatchOnAALinesAndPoints,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaLSLMAddressDisable,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaPipelineFlushCoherentLines,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaDisableAuxCCSForMRTBlend,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaUrbAtomics,
        "Workaround",
        WA_BUG_TYPE_PERF,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaFlushOpOnCSStall,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaPSRandomCSNotDone,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaDCFlushOnL3CacheConfig,
        "Workaround",
        WA_BUG_TYPE_HANG,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_D3D)

        WA_DECLARE(
        WaInvalidateTextureCache,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaLimitSLMSizeTo16KBOnA0,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaLimitSLMSizeTo8KBOnB0,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaBasicCompilationForDPInstructions,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaHalfFloatSelNotAllowedWithSourceModifiers,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaLowPrecWriteRTOnlyFloat,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaBreakF32MixedModeIntoSimd8,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaDisableDSDualPatchMode,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaDispatchGRFHWIssueInGSAndHSUnit,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaDisallow64BitImmMov,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)
        WA_DECLARE(
        WaDisallowDFImmMovWithSimd8,
        "Workaround",
        WA_BUG_TYPE_CORRUPTION,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaDisableNoSrcDepSetBeforeEOTSend,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaDstSubRegNumNotAllowedWithLowPrecPacked,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaDisableSendsSrc0DstOverlap,
        "Workaround",
        WA_BUG_TYPE_HANG,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaDisableSIMD16On3SrcInstr,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaHeaderRequiredOnSimd16Sample16bit,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaLodRequiredOnTypedMsaaUav,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        AccWrEnNotAllowedToAcc1With16bit,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaSendsSrc1Length0NotAllowed,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaDisableEuBypassOnSimd16Float16,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaDisableEuBypassOnSimd16Float32,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaDisableThreadDispatchToEU0,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaSrc1ImmHfNotAllowed,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaReturnZeroforRTReadOutsidePrimitive,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaCselUnsupported,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaDisableDSCaching,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaSubtract1FromMaxNoOfThreads,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaSendColorCalcAndBlendStateTogether,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaEmitVtxWhenOutVtxCntIsZero,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaCsStallBeforeURBVS,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaAlignIndexBuffer,
        "Workaround",
        WA_BUG_TYPE_CORRUPTION,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaGuardbandSize,
        "Workaround",
        WA_BUG_TYPE_CORRUPTION,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaRCCByteSharingDisableFor3DRT,
        "Workaround",
        WA_BUG_TYPE_CORRUPTION,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaDisable4x2SubSpanOptimizationForDS,
        "Workaround",
        WA_BUG_TYPE_CORRUPTION,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaFixCentroidInterpolationRTIR16X,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaDisableIndirectDataForGPGPUWalker,
        "Workaround",
        WA_BUG_TYPE_HANG | WA_BUG_TYPE_CORRUPTION,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaDisableIndirectDataAndFlushGPGPUWalker,
        "Workaround",
        WA_BUG_TYPE_HANG | WA_BUG_TYPE_CORRUPTION,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaDisableIndirectDataForIndirectDispatch,
        "Workaround",
        WA_BUG_TYPE_HANG | WA_BUG_TYPE_CORRUPTION,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaSendMediaStateFlushAfterGPGPUWalker,
        "Workaround",
        WA_BUG_TYPE_HANG,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaDisableDeferredDeallocation,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaDisablePushConstantHSGS,
        "Workaround",
        WA_BUG_TYPE_HANG,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaEnableAllWriteChannelMask,
        "Workaround",
        WA_BUG_TYPE_CORRUPTION,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaGather4WithGreenChannelSelectOnR32G32Float,
        "Workaround",
        WA_BUG_TYPE_CORRUPTION,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaStateBindingTableOverfetch,
        "Workaround",
        WA_BUG_TYPE_CORRUPTION,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaIncreaseL3CreditsForVLVB0,
        "Workaround",
        WA_BUG_TYPE_PERF,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaUAVCoherency,
        "Workaround",
        WA_BUG_TYPE_HANG,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WAInsertNOPBetweenMathPOWDIVAnd2RegInstr,
        "Workaround",
        WA_BUG_TYPE_HANG,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaCsStallBeforeEnabling3DstateHS,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaCsStallBefore3DStateVS,
        "Workaround",
        WA_BUG_TYPE_HANG,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaSendMiRsStoreDataImmBeforeRsSyncCommand,
        "Workaround",
        WA_BUG_TYPE_HANG,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaB0ParityHangDisable,
        "Workaround",
        WA_BUG_TYPE_HANG,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaDisableObjectLevelPreemptionDuringUAVDrawCall,
        "Workaround",
        WA_BUG_TYPE_HANG,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaFlushBefore3DStateConstant,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaSendExtraRSGatherConstantAndRSStoreImmCmds,
        "Workaround",
        WA_BUG_TYPE_HANG,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaNoPreemptionWhenBarrierEnabled,
        "Workaround",
        WA_BUG_TYPE_HANG,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaDisablePreemptionMMIOWhenBarrierEnabled,
        "Workaround",
        WA_BUG_TYPE_HANG,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaAvoidRCZCounterRollover,
        "Workaround",
        WA_BUG_TYPE_HANG,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaPreemptOnArbCheckOnly,
        "Workaround",
        WA_BUG_TYPE_HANG,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaTSGStarvation,
        "Workaround",
        WA_BUG_TYPE_PERF,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaInhibitPreemptionForOCLProfiling,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaMediaStateFlushBeforePipeControl,
        "Workaround",
        WA_BUG_TYPE_HANG,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaUAVDisableMinimumArrayElement,
        "Workaround",
        WA_BUG_TYPE_CORRUPTION,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaDisableNonSlm,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        Wa4x4STCOptimizationDisable,
        "Workaround",
        WA_BUG_TYPE_HANG,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaEnableKernelDebugFeatureInHWUsingCsDebugMode1,
        "Workaround",
        WA_BUG_TYPE_FUNCTIONAL,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaEnsureMemCoherencyBeforeLoadRegisterMem,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaClearCCStatePriorPipelineSelect,
        "Workaround",
        WA_BUG_TYPE_HANG,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaSendDummyVFEafterPipelineSelect,
        "Workaround",
        WA_BUG_TYPE_HANG,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaSendMIFLUSHBeforeVFE,
        "Workaround",
        WA_BUG_TYPE_HANG,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaDisableGunitClockGating,
        "Workaround",
        WA_BUG_TYPE_HANG,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaSetMaskForGfxBusyness,
        "Workaround",
        WA_BUG_TYPE_HANG,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaInvalidateROCacheOnCxtSwitch,
        "Workaround",
        WA_BUG_TYPE_HANG,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaSetRbWaitForAsyncFlip,
        "Workaround",
        WA_BUG_TYPE_HANG,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaDisableSDEUnitClockGating,
        "Workaround",
        WA_BUG_TYPE_CORRUPTION,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaDisableMidBatchPreempt,
        "Workaround",
        WA_BUG_TYPE_HANG,
        WA_BUG_PERF_IMPACT(0), WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaDisablePerCtxtPreemptionGranularityControl,
        "Workaround",
        WA_BUG_TYPE_SPEC,
        WA_BUG_PERF_IMPACT(0), WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaEnablePreemptionGranularityControlByUMD,
        "Workaround",
        WA_BUG_TYPE_HANG,
        WA_BUG_PERF_IMPACT(0), WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaDisableSemaphoreAndSyncFlipWait,
        "Workaround",
        WA_BUG_TYPE_HANG,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaClearSlmSpaceAtContextSwitch,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaFlushCoherentL3CacheLinesAtContextSwitch,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaPerCtxtBbInvalidateRoCaches,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaSetPipeControlCSStallforGPGPUAndMediaWorkloads,
        "Workaround",
        WA_BUG_TYPE_HANG,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaDisableFenceDestinationToSLM,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaDisableLSQCROPERFforOCL,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)
        WA_DECLARE(
        WaForceMinMaxGSThreadCount,
        "Workaround",
        WA_BUG_TYPE_HANG,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaAtomicsForceCoherency,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaDisableLowPrecisionWriteRTRepData,
        "Workaround",
        WA_BUG_TYPE_HANG,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WAResetN0AfterRenderTargetRead,
        "Workaround",
        WA_BUG_TYPE_HANG,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaDisablePreemptionOnSimd32,
        "Workaround",
        WA_BUG_TYPE_HANG,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaSetDepthToArraySizeForUAV,
        "Workaround",
        WA_BUG_TYPE_CORRUPTION,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaIndependentAlphaBlend,
        "Workaround",
        WA_BUG_TYPE_CORRUPTION,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaSendPushConstantsFromBTP,
        "Workaround",
        WA_BUG_TYPE_SPEC,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaSendPushConstantsFromMMIO,
        "Workaround",
        WA_BUG_TYPE_SPEC,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaSendPipeControlWithProtectedMemoryDisable,
        "Workaround",
        WA_BUG_TYPE_HANG,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaNullStateDepthBufferAsD16And2d,
        "Workaround",
        WA_BUG_TYPE_HANG,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)



        WA_DECLARE(
        WaAvoid16KWidthForTiledSurfaces,
        "Workaround",
        WA_BUG_TYPE_CORRUPTION,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaDisableRsInPostRestoreWaBb,
        "Workaround",
        WA_BUG_TYPE_HANG,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_KMD)

        WA_DECLARE(
        WaInsertGSforConstInterpolatedTrailingVertex,
        "Workaround",
        WA_BUG_TYPE_CORRUPTION,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_OGL)

        WA_DECLARE(
        WaForceCB0ToBeZeroWhenSendingPC,
        "Workaround",
        WA_BUG_TYPE_HANG,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_OGL)

        WA_DECLARE(
        WaDefaultCrossAndSubSliceHashingForSimplePS,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_OGL)

        WA_DECLARE(
        WaResetPSDoesNotWriteToRT,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_OGL)

        WA_DECLARE(
        WaPipeControlBeforeGpgpuImplicitFlushes,
        "Workaround",
        WA_BUG_TYPE_HANG,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaEnableDSCacheWorkAround,
        "Workaround",
        WA_BUG_TYPE_HANG,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_D3D)

        WA_DECLARE(
        WaSampleOffsetIZ,
        "Workaround",
        WA_BUG_TYPE_HANG,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaFlushHangWhenNonPipelineStateAndMarkerStalled,
        "Workaround",
        WA_BUG_TYPE_HANG,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)


        unsigned int : 0;


        WA_DECLARE(
        WaPcSlpcUseBxtGucBinaryVer1219,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaRccHangDisableMCSUnrefined,
        "Workaround",
        WA_BUG_TYPE_HANG,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN )

        WA_DECLARE(
        WaDisableGafsUnitClkGating,
        "Workaround",
        WA_BUG_TYPE_HANG,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_KMD)

        WA_DECLARE(
        WaToEnableHwFixForPushConstHWBug,
        "Workaround",
        WA_BUG_TYPE_HANG,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_KMD)

        WA_DECLARE(
        Wa_220856683,
        "Workaround",
        WA_BUG_TYPE_FUNCTIONAL,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_D3D)

        WA_DECLARE(
        WaBlcOutputHighInverterPWMFreq,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        Wa32bppWmWithFbc,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaFbcAsynchFlipDisableFbcQueue,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaFbcDisabledForOverlaySprite,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaFbcLimitedTo1MBStolenMemory,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaFbcOnlyForNativeModeOnLFP,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaFbcOnly1to1Ratio,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaFbcDisableDpfdClockGating,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaFbcDisable,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaFbcDisableDpfcClockGating,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaFbcFlickers,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaDisableFbcOnFixedMuxless,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaFbcWaitForVBlankBeforeEnable,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaFbcNukeOn3DBlt,
        "Workaround",
        WA_BUG_TYPE_CORRUPTION,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaFbcExceedCdClockThreshold,
        "Workaround",
        WA_BUG_TYPE_CORRUPTION,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaFbcCdClkFreqTooLow,
        "Workaround",
        WA_BUG_TYPE_CORRUPTION,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaFbcDisableRleCompressionForVTD,
        "Workaround",
        WA_BUG_TYPE_CORRUPTION,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaIpsDisableOnCdClockThreshold,
        "Workaround",
        WA_BUG_TYPE_CORRUPTION,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaFbcRequireStrideBeMultipleOfCompressionRatio,
        "Workaround" ,
        WA_BUG_TYPE_CORRUPTION,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaFbcDisableOnCompressionRatio2Or4,
        "Workaround" ,
        WA_BUG_TYPE_CORRUPTION,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaFbcDisableOnNonZeroPlanePosition,
        "Workaround" ,
        WA_BUG_TYPE_CORRUPTION,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaFbcProgramYTileCbStrideRegister,
        "Workaround" ,
        WA_BUG_TYPE_CORRUPTION,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaFbcProgramLinTileCbStrideRegister,
        "Workaround" ,
        WA_BUG_TYPE_CORRUPTION,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaFbcInvalidateCompressedLines,
        "Workaround",
        WA_BUG_TYPE_CORRUPTION,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaFbcTurnOffFbcWatermark,
        "Workaround",
        WA_BUG_TYPE_CORRUPTION,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaFbcHighMemBwCorruptionAvoidance,
        "Workaround",
        WA_BUG_TYPE_CORRUPTION,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaFbcWakeMemOn,
        "Workaround",
        WA_BUG_TYPE_CORRUPTION,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaFbcSkipSegments,
        "Workaround",
        WA_BUG_TYPE_CORRUPTION,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaFbcTurnOffFbcWhenHyperVisorIsUsed,
        "Workaround" ,
        WA_BUG_TYPE_CORRUPTION,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaFbcNukeOnHostModify,
        "Workaround" ,
        WA_BUG_TYPE_CORRUPTION,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaFixR32G32FloatBorderTextureAddressingMode,
        "Workaround",
        WA_BUG_TYPE_CORRUPTION,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaDisableIPS,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaIpsWaitForPcodeOnDisable,
        "Workaround",
        WA_BUG_TYPE_CORRUPTION,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaIpsDisableOnAsyncFlips,
        "Workaround",
        WA_BUG_TYPE_PERF,
        WA_BUG_PERF_IMPACT, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaPsrExitBlockedOnFbcNuke,
        "Workaround",
        WA_BUG_TYPE_CORRUPTION,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaGsvGtFreq200MhzMultiple,
        "Workaround",
        "Workaround",
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaGsvBringDownFreqInRc6,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaSkipDisplayPowerGating,
        "Workaround",
        WA_BUG_TYPE_HANG,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaFbcEnableDuringAeroModeOnly,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaFbcDontLimitCfbAllocationTo2K,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)


        WA_DECLARE(
        WaOvlSpriteCxSR,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaDisableHpllOffDuringSr,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaCxSRDisable,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaCxSRUseFixedWmark,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaCxSROnAndOffForVistaCursorSupport,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaCxSRDisableDparbClockGating,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaCxSRDisableHpllPowerDownForMedia,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaCxSRDisableFBCWaterMark,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaCxSRLimitFBCWaterMark,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        waCxSRLimitFifo,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaCxSRDisableDparbFix,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaDelayFrameStart,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaEmiBurstSizeMitigation,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaCxSRDisableLp2Watermarks,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaCxSRWmLatencyUnitIdentity,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)


        WA_DECLARE(
        WaSyncFlushWaitOnSyncFlushBit,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaPsrUseSwCursor,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaUseSwCursorInCommandMode,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaPsrDisableFbcAndIps,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaPsrForceUseLinkDisableMode,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaRS2RenderRegReadHangBug,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaRsForcewakeWaitTC0,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaRsForcewakeDelayAckPoll,
        "Workaround",
        WA_BUG_TYPE_HANG,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaRsForcewakeAddDelayForAck,
        "Workaround",
        WA_BUG_TYPE_HANG,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaDisableMarkerFlow,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaDisableMarkerFlow2,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaRsConsecutiveOptimizedWrite,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaRsUseTimeoutMode,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaGsvAxSteppingRegisters,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaGsvHighRingFreqScalingForUlt,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaRsDontPollForAckOnClearingFWBits,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaGsvLimitCpuTurboInRp0,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaDPSTHistogramErrorTolerance,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaRsDisplayPMReq,
        "Workaround",
        WA_BUG_TYPE_HANG,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaRsPkgCStateDisplayPMReq,
        "Workaround",
        WA_BUG_TYPE_HANG,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaRsRCSIdleBlockedInPSMI,
        "Workaround",
        WA_BUG_TYPE_HANG,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaRsForceSingleThreadFW,
        "Workaround",
        WA_BUG_TYPE_HANG,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaRsDisableDecoupledMMIO,
        "Workaround",
        WA_BUG_TYPE_PERF,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaRsClearFWBitsAtFLR,
        "Workaround",
        WA_BUG_TYPE_HANG,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaSyncSameMMIORegAccess,
        "Workaround",
        WA_BUG_TYPE_HANG,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_PWRCONS)

        WA_DECLARE(
        WaRsDoubleRc6WrlWithCoarsePowerGating,
        "Workaround",
        WA_BUG_TYPE_FUNCTIONAL,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_PWRCONS)

        WA_DECLARE(
        WaRsDisableCoarsePowerGating,
        "Workaround",
        WA_BUG_TYPE_HANG,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaFidMismatch,
        "Workaround",
        WA_BUG_TYPE_HANG,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaDpstDisableDlcdGating,
        "Workaround",
        WA_BUG_TYPE_HANG,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaIpsEnableOutsideOfVblankRegion,
        "Workaround",
        WA_BUG_TYPE_CORRUPTION,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaIpsEnableOnMediaPlaybackOnly,
        "Workaround",
        "Workaround",
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaIpsDisableOnPaletteAccess,
        "Workaround",
        WA_BUG_TYPE_HANG,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)


        WA_DECLARE(
        WaUsePipeAFlipTimestamp,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaTurboEnergyCounterMask,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaRc6Ppgtt,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaLaceRAMGatedClockForLPDSTAutoIndexing,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaLaceIEWriteDuringPSR,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaDisablePwrmtrEvent,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaDisableDPSTWhenPipeBandCActive,
        "Workaround",
        WA_BUG_TYPE_CORRUPTION,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaEnableTiledResourceTranslationTables,
        "Workaround",
        WA_BUG_TYPE_FUNCTIONAL,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)


        unsigned int : 0;

        WA_DECLARE(
        WaDisableCpClockGating,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaDisableReorderBuffer,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaDisableL2CacheClockGating,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaLowPriorityGracePeriodDisable,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaMiBatchBuffer,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaBlueCorruption,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaClockGatingDisable,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaDisableNearestTexelRound,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaFBCSetupUseRing,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaFBCSetStopCompOnModify,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaFBCDisablePerAlvRev,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaFlushGWBBeforeReads,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaDisableSnoopOnCacheWriteCyl,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaDisable36BitPhysAddress,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaUpdateOnCacheLineBoundary,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaUpdateBCSOnCacheLineBoundary,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaDisableCSUnitClockGating,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaEnablePhysAddrForMiInstr,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        Wa_Disable_C0_Fix_For_Req_Perf,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaDisableCrClkThrottlingDuringC2,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaClearRingBufHeadRegAtInit,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaForcePhysAddrForMiStoreDword,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaDisIndStatePointersForSubmit,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaDpst4DIETMultiplicativeMode,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaDisableMediaReset,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaRenderResetOnly,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaDmaBufferPadding,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WAGPUResetPCIRead,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaInitStopRenderWatchdogCounter,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaMediaResetMainRingCleanup,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaVcpClkGateDisableForMediaReset,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaDisableVfeClockGating,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaDisableEmUnitClockGating,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaDisableStcUnitClockGating,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaDisableMtmUnitClockGating,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaDisableHizUnitClockGating,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaDisableSamplerL2L1BandwidthPerformance,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaDisableTDSandwichDispatchMode,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaDisableNonLRAReplacementPolicy,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaDisableRCZMUnitClockGating,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaDisableVS0MUnitClockGating,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaDisableSFMUnitClockGating,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaIlkMariUnitOverrun,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaIlkFlushAfterMiSetContext,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaDoNotInhibitDepthCacheFlush,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaPipeControlISCFlushDisable,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaDisableSVSMUnitClockGating,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaDoNotUseSingleThreadGSMode,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaFlushBeforeGSDisabled,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaDisableHiZNonPromoted,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaNoCubeCornerAddressMode,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaIlkEnableDisableSuspendFlush,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaRestrictURBWriteMsgLength,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaDisableConstantCacheDualScattered,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaDisableConstantCache,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaNoPipelinedURBFenceChange,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaDisableStcLraEviction,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaSendPipelinedStateWithPsPushConstants,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaDisableGsDwordScatteredWrites,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaFlushStateCacheOnViewportScissorEnable,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaSendAllDepthState,
        "Workaround",
        WA_BUG_TYPE_HANG,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaCsStallPriorToDepthState,
        "Workaround",
        WA_BUG_TYPE_HANG,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaDepthStallAfterAnyPSState,
        "Workaround",
        WA_BUG_TYPE_HANG,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaSendPipeControlBeforePushConstantUpdate,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaPixelShaderKillPixelHang,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaDepthBiasCsStall,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaValign2For96bppFormats,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaValign2ForR8G8B8UINTFormat,
        "Workaround",
        WA_BUG_TYPE_CORRUPTION,
        WA_BUG_PERF_IMPACT(0), WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaFlushBefore3DPrimIfTopologyFilterEnabled,
        "Workaround",
        WA_BUG_TYPE_CORRUPTION,
        WA_BUG_PERF_IMPACT(0.5), WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaDummyRenderForAdderIssueXP,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaB2BPipeControlFlush,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaLimitGsUrbToTop256kb,
        "Workaround",
        WA_BUG_TYPE_CORRUPTION,
        WA_BUG_PERF_IMPACT(1), WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaDisablePSDDualDispatchEnable,
        "Workaround",
        WA_BUG_TYPE_HANG,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaSystemThreadCacheFlushEnabled,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaVSRefCountFullforceMissDisable,
        "Workaround",
        WA_BUG_TYPE_HANG,
        WA_BUG_PERF_IMPACT(20), WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaDSRefCountFullforceMissDisable,
        "Workaround",
        WA_BUG_TYPE_HANG,
        WA_BUG_PERF_IMPACT(20), WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaSampleCChickenBitEnable,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaAvoidPMAStall,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT(60), WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaDisablePixelBackendOptimization,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaSetCacheModeForVLV,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaDisableGunitPFIClkGating,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaGtWakeFifoManagement,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaGsvRC0ResidencyMethod,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaUseMediaScratchRegister,
        "Workaround",
        WA_BUG_TYPE_HANG,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaPsdDispatchEnable,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaEnableGunitDisplayInterruptMask,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT(0), WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaDividePSInvocationCountBy4,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaSbeConservativeCacheMode,
        "Workaround",
        WA_BUG_TYPE_HANG,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaCPUPushConstants,
        "Workaround",
        WA_BUG_TYPE_HANG,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaAvoidPMAStallA0Conditionals,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaUseOnlySIMD8PixelShaderDispatchForMSAA,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaSendLRITwice,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaAvoidStcPMAStall,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT(60), WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaAvoidStcPMAStallShaderFiltering,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)


        unsigned int : 0;

        WA_DECLARE(
        WaHDCL3Deadlock,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaIommuPendingInvalidationHang,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaIndexBufferBoundsCheck,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaMediaResetBeforeFullReset,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaDisableOverlayDSQualityFix,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaDisableEUInstructionPrefetch,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaSpriteRegisterUpdateViaMMIO,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaAlignMIReportPerfCount,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaDisableASModeReplayFifo,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaEnableSpriteBUpdateForUnderflowFix,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WAWakeVCRDuringCSProtectionOnAndOffReq,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaDisableSpriteDestColorKey,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaDisableD3D9OverlayScaling,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaAlignBltUpdateGttCmdHeader,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaMediaResetSpecialSequence,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaWakeUp3DForRs2,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaDisplayFlipAWaitAFlipBWaitB,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaInsertFlushBetween3DOverlappingBlts,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaDisableRc6OnWaitForEvent,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaEnableAllByteWritesForLRI,
        "Workaround",
        WA_BUG_TYPE_HANG,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaAlwaysClearIndirectStatePointersDisable,
        "Workaround",
        WA_BUG_TYPE_HANG,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaLoadDummyCB2,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaEnableLRIPostedOverrideBit,
        "Workaround",
        WA_BUG_TYPE_HANG,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaL3RowRedundancyUnavailable,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaL3ErrorRegistersInHwContext,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaAdditionalMiUserIntCmdNeeded,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaPSMIHandlerSemaphore,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaInjectFlushInB2BFastCopyBlts,
        "Workaround",
        WA_BUG_TYPE_HANG,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaAllowAsyncMMIOFlips,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaDisableCtxRestoreArbitration,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaDisableWaBBUse,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaDisableOcaLogging,
        "Workaround",
        WA_BUG_TYPE_HANG,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaForceL3LlcCoherencyInDescriptor,
        "Workaround",
        WA_BUG_TYPE_HANG,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaPipeControlUpperDwordCorruption,
        "Workaround",
        WA_BUG_TYPE_HANG,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaUseGfxModeFor3DPreemptionGranularity,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaUsePseudoL3AddressingScheme,
        "Workaround",
        WA_BUG_TYPE_CORRUPTION,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_KMD)

        WA_DECLARE(
        WaAllowUmdToEnableL3CycleThruZTLB,
        "Workaround",
        WA_BUG_TYPE_PERF,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_KMD)

        WA_DECLARE(
        WaAllowUmdToModifySamplerMode,
        "Workaround",
        WA_BUG_TYPE_FUNCTIONAL,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_KMD)

        WA_DECLARE(
        WaAllowUMDToModifyHDCChicken1,
        "Workaround",
        WA_BUG_TYPE_PERF,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_KMD)

        WA_DECLARE(
        WaAllowUMDToModifyHalfSliceChicken2,
        "Workaround",
        WA_BUG_TYPE_PERF,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_KMD)

        WA_DECLARE(
        WaAllowUMDToModifyHalfSliceChicken7,
        "Workaround",
        WA_BUG_TYPE_PERF,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_KMD)

        WA_DECLARE(
        WaEnableStateCacheRedirectToCS,
        "Workaround",
        WA_BUG_TYPE_PERF,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_KMD)

        WA_DECLARE(
        WaAllowUMDToModify3DPrimitiveExtParam,
        "Workaround",
        WA_BUG_TYPE_FUNCTIONAL,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_KMD)

        WA_DECLARE(
        WaBindlessSamplerStateBoundsCheckingDefeature,
        "Workaround",
        WA_BUG_TYPE_FUNCTIONAL,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_KMD)

        WA_DECLARE(
        WaDisableGatherAtSetShaderCommonSlice,
        "Workaround",
        WA_BUG_TYPE_FUNCTIONAL,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_KMD)

        WA_DECLARE(
        WaAvoidBackToBackIdAndCurbeCommandsViaPipeControl,
        "Workaround",
        WA_BUG_TYPE_CORRUPTION,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_KMD)

        WA_DECLARE(
        FtrEnableFastAnisoL1BankingFix,
        "Workaround",
        WA_BUG_TYPE_PERF,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_KMD)

        WA_DECLARE(
        WaDisableRc6Wabb,
        "Workaround",
        WA_BUG_TYPE_FUNCTIONAL,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_KMD)

        WA_DECLARE(
        WaDisableBlitterFbcTracking,
        "Workaround",
        WA_BUG_TYPE_FUNCTIONAL,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_KMD)

        WA_DECLARE(
        WaDisableI2mCycleOnWRPort,
        "Workaround",
        WA_BUG_TYPE_FUNCTIONAL,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_KMD)

        WA_DECLARE(
        WaThrottleEUPerfToAvoidTDBackPressure,
        "Workaround",
        WA_BUG_TYPE_HANG,
        WA_BUG_PERF_IMPACT, WA_COMPONENT_KMD)

        WA_DECLARE(
        WaDisableEnhancedSBEVertexCaching,
        "Workaround",
        WA_BUG_TYPE_CORRUPTION,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_KMD)

        WA_DECLARE(
        WaToggleSubsliceEnableBitsToClearCam,
        "Workaround",
        WA_BUG_TYPE_HANG,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_KMD)

        WA_DECLARE(
        WaDisableReplayBufferBankArbitrationOptimization,
        "Workaround",
        WA_BUG_TYPE_CORRUPTION,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_KMD)

        WA_DECLARE(
        WaPerDmaStallRcsForPocsCompletion,
        "Workaround",
        WA_BUG_TYPE_FUNCTIONAL,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_KMD)

        WA_DECLARE(
        WaPerDmaStallPocsForRcsCompletion,
        "Workaround",
        WA_BUG_TYPE_FUNCTIONAL,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_KMD)

        WA_DECLARE(
        WaSarbUnitClockGatingDisable,
        "Workaround",
        WA_BUG_TYPE_FUNCTIONAL,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_KMD)

        WA_DECLARE(
        WaPushConstantDereferenceHoldDisable,
        "Workaround",
        WA_BUG_TYPE_HANG,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_KMD)

        WA_DECLARE(
        WaAllowUMDToControlCoherency,
        "Workaround",
        WA_BUG_TYPE_FUNCTIONAL,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_KMD)

        WA_DECLARE(
        WaPocsOvrRestart,
        "Workaround",
        WA_BUG_TYPE_HANG,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_KMD)

        WA_DECLARE(
        WaDisableMSCunitClkGating,
        "Workaround",
        WA_BUG_TYPE_CORRUPTION,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_KMD)

        WA_DECLARE(
        WaDisCtxReload,
        "Workaround",
        WA_BUG_TYPE_HANG,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_KMD)

        WA_DECLARE(
        WaProgramMgsrForL3BankSpecificMmioReads,
        "Workaround",
        WA_BUG_TYPE_FUNCTIONAL,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_KMD)

        WA_DECLARE(
        WaGamTlbPendError,
        "Workaround",
        WA_BUG_TYPE_FUNCTIONAL,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_KMD)



        WA_DECLARE(
        WaSkip16thBindingTableIndices,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaForceRenderingEnabled,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaEnableFFSyncWithOutAllocate,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaDisableDiscardAdjacency,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaDePipelineReadFlushes,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaDisableBindingTableSamplerCountPrefetch,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaIncorrectSampleInfoSampleCount,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaIncorrectSampleInfoPaletteIndex,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaCubesAreNot2DArray,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaFlushOnMaxNumberClipperThreadsChange,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaEnableForceWakeForRc6WaBb,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaDuplicateMiDisplayFlip,
        "Workaround",
        WA_BUG_TYPE_CORRUPTION,
        WA_BUG_PERF_IMPACT, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaDisablePreservingDenormsInPixelBackend,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaSampleLPerformance,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaWGFVertexBufferMaxIndex,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaNullVertexBufferWhenZeroSize,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaFlushBetweenBindingTablePointers,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaHizCorruptionRenderArbWriteMaskDisable,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaDisableFastClearFor16bpp,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaSetNoOverlapBltCaps,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaDisable128bppCopyBlt,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaForceWindowerMinThreadsTo6,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaUsePostSyncOpWithROCacheFlushPipeControl,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaDisableRHWOOptimization,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaLimitMaxGSThreads,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaToggleDepthStallOnDepthWrite,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaDisableVertexShaderPushConstants,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaDisablePixelShaderPushConstants,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaDropZEvictions,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaLimitEusTo5ThreadsWhenSystemThreadPresent,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaDisableRCZWatermark,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaDisableHizNoDepthTestWrite,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaDisableVfFix,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaTlbInvalidateStoreDataAfter,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaTlbInvalidateStoreDataBefore,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaDisableAsyncFlipPerfMode,
        "Workaround",
        WA_BUG_TYPE_SPEC,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaEnableUrbDataShuffleMode,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaDisableBlbUnitClkGating,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaLimitAllowedPsThreadDependencies,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaSurfaceStateBaseDwordAlignment,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaVcsBcsQwordWriteCacheLineAlignment,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaPipeControlBeforeWmMaxThreadCountChange,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaNopWithIdWriteAfterLastFlush,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaDisableDisplayFetchStrideStretching,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaDapOneStateCacheLookUp,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaChickenReadModifyWrite,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaExtendedStateSaveRestoreAlwaysEnable,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaDisableVFUnitClockGating,
        "Workaround",
        WA_BUG_TYPE_HANG,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaDisableSOUnitClockGating,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaDisableSFUnitClockGating,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaDisableRCCUnitClockGating,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaDisableSCUnitClockGating,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaDisableIZUnitClockGating,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaDisableRCPBUnitClockGating,
        "Workaround",
        WA_BUG_TYPE_HANG,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaUseBlitterForPresent,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaMbcDriverBootEnable,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaReEnableInterrupts,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaOverlaySynchViaVblank,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaSendPipeControlBeforeNonPipelinedState,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaSetCsStallPipeControlBeforeNonPipelinedState,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaGTEnableMIFlush,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaIdleBcsBeforeUpdateTail,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)


        WA_DECLARE(
        WaClearRenderResponseMasks,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaGTSyncRegister,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaDummyPipelinedStateBeforeIspDisable,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaDisableCacheabilityControl,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaSlowFenceIdPropagation,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaHardcodeMediaResetTimerClkFreq,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaEnableContinueAfterPageFault,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaTileWalkYIsInvalidWhenNotTiled,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaSampleinfoForUnboundTextures,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaMSAABandwidthOptimization,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaDisableSampleLPerfFix,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaDisableDopClockGating,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaDisableRowChickenDopClockGating,
        "Workaround",
        WA_BUG_TYPE_HANG,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaDisableFfDopClockGating,
        "Workaround",
        WA_BUG_TYPE_HANG,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaDisableCSUnitLevelClockGating,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaEnableFlushTlbInvalidationMode,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaBCSVCSTlbInvalidationMode,
        "Workaround",
        WA_BUG_TYPE_CORRUPTION,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaStripsFansDisableFastClipPerformanceFix,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaDisableVcsIdleWhileWritingTp,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaDisableEuUnitClockGatingForOA,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaVerticalAlignment4Power2,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaCSStallBefore3DStateGSEnableToggle,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaDisableVDSUnitClockGating,
        "Workaround",
        WA_BUG_TYPE_HANG,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaRevertDopClockGateFix2,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaRevertAsynchFlushFix,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaDisableTDLUnitClockGating,
        "Workaround",
        WA_BUG_TYPE_HANG,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaFlushPipelineBeforeStreamOutState,
        "Workaround",
        WA_BUG_TYPE_CORRUPTION,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaForceAllSOLDecls1Dword,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaSendAllSOLDecls,
        "Workaround",
        WA_BUG_TYPE_CORRUPTION,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaPostSyncOpBeforeVSState,
        "Workaround",
        WA_BUG_TYPE_HANG,
        WA_BUG_PERF_IMPACT(15), WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaEnableEwaLodOnlyForAniso,
        "Workaround",
        WA_BUG_TYPE_HANG,
        WA_BUG_PERF_IMPACT(15), WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaDisableEarlyCull,
        "Workaround",
        WA_BUG_TYPE_HANG,
        WA_BUG_PERF_IMPACT(2), WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaFlushAfterCubeTexCordClamp,
        "Workaround",
        WA_BUG_TYPE_HANG,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaRSPushConstantCoherencyBug,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaRSStoreDataImmDeadlock,
        "Workaround",
        WA_BUG_TYPE_HANG,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaDisablePerfMonGathering,
        "Workaround",
        WA_BUG_TYPE_HANG,
        WA_BUG_PERF_IMPACT(0), WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaReportPerfCountUseGlobalContextID,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaForcePcBbFullCfgRestore,
        "Workaround",
        WA_BUG_TYPE_FUNCTIONAL,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_KMD)

        WA_DECLARE(
        WaDisableNonPresentRenderTargetChannels,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaFixRenderSyncFlush,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaSetupGtModeTdRowDispatch,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaNoBackToBackLriInSCD,
        "Workaround",
        WA_BUG_TYPE_HANG,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaPutSRMBetweenBackToBackLRIForDisplayReg,
        "Workaround",
        WA_BUG_TYPE_HANG,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaGSNoDualModeWhenPrimId,
        "Workaround",
        WA_BUG_TYPE_CORRUPTION,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaBarrierGrfReturnOffset,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaPreservePayloadR0,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaWaitForRingIdleIndicatorBeforeSyncFlush,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaIgnoreRingIdleIndicator,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaDisableVertexFifo,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaSMLimitPresentDmaBufferSize,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaForTogglingDopClkGatingBit,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaSetIspCounterToNonZeroBeforeCsRingEnable,
        "Workaround",
        WA_BUG_TYPE_HANG,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaDisableL3Bank2xClockGate,
        "Workaround",
        WA_BUG_TYPE_HANG,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaInsertNoopAfterMiWaitForEvent,
        "Workaround",
        WA_BUG_TYPE_HANG,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaDisableEUInstructionShootdown,
        "Workaround",
        "Workaround",
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaProgramMiArbOnOffAroundMiSetContext,
        "Workaround",
        WA_BUG_TYPE_HANG,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaCatErrorRejectionIssue,
        "Workaround",
        WA_BUG_TYPE_HANG,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaDisableBackToBackFlipFix,
        "Workaround",
        WA_BUG_TYPE_HANG,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaDisplayPitchPowerOf2,
        "Workaround",
        WA_BUG_TYPE_CORRUPTION,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_GMM)

        WA_DECLARE(
        WaApplyL3ControlAndL3ChickenMode,
        "Workaround",
        WA_BUG_TYPE_CORRUPTION,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaSendDummy3dPrimitveAfterSetContext,
        "Workaround",
        WA_BUG_TYPE_HANG,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaDisableL3CacheAging,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaDivideLLCHitsCounterBy16,
        "Workaround",
        WA_BUG_TYPE_PERF,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaSaveVscRegisters,
        "Workaround",
        WA_BUG_TYPE_CORRUPTION,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaDisableRCZUnitClockGating,
        "Workaround",
        WA_BUG_TYPE_HANG,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaSerializeKmdDisplayAccess,
        "Workaround",
        WA_BUG_TYPE_HANG,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaIssueContextSwitchBeforePreempt,
        "Workaround",
        WA_BUG_TYPE_HANG,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaDisableVfePreemptionFix,
        "Workaround",
        WA_BUG_TYPE_HANG,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaDisableRHWOOptimizationForRenderHang,
        "Workaround",
        WA_BUG_TYPE_HANG,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaIVBInstrumentedVLV,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaDisableDAPRHSClockGating,
        "Workaround",
        WA_BUG_TYPE_HANG,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaDisableMidThreadPreempt,
        "Workaround",
        WA_BUG_TYPE_HANG,
        WA_BUG_PERF_IMPACT(0), WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaDisableObjectLevelPreempt,
        "Workaround",
        WA_BUG_TYPE_HANG,
        WA_BUG_PERF_IMPACT(0), WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaDisablePreemptionForVgt,
        "Workaround",
        WA_BUG_TYPE_FUNCTIONAL,
        WA_BUG_PERF_IMPACT(0), WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaPostSyncOpBefore3DSTATEGS,
        "Workaround",
        WA_BUG_TYPE_HANG,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaCSRUncachable,
        "Workaround",
        WA_BUG_TYPE_HANG,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaFlushBefore3DSTATEGS,
        "Workaround",
        WA_BUG_TYPE_HANG,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaSwitchSolVfFArbitrationPriority,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaBBSNonPrivilegedBit,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaAlternateSigKeys,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaUseNoopClearBuffer,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaDisableCCCheckIn2DPresentPath,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaForceToNonPrivFifthRegisterNonFunctional,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaDisableSamplerPowerBypassForSOPingPong,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaLimitSizeOfSDEPolyFifo,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaDisableSamplerPowerBypass,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaDisableBcCentroidPerformanceOptimization,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaInsertNOPViaChickenBit,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaBlockMsgChannelDuringGfxReset,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaForcePreemptWaitForIdleOnNonRcsEngines,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaIncreaseTagClockTimer,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaLRIToDEUnsupported,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaDisableThreadStallDopClockGating,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaDisableInstructionShootdown,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaDisablePartialInstShootdown,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaDisableGpGpuPreemptOnGt1,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaControlPrimaryTLBUtilization,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaDisableLiteRestore,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaHdcDisableFetchWhenMasked,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaSetVfGuardbandPreemptionVertexCount,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaDisableTdsClockGating,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaEnableVMEReferenceWindowCheck,
        "Workaround",
        WA_BUG_TYPE_SPEC,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaDisableContextRestoreSubsliceAck,
        "Workaround",
        WA_BUG_TYPE_HANG,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaDisableCoherency,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaEnableCoherencyHWFixes,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaForceEnableNonCoherent,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaForceSyncFlipWithVisibilityOff,
        "Workaround",
        WA_BUG_TYPE_HANG,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_KMD)

        WA_DECLARE(
        WaDisableGamClockGating,
        "Workaround",
        WA_BUG_TYPE_HANG,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_KMD)

        WA_DECLARE(
        WaDisDdbClkWhileProgVisibilityOn,
        "Workaround",
        WA_BUG_TYPE_HANG,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_KMD)

        unsigned int : 0;

        WA_DECLARE(
        DisableClockGatingForGucClocks,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaProgramMgsrForCorrectSliceSpecificMmioReads,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaEngineResetAfterMidThreadPreemption,
        "Workaround",
        WA_BUG_TYPE_HANG,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaModifyVFEStateAfterGPGPUPreemption,
        "Workaround",
        WA_BUG_TYPE_HANG,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaEnableuKernelHeaderValidFix,
        "Workaround",
        WA_BUG_TYPE_FUNCTIONAL,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaEnableGoMsgToGAMDuringCPD,
        "Workaround",
        WA_BUG_TYPE_FUNCTIONAL,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaEnableGoMsgAckDuringCPD,
        "Workaround",
        WA_BUG_TYPE_FUNCTIONAL,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaGuCInitSramToZeroes,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaEnableGuCBootHashCheckNotSet,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaDisableGuCClockGating,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaGuCForceFenceByTlbInvalidateReg,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaGuCCopyHuCKernelHashToSramVar,
        "Workaround",
        WA_BUG_TYPE_FUNCTIONAL,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaGuCDummyWriteBeforeFenceCycle,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaGuCDisableSRAMRestoreDisable,
        "Workaround",
        WA_BUG_TYPE_FUNCTIONAL,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)


        unsigned int : 0;

        WA_DECLARE(
        WaCursor16K,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaGWBFlushOnFenceChange,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaGWBFlushOnGTTUpdateEvenViaGTTADDR,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        Wa8kAlignforAsyncFlip,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        Wa29BitDisplayAddrLimit,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaForce1MBGTTSize,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaIncreaseFixedSegSize,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaVistaTempResourceWA,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaAlignContextImage,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaForceGlobalGTT,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaReportPerfCountForceGlobalGTT,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaOaAddressTranslation,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        Wa2RowVerticalAlignment,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaEnableRingHostMapping,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaMfx2ndLevelBatchRingSizeAlign,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaDisablePhysAddrBelow1MB,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaPpgttAliasGlobalGttSpace,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaClearFenceRegistersAtDriverInit,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaRestrictPitch128KB,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaAvoidLLC,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaAvoidL3,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        Wa16TileFencesOnly,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaCacheHizBufferState,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaL3ParitySupportDisable,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaL3ParityInterruptUnmask,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaEmulationSmartCacheFlush,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        Wa32bitGeneralStateOffset,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        Wa32bitInstructionBaseOffset,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaLateL3ErrorInterrupts,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaOAStatus2MemSelect,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        Wa16MBOABufferAlignment,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaL3ErrorHwHanging,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaIommuUncoreUnavailable,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaIommuCCInvalidationHang,
        "Workaround",
        WA_BUG_TYPE_HANG,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaTranslationTableUnavailable,
        "Workaround",
        WA_BUG_TYPE_SPEC,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaExtIotlbInvHang,
        "Workaround",
        WA_BUG_TYPE_HANG,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaL3IACoherencyRequiresIoMmu,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaDisableIommuTEBit,
        "Workaround",
        WA_BUG_TYPE_FUNCTIONAL,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaNoMinimizedTrivialSurfacePadding,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaNoBufferSamplerPadding,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaReusePteL3BitforSecurity,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaDisableWTCaching,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaSecureSegmentInPpgtt,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaSetDVMSizeToStolenMemorySize,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaAllPasidInvHang,
        "Workaround",
        WA_BUG_TYPE_HANG,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaSurfaceStatePlanarYOffsetAlignBy2,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaGttCachingOffByDefault,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaEnableOnlyGpgpuCommandLevelPreemption,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaCompressedResourceSamplerPbeMediaNewHashMode,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaCompressedResourceDisplayNewHashMode,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaCompressedResourceDisplayOldHashMode,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaInPlaceDecompressionHang,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaTouchAllSvmMemory,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaIOBAddressMustBeValidInHwContext,
        "Workaround",
        WA_BUG_TYPE_HANG,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaDisableKillLogic,
        "Workaround",
        WA_BUG_TYPE_HANG,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaFlushTlbAfterCpuGgttWrites,
        "Workaround",
        WA_BUG_TYPE_FUNCTIONAL,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaMsaa8xTileYDepthPitchAlignment,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaDisableIommuAccessedDirtyBit,
        "Workaround",
        WA_BUG_TYPE_PERF,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_GMM)

        WA_DECLARE(
        WaDisableNullPageAsDummy,
        "Workaround",
        WA_BUG_TYPE_HANG | WA_BUG_TYPE_CORRUPTION,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_GMM)

        WA_DECLARE(
        WaUseVAlign16OnTileXYBpp816,
        "Workaround",
        WA_BUG_TYPE_CORRUPTION,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_GMM)

        WA_DECLARE(
        WaDisableRFOSelfSnoop,
        "Workaround",
        WA_BUG_TYPE_PERF,
        WA_BUG_PERF_IMPACT, WA_COMPONENT_GMM)

        WA_DECLARE(
        WaDisableDynamicCreditSharing,
        "Workaround",
        WA_BUG_TYPE_HANG,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_GMM)

        WA_DECLARE(
        WaNoMocsEllcOnly,
        "Workaround",
        WA_BUG_TYPE_FUNCTIONAL,
        WA_BUG_PERF_IMPACT, WA_COMPONENT_GMM)

        WA_DECLARE(
        WaGttPat0,
        "Workaround",
        WA_BUG_TYPE_FUNCTIONAL,
        WA_BUG_PERF_IMPACT, WA_COMPONENT_GMM)

        WA_DECLARE(
        WaGttPat0WB,
        "Workaround",
        WA_BUG_TYPE_FUNCTIONAL,
        WA_BUG_PERF_IMPACT, WA_COMPONENT_GMM)

        WA_DECLARE(
        WaGttPat0GttWbOverOsIommuEllcOnly,
        "Workaround",
        WA_BUG_TYPE_FUNCTIONAL,
        WA_BUG_PERF_IMPACT, WA_COMPONENT_GMM)

        WA_DECLARE(
        WaAddDummyPageForDisplayPrefetch,
        "Workaround",
        WA_BUG_TYPE_CORRUPTION,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_GMM)


        unsigned int : 0;

        WA_DECLARE(
        WaRestore3DBufVarMpeg,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaNo2ndLevelBatchBuffer,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_MEDIA)

        WA_DECLARE(
        WaForceAllocationToAperture,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaDisableSuppressReconPicForNonRefPic,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_MEDIA)

        WA_DECLARE(
        WaAddMediaStateFlushCmd,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_MEDIA)

        WA_DECLARE(
        Wa8BitFrameIn10BitHevc,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaVC1UnequalFieldHeights,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_MEDIA)

        WA_DECLARE(
        WaDisableLockForTranscodePerf,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_MEDIA)

        WA_DECLARE(
        WaInsertAVCFrameForFormatSwitchToJPEG,
        "Workaround",
        WA_BUG_TYPE_HANG,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_MEDIA)

        WA_DECLARE(
        WaDisableJPEGHSWNewFeatures,
        "Workaround",
        WA_BUG_TYPE_FAIL,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_MEDIA)

        WA_DECLARE(
        WaJPEGHeightAlignYUV422H2YToNV12,
        "Workaround",
        WA_BUG_TYPE_HANG,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_MEDIA)

        WA_DECLARE(
        WaVC1DecodingMaxResolution,
        "Workaround",
        WA_BUG_TYPE_FAIL,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_MEDIA)

        WA_DECLARE(
        WaParseVC1PicHeaderInSlice,
        "Workaround",
        WA_BUG_TYPE_FAIL,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_MEDIA)

        WA_DECLARE(
        WaParseVC1FirstFieldPictureHeader,
        "Workaround",
        WA_BUG_TYPE_FAIL,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_MEDIA)

        WA_DECLARE(
        WaParseVC1BPictureHeader,
        "Workaround",
        WA_BUG_TYPE_FAIL,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_MEDIA)

        WA_DECLARE(
        WaAddVC1StuffingBytesForSPMP,
        "Workaround",
        WA_BUG_TYPE_FAIL,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_MEDIA)

        WA_DECLARE(
        WaLinearMediaBlockAccess64BytePitchAlign,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_MEDIA)

        WA_DECLARE(
        WaLLCCachingUnsupported,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_MEDIA)

        WA_DECLARE(
        WaDisableNonStallingScoreboard,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_MEDIA)

        WA_DECLARE(
        WaDisableNonStallingScoreboardBasedOnNumSlices,
        "Workaround",
        WA_BUG_TYPE_CORRUPTION,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_MEDIA)

        WA_DECLARE(
        WaResetVLineStrideInRenderCacheAfterMedia,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_MEDIA)

        WA_DECLARE(
        WaDisableMFX48bitAddressing,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_MEDIA)

        WA_DECLARE(
        WaUseVP8DecodePrivateInputBuffer,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_MEDIA)

        WA_DECLARE(
        WaDummyDMVBufferForMVCInterviewPred,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_MEDIA)

        WA_DECLARE(
        WaVeboxSliceEnable,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_MEDIA)

        WA_DECLARE(
        WaIs64BInstrEnabled,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_MEDIA)

        WA_DECLARE(
        WaIgnoreCSXRStateForWMProgramming,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_PWRCONS)

        WA_DECLARE(
        WaDisableDSHEncryptionForWiDi,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_MEDIA)

        WA_DECLARE(
        WaAssumeSubblockPresent,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_MEDIA)

        WA_DECLARE(
        WaEnableDscale,
        "Workaround",
        WA_BUG_TYPE_HANG,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_MEDIA)

        WA_DECLARE(
        WaDisableGroupIDLoopSelect,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_MEDIA)

        WA_DECLARE(
        WaDisableHuCBasedDRM,
        "Workaround",
        WA_BUG_TYPE_FUNCTIONAL,
        WA_BUG_PERF_IMPACT, WA_COMPONENT_MEDIA)

        WA_DECLARE(
        WaNeedHeightAlignmentForTiledYCaptureSurface,
        "Workaround",
        WA_BUG_TYPE_CORRUPTION,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaLinearCaptureSurface,
        "Workaround",
        WA_BUG_TYPE_CORRUPTION,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaSuperSliceHeaderPacking,
        "Workaround",
        WA_BUG_TYPE_CORRUPTION,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)


        unsigned int : 0;

        WA_DECLARE(
        WaProgramDpll,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaADD2DetectBit,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaTVDetect,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaEnableSCWBPPeriodicFlush,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaExtModeFSDOSBlankScreen,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaTVEncoderDisable,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaWaitForVBlankAfterTVDisableOREnable,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaDisableCenteringDuringVGADisable,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaDisableDynamicNormalWaterMark,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaClosedCaptionHotplug,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaSetCR17regAfterS3Resume,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaDisableHPLLShutdown,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaWaitForVSyncAfterPortEnable,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaPF2ForDisplayPort,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaDPHDMISupriousHpd,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaEnablePFinMultiPlaneMode,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaDPHDMIHpdEnable,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaTVFullScreenHotUnplug,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaRandomAnGeneration,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaUse32BppForSRWM,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        Wa9DotDisableinVGA,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaHPDVrefValue,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaDelayAfterSetDisplayStart,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaEnablePF3ForInterlaced,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaTurnDPOffAfterCPUPipe,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaDisableESFVPwhenFBCisON,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaClkGatingForEmbDPPortD,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaUpdateFBCasPlaneStatusChanges,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaWaitForVBBeforeEDPLLON,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaEnablebyPassModePllForMIPI,
        "Workaround",
        WA_BUG_TYPE_CORRUPTION,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaMipiDispShiftIssue,
        "Workaround",
        WA_BUG_TYPE_CORRUPTION,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_SOFTBIOS)

        WA_DECLARE(
        WaMIPIDualLinkPixelOverlapCount,
        "Workaround",
        WA_BUG_TYPE_CORRUPTION,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaEnableTxrequest_0,
        "Workaround",
        WA_BUG_TYPE_CORRUPTION,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaMipiDPOUnitClkGateEnable,
        "Workaround",
        WA_BUG_TYPE_CORRUPTION,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaAudioInactiveReset,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaConvertorToPinMapping,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaResetChickenBitForAutoLinkTrain,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaPortWriteforAudioControllerinBIOS,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaCheckforAudioPowerStateRegister,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaCRCDisabledForMBO,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaPsrSfuMaskSprite,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaIsAudioControllerinLPSPWell,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaForBlackFlashInMBOMode,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaDisablePrimaryFlipsForMBO,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaDisableLSPCONAuxTransactionInLSMode,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaDoubleCursorLP3Latency,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaEnableHDMI8bpcBefore12bpc,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaFrameStartDelayWaForSDRRS,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaClearPSRReset,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaS3DSoftwareMode,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaDisableBwgTlbClockGating,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaFdiRxMiscProgramming,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaMPhyProgramming,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaDisableVLVClockGating_VBIIssue,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaOGLCubemapWrapModes,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaHSWBorderColorCalculation,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaIntegerTextureSamplingEmulation,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaDisableTileWInRcc,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaFastClearRegistersInPrivilegedList,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaSpriteYUVOffset,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaEnableVBlankForOnlyActivePipe,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaEDPModeSetSequenceChange,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaPartitionLevelClockGatingDisable,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaVLVDPAudioEnable,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaVLVPMCiCLK5WriteEnable,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaClearArfDependenciesBeforeEot,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaDisableMADMMacros,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaPMICRegisterReadWrite,
        "Workaround",
        WA_BUG_TYPE_FUNCTIONAL,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaDisable1DDepthStencil,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaZeroOneClearValues,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaZeroOneClearValuesAtSampler,
        "Workaround",
        WA_BUG_TYPE_CORRUPTION,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaZeroOneClearValuesMSAA,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaDisableCCSClearsIfRtCompressionEnabledInGT3,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaDisableLosslessCompressionForSampleL,
        "Workaround",
        WA_BUG_TYPE_PERF,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaHizAndClearedResourcesBoundToSamplerAtSameTime,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaHizAndCompressedAtSamplerAtSameTime,
        "Workaround",
        WA_BUG_TYPE_CORRUPTION,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaDisableSamplerL2BypassForTextureCompressedFormats,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaSamplerTexCoordModeMirror,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaDCFlushOnCacheInvalidate,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaPCFlushBeforeRTCacheFlush,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaResendURBWhenGSorHSGetsEnabled,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaAuxRetryOnUnknownError,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaAsyncFlipPow2Pitch,
        "Workaround",
        WA_BUG_TYPE_CORRUPTION,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaDoubleFastClearWidthAlignment,
        "Workaround",
        WA_BUG_TYPE_CORRUPTION,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaNoMMIOWhenPGOff,
        "Workaround",
        WA_BUG_TYPE_HANG,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaRsNullConstantBuffer,
        "Workaround",
        WA_BUG_TYPE_FUNCTIONAL,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaUseNonPrivRegisterForObjectLevelPreemption,
        "Workaround",
        WA_BUG_TYPE_HANG,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaDisableObjectLevelPreemptionSequentialMode,
        "Workaround",
        WA_BUG_TYPE_HANG,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaDisableObjectLevelPreemptionForInstancedDraw,
        "Workaround",
        WA_BUG_TYPE_HANG,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaDisableObjectLevelPreemptionForDraw,
        "Workaround",
        WA_BUG_TYPE_HANG,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaDisableObjectLevelPreemptionForGSLineStripAdj,
        "Workaround",
        WA_BUG_TYPE_HANG,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaMaskRegWriteinPSR2AndPSR2Playback,
        "Workaround",
        WA_BUG_TYPE_FUNCTIONAL,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaPsrDPRSUnmaskVBlankInSRD,
        "Workaround",
        WA_BUG_TYPE_FUNCTIONAL,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaLimitSqIdiCounterToEleven,
        "Workaround",
        WA_BUG_TYPE_FUNCTIONAL,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaC6DisallowByGfxPause,
        "Workaround",
        WA_BUG_TYPE_FUNCTIONAL,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaDisableMinuteIaClockGating,
        "Workaround",
        WA_BUG_TYPE_FUNCTIONAL,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaDisableRepcolMessages,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaPsrDPAMaskVBlankInSRD,
        "Workaround",
        WA_BUG_TYPE_FUNCTIONAL,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaSendsSrc1SizeLimitWhenEOT,
        "Workaround",
        WA_BUG_TYPE_HANG,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaDisableMixedModeLog,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaDisableMixedModePow,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaDisableMixedModeFdiv,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaResetN0BeforeGatewayMessage,
        "Workaround",
        WA_BUG_TYPE_HANG,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaFloatMixedModeSelNotAllowedWithPackedDestination,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaDisableDSPushConstantsInFusedDownModeWithOnlyTwoSubslices,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaDisableVSPushConstantsInFusedDownModeWithOnlyTwoSubslices,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaDisableDgMirrorFixInHalfSliceChicken5,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaSetDisablePixMaskCammingAndRhwoInCommonSliceChicken,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaSetMDRBunitClckGatingDisable,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaSetGAPSunitClckGateDisable,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaDisableAutostripInFFMode,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaDisableNativeDWxDWMultiplication,
        "Workaround",
        WA_BUG_TYPE_HANG,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WADisableWriteCommitForPageFault,
        "Workaround",
        WA_BUG_TYPE_FUNCTIONAL,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaDisableNullDepthBuffer,
        "Workaround",
        WA_BUG_TYPE_HANG,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaSkipInvalidSubmitsFromOS,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WAGPGPUMidThreadPreemption,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaEnableHGAsyncFlipLinearToTileConvert,
        "Workaround",
        WA_BUG_TYPE_CORRUPTION,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaDisableGPGPUSlmPerfFix,
        "Workaround",
        WA_BUG_TYPE_HANG,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaMIPICControlRegAndTERegRead,
        "Workaround",
        WA_BUG_TYPE_FUNCTIONAL,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaMIPIDSIRegRead,
        "Workaround",
        WA_BUG_TYPE_FUNCTIONAL,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaCompressedResourceRequiresConstVA21,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaCsStallBeforeNonZeroInstanceCount,
        "Workaround",
        WA_BUG_TYPE_HANG,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaRCFlushEvery16RTVOnBTPUpdate,
        "Workaround",
        WA_BUG_TYPE_CORRUPTION,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaPipeControlBeforeVFCacheInvalidationEnable,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaDisregardPlatformChecks,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WAMMCDUseSlice0Subslice0,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WAMMCDDisableStallBitInPipeControl,
        "Workaround",
        WA_BUG_TYPE_HANG,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaWmMemoryReadLatency,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)


        WA_DECLARE(
        WaForceGrfInitializationAtBoot,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaIntegerDivisionSourceModifierNotSupported,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaMIPIPhaseDelay,
        "Workaround",
        WA_BUG_TYPE_FUNCTIONAL,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaCSCDisable,
        "Workaround",
        WA_BUG_TYPE_FUNCTIONAL,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaDisableObjectLevelPreemtionForVertexCount,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

    WA_DECLARE(
        WaPlaneCxTilingFailure,
        "Workaround",
        WA_BUG_TYPE_CORRUPTION,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

    WA_DECLARE(
        WaRealignCursorC,
        "Workaround",
        WA_BUG_TYPE_CORRUPTION,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

    WA_DECLARE(
        WaSSCClockOverride,
        "Workaround",
        WA_BUG_TYPE_FUNCTIONAL,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaCCKClkSkuIncorrect,
        "Workaround",
        WA_BUG_TYPE_FUNCTIONAL,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaPixelRepeatModeFixForC0,
        "Workaround",
        WA_BUG_TYPE_FUNCTIONAL,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaHPDPeriodIncorrect,
        "Workaround",
        WA_BUG_TYPE_FUNCTIONAL,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaAllocateSLML3CacheCtrlOverride,
        "Workaround",
        WA_BUG_TYPE_HANG,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaDisableObjectLevelPreemtionForInstanceId,
        "Workaround",
        WA_BUG_TYPE_HANG,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaDisableObjectLevelPreemptionForLineLoop,
        "Workaround",
        WA_BUG_TYPE_HANG,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaDisableObjectLevelPreemptionForTrifanOrPolygon,
        "Workaround",
        WA_BUG_TYPE_HANG,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaForceDX10BorderColorSampleC,
        "Workaround",
        WA_BUG_TYPE_FUNCTIONAL,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaForceDX10BorderColorFor64BPTTextures,
        "Workaround",
        WA_BUG_TYPE_FUNCTIONAL,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)


        unsigned int : 0;

        WA_DECLARE(
        WaHucStreamoutEnable,
        "Workaround",
        WA_BUG_TYPE_FUNCTIONAL,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaHucStreamoutOnlyDisable,
        "Workaround",
        WA_BUG_TYPE_FUNCTIONAL,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaZeroHuCImemDmemAttributes,
        "Workaround",
        WA_BUG_TYPE_HANG,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaDisableObjectLevelPreemptionForQuadStrip,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaDisableObjectLevelPreemptionForLineStripAdjLineStripContPolygon,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaDisable3DPreemptionDuringUAVDrawCall,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaDisableRCWithAsyncFlip,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaDisableHBR2,
        "Workaround",
        WA_BUG_TYPE_FUNCTIONAL,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaEnableRCNV12,
        "Workaround",
        WA_BUG_TYPE_FUNCTIONAL,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaEnableChickenDCPR,
        "Workaround",
        WA_BUG_TYPE_FUNCTIONAL,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaEnableBandWidthLimitation,
        "Workaround",
        WA_BUG_TYPE_FUNCTIONAL,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaKeepAllPGsActive,
        "Workaround",
        WA_BUG_TYPE_HANG,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_SOFTBIOS)

        WA_DECLARE(
        WaKeepPG1ActiveDueToDMCIssue,
        "Workaround",
        WA_BUG_TYPE_HANG,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_SOFTBIOS)

        WA_DECLARE(
        WaDisableRCWithS3D,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaProgramL3SqcReg1Default,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaSetHdcUnitClockGatingDisableInUcgctl6,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaDisableFtrSubSliceIzHashing,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaDisableDither,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaSPTMmioAccessSbi,
        "Workaround",
        WA_BUG_TYPE_FUNCTIONAL,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaSPTMmioReadFailure,
        "Workaround",
        WA_BUG_TYPE_FUNCTIONAL,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaDisablePlaneGamma,
        "Workaround",
        WA_BUG_TYPE_FUNCTIONAL,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaVfPostSyncWrite,
        "Workaround",
        WA_BUG_TYPE_HANG,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaIdleLiteRestore,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaEnableYV12BugFixInHalfSliceChicken7,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaDisableSFCSrcCrop,
        "Workaround",
        WA_BUG_TYPE_HANG,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaSFC270DegreeRotation,
        "Workaround",
        WA_BUG_TYPE_CORRUPTION,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaDisablePowerCompilerClockGating,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaDisableDC5DC6,
        "Workaround",
        WA_BUG_TYPE_FUNCTIONAL,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaIgnoreDDIAStrap,
        "Workaround",
        WA_BUG_TYPE_FUNCTIONAL,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaRsRestoreWithPerCtxtBb,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaRSFlushRequiredBefore3DPrimitivePreemption,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaDisableHuCAuthentication,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaHuCNoStreamObject,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaHucBitstreamSizeLimitationEnable,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaModeSwitchDummyFrame,
        "Workaround",
        WA_BUG_TYPE_HANG,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaAddDelayInVDEncDynamicSlice,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaReadVDEncOverflowStatus,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaSklLpt,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaUnitLevelClockGatingDisableGMBUS_PCH,
        "Workaround",
        WA_BUG_TYPE_FUNCTIONAL,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaUnitLevelClockGatingDisableGMBUS_SOC,
        "Workaround",
        WA_BUG_TYPE_FUNCTIONAL,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaEnableChickenBits_Hypervisor,
        "Workaround",
        WA_BUG_TYPE_FUNCTIONAL,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaS3DCurrentFieldLeft,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaEnableForceRestoreInCtxtDescForVCS,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaForceNullSurfaceTileY,
        "Workaround",
        WA_BUG_TYPE_HANG,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaBindlessSurfaceStateModifyEnable,
        "Workaround",
        WA_BUG_TYPE_HANG,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaDisablePreemptionForWatchdogTimer,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaDisableEUChangeForSs0DisableDieRecovery,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaDisableSlicePowerGating,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaCur180BufAddressCalcForPipeA,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaCHVBxMPOHWSupport,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaCHVKxPlaneScalarSupport,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaCHVMPO,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaCHVDisableScalar,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaDisableChickenBitTSGBarrierAckForFFSliceCS,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaBindlessHeapTestSupport,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaDisableCLVertexCache,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaSendSEnableIndirectMsgDesc,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaStructuredBufferAsRawBufferOverride,
        "Workaround",
        WA_BUG_TYPE_FUNCTIONAL,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaConservativeRasterization,
        "Workaround",
        WA_BUG_TYPE_FUNCTIONAL,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN )

        WA_DECLARE(
        WaMSFAfterWalkerWithoutSLMorBarriers,
        "Workaround",
        WA_BUG_TYPE_FUNCTIONAL,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN )

        WA_DECLARE(
        WaDisableRendCompFeature,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaDisableNonLinearGammaCheckWin7,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaBarrierPerformanceFixDisable,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaForceContextSaveRestoreNonCoherent,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaEnableGapsTsvCreditFix,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaDisableSkipCaching,
        "Workaround",
        WA_BUG_TYPE_HANG,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaLosslessCompressionSurfaceStride,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaFbcLinearSurfaceStride,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaFbcPsrUpdateOnCpuHostModifyWrite,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaDisableDPFCGatingForFrontBufModifySignal,
        "Workaround",
        WA_BUG_TYPE_FUNCTIONAL,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_SOFTBIOS)

        WA_DECLARE(
        WaLimit64BppScenarios,
        "Workaround",
        WA_BUG_TYPE_FUNCTIONAL,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_SOFTBIOS)

        WA_DECLARE(
        Wa4kAlignUVOffsetNV12LinearSurface,
        "Workaround",
        WA_BUG_TYPE_CORRUPTION,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaDisableIPC,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaIncreaseLatencyIPCEnabled,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaDisableTWM,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaProgramHalfLineTimeForIPC,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaWatermarkLinesBlocks,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaSamplerResponseLengthMustBeGreaterThan1,
        "Workaround",
        WA_BUG_TYPE_HANG,
        WA_BUG_PERF_IMPACT, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaMixModeSelInstDstNotPacked,
        "Workaround",
        WA_BUG_TYPE_FAIL,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaDisablePooledEuLoadBalancingFix,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaDisablePartialResolveInVc,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaDisablePreemptionWithCoherency,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaReadVcrDebugRegister,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaDisableHDCInvalidation,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaSplitPipeControlForTlbInvalidate,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaDisableSbeCacheDispatchPortSharing,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaWGBoxAndWDtranscoderEnable,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaEnableLbsSlaRetryTimerDecrement,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaCcsTlbPrefetchDisable,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(WaDisableTrickleFeedForNV12,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaEnableSoftwarePCDDelay,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaDisablePWMClockGating,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaDisableSTUnitPowerOptimization,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaDisablePixelMaskBasedCammingInRcpbe,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaMtpRenderPowerGatingBug,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaDisablePUnitMailboxMMIODisable,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaSetClckGatingDisableMedia,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaSetSDEunitClckGatingDisable,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaSetHDCunitClckGatingDisable,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaStoreMultiplePTEenable,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaEnableHostToGucInterrupt,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaReInitRingContextLriPostedWrite,
        "Workaround",
        WA_BUG_TYPE_HANG,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaEnableDefaultEUCount,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaCheckEU10Disabled,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaC0AstcCorruptionForOddCompressedBlockSizeX,
        "Workaround",
        WA_BUG_TYPE_CORRUPTION,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaRCCByteSharingDisableForHSWGT3,
        "Workaround",
        WA_BUG_TYPE_SPEC,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaAstcCorruptionForOddCompressedBlockSizeX,
        "Workaround",
        WA_BUG_TYPE_CORRUPTION,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaUseYCordforPSR2,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaDisableDeepLoopsUnrolling,
        "Workaround",
        WA_BUG_TYPE_FUNCTIONAL,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN )

        WA_DECLARE(
        WaEnableDMCForNV12MPO,
        "Workaround",
        WA_BUG_TYPE_CORRUPTION,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaDups1GatingDisableClockGatingForMPO,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaDisableScalarClockGating,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaFirstSyncFlipAfterMPOExit,
        "Workaround",
        WA_BUG_TYPE_FUNCTIONAL,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN )

        WA_DECLARE(
        WaDisableSendsPreemption,
        "Workaround",
        WA_BUG_TYPE_HANG,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaEnableSamplerGPGPUPreemptionSupport,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaEnableChromaTrellisQuantization,
        "Workaround",
        WA_BUG_TYPE_HANG,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaMIPIChangesFromBStep,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_SOFTBIOS)

        WA_DECLARE(
        WaDisableMipiDsrWithExtPhyON,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_SOFTBIOS)

        WA_DECLARE(
        WaDisplayYtiling,
        "Workaround",
        WA_BUG_TYPE_CORRUPTION,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_SOFTBIOS)

        WA_DECLARE(
        WaDDdiHPDSwapUntilBStep,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_SOFTBIOS)

        WA_DECLARE(
        WaOCLEnableSLMSizeGWLWA1,
        "Workaround",
        WA_BUG_TYPE_HANG,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaOCLEnableSLMSizeGWLWA2,
        "Workaround",
        WA_BUG_TYPE_HANG,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaGlobalDepthConstantScaleUp,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaSetDCFlushOnReadOnlyInvalidate,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaRasterisationOfDegenerateTriangles,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaAvoidURBAllocationSizeMultipleOf3,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaChickenBitsMidBatchPreemption,
        "Workaround",
        WA_BUG_TYPE_HANG,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaForceWakeRenderDuringMmioTLBInvalidate,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_KMD)

        WA_DECLARE(
        WaAudioSetEPSS,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN,
        WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaAllowUmdWriteTRTTRootTable,
        "Workaround",
        WA_BUG_TYPE_FUNCTIONAL,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaDualMapUntil3DOnlyTRTT,
        "Workaround",
        WA_BUG_TYPE_FUNCTIONAL,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaGucSizeUsedWhenValidatingHucCopy,
        "Workaround",
        WA_BUG_TYPE_FUNCTIONAL,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_KMD)

        WA_DECLARE(
        WaGucDisable2ElementSubmission,
        "Workaround",
        WA_BUG_TYPE_FUNCTIONAL,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_KMD)

        WA_DECLARE(
        WaDisable4KPushConstant,
        "Workaround",
        WA_BUG_TYPE_FUNCTIONAL,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaClearTdlStateAckDirtyBits,
        "Workaround",
        WA_BUG_TYPE_FUNCTIONAL,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_KMD)

        WA_DECLARE(
        WaSendDummyGPGPUWalkerBeforeHSWithBarrier,
        "Workaround",
        WA_BUG_TYPE_HANG,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaVFEStateAfterPipeControlwithMediaStateClear,
        "Workaround",
        WA_BUG_TYPE_HANG,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaSendDummyConstantsForPS,
        "Workaround",
        WA_BUG_TYPE_HANG,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaUseAuxSurfaceMode,
        "Workaround",
        WA_BUG_TYPE_HANG,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_KMD)

        WA_DECLARE(
        WaHwManagedClearConvertDepthFormat,
        "Workaround",
        WA_BUG_TYPE_FUNCTIONAL,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaHwManagedClearResolveDepth,
        "Workaround",
        WA_BUG_TYPE_FUNCTIONAL,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaDisableHSEightPatchIfInputControlGeq29,
        "Workaround",
        WA_BUG_TYPE_FUNCTIONAL,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaRsGatherPoolEnable,
        "Workaround",
        WA_BUG_TYPE_HANG,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_KMD)

        WA_DECLARE(
        WaSetMipTailStartLODLargertoSurfaceLOD,
        "Workaround",
        WA_BUG_TYPE_CORRUPTION,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_3D)


        WA_DECLARE(
        WaDisableSamplerRoundingDisableFix,
        "Workaround",
        WA_BUG_TYPE_CORRUPTION,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_3D)

        WA_DECLARE(
        WaForGAMHang,
        "Workaround",
        WA_BUG_TYPE_HANG,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_KMD)

        WA_DECLARE(
        WaGAMWrrbClkGateDisable,
        "Workaround",
        WA_BUG_TYPE_HANG,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_KMD)

        WA_DECLARE(
        WaMediaPoolStateCmdInWABB,
        "Workaround",
        WA_BUG_TYPE_FUNCTIONAL,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_KMD)

        WA_DECLARE(
        WaPlanePosPlusWidthLessThanPipeHorSize,
        "Workaround" ,
        WA_BUG_TYPE_FUNCTIONAL,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaPSR2MultipleRegionUpdateCorruption,
        "Workaround",
        WA_BUG_TYPE_CORRUPTION,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaEnablePSRExitOn3DLutUpdate,
        "Workaround",
        WA_BUG_TYPE_FUNCTIONAL,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaDisableCursorWith1LineInInterlacedMode,
        "Workaround" ,
        WA_BUG_TYPE_FUNCTIONAL,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaEnableAccessToDisplayIO,
        "Workaround",
        WA_BUG_TYPE_FUNCTIONAL,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaHDMIRestrict12BpcRgbYuv444Modes,
        "Workaround",
        WA_BUG_TYPE_FUNCTIONAL,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_SOFTBIOS)

        WA_DECLARE(
        WaEnableBitBashingFor4BlockEDID,
        "Workaround",
        WA_BUG_TYPE_FUNCTIONAL,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_SOFTBIOS)

        WA_DECLARE(
        WaVRRDisableBackToBackMasterFlipHWSupport,
        "Workaround" ,
        WA_BUG_TYPE_FUNCTIONAL,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_SOFTBIOS)

        WA_DECLARE(
        WaGTCLockAcquisitionDelay,
        "Workaround" ,
        WA_BUG_TYPE_FUNCTIONAL,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_SOFTBIOS)

        WA_DECLARE(
        WaCDClkPLLLockCorrection,
        "Workaround" ,
        WA_BUG_TYPE_FUNCTIONAL,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_SOFTBIOS)

        WA_DECLARE(
        WaRCWaterMarkCalculation,
        "Workaround" ,
        WA_BUG_TYPE_FUNCTIONAL,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_SOFTBIOS)

        WA_DECLARE(
        WaRecomputeMGPHYRCOMP,
        "Workaround" ,
        WA_BUG_TYPE_FUNCTIONAL,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_SOFTBIOS)

        WA_DECLARE(
        WaPipeControlBefore3DStateSamplePattern,
        "Workaround",
        WA_BUG_TYPE_HANG,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN )

        WA_DECLARE(
        WaForceShaderChannelSelects,
        "Workaround",
        WA_BUG_TYPE_HANG,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN )

        WA_DECLARE(
        WaRCCCacheMissFix,
        "Workaround",
        WA_BUG_TYPE_PERF,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN )

        WA_DECLARE(
        WaTlbAllocationForAvcVdenc,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN )

        WA_DECLARE(
        WaConextSwitchWithConcurrentTLBInvalidate,
        "Workaround",
        WA_BUG_TYPE_HANG,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_KMD)

        WA_DECLARE(
        WaDisableDOPRenderClkGatingAroundSubmit,
        "Workaround",
        WA_BUG_TYPE_HANG,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_KMD)

        WA_DECLARE(
        WaProgramL3SqcReg1DefaultForPerf,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaInsertDummyPushConstPs,
        "Workaround",
        WA_BUG_TYPE_HANG,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_D3D)

        WA_DECLARE(
        WaClearTDRRegBeforeEOTForNonPS,
        "Workaround",
        WA_BUG_TYPE_HANG,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaReducedGMBusReadRetryCount,
        "Workaround",
        WA_BUG_TYPE_FUNCTIONAL,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaDisableEdramForDisplayRT,
        "Workaround",
        WA_BUG_TYPE_PERF,
        WA_BUG_PERF_IMPACT, WA_COMPONENT_GMM)

        WA_DECLARE(
        WaDisablePreemptForMediaWalkerWithGroups,
        "Workaround",
        WA_BUG_TYPE_HANG,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_MEDIA)

        WA_DECLARE(
        WaAllocateExtraVBPageForGpuMmuPageFaults,
        "Workaround",
        WA_BUG_TYPE_HANG,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
         WaSamplerCacheFlushBetweenRedescribedSurfaceReads,
        "Workaround",
        WA_BUG_TYPE_CORRUPTION,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaKBLVECSSemaphoreWaitPoll,
        "Workaround",
        WA_BUG_TYPE_HANG,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_KMD)

        WA_DECLARE(
        WaNV12YfTileHWCursorUnderrun,
        "Workaround",
        WA_BUG_TYPE_CORRUPTION,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_SOFTBIOS)
        WA_DECLARE(
        WaDDIIOTimeout,
        "Workaround",
        WA_BUG_TYPE_HANG,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_SOFTBIOS)

        WA_DECLARE(
        WaDSIRcompFailure,
        "Workaround",
        WA_BUG_TYPE_CORRUPTION,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_SOFTBIOS)

        WA_DECLARE(
        WaAlwaysEnableAlphaMode,
        "Workaround",
        WA_BUG_TYPE_SPEC,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_SOFTBIOS)

        WA_DECLARE(
        WaAddSourceAndDestinationPixelBypassForPlaneAlphaBlending,
        "Workaround",
        WA_BUG_TYPE_FUNCTIONAL,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_SOFTBIOS)

        WA_DECLARE(
        WaEnableVoidExtentBlockPatchingforASTCLDRTextures,
        "Workaround",
        WA_BUG_TYPE_FUNCTIONAL,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_OGL)

        WA_DECLARE(
        WaDisableKmPresentForRtlSim,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_KMD)

        WA_DECLARE(
        WaRtlSimulation,
        "Workaround",
        WA_BUG_TYPE_PERF,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_KMD)

        WA_DECLARE(
        WaModifyGamTlbPartitioning,
        "Workaround",
        WA_BUG_TYPE_PERF,
        WA_BUG_PERF_IMPACT(25), WA_COMPONENT_KMD)

        WA_DECLARE(
        WaGAPZPriorityScheme,
        "Workaround",
        WA_BUG_TYPE_PERF,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_KMD)

        WA_DECLARE(
        WaL3BankAddressHashing,
        "Workaround",
        WA_BUG_TYPE_PERF,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_KMD)

        WA_DECLARE(
        WaDisableCleanEvicts,
        "Workaround",
        WA_BUG_TYPE_FUNCTIONAL,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_KMD)

        WA_DECLARE(
        WaDisableImprovedTdlClkGating,
        "Workaround",
        WA_BUG_TYPE_PERF,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_KMD)

        WA_DECLARE(
        WaCL2SFHalfMaxAlloc,
        "Workaround",
        WA_BUG_TYPE_FUNCTIONAL,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_KMD)

        WA_DECLARE(
        WaNoSimd16TernarySrc0Imm,
        "Workaround",
        WA_BUG_TYPE_FAIL,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaDPFRGatingDisableWhenScalarEnabled,
        "Workaround",
        WA_BUG_TYPE_FUNCTIONAL,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_KMD)

        WA_DECLARE(
        WaArbitraryNumMbsInSlice,
        "Workaround",
        WA_BUG_TYPE_FUNCTIONAL,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_MEDIA)

        WA_DECLARE(
        WaInterlacedmodeReqPlaneHeightMinTwoScanlines,
        "Workaround",
        WA_BUG_TYPE_FUNCTIONAL,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaPruneModesHavingHfrontPorchBetween122To130,
        "Workaround",
        WA_BUG_TYPE_CORRUPTION,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_SOFTBIOS)

        WA_DECLARE(
            WaMPOReqMinPlaneLeftFourBelowHActive,
            "Workaround",
            WA_BUG_TYPE_FUNCTIONAL,
            WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(WaPlaneSizeAlignmentFor180Rotation,
        "Workaround",
        WA_BUG_TYPE_CORRUPTION,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_SOFTBIOS)

        WA_DECLARE(WaSkipPortRegisterAccess,
            "Workaround",
            WA_BUG_TYPE_HANG,
            WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_SOFTBIOS)

        WA_DECLARE(
            WADisableGTPAndSetISPDisable,
            "Workaround",
            WA_BUG_TYPE_UNKNOWN,
            WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaSetPerfSuperQueueFullLimit,
        "Workaround",
        WA_BUG_TYPE_PERF,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_KMD)

        WA_DECLARE(
            Wa_1406306137,
            "Workaround",
            WA_BUG_TYPE_HANG,
            WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaDisableUnormPathForBlending,
        "Workaround",
        WA_BUG_TYPE_CORRUPTION,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaDisableMultiChannelAudioForDP,
        "Workaround",
        WA_BUG_TYPE_FUNCTIONAL,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_SOFTBIOS)

        WA_DECLARE(
        Wa3DStateMode,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaDisablePTBRDiscardColor,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaBlendEmbDisable,
        "Workaround",
        WA_BUG_TYPE_FUNCTIONAL,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_KMD)

        WA_DECLARE(
        WaDisableDcStatesWhenPSR_3DLUTEnabled,
        "Workaround",
        WA_BUG_TYPE_FUNCTIONAL,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_SOFTBIOS)

        WA_DECLARE(
        WaHardHangonHotPlug,
        "Workaround",
        WA_BUG_TYPE_HANG,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_SOFTBIOS)

        WA_DECLARE(WaForIcompVarations,
        "Workaround",
        WA_BUG_TYPE_FUNCTIONAL,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaDisable10BpcHDMIForYUV420WithHBlankMod8Reminder2,
        "Workaround" ,
         WA_BUG_TYPE_FUNCTIONAL,
         WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

         WA_DECLARE(
         WaDisable10BpcHDMIFor4XPixelRepeatModes,
        "Workaround" ,
         WA_BUG_TYPE_FUNCTIONAL,
         WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaCSStallBefore3DSamplePattern,
        "Workaround",
        WA_BUG_TYPE_HANG,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_KMD)

        WA_DECLARE(
        WaInitCDClkNewSeq,
        "Workaround",
        WA_BUG_TYPE_HANG,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_SOFTBIOS)

        WA_DECLARE(
        WaDisableRenderComputeDataSharing,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_KMD)

        WA_DECLARE(
        WaEnableFloatBlendOptimization,
        "Workaround",
        WA_BUG_TYPE_PERF,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_KMD)

        WA_DECLARE(
        WaTLBInvalidationOptimization,
        "Workaround",
        WA_BUG_TYPE_PERF,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_KMD)

        WA_DECLARE(
        WaDisableEarlyEOT,
        "Workaround",
        WA_BUG_TYPE_HANG,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_KMD)

        WA_DECLARE(
        Wa_2201674230,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        Wa_1406950495,
        "Workaround",
        WA_BUG_TYPE_HANG,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        Wa_1805992985,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        Wa_1407528679,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        WaPreventCosineOverShoot,
        "WA for clamping the lower cosine range",
        WA_BUG_TYPE_CORRUPTION,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        Wa_1409392000,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        Wa_1606931601,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        Wa_1406872168,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        Wa_1409460247,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        Wa_1604727933,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        Wa_1604402567,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        Wa_2201039848,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        Wa_1406614636,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        Wa_1806230709,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        Wa_1306055483,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        Wa_14010017096,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)

        WA_DECLARE(
        Wa_14010198302,
        "Workaround",
        WA_BUG_TYPE_UNKNOWN,
        WA_BUG_PERF_IMPACT_UNKNOWN, WA_COMPONENT_UNKNOWN)
} WA_TABLE, *PWA_TABLE;

#ifdef _USC_
/*****************************************************************************\

STRUCT:
    HW_STATUS

Description:
    holds WA info for compiler

\*****************************************************************************/
struct HW_STATUS
{
    SKU_FEATURE_TABLE   SkuTable;
    WA_TABLE            WaTable;

    SKU_FEATURE_TABLE*  pSkuTable;
    WA_TABLE*           pWaTable;
};
#endif



#if (defined(__MINIPORT) || defined(__KCH) || defined(__SOFTBIOS) || defined(__GRM) || defined(__PWRCONS))
#if LHDM || LINUX
#define GFX_IS_SKU(s, f) ((s)->SkuTable.f)
#define GFX_IS_WA(s, w)  ((s)->WaTable.w)
#define GFX_WRITE_WA(x, y, z) ((x)->WaTable.y = z)


#define GFX_WRITE_SKU(x, y, z) ((x)->SkuTable.y = z)
#else
#define GFX_IS_SKU(h, f) (((PHW_DEVICE_EXTENSION)(h))->pHWStatusPage->pSkuTable->f)
#define GFX_IS_WA(h, w) (((PHW_DEVICE_EXTENSION)(h))->pHWStatusPage->pWaTable->w)
#define GFX_WRITE_WA(x, y, z) (((HW_DEVICE_EXTENSION *)(x))->pHWStatusPage->pWaTable->y = z)


#define GFX_WRITE_SKU(x, y, z) (((HW_DEVICE_EXTENSION *)(x))->pHWStatusPage->pSkuTable->y = z)
#endif
#else
#if XPDM
#define GFX_IS_SKU(s, f) ((s)->pSkuTable->f)
#define GFX_IS_WA(s, w)  ((s)->pWaTable->w)
#else
#define GFX_IS_SKU(s, f) ((s)->SkuTable.f)
#define GFX_IS_WA(s, w)  ((s)->WaTable.w)
#endif
#endif
#define GRAPHICS_IS_SKU(s, f) ((s)->f)
#define GRAPHICS_IS_WA(s, w)  ((s)->w)

#endif
